/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOPreference;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.def.DefaultFolder;
import com.dassault.cecilia.db.dao.sql.def.DefaultGlobEvent;
import com.dassault.cecilia.db.dao.sql.def.DefaultGroup;
import com.dassault.cecilia.db.dao.sql.def.DefaultLicense;
import com.dassault.cecilia.db.dao.sql.def.DefaultObjModel;
import com.dassault.cecilia.db.dao.sql.def.DefaultObjProperty;
import com.dassault.cecilia.db.dao.sql.def.DefaultObject;
import com.dassault.cecilia.db.dao.sql.def.DefaultPreference;
import com.dassault.cecilia.db.dao.sql.def.DefaultProperty;
import com.dassault.cecilia.db.dao.sql.def.DefaultRelation;
import com.dassault.cecilia.db.dao.sql.def.DefaultSession;
import com.dassault.cecilia.db.dao.sql.def.DefaultUser;
import com.dassault.cecilia.db.dao.sql.def.DefaultUtility;
import com.dassault.cecilia.lib.util.logging.LogUtility;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultFactory
implements DAOFactory {
    static Logger _LOG = Logger.getLogger(DefaultFactory.class.getPackage().getName());
    protected SQLConnection _sqlConnect = null;
    protected Connection _connect = null;
    public static final String PROP_DB_QUERY_TIMEOUT = "cecilia.db.QueryTimeout";
    int _queryTimeout = Integer.getInteger("cecilia.db.QueryTimeout", 10);
    long _cptStatement = 0L;
    int _cumulatifCall = -1;
    protected DefaultGroup _daoGroup = null;
    protected DefaultUser _daoUser = null;
    protected DefaultSession _daoSession = null;
    protected DefaultLicense _daoLicense = null;
    protected DefaultProperty _daoProperty = null;
    protected DefaultPreference _daoPreference = null;
    protected DefaultFolder _daoFolder = null;
    protected DefaultObject _daoObject = null;
    protected DefaultObjProperty _daoObjProp = null;
    protected DefaultObjModel _daoObjModel = null;
    protected DefaultRelation _daoRelation = null;
    protected DefaultGlobEvent _daoGlobEvent = null;
    protected DefaultUtility _daoUtility = null;
    protected DateFormat _dateFormat = null;
    public static final String JAVA_DATE_TIME_FORMAT_PATTERN = "dd/MM/yyyy HH:mm:ss";
    Charset _charset = null;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.ENGLISH);
    private boolean _bIgnoreFreezeState = false;

    public DefaultFactory(SQLConnection sqlConnect) {
        this._sqlConnect = sqlConnect;
        this._connect = sqlConnect.getConnection();
    }

    @Override
    public void initConnection() {
        this.createFolderDAO().prepareCache();
    }

    public void initStatement(Statement stat) throws SQLException {
        ++this._cptStatement;
        if (this._queryTimeout > 0) {
            stat.setQueryTimeout(this._queryTimeout);
        }
    }

    protected boolean isDuringTransaction() {
        return this._cumulatifCall > -1;
    }

    @Override
    public void beginTransaction(boolean cumulatif) throws SQLException {
        _LOG.log(cumulatif ? Level.FINER : Level.FINEST, "DefaultFactory-beginTransaction | CumulatifCall=" + this._cumulatifCall);
        if (this._cumulatifCall >= 0) {
            if (cumulatif) {
                throw new SQLException("Cecilia - Transaction-Cumulatif already beginning");
            }
            ++this._cumulatifCall;
        } else {
            if (!this._connect.getAutoCommit()) {
                throw new SQLException("Cecilia - Transaction already beginning");
            }
            this._connect.setAutoCommit(false);
            if (cumulatif) {
                this._cumulatifCall = 0;
            }
        }
    }

    @Override
    public void endTransaction() throws SQLException {
        _LOG.log(this._cumulatifCall == 0 ? Level.FINER : Level.FINEST, "DefaultFactory-endTransaction | CumulatifCall=" + this._cumulatifCall);
        if (this._cumulatifCall >= 0) {
            --this._cumulatifCall;
        }
        if (this._cumulatifCall < 0) {
            this._connect.commit();
            this._connect.setAutoCommit(true);
        }
    }

    @Override
    public void abortTransaction() throws SQLException {
        _LOG.log(this._cumulatifCall == 0 ? Level.FINER : Level.FINEST, "DefaultFactory-abortTransaction | CumulatifCall=" + this._cumulatifCall);
        if (this._cumulatifCall >= 0) {
            --this._cumulatifCall;
        }
        if (this._cumulatifCall < 0) {
            this._connect.rollback();
            this._connect.setAutoCommit(true);
        }
    }

    @Override
    public DefaultGroup createGroupDAO() {
        if (this._daoGroup == null) {
            this._daoGroup = new DefaultGroup(this._connect, this);
        }
        return this._daoGroup;
    }

    @Override
    public DefaultUser createUserDAO() {
        if (this._daoUser == null) {
            this._daoUser = new DefaultUser(this._connect, this);
        }
        return this._daoUser;
    }

    @Override
    public DefaultSession createSessionDAO() {
        if (this._daoSession == null) {
            this._daoSession = new DefaultSession(this._connect, this);
        }
        return this._daoSession;
    }

    @Override
    public DefaultLicense createLicenseDAO() {
        if (this._daoLicense == null) {
            this._daoLicense = new DefaultLicense(this._sqlConnect, this);
        }
        return this._daoLicense;
    }

    @Override
    public DefaultProperty createPropertyDAO() {
        if (this._daoProperty == null) {
            this._daoProperty = new DefaultProperty(this._connect, this);
        }
        return this._daoProperty;
    }

    @Override
    public DAOPreference createPreferenceDAO() {
        if (this._daoPreference == null) {
            this._daoPreference = new DefaultPreference(this._connect, this);
        }
        return this._daoPreference;
    }

    @Override
    public DefaultFolder createFolderDAO() {
        if (this._daoFolder == null) {
            this._daoFolder = new DefaultFolder(this._connect, this);
        }
        return this._daoFolder;
    }

    @Override
    public DefaultObject createObjectDAO() {
        if (this._daoObject == null) {
            this._daoObject = new DefaultObject(this._connect, this);
        }
        return this._daoObject;
    }

    public DefaultObjProperty createObjPropertyDAO() {
        if (this._daoObjProp == null) {
            this._daoObjProp = new DefaultObjProperty(this._connect, this);
        }
        return this._daoObjProp;
    }

    @Override
    public DefaultObjModel createObjModelDAO() {
        if (this._daoObjModel == null) {
            this._daoObjModel = new DefaultObjModel(this._connect, this);
        }
        return this._daoObjModel;
    }

    @Override
    public DefaultRelation createRelationDAO() {
        if (this._daoRelation == null) {
            this._daoRelation = new DefaultRelation(this._connect, this);
        }
        return this._daoRelation;
    }

    @Override
    public DefaultGlobEvent createGlobEventDAO() {
        if (this._daoGlobEvent == null) {
            this._daoGlobEvent = new DefaultGlobEvent(this._connect, this);
        }
        return this._daoGlobEvent;
    }

    @Override
    public DefaultUtility createUtilityDAO() {
        if (this._daoUtility == null) {
            this._daoUtility = new DefaultUtility(this._connect, this);
        }
        return this._daoUtility;
    }

    @Override
    public DateFormat createDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat(JAVA_DATE_TIME_FORMAT_PATTERN, Locale.ENGLISH);
        }
        return this._dateFormat;
    }

    public String getSQLFunctionNow() {
        return "now()";
    }

    public Charset getCharset() {
        if (this._charset == null) {
            this._charset = StandardCharsets.UTF_8;
        }
        return this._charset;
    }

    @Override
    public void logStats() {
        _LOG.fine("NbrStat:[" + this._cptStatement + "]");
        this.createObjectDAO().logStats();
    }

    @Override
    public String getUserLogin() {
        return "admin";
    }

    protected long convertTimeStamp(ResultSet resultSet, int col) throws SQLException {
        try {
            return resultSet.getTimestamp(col).getTime();
        }
        catch (Exception e) {
            LogUtility.logStackTrace((Logger)_LOG, (Level)Level.INFO, (String)"Probl\u00e8me lors de la convertion d'un TimeStamp", (int)3);
            Date date = resultSet.getDate(col);
            Time time = resultSet.getTime(col);
            String d = DATE_FORMAT.format(date);
            String t = TIME_FORMAT.format(time);
            try {
                return DATE_TIME_FORMAT.parse(d + " " + t).getTime();
            }
            catch (Exception e2) {
                LogUtility.logStackTrace((Logger)_LOG, (Level)Level.INFO, (String)("Probl\u00e8me lors de la convertion d'un TimeStamp via la date\nOther informations: [date=" + date + "][time=" + time + "][d=" + d + "][t=" + t + "]"), (int)3);
                return new java.util.Date(date.getTime() + time.getTime()).getTime();
            }
        }
    }

    @Override
    public boolean ignoreFreezeState() {
        return this._bIgnoreFreezeState;
    }

    @Override
    public void setIgnoreFreezeState(boolean value) {
        this._bIgnoreFreezeState = value;
    }
}

