/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.DAOGroup;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;

public class DefaultGroup
extends DAOGroup {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultGroup(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createGroupIntoTable(DBGroup obj) throws SQLException {
        boolean result;
        block16: {
            result = false;
            PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.GROUPS + " (grp_name, grp_description, grp_flags) VALUES (?, ?, ?)", 1);
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, obj.getName());
                prepare.setString(2, obj.getDescription());
                prepare.setInt(3, obj.getFlags());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) break block16;
                ResultSet resultSet = prepare.getGeneratedKeys();
                try {
                    if (resultSet.next()) {
                        obj.setID(resultSet.getLong(1));
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!result) {
            throw new SQLException("Internal error during INSERT INTO " + SQLTable.GROUPS + ": " + obj.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBGroup create(DBGroup obj) {
        long id = -1L;
        try {
            this._factory.beginTransaction(false);
            this.createGroupIntoTable(obj);
            id = obj.getID();
            if (obj.getUsers().size() > 0) {
                PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.GRP_USR + " (grp_grp_id, grp_usr_id) VALUES (?, ?)");
                this._factory.initStatement(prepare);
                try {
                    for (IUser user : obj.getUsers()) {
                        if (user instanceof DBUser && user.getID() <= 0L) {
                            this._factory.createUserDAO().createUserIntoTable((DBUser)user);
                        }
                        prepare.setLong(1, id);
                        prepare.setLong(2, user.getID());
                        prepare.executeUpdate();
                    }
                }
                finally {
                    try {
                        prepare.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this._factory.endTransaction();
        }
        catch (Exception e) {
            id = -1L;
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultGroup::create(" + obj.getName() + ")");
        }
        if (id != -1L) {
            return this.find(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(DBGroup obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.GROUPS + " WHERE grp_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultGroup::delete(" + obj.getID() + "," + obj.getName() + ")");
            return false;
        }
        catch (Exception e) {
            this.logException(e, "DefaultGroup::delete(" + obj.getID() + "," + obj.getName() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(DBGroup obj) {
        try {
            this._factory.beginTransaction(false);
            PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.GROUPS + " SET grp_name=?, grp_description=?, grp_flags=? WHERE grp_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, obj.getName());
                prepare.setString(2, obj.getDescription());
                prepare.setInt(3, obj.getFlags());
                prepare.setLong(4, obj.getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.GRP_USR + " WHERE grp_grp_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            if (obj.getUsers().size() > 0) {
                prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.GRP_USR + " (grp_grp_id, grp_usr_id) VALUES (?, ?)");
                this._factory.initStatement(prepare);
                try {
                    for (IUser user : obj.getUsers()) {
                        prepare.setLong(1, obj.getID());
                        prepare.setLong(2, user.getID());
                        prepare.executeUpdate();
                    }
                }
                finally {
                    try {
                        prepare.close();
                    }
                    catch (Exception exception) {}
                }
            }
            List<DBGroup> groupsToUpdate = Collections.singletonList(obj);
            this._factory.createFolderDAO().updateVisibilityForGroups(groupsToUpdate);
            this._factory.endTransaction();
            return true;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultGroup::update(" + obj.getID() + "," + obj.getName() + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBGroup> findAll() {
        TreeMap<Long, DBGroup> result = new TreeMap<Long, DBGroup>();
        try {
            DBGroup obj;
            ResultSet resultSet2;
            PreparedStatement prepare = this._connect.prepareStatement("SELECT grp_id, grp_name, grp_description, grp_flags FROM " + SQLTable.GROUPS, 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                resultSet2 = prepare.executeQuery();
                try {
                    while (resultSet2.next()) {
                        long id = resultSet2.getLong(1);
                        obj = new DBGroup(id, resultSet2.getString(2));
                        obj.setDescription(resultSet2.getString(3));
                        obj.setFlags(resultSet2.getInt(4));
                        result.put(id, obj);
                    }
                }
                finally {
                    try {
                        resultSet2.close();
                    }
                    catch (Exception id) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception resultSet2) {}
            }
            prepare = this._connect.prepareStatement("SELECT grp_id, usr_id, usr_login, usr_flags FROM " + SQLTable.GROUPS + ", " + SQLTable.GRP_USR + ", " + SQLTable.USERS + " WHERE grp_grp_id = grp_id AND grp_usr_id = usr_id", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                resultSet2 = prepare.executeQuery();
                try {
                    while (resultSet2.next()) {
                        long id = resultSet2.getLong(1);
                        obj = (DBGroup)result.get(id);
                        if (obj == null) continue;
                        obj.addUser(new IUser.MinimalUser(resultSet2.getLong(2), resultSet2.getString(3), resultSet2.getInt(4)));
                    }
                }
                finally {
                    try {
                        resultSet2.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultGroup::findAll()");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultGroup::findAll()");
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBGroup find(long id) {
        DBGroup obj = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT grp_name, grp_description, grp_flags FROM " + SQLTable.GROUPS + " WHERE grp_id = ? ", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, id);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        obj = new DBGroup(id, resultSet.getString(1));
                        obj.setDescription(resultSet.getString(2));
                        obj.setFlags(resultSet.getInt(3));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            if (obj != null) {
                if (this.findUsers(obj)) {
                    return obj;
                }
                return null;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultGroup::find(" + id + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultGroup::find(" + id + ")");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findUsers(DBGroup obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT usr_id, usr_login, usr_flags FROM " + SQLTable.GRP_USR + ", " + SQLTable.USERS + " WHERE grp_grp_id = ? AND grp_usr_id = usr_id", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long idUsr = resultSet.getLong(1);
                        String login = resultSet.getString(2);
                        int flags = resultSet.getInt(3);
                        obj.addUser(new IUser.MinimalUser(idUsr, login, flags));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultGroup::findUsers(" + obj.getID() + "," + obj.getName() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultGroup::findUsers(" + obj.getID() + "," + obj.getName() + ")");
        }
        return false;
    }
}

