/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBLicense;
import com.dassault.cecilia.db.dao.DAOLicense;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import com.dassault.cecilia.lib.util.CryptUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;
import java.util.logging.Level;

public class DefaultLicense
extends DAOLicense {
    protected SQLConnection _sqlConnect = null;
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultLicense(SQLConnection sqlConnect, DefaultFactory factory) {
        this._sqlConnect = sqlConnect;
        this._connect = sqlConnect.getConnection();
        this._factory = factory;
    }

    @Override
    public boolean verifyHost(String dbHost, String localHost) {
        return localHost.equals(dbHost);
    }

    protected DBLicense specificFind(long id, String module, String company, String host, String version, int token, Date expire) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBLicense find(String module) {
        String currentHost = null;
        DBLicense obj = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT lic_id, lic_company, lic_version, lic_host, lic_token, lic_expire FROM " + SQLTable.LICENSES + " WHERE lic_module = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, module);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        Date expire;
                        int token;
                        String version;
                        String host;
                        String company;
                        long id = resultSet.getLong(1);
                        obj = this.specificFind(id, module, company = resultSet.getString(2), host = CryptUtility.decryptData((String)resultSet.getString(4), (String)company), version = CryptUtility.decryptData((String)resultSet.getString(3), (String)company), token = DBLicense.parseToken(CryptUtility.decryptData((String)resultSet.getString(5), (String)company)), expire = DBLicense.parseDate(CryptUtility.decryptData((String)resultSet.getString(6), (String)company)));
                        if (obj != null) {
                        } else {
                            if (currentHost == null) {
                                currentHost = this.getHostConnection();
                            }
                            if (currentHost == null || !this.verifyHost(host, currentHost)) continue;
                            obj = new DBLicense(id);
                            obj.setCompany(company).setModule(module).setHost(host);
                            obj.setVersion(version).setToken(token).setExpire(expire);
                        }
                        break;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultLicense::find(" + module + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultLicense::find(" + module + ")");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(DBLicense obj) {
        String company = obj.getCompany();
        String module = obj.getModule();
        try {
            ArrayList<Long> deleteLicenses = new ArrayList<Long>();
            PreparedStatement prepare = this._connect.prepareStatement("SELECT lic_id, lic_host FROM " + SQLTable.LICENSES + " WHERE lic_module = ? AND lic_company = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, module);
                prepare.setString(2, company);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        String host = CryptUtility.decryptData((String)resultSet.getString(2), (String)company);
                        if (!this.verifyHost(host, obj.getHost())) continue;
                        deleteLicenses.add(id);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception id) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception resultSet) {}
            }
            this._factory.beginTransaction(false);
            int nbrChg = 0;
            if (deleteLicenses.size() > 0) {
                PreparedStatement prepare2 = this._connect.prepareStatement("DELETE FROM " + SQLTable.LICENSES + " WHERE lic_id = ?");
                this._factory.initStatement(prepare2);
                try {
                    for (int i = 0; i < deleteLicenses.size(); ++i) {
                        prepare2.setLong(1, (Long)deleteLicenses.get(i));
                        nbrChg += prepare2.executeUpdate();
                    }
                }
                finally {
                    try {
                        prepare2.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this._factory.endTransaction();
            if ((nbrChg += this.doInsert(obj)) != deleteLicenses.size() + 1) {
                DefaultFactory._LOG.info("DefaultLicense::insert(...): Number change in DB (" + nbrChg + ") not equal at " + (deleteLicenses.size() + 1));
            }
            return true;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultLicense::insert(" + obj.getCompany() + "," + obj.getModule() + "," + obj.getHost() + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doInsert(DBLicense obj) throws SQLException {
        String company = obj.getCompany();
        String module = obj.getModule();
        PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.LICENSES + " (lic_company, lic_module, lic_version, lic_host, lic_token, lic_expire) VALUES (?, ?, ?, ?, ?, ?)");
        this._factory.initStatement(prepare);
        try {
            int col = 1;
            prepare.setString(col++, company);
            prepare.setString(col++, module);
            prepare.setString(col++, CryptUtility.cryptData((String)obj.getVersion(), (String)company));
            prepare.setString(col++, CryptUtility.cryptData((String)obj.getHost(), (String)company));
            prepare.setString(col++, CryptUtility.cryptData((String)DBLicense.printToken(obj.getToken()), (String)company));
            prepare.setString(col++, CryptUtility.cryptData((String)DBLicense.printDate(obj.getExpire()), (String)company));
            int n = prepare.executeUpdate();
            return n;
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(DBLicense obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.LICENSES + " WHERE lic_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultLicense::delete(" + obj.getID() + "," + obj.getCompany() + ")");
            return false;
        }
        catch (Exception e) {
            this.logException(e, "DefaultLicense::delete(" + obj.getID() + "," + obj.getCompany() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBLicense> findAll() {
        TreeMap<Long, DBLicense> result = new TreeMap<Long, DBLicense>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT lic_id, lic_company, lic_module, lic_version, lic_host, lic_token, lic_expire FROM " + SQLTable.LICENSES, 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        DBLicense obj = new DBLicense(id);
                        String company = resultSet.getString(2);
                        obj.setCompany(company);
                        obj.setModule(resultSet.getString(3));
                        obj.setVersion(CryptUtility.decryptData((String)resultSet.getString(4), (String)company));
                        obj.setHost(CryptUtility.decryptData((String)resultSet.getString(5), (String)company));
                        obj.setToken(DBLicense.parseToken(CryptUtility.decryptData((String)resultSet.getString(6), (String)company)));
                        obj.setExpire(DBLicense.parseDate(CryptUtility.decryptData((String)resultSet.getString(7), (String)company)));
                        result.put(id, obj);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultLicense::findAll()");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultLicense::findAll()");
        }
        return result.values();
    }

    @Override
    public int getCountConnection() {
        return -1;
    }

    @Override
    public String getHostConnection() {
        return this._sqlConnect.getConnectionUrl();
    }
}

