/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.logging.Level;

public class DefaultObjModel
extends DAOObjModel {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultObjModel(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createInTransaction(DBObjModel obj) throws SQLException {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::createInTransaction(" + obj + ")");
        }
        boolean result = false;
        PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.OBJ_MODELS + " (mod_obj_id, mod_nature, mod_format, mod_encoding, mod_crc, mod_data_size, mod_data) VALUES (?, ?, ?, ?, ?, ?, ?)", 1);
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, obj.getObject().getID());
            prepare.setString(2, obj.getNature());
            prepare.setString(3, obj.getFormat());
            prepare.setString(4, obj.getEncoding());
            prepare.setString(5, obj.getCRC());
            prepare.setLong(6, obj.getSize());
            prepare.setBinaryStream(7, obj.getStreamToSave());
            int nbrChg = prepare.executeUpdate();
            if (nbrChg == 1) {
                ResultSet resultSet = prepare.getGeneratedKeys();
                try {
                    if (resultSet.next()) {
                        obj.setID(resultSet.getLong(1));
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            obj.setStreamToSave(null);
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    @Override
    public DBObjModel create(DBObjModel obj) {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::create(" + obj + ")");
        }
        try {
            if (this.createInTransaction(obj)) {
                return obj;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjModel::create(" + obj.getObject().getID() + "," + obj.getNature() + ")");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(DBObjModel obj) {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::delete(" + obj + ")");
        }
        try {
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.OBJ_MODELS + " WHERE mod_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) return false;
                this._factory.createFolderDAO().updateTimeUpdate(obj.getObject().getFolder());
                obj.getObject().delModel(obj);
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjModel::delete(" + obj.getObject().getID() + "," + obj.getNature() + ")");
            return false;
        }
        catch (Exception e) {
            this.logException(e, "DefaultObjModel::delete(" + obj.getObject().getID() + "," + obj.getNature() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteAll(DBObject obj) {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::deleteAll(" + obj + ")");
        }
        try {
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.OBJ_MODELS + " WHERE mod_obj_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg <= 1) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjModel::deleteAll(" + obj.getID() + ")");
            return false;
        }
        catch (Exception e) {
            this.logException(e, "DefaultObjModel::deleteAll(" + obj.getID() + ")");
        }
        return false;
    }

    @Override
    public boolean update(DBObjModel obj) {
        try {
            return this.updateInTransaction(obj);
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjModel::update(" + obj.getObject().getID() + "," + obj.getNature() + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateInTransaction(DBObjModel obj) throws SQLException {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::update(" + obj + ")");
        }
        try {
            InputStream input = obj.getStreamToSave();
            if (input == null) {
                throw new SQLException("Le flux de donnee n'a pas ete initialise: null");
            }
            PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.OBJ_MODELS + " SET mod_nature=?, mod_format=?, mod_encoding=?, mod_crc=?, mod_data_size=?, mod_data=? WHERE mod_id = ? AND mod_obj_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, obj.getNature());
                prepare.setString(2, obj.getFormat());
                prepare.setString(3, obj.getEncoding());
                prepare.setString(4, obj.getCRC());
                prepare.setLong(5, obj.getSize());
                prepare.setBinaryStream(6, obj.getStreamToSave());
                prepare.setLong(7, obj.getID());
                prepare.setLong(8, obj.getObject().getID());
                prepare.executeUpdate();
                obj.setStreamToSave(null);
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        catch (SQLException e) {
            DefaultFactory._LOG.info("Exception during DefaultObjModel::updateInTransaction(" + obj.getObject().getID() + "," + obj.getNature() + ")");
            throw e;
        }
    }

    @Override
    public DBObjModel find(long id) {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::find(" + id + ")");
        }
        DefaultFactory._LOG.severe("DefaultObjModel::find(" + id + "): appele incongrue a cette methode");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBObjModel find(DBObject obj, String nature) {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::find(" + obj + "," + nature + ")");
        }
        DBObjModel objProp = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT mod_id, mod_obj_id, mod_nature, mod_format, mod_encoding, mod_crc, mod_data_size FROM " + SQLTable.OBJ_MODELS + " WHERE mod_obj_id = ? AND mod_nature = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                prepare.setString(2, nature);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        objProp = new DBObjModel();
                        objProp.setID(resultSet.getLong(1));
                        objProp.setObject(obj);
                        objProp.setNature(nature);
                        objProp.setFormat(resultSet.getString(4));
                        objProp.setEncoding(resultSet.getString(5));
                        objProp.setCRC(resultSet.getString(6));
                        objProp.setSize(resultSet.getLong(7));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjModel::find(" + obj.getID() + "," + nature + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultObjModel::find(" + obj.getID() + "," + nature + ")");
        }
        return objProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBObjModel> findAll(DBObject obj) {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::findAll(" + obj + ")");
        }
        LinkedHashMap<Long, DBObjModel> result = new LinkedHashMap<Long, DBObjModel>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT mod_id, mod_obj_id, mod_nature, mod_format, mod_encoding, mod_crc, mod_data_size FROM " + SQLTable.OBJ_MODELS + " WHERE mod_obj_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        DBObjModel objProp = new DBObjModel();
                        long id = resultSet.getLong(1);
                        objProp.setID(id);
                        objProp.setObject(obj);
                        objProp.setNature(resultSet.getString(3));
                        objProp.setFormat(resultSet.getString(4));
                        objProp.setEncoding(resultSet.getString(5));
                        objProp.setCRC(resultSet.getString(6));
                        objProp.setSize(resultSet.getLong(7));
                        result.put(id, objProp);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultObjModel::findAll()");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultObjModel::findAll()");
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(DBObjModel model) {
        if (DefaultFactory._LOG.isLoggable(Level.FINEST)) {
            DefaultFactory._LOG.finest("DefaultObjModel::getBinaryStream(" + model + ")");
        }
        InputStream stream = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT mod_data FROM " + SQLTable.OBJ_MODELS + " WHERE mod_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, model.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        stream = resultSet.getBinaryStream(1);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjModel::getBinaryStream(" + model.getID() + "[" + model.getObject().getFolder().getName() + "])");
        }
        catch (Exception e) {
            this.logException(e, "DefaultObjModel::getBinaryStream(" + model.getID() + "[" + model.getObject().getFolder().getName() + "])");
        }
        return stream;
    }
}

