/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.DAO;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;

public class DefaultObjProperty
extends DAO<DBObjProperty> {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultObjProperty(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createInTransaction(DBObjProperty obj) throws SQLException {
        boolean result;
        block15: {
            result = false;
            PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.OBJ_PROPS + " (opr_obj_id, opr_name, opr_value, opr_type) VALUES (?, ?, ?, ?)", 1);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getObject().getID());
                prepare.setString(2, obj.getName());
                prepare.setString(3, obj.getValue());
                prepare.setString(4, obj.getType());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) break block15;
                ResultSet resultSet = prepare.getGeneratedKeys();
                try {
                    if (resultSet.next()) {
                        obj.setID(resultSet.getLong(1));
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    @Override
    public DBObjProperty create(DBObjProperty obj) {
        try {
            if (this.createInTransaction(obj)) {
                return obj;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjProperty::create(" + obj.getObject().getID() + "," + obj.getName() + ")");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteInTransaction(DBObjProperty obj) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.OBJ_PROPS + " WHERE opr_id = ?");
        this._factory.initStatement(prepare);
        try {
            prepare.setLong(1, obj.getID());
            int nbrChg = prepare.executeUpdate();
            if (nbrChg == 1) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    public boolean delete(DBObjProperty obj) {
        try {
            return this.deleteInTransaction(obj);
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjProperty::delete(" + obj.getObject().getID() + "," + obj.getName() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultObjProperty::delete(" + obj.getObject().getID() + "," + obj.getName() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteAll(DBObject obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.OBJ_PROPS + " WHERE opr_obj_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg <= 1) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjProperty::deleteAll(" + obj.getID() + ")");
            return false;
        }
        catch (Exception e) {
            this.logException(e, "DefaultObjProperty::deleteAll(" + obj.getID() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateInTransaction(DBObjProperty obj) throws SQLException {
        PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.OBJ_PROPS + " SET opr_name=?, opr_value=?, opr_type=? WHERE opr_id = ? AND opr_obj_id = ?");
        this._factory.initStatement(prepare);
        try {
            prepare.setString(1, obj.getName());
            prepare.setString(2, obj.getValue());
            prepare.setString(3, obj.getType());
            prepare.setLong(4, obj.getID());
            prepare.setLong(5, obj.getObject().getID());
            prepare.executeUpdate();
        }
        finally {
            try {
                prepare.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    @Override
    public boolean update(DBObjProperty obj) {
        try {
            return this.updateInTransaction(obj);
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjProperty::update(" + obj.getObject().getID() + "," + obj.getName() + ")");
            return false;
        }
    }

    @Override
    public DBObjProperty find(long id) {
        DefaultFactory._LOG.severe("DefaultObjProperty::find(" + id + "): appele incongrue a cette methode");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBObjProperty find(DBObject obj, String name) {
        DBObjProperty objProp = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT opr_id, opr_obj_id, opr_name, opr_value, opr_type FROM " + SQLTable.OBJ_PROPS + " WHERE opr_obj_id = ? AND opr_name = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                prepare.setString(2, name);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        objProp = new DBObjProperty();
                        objProp.setID(resultSet.getLong(1));
                        objProp.setObject(obj);
                        objProp.setName(name);
                        objProp.setValue(resultSet.getString(4));
                        objProp.setType(resultSet.getString(5));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultObjProperty::find(" + obj.getID() + "," + name + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultObjProperty::find(" + obj.getID() + "," + name + ")");
        }
        return objProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DBObjProperty> findAll(DBObject obj) {
        LinkedHashMap<Long, DBObjProperty> result = new LinkedHashMap<Long, DBObjProperty>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT opr_id, opr_obj_id, opr_name, opr_value, opr_type FROM " + SQLTable.OBJ_PROPS + " WHERE opr_obj_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        DBObjProperty objProp = new DBObjProperty();
                        long id = resultSet.getLong(1);
                        objProp.setID(id);
                        objProp.setObject(obj);
                        objProp.setName(resultSet.getString(3));
                        objProp.setValue(resultSet.getString(4));
                        objProp.setType(resultSet.getString(5));
                        result.put(id, objProp);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultObjProperty::findAll(" + obj + ")");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultObjProperty::findAll(" + obj + ")");
        }
        return result.values();
    }
}

