/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBPreference;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOPreference;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.TreeMap;

public class DefaultPreference
extends DAOPreference {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultPreference(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createInTransaction(DBPreference obj) throws SQLException {
        boolean result;
        block15: {
            result = false;
            PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.PREFERENCIES + " (upf_usr_id, upf_key, upf_flags, upf_data_size, upf_data) VALUES (?, ?, ?, ?, ?)", 1);
            this._factory.initStatement(prepare);
            try {
                String value = obj.getValue();
                prepare.setLong(1, obj.getUser().getID());
                prepare.setString(2, obj.getName());
                prepare.setInt(3, obj.getFlags());
                prepare.setLong(4, value.length());
                byte[] bvalue = value.getBytes(this._factory.getCharset());
                prepare.setBinaryStream(5, new ByteArrayInputStream(bvalue));
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) break block15;
                ResultSet resultSet = prepare.getGeneratedKeys();
                try {
                    if (resultSet.next()) {
                        obj.setID(resultSet.getLong(1));
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    @Override
    public DBPreference create(DBPreference obj) {
        try {
            if (this.createInTransaction(obj)) {
                return obj;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultPreference::create(" + obj.getUser().getID() + "," + obj.getName() + ")");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(DBPreference obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.PREFERENCIES + " WHERE upf_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultPreference::delete(" + obj.getID() + "," + obj.getName() + ")");
            return false;
        }
        catch (Exception e) {
            this.logException(e, "DefaultPreference::delete(" + obj.getID() + "," + obj.getName() + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(DBPreference obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.PREFERENCIES + " SET upf_key=?, upf_flags=?, upf_data_size=?, upf_data=? WHERE upf_id = ? AND upf_usr_id = ?");
            this._factory.initStatement(prepare);
            try {
                String value = obj.getValue();
                prepare.setString(1, obj.getName());
                prepare.setInt(2, obj.getFlags());
                prepare.setLong(3, value.length());
                prepare.setBinaryStream(4, new ByteArrayInputStream(value.getBytes(this._factory.getCharset())));
                prepare.setLong(5, obj.getID());
                prepare.setLong(6, obj.getUser().getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultPreference::update(" + obj.getUser().getName() + "," + obj.getName() + ")");
            return false;
        }
    }

    @Override
    public DBPreference find(long id) {
        DefaultFactory._LOG.severe("DefaultPreference::find(" + id + "): appele incongrue a cette methode");
        return null;
    }

    protected String convertString(InputStream input, int length) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream output = new ByteArrayOutputStream(length * 2);
        while ((len = input.read(buffer)) > 0) {
            output.write(buffer, 0, len);
        }
        buffer = output.toByteArray();
        return new String(buffer, this._factory.getCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBPreference find(DBUser user, String key) {
        DBPreference result = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT upf_id, upf_usr_id, upf_key, upf_flags, upf_data_size, upf_data FROM " + SQLTable.PREFERENCIES + " WHERE upf_usr_id = ? AND upf_key = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, user.getID());
                prepare.setString(2, key);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        DBPreference tmpPref = new DBPreference();
                        tmpPref.setID(resultSet.getLong(1));
                        tmpPref.setUser(user);
                        tmpPref.setName(key);
                        tmpPref.setFlags(resultSet.getInt(4));
                        tmpPref.setValue(this.convertString(resultSet.getBinaryStream(6), (int)resultSet.getLong(5)));
                        result = tmpPref;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DBPreference::find(" + user.getID() + "," + key + ")");
        }
        catch (Exception e) {
            this.logException(e, "DBPreference::find(" + user.getID() + "," + key + ")");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> collect(DBUser user) {
        TreeMap<Long, String> result = new TreeMap<Long, String>();
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT upf_id, upf_key, upf_data_size FROM " + SQLTable.PREFERENCIES + " WHERE upf_usr_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, user.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        String key = resultSet.getString(2);
                        long length = resultSet.getLong(3);
                        if (length <= 0L) continue;
                        result.put(id, key);
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultPreference::collect(" + user.getName() + ")");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultPreference::collect(" + user.getName() + ")");
        }
        return result.values();
    }
}

