/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.def;

import com.dassault.cecilia.db.DBGroup;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.dao.DAOUser;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;

public class DefaultUser
extends DAOUser {
    protected Connection _connect = null;
    protected DefaultFactory _factory = null;

    public DefaultUser(Connection connect, DefaultFactory factory) {
        this._connect = connect;
        this._factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createUserIntoTable(DBUser obj) throws SQLException {
        boolean result;
        block16: {
            result = false;
            PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.USERS + " (usr_name, usr_login, usr_password, usr_description, usr_flags, usr_default_grp_id) VALUES (?, ?, ?, ?, ?, ?)", 1);
            this._factory.initStatement(prepare);
            try {
                int col = 1;
                prepare.setString(col++, obj.getName());
                prepare.setString(col++, obj.getLogin());
                prepare.setString(col++, obj.getPassword());
                prepare.setString(col++, obj.getDescription());
                prepare.setInt(col++, obj.getFlags());
                prepare.setLong(col++, obj.getDefaultGroup().getID());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) break block16;
                ResultSet resultSet = prepare.getGeneratedKeys();
                try {
                    if (resultSet.next()) {
                        obj.setID(resultSet.getLong(1));
                        result = true;
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!result) {
            throw new SQLException("Internal error during INSERT INTO " + SQLTable.USERS + ": " + obj.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBUser create(DBUser obj) {
        long id = -1L;
        try {
            this._factory.beginTransaction(false);
            IGroup defGroup = obj.getDefaultGroup();
            if (defGroup instanceof DBGroup && defGroup.getID() <= 0L) {
                this._factory.createGroupDAO().createGroupIntoTable((DBGroup)defGroup);
            }
            this.createUserIntoTable(obj);
            id = obj.getID();
            obj.addGroup(obj.getDefaultGroup());
            PreparedStatement prepare = this._connect.prepareStatement("INSERT INTO " + SQLTable.GRP_USR + " (grp_grp_id, grp_usr_id) VALUES (?, ?)");
            this._factory.initStatement(prepare);
            try {
                for (IGroup group : obj.getGroups()) {
                    if (group instanceof DBGroup && group.getID() <= 0L) {
                        this._factory.createGroupDAO().createGroupIntoTable((DBGroup)group);
                    }
                    prepare.setLong(1, group.getID());
                    prepare.setLong(2, id);
                    prepare.executeUpdate();
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            this._factory.endTransaction();
        }
        catch (Exception e) {
            id = -1L;
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultUser::create(" + obj.getName() + ")");
        }
        if (id != -1L) {
            return this.find(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(DBUser obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.USERS + " WHERE usr_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                int nbrChg = prepare.executeUpdate();
                if (nbrChg != 1) return false;
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultUser::delete(" + obj.getID() + "," + obj.getName() + ")");
            return false;
        }
        catch (Exception e) {
            this.logException(e, "DefaultUser::delete(" + obj.getID() + "," + obj.getName() + ")");
        }
        return false;
    }

    @Override
    public boolean update(DBUser obj) {
        Set emptyGroups = Collections.emptySet();
        return this.update(obj, emptyGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(DBUser obj, Set<? extends IGroup> oldGroups) {
        boolean withSessions = this._factory.createSessionDAO().findAll(obj).size() > 0;
        try {
            this._factory.beginTransaction(false);
            PreparedStatement prepare = this._connect.prepareStatement("UPDATE " + SQLTable.USERS + " SET usr_name=?, usr_login=?, usr_password=?, usr_description=?, usr_flags=?, usr_default_grp_id=? WHERE usr_id = ?");
            this._factory.initStatement(prepare);
            try {
                int col = 1;
                prepare.setString(col++, obj.getName());
                prepare.setString(col++, obj.getLogin());
                prepare.setString(col++, obj.getPassword());
                prepare.setString(col++, obj.getDescription());
                prepare.setLong(col++, obj.getFlags());
                prepare.setLong(col++, obj.getDefaultGroup().getID());
                prepare.setLong(col++, obj.getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception col) {}
            }
            prepare = this._connect.prepareStatement("DELETE FROM " + SQLTable.GRP_USR + " WHERE grp_usr_id = ?");
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                prepare.executeUpdate();
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception col) {}
            }
            obj.addGroup(obj.getDefaultGroup());
            ArrayList<? extends IGroup> newGroups = new ArrayList<IGroup>();
            PreparedStatement prepare2 = this._connect.prepareStatement("INSERT INTO " + SQLTable.GRP_USR + " (grp_grp_id, grp_usr_id) VALUES (?, ?)");
            this._factory.initStatement(prepare2);
            try {
                for (IGroup group : obj.getGroups()) {
                    prepare2.setLong(1, group.getID());
                    prepare2.setLong(2, obj.getID());
                    prepare2.executeUpdate();
                    if (oldGroups.remove(group)) continue;
                    newGroups.add(group);
                }
            }
            finally {
                try {
                    prepare2.close();
                }
                catch (Exception exception) {}
            }
            if (withSessions) {
                newGroups.addAll(oldGroups);
                this._factory.createFolderDAO().updateVisibilityForGroups(newGroups);
            }
            this._factory.endTransaction();
            return true;
        }
        catch (Exception e) {
            try {
                this._factory.abortTransaction();
            }
            catch (Exception abortExc) {
                DefaultFactory._LOG.log(Level.SEVERE, "Exception during abort transaction operation: Risk of corruption of data", abortExc);
            }
            this.logException(e, "DefaultUser::update(" + obj.getID() + "," + obj.getName() + ")");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBUser> findAll() {
        TreeMap<Long, DBUser> result = new TreeMap<Long, DBUser>();
        try {
            ResultSet resultSet2;
            PreparedStatement prepare = this._connect.prepareStatement("SELECT usr_id, usr_name, usr_login, usr_password, usr_description, usr_flags, usr_default_grp_id FROM " + SQLTable.USERS, 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                resultSet2 = prepare.executeQuery();
                try {
                    while (resultSet2.next()) {
                        int col = 1;
                        long id = resultSet2.getLong(col++);
                        String name = resultSet2.getString(col++);
                        String login = resultSet2.getString(col++);
                        String passwd = resultSet2.getString(col++);
                        String description = resultSet2.getString(col++);
                        int flags = resultSet2.getInt(col++);
                        long groupId = resultSet2.getLong(col++);
                        DBUser obj = new DBUser(id, login).setPassword(passwd);
                        obj.setName(name).setDescription(description);
                        obj.setFlags(flags);
                        obj.setDescription(description);
                        DBGroup group = this._factory.createGroupDAO().find(groupId);
                        if (group != null) {
                            obj.setDefaultGroup(group);
                        }
                        result.put(id, obj);
                    }
                }
                finally {
                    try {
                        resultSet2.close();
                    }
                    catch (Exception col) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception resultSet2) {}
            }
            prepare = this._connect.prepareStatement("SELECT usr_id, grp_id, grp_name, grp_flags FROM " + SQLTable.GROUPS + ", " + SQLTable.GRP_USR + ", " + SQLTable.USERS + " WHERE grp_grp_id = grp_id AND grp_usr_id = usr_id", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                resultSet2 = prepare.executeQuery();
                try {
                    while (resultSet2.next()) {
                        long id = resultSet2.getLong(1);
                        DBUser obj = (DBUser)result.get(id);
                        if (obj == null) continue;
                        obj.addGroup(new IGroup.MinimalGroup(resultSet2.getLong(2), resultSet2.getString(3), resultSet2.getInt(4)));
                    }
                }
                finally {
                    try {
                        resultSet2.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            result.clear();
            this.logSQLException(e, "DefaultUser::findAll()");
        }
        catch (Exception e) {
            result.clear();
            this.logException(e, "DefaultUser::findAll()");
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean find(long id, DBUser obj) throws SQLException {
        block21: {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT usr_name, usr_login, usr_password, usr_description, usr_flags, usr_default_grp_id FROM " + SQLTable.USERS + " WHERE usr_id = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, id);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        int col = 1;
                        String name = resultSet.getString(col++);
                        String login = resultSet.getString(col++);
                        String passwd = resultSet.getString(col++);
                        String description = resultSet.getString(col++);
                        int flags = resultSet.getInt(col++);
                        long groupId = resultSet.getLong(col++);
                        obj.setLogin(login).setPassword(passwd).setID(id);
                        obj.setName(name).setDescription(description);
                        obj.setFlags(flags);
                        obj.setDescription(description);
                        DBGroup group = this._factory.createGroupDAO().find(groupId);
                        if (group != null) {
                            obj.setDefaultGroup(group);
                        }
                        break block21;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
        }
        obj.clearGroups();
        return this.findGroups(obj);
    }

    @Override
    public DBUser find(long id) {
        DBUser obj = new DBUser();
        try {
            if (this.find(id, obj)) {
                return obj;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultUser::find(" + id + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultUser::find(" + id + ")");
        }
        return null;
    }

    @Override
    public boolean refresh(DBUser obj) {
        try {
            if (this.find(obj.getID(), obj)) {
                return true;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultUser::refresh(" + obj + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultUser::refresh(" + obj + ")");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBUser findByLogin(String login) {
        DBUser obj = null;
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT usr_id, usr_name, usr_password, usr_description, usr_flags, usr_default_grp_id FROM " + SQLTable.USERS + " WHERE usr_login = ?", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setString(1, login);
                ResultSet resultSet = prepare.executeQuery();
                try {
                    if (resultSet.first()) {
                        int col = 1;
                        long id = resultSet.getLong(col++);
                        String name = resultSet.getString(col++);
                        String passwd = resultSet.getString(col++);
                        String description = resultSet.getString(col++);
                        int flags = resultSet.getInt(col++);
                        long groupId = resultSet.getLong(col++);
                        obj = new DBUser(id, login).setPassword(passwd);
                        obj.setName(name).setDescription(description);
                        obj.setFlags(flags);
                        obj.setDescription(description);
                        DBGroup group = this._factory.createGroupDAO().find(groupId);
                        if (group != null) {
                            obj.setDefaultGroup(group);
                        }
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            if (obj != null && this.findGroups(obj)) {
                return obj;
            }
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultUser::findByLogin(" + login + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultUser::findByLogin(" + login + ")");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findGroups(DBUser obj) {
        try {
            PreparedStatement prepare = this._connect.prepareStatement("SELECT grp_id, grp_name, grp_flags FROM " + SQLTable.GRP_USR + ", " + SQLTable.GROUPS + " WHERE grp_usr_id = ? AND grp_grp_id = grp_id", 1004, 1007);
            this._factory.initStatement(prepare);
            try {
                prepare.setLong(1, obj.getID());
                ResultSet resultSet = prepare.executeQuery();
                try {
                    while (resultSet.next()) {
                        long idGrp = resultSet.getLong(1);
                        String name = resultSet.getString(2);
                        int flags = resultSet.getInt(3);
                        obj.addGroup(new IGroup.MinimalGroup(idGrp, name, flags));
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    prepare.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        catch (SQLException e) {
            this.logSQLException(e, "DefaultUser::findGroups(" + obj.getID() + "," + obj.getName() + ")");
        }
        catch (Exception e) {
            this.logException(e, "DefaultUser::findGroups(" + obj.getID() + "," + obj.getName() + ")");
        }
        return false;
    }
}

