/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.h2;

import com.dassault.cecilia.db.DBLicense;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.def.DefaultLicense;
import com.dassault.cecilia.db.dao.sql.h2.H2Factory;
import com.dassault.cecilia.lib.util.MacAdressUtility;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class H2License
extends DefaultLicense {
    public H2License(SQLConnection sqlConnect, H2Factory factory) {
        super(sqlConnect, factory);
    }

    @Override
    public boolean verifyHost(String dbHost, String localHost) {
        StringTokenizer st = new StringTokenizer(localHost, ";");
        while (st.hasMoreTokens()) {
            if (!dbHost.contains(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    private String readMacAdress() {
        try {
            return MacAdressUtility.getMACAddress();
        }
        catch (Exception e) {
            H2Factory._LOG.log(Level.SEVERE, "Exception during read MAC adress", e);
            return null;
        }
    }

    @Override
    public String getHostConnection() {
        return this.readMacAdress();
    }

    @Override
    protected DBLicense specificFind(long id, String module, String company, String host, String version, int token, Date expire) {
        if (company.equals("Dassault Aviation") && host.equals(System.getProperty("cecilia.db.user"))) {
            DBLicense obj = new DBLicense(id);
            obj.setCompany(company).setModule(module).setHost(host);
            obj.setVersion(version);
            obj.setToken(token);
            obj.setExpire(expire);
            return obj;
        }
        return null;
    }

    @Override
    public int getCountConnection() {
        return 1;
    }
}

