/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.postgres;

import com.dassault.cecilia.db.dao.DAOPreference;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.def.DefaultFolder;
import com.dassault.cecilia.db.dao.sql.def.DefaultGroup;
import com.dassault.cecilia.db.dao.sql.def.DefaultLicense;
import com.dassault.cecilia.db.dao.sql.def.DefaultObjModel;
import com.dassault.cecilia.db.dao.sql.def.DefaultObjProperty;
import com.dassault.cecilia.db.dao.sql.def.DefaultObject;
import com.dassault.cecilia.db.dao.sql.def.DefaultSession;
import com.dassault.cecilia.db.dao.sql.def.DefaultUser;
import com.dassault.cecilia.db.dao.sql.postgres.PostgresFolder;
import com.dassault.cecilia.db.dao.sql.postgres.PostgresLicense;
import com.dassault.cecilia.db.dao.sql.seq.SeqFactory;
import com.dassault.cecilia.db.dao.sql.seq.SeqGroup;
import com.dassault.cecilia.db.dao.sql.seq.SeqObjModel;
import com.dassault.cecilia.db.dao.sql.seq.SeqObjProperty;
import com.dassault.cecilia.db.dao.sql.seq.SeqObject;
import com.dassault.cecilia.db.dao.sql.seq.SeqPreference;
import com.dassault.cecilia.db.dao.sql.seq.SeqSession;
import com.dassault.cecilia.db.dao.sql.seq.SeqUser;
import java.sql.SQLException;
import java.util.logging.Logger;

public class PostgresFactory
extends SeqFactory {
    static Logger _LOG = Logger.getLogger(PostgresFactory.class.getPackage().getName());
    private boolean _bWithExceptionDuringTransaction = false;

    public PostgresFactory(SQLConnection sqlConnect) {
        super(sqlConnect);
    }

    @Override
    public void beginTransaction(boolean cumulatif) throws SQLException {
        super.beginTransaction(cumulatif);
        if (cumulatif) {
            this._bWithExceptionDuringTransaction = false;
        }
    }

    void setExceptionDuringTransaction() {
        this._bWithExceptionDuringTransaction = true;
    }

    @Override
    public boolean withExceptionDuringTransaction() {
        return this._bWithExceptionDuringTransaction;
    }

    @Override
    public DefaultGroup createGroupDAO() {
        if (this._daoGroup == null) {
            this._daoGroup = new SeqGroup(this._connect, this);
        }
        return this._daoGroup;
    }

    @Override
    public DefaultUser createUserDAO() {
        if (this._daoUser == null) {
            this._daoUser = new SeqUser(this._connect, this);
        }
        return this._daoUser;
    }

    @Override
    public DefaultSession createSessionDAO() {
        if (this._daoSession == null) {
            this._daoSession = new SeqSession(this._connect, this);
        }
        return this._daoSession;
    }

    @Override
    public DefaultLicense createLicenseDAO() {
        if (this._daoLicense == null) {
            this._daoLicense = new PostgresLicense(this._sqlConnect, this);
        }
        return this._daoLicense;
    }

    @Override
    public DAOPreference createPreferenceDAO() {
        if (this._daoPreference == null) {
            this._daoPreference = new SeqPreference(this._connect, this);
        }
        return this._daoPreference;
    }

    @Override
    public DefaultFolder createFolderDAO() {
        if (this._daoFolder == null) {
            this._daoFolder = new PostgresFolder(this._connect, this);
        }
        return this._daoFolder;
    }

    @Override
    public DefaultObject createObjectDAO() {
        if (this._daoObject == null) {
            this._daoObject = new SeqObject(this._connect, this);
        }
        return this._daoObject;
    }

    @Override
    public DefaultObjProperty createObjPropertyDAO() {
        if (this._daoObjProp == null) {
            this._daoObjProp = new SeqObjProperty(this._connect, this);
        }
        return this._daoObjProp;
    }

    @Override
    public DefaultObjModel createObjModelDAO() {
        if (this._daoObjModel == null) {
            this._daoObjModel = new SeqObjModel(this._connect, this);
        }
        return this._daoObjModel;
    }

    @Override
    protected String createSequencesSQL(String seq) {
        StringBuilder sb = new StringBuilder();
        sb.append("nextval('");
        sb.append(seq).append("_pk_seq");
        sb.append("')");
        return sb.toString();
    }
}

