/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.sql.seq;

import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.db.dao.sql.SQLTable;
import com.dassault.cecilia.db.dao.sql.def.DefaultSession;
import com.dassault.cecilia.db.dao.sql.seq.SeqFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SeqSession
extends DefaultSession {
    private static final String[] __GENERATED_KEYS = new String[]{"ses_id"};

    public SeqSession(Connection connect, SeqFactory factory) {
        super(connect, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBSession create(DBSession obj) {
        try {
            long id;
            block22: {
                id = -1L;
                IUser curUser = obj.getUser();
                if (curUser instanceof DBUser && curUser.getID() <= 0L && (curUser = this._factory.createUserDAO().create((DBUser)curUser)) == null) {
                    return null;
                }
                StringBuilder sqlQuery = new StringBuilder(240).append("INSERT INTO " + SQLTable.SESSIONS + " (ses_id, ses_usr_id, ses_module, ses_flags, ses_expire)");
                sqlQuery.append(" VALUES (").append(((SeqFactory)this._factory).getSQLNextVal(SQLTable.SESSIONS));
                sqlQuery.append(", ?, ?, ?, ?)");
                PreparedStatement prepare = this._connect.prepareStatement(sqlQuery.toString(), __GENERATED_KEYS);
                this._factory.initStatement(prepare);
                try {
                    prepare.setLong(1, curUser.getID());
                    prepare.setString(2, obj.getModule());
                    prepare.setInt(3, obj.getFlags());
                    prepare.setLong(4, obj.getExpire());
                    int nbrChg = prepare.executeUpdate();
                    if (nbrChg != 1) break block22;
                    ResultSet resultSet = prepare.getGeneratedKeys();
                    try {
                        if (resultSet.next()) {
                            id = resultSet.getLong(1);
                        }
                    }
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (SQLException e) {
                    sqlQuery.append("[").append(curUser.getID());
                    sqlQuery.append(",").append(obj.getModule());
                    sqlQuery.append(",").append(obj.getFlags());
                    sqlQuery.append(",").append(obj.getExpire());
                    sqlQuery.append("]");
                    SeqFactory._LOG.fine("sqlQuery=" + sqlQuery.toString());
                    throw e;
                }
                finally {
                    try {
                        prepare.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (id != -1L) {
                return this.find(id);
            }
            this.logError("Error during OracleSession::create(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        catch (SQLException e) {
            this.logSQLException(e, "OracleSession::create(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        catch (Exception e) {
            this.logException(e, "OracleSession::create(" + obj.getID() + "," + obj.getUser().getLogin() + ")");
        }
        return null;
    }
}

