/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.xml;

import com.dassault.cecilia.db.DBPreference;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOPreference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DAOImportXmlPreference
extends DAOPreference {
    private long _seqID = 1L;
    Map<Key, DBPreference> _preferencies = new HashMap<Key, DBPreference>();

    @Override
    public DBPreference find(DBUser user, String key) {
        return this._preferencies.get(new Key(user, key));
    }

    @Override
    public Collection<String> collect(DBUser user) {
        return null;
    }

    @Override
    public DBPreference create(DBPreference obj) {
        Key key = new Key(obj.getUser(), obj.getName());
        if (this._preferencies.containsKey(key)) {
            return null;
        }
        this._preferencies.put(key, obj);
        obj.setID(this._seqID++);
        return obj;
    }

    @Override
    public boolean delete(DBPreference obj) {
        DBPreference dbPref = this.find(obj.getID());
        if (dbPref != null) {
            this._preferencies.remove(new Key(dbPref.getUser(), dbPref.getName()));
            return true;
        }
        return false;
    }

    @Override
    public boolean update(DBPreference obj) {
        DBPreference dbPref = this.find(obj.getID());
        if (dbPref != null) {
            this._preferencies.remove(new Key(dbPref.getUser(), dbPref.getName()));
            dbPref.copyFrom(obj);
            this._preferencies.put(new Key(dbPref.getUser(), dbPref.getName()), dbPref);
            return true;
        }
        return false;
    }

    @Override
    public DBPreference find(long id) {
        for (DBPreference dbPref : this._preferencies.values()) {
            if (dbPref.getID() != id) continue;
            return dbPref;
        }
        return null;
    }

    static class Key {
        DBUser _user;
        String _name;

        Key(DBUser dbUser, String name) {
            this._user = dbUser;
            this._name = name;
        }

        public int hashCode() {
            return this._name.hashCode() * 7 + Long.valueOf(this._user.getID()).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key key = (Key)obj;
                if (!this._user.equals(key._user)) {
                    return false;
                }
                return this._name.equals(key._name);
            }
            return false;
        }
    }
}

