/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.db.dao.xml;

import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IGroup;
import com.dassault.cecilia.db.dao.DAOUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DAOImportXmlUser
extends DAOUser {
    DBUser _dbUserAdmin;
    List<DBUser> _users;
    long _seqID = 2L;

    public DAOImportXmlUser(DBUser dbUser) {
        this._dbUserAdmin = dbUser;
        this._users = new ArrayList<DBUser>(5);
        this._users.add(this._dbUserAdmin);
    }

    @Override
    public DBUser find(long id) {
        for (int i = this._users.size() - 1; i >= 0; --i) {
            if (this._users.get(i).getID() != id) continue;
            return this._users.get(i);
        }
        return null;
    }

    @Override
    public DBUser findByLogin(String login) {
        for (int i = this._users.size() - 1; i >= 0; --i) {
            if (!this._users.get(i).getName().equals(login)) continue;
            return this._users.get(i);
        }
        return null;
    }

    @Override
    public Collection<DBUser> findAll() {
        return this._users;
    }

    @Override
    public boolean refresh(DBUser obj) {
        return obj.getID() == this._dbUserAdmin.getID();
    }

    @Override
    public DBUser create(DBUser obj) {
        for (int i = this._users.size() - 1; i >= 0; --i) {
            if (!this._users.get(i).getLogin().equals(obj.getLogin())) continue;
            return null;
        }
        obj.setID(this._seqID++);
        this._users.add(obj);
        return obj;
    }

    @Override
    public boolean delete(DBUser obj) {
        for (int i = this._users.size() - 1; i >= 0; --i) {
            if (this._users.get(i).getID() != obj.getID()) continue;
            this._users.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean update(DBUser obj) {
        for (int i = this._users.size() - 1; i >= 0; --i) {
            DBUser dbUser = this._users.get(i);
            if (dbUser.getID() != obj.getID()) continue;
            dbUser.copyFrom(obj);
            dbUser.setLogin(obj.getLogin());
            dbUser.setPassword(obj.getPassword());
            dbUser.setName(obj.getName());
            dbUser.setDescription(obj.getDescription());
            return true;
        }
        return false;
    }

    @Override
    public boolean update(DBUser dbUser, Set<? extends IGroup> oldGroups) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBUser getMasterUser() {
        return this._dbUserAdmin;
    }
}

