/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.general.law.ParamLaw;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.ResLaw;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.wrap.DBWrap;

public class CLawManager
extends LawManager {
    public static final String ARBOR_LAW = "ARBOR-Law";
    public static final String ARBOR_PAR = "ARBOR-Parameter";
    public static final String ARBOR_MOD = "ARBOR-Modifier";
    public static final int LAW_ID_EXP = 0;
    public static final int LAW_ID_CST = 1;
    public static final int LAW_ID_GLM = 2;
    public static final int LAW_ID_GLMA = 3;
    public static final int LAW_ID_WEB = 4;
    public static final int LAW_ID_SPT = 5;
    public static final int LAW_ID_FPT = 6;
    public static final int LAW_ID_NRD = 7;
    public static final int LAW_ID_CMT = 8;
    public static final int LAW_ID_DOR = 9;
    public static final int LAW_ID_DIR = 10;
    public static final int LAW_ID_WEB2 = 104;
    public static final int LAW_ID_INCERT_NLOG = 0;
    public static final int LAW_ID_INCERT_UNIF = 1;
    public static final int LAW_ID_INCERT_NORM = 2;
    public static final int LAW_ID_MOD_BOUND = 0;
    CECFactory _cecFactory;
    int[] _lawIDs = null;
    Object _lockerGetLaws = new Object();

    private static String _G(String key) {
        return ResLaw.getString(key);
    }

    public CLawManager(CECFactory cecFactory) {
        super(ARBOR_LAW);
        this._cecFactory = cecFactory;
        this.createLaws();
        this.createParameterLaws();
        this.createModifierLaws();
    }

    private void createLaws() {
        int idx = 0;
        this.defineLaw(0, CLawManager._G("LAW_LBL_EXP"), CLawManager._G("LAW_TLT_EXP"), 2, "exponential", "exponential");
        this.addParam(0, this.defineParam(idx++, CLawManager._G("PARAM_LBL_LAMBDA"), CLawManager._G("PARAM_TLT_LAMBDA"), TypeParam.RATE, 0.001));
        this._defaultLaw = 1;
        this.defineLaw(1, CLawManager._G("LAW_LBL_CST"), CLawManager._G("LAW_TLT_CST"), 2, "constant", "constant");
        this.addParam(1, this.defineParam(idx++, CLawManager._G("PARAM_LBL_VALUE"), CLawManager._G("PARAM_TLT_VALUE"), TypeParam.PROBABILITY, 0.0));
        this.defineLaw(2, CLawManager._G("LAW_LBL_GLM"), CLawManager._G("LAW_TLT_GLM"), 2, "GLM", "GLM");
        this.addParam(2, this.defineParam(idx++, CLawManager._G("PARAM_LBL_GAMMA"), CLawManager._G("PARAM_TLT_GAMMA"), TypeParam.PROBABILITY, 0.0));
        this.addParam(2, this.defineParam(idx++, CLawManager._G("PARAM_LBL_LAMBDA"), CLawManager._G("PARAM_TLT_LAMBDA"), TypeParam.RATE, 0.001));
        this.addParam(2, this.defineParam(idx++, CLawManager._G("PARAM_LBL_MU"), CLawManager._G("PARAM_TLT_MU"), TypeParam.RATE, 0.01));
        this.defineLaw(3, CLawManager._G("LAW_LBL_GLMa"), CLawManager._G("LAW_TLT_GLMa"), 2, "GLM-asymptotic", "GLMa");
        this.addParam(3, this.defineParam(idx++, CLawManager._G("PARAM_LBL_LAMBDA"), CLawManager._G("PARAM_TLT_LAMBDA"), TypeParam.RATE, 0.001));
        this.addParam(3, this.defineParam(idx++, CLawManager._G("PARAM_LBL_MU"), CLawManager._G("PARAM_TLT_MU"), TypeParam.RATE, 0.01));
        this.defineLaw(4, CLawManager._G("LAW_LBL_WBL"), CLawManager._G("LAW_TLT_WBL"), 2, "Weibull", "Weibull");
        this.addParam(4, this.defineParam(idx++, CLawManager._G("PARAM_LBL_ALPHA"), CLawManager._G("PARAM_TLT_ALPHA"), TypeParam.FACTOR, 1000.0));
        this.addParam(4, this.defineParam(idx++, CLawManager._G("PARAM_LBL_BETA"), CLawManager._G("PARAM_TLT_BETA"), TypeParam.FACTOR, 1.0));
        this.addParam(4, this.defineParam(idx++, CLawManager._G("PARAM_LBL_T0"), CLawManager._G("PARAM_TLT_T0"), TypeParam.DELAY, 0.0));
        this.defineLaw(104, CLawManager._G("LAW_LBL_WBL"), CLawManager._G("LAW_TLT_WBL"), 2, "Weibull", "Weibull2");
        this.addParam(104, this.defineParam(idx++, CLawManager._G("PARAM_LBL_ALPHA"), CLawManager._G("PARAM_TLT_ALPHA"), TypeParam.FACTOR, 0.001));
        this.addParam(104, this.defineParam(idx++, CLawManager._G("PARAM_LBL_BETA"), CLawManager._G("PARAM_TLT_BETA"), TypeParam.FACTOR, 2.0));
        this.defineLaw(5, CLawManager._G("LAW_LBL_SPT"), CLawManager._G("LAW_TLT_SPT"), 2, "periodic-test", "SPT");
        this.addParam(5, this.defineParam(idx++, CLawManager._G("PARAM_LBL_LAMBDA"), CLawManager._G("PARAM_TLT_LAMBDA"), TypeParam.RATE, 0.001));
        this.addParam(5, this.defineParam(idx++, CLawManager._G("PARAM_LBL_T"), CLawManager._G("PARAM_TLT_T"), TypeParam.DELAY, 730.0));
        this.addParam(5, this.defineParam(idx++, CLawManager._G("PARAM_LBL_T0"), CLawManager._G("PARAM_TLT_T0"), TypeParam.DELAY, 0.0));
        this.addLawDagExportAlias(5, "periodic_test");
        this.defineLaw(6, CLawManager._G("LAW_LBL_FPT"), CLawManager._G("LAW_TLT_FPT"), 3, "periodic-test", "FPT");
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_LAMBDA"), CLawManager._G("PARAM_TLT_LAMBDA"), TypeParam.RATE, 0.001));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_LAMBDA2"), CLawManager._G("PARAM_TLT_LAMBDA2"), TypeParam.RATE, 0.001));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_MU"), CLawManager._G("PARAM_TLT_MU"), TypeParam.RATE, 0.01));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_TAU"), CLawManager._G("PARAM_TLT_TAU"), TypeParam.DELAY, 730.0));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_THETA"), CLawManager._G("PARAM_TLT_THETA"), TypeParam.DELAY, 730.0));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_GAMMA"), CLawManager._G("PARAM_TLT_GAMMA"), TypeParam.PROBABILITY, 0.0));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_PI"), CLawManager._G("PARAM_TLT_PI"), TypeParam.DELAY, 10.0));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_X"), CLawManager._G("PARAM_TLT_X"), TypeParam.BOOLEAN, 1.0));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_SIGMA"), CLawManager._G("PARAM_TLT_SIGMA"), TypeParam.PROBABILITY, 1.0));
        this.addParam(6, this.defineParam(idx++, CLawManager._G("PARAM_LBL_OMEGA"), CLawManager._G("PARAM_TLT_OMEGA"), TypeParam.PROBABILITY, 0.0));
        this.addLawDagExportAlias(6, "periodic_test");
        this.defineLaw(7, CLawManager._G("LAW_LBL_NRD"), CLawManager._G("LAW_TLT_NRD"), 2, "NRD", "NRD");
        this.addParam(7, this.defineParam(idx++, CLawManager._G("PARAM_LBL_MU"), CLawManager._G("PARAM_TLT_MU"), TypeParam.RATE, 0.01));
        this.addParam(7, this.defineParam(idx++, CLawManager._G("PARAM_LBL_T"), CLawManager._G("PARAM_TLT_T"), TypeParam.DELAY, 24.0));
        this.defineLaw(8, CLawManager._G("LAW_LBL_CMT"), CLawManager._G("LAW_TLT_CMT"), 2, "CMT", "CMT");
        this.addParam(8, this.defineParam(idx++, CLawManager._G("PARAM_LBL_LAMBDA"), CLawManager._G("PARAM_TLT_LAMBDA"), TypeParam.RATE, 0.001));
        this.addParam(8, this.defineParam(idx++, CLawManager._G("PARAM_LBL_MT"), CLawManager._G("PARAM_TLT_MT"), TypeParam.DELAY, 730.0));
        this.addParam(8, this.defineParam(idx++, CLawManager._G("PARAM_LBL_VALUE"), CLawManager._G("PARAM_TLT_VALUE"), TypeParam.PROBABILITY, 0.0));
        this.defineLaw(9, CLawManager._G("LAW_LBL_DOR"), CLawManager._G("LAW_TLT_DOR"), 2, "dormant", "dormant");
        this.addParam(9, this.defineParam(idx++, CLawManager._G("PARAM_LBL_LAMBDA"), CLawManager._G("PARAM_TLT_LAMBDA"), TypeParam.RATE, 0.001));
        this.addParam(9, this.defineParam(idx++, CLawManager._G("PARAM_LBL_MTTR"), CLawManager._G("PARAM_TLT_MTTR"), TypeParam.DELAY, 48.0));
        this.addParam(9, this.defineParam(idx++, CLawManager._G("PARAM_LBL_T"), CLawManager._G("PARAM_TLT_T"), TypeParam.DELAY, 730.0));
        this.defineLaw(10, CLawManager._G("LAW_LBL_DRC"), CLawManager._G("LAW_TLT_DRC"), 3, "Dirac", "Dirac");
        this.addParam(10, this.defineParam(idx++, CLawManager._G("PARAM_LBL_DELAY"), CLawManager._G("PARAM_TLT_DELAY"), TypeParam.DELAY, 10.0));
    }

    @Override
    public Law createLaw(int idLaw) {
        if (idLaw == 104) {
            return super.createLaw(4);
        }
        return super.createLaw(idLaw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getLaws() {
        if (this._lawIDs == null) {
            Object object = this._lockerGetLaws;
            synchronized (object) {
                int[] lawIDs = super.getLaws();
                this._lawIDs = new int[lawIDs.length - 1];
                int idx = 0;
                for (int i = 0; i < lawIDs.length; ++i) {
                    int id = lawIDs[i];
                    if (id == 104) continue;
                    this._lawIDs[idx++] = id;
                }
            }
        }
        return this._lawIDs;
    }

    @Override
    public double evaluate(Param param) {
        if (param instanceof ParamValue) {
            return (Double)param.getValue();
        }
        if (param instanceof ParamLaw) {
            return this.getParameterManager().evaluate(param);
        }
        if (param instanceof ParamRef) {
            DBWrap dbWrap;
            if (this._cecFactory != null && (dbWrap = this._cecFactory.findOrCreateWrap(((ParamRef)param).getValue())) != null && dbWrap instanceof DBParam) {
                return this.evaluate(((DBParam)dbWrap).getValue());
            }
        } else if (param instanceof ParamFMEA) {
            return (Double)param.getValue();
        }
        return Double.NaN;
    }

    @Override
    public double evaluate(Law law, double time) {
        return Double.NaN;
    }

    private void createParameterLaws() {
        LawManager incertitudes = new LawManager(ARBOR_PAR){

            @Override
            public double evaluate(Param param) {
                if (param instanceof ParamLaw) {
                    Law law = ((ParamLaw)param).getValue();
                    switch (law.getID()) {
                        case 0: {
                            return CLawManager.this.evaluate(law.getParamAt(0));
                        }
                        case 2: {
                            return CLawManager.this.evaluate(law.getParamAt(0));
                        }
                        case 1: {
                            return 0.5 * (CLawManager.this.evaluate(law.getParamAt(0)) + CLawManager.this.evaluate(law.getParamAt(1)));
                        }
                    }
                }
                return Double.NaN;
            }

            @Override
            public double evaluate(Law law, double time) {
                return Double.NaN;
            }
        };
        int idx = 0;
        incertitudes.defineLaw(0, CLawManager._G("LAW_LBL_NLOG"), CLawManager._G("LAW_TLT_NLOG"), 2, "lognormal", "lognormal");
        incertitudes.addParam(0, incertitudes.defineParam(idx++, CLawManager._G("PARAM_LBL_MEAN"), CLawManager._G("PARAM_TLT_MEAN"), null, Double.MIN_VALUE));
        incertitudes.addParam(0, incertitudes.defineParam(idx++, CLawManager._G("PARAM_LBL_FACTOR"), CLawManager._G("PARAM_TLT_FACTOR"), TypeParam.FACTOR, 3.0));
        incertitudes.defineLaw(1, CLawManager._G("LAW_LBL_UNIF"), CLawManager._G("LAW_TLT_UNIF"), 2, "uniform", "uniform");
        incertitudes.addParam(1, incertitudes.defineParam(idx++, CLawManager._G("PARAM_LBL_MIN"), CLawManager._G("PARAM_TLT_MIN"), null, Double.MIN_VALUE));
        incertitudes.addParam(1, incertitudes.defineParam(idx++, CLawManager._G("PARAM_LBL_MAX"), CLawManager._G("PARAM_TLT_MAX"), null, Double.MIN_VALUE));
        incertitudes.defineLaw(2, CLawManager._G("LAW_LBL_NORMAL"), CLawManager._G("LAW_TLT_NORMAL"), 4, "normal", "normal");
        incertitudes.addParam(2, incertitudes.defineParam(idx++, CLawManager._G("PARAM_LBL_MEAN"), CLawManager._G("PARAM_TLT_MEAN"), null, Double.MIN_VALUE));
        incertitudes.addParam(2, incertitudes.defineParam(idx++, CLawManager._G("PARAM_LBL_STDDEV"), CLawManager._G("PARAM_TLT_STDDEV"), TypeParam.FACTOR, 0.01));
        this.setParameterManager(incertitudes);
    }

    private void createModifierLaws() {
        LawManager modifiers = new LawManager(ARBOR_MOD){

            @Override
            public double evaluate(Param param) {
                return CLawManager.this.evaluate(param);
            }

            @Override
            public double evaluate(Law law, double time) {
                return Double.NaN;
            }
        };
        int idx = 0;
        modifiers.defineLaw(0, CLawManager._G("LAW_LBL_BOUND"), CLawManager._G("LAW_TLT_BOUND"), 4, "bound-time", "bound-time");
        modifiers.addParam(0, modifiers.defineParam(idx++, CLawManager._G("PARAM_LBL_T0"), CLawManager._G("PARAM_TLT_T0"), TypeParam.DELAY, 0.0));
        modifiers.addParam(0, modifiers.defineParam(idx++, CLawManager._G("PARAM_LBL_DELAY"), CLawManager._G("PARAM_TLT_DELAY"), TypeParam.DELAY, 48.0));
        this.setModifierManager(modifiers);
    }

    @Override
    public boolean isInspectedCompatible(Law law) {
        if (law == null) {
            return true;
        }
        if (law.getID() != 0) {
            return false;
        }
        return law.getModifierLaw() == null;
    }

    @Override
    public boolean isConstanteCompatible(Law law) {
        if (law == null) {
            return false;
        }
        if (law.getModifierLaw() != null) {
            return false;
        }
        switch (law.getID()) {
            case 1: {
                return true;
            }
            case 9: {
                return true;
            }
            case 3: {
                return true;
            }
            case 8: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }
}

