/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOGlobEvent;
import com.dassault.cecilia.db.dao.DAOGroup;
import com.dassault.cecilia.db.dao.DAOLicense;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.db.dao.DAOPreference;
import com.dassault.cecilia.db.dao.DAOProperty;
import com.dassault.cecilia.db.dao.DAORelation;
import com.dassault.cecilia.db.dao.DAOSession;
import com.dassault.cecilia.db.dao.DAOUser;
import com.dassault.cecilia.db.dao.DAOUtility;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CLawManager;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.dsf.DSFEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.BoolEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.fmea.DBModelFMEA;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.operator.OperatorDictionary;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CeciliaFactory
implements CECFactory {
    private static Logger _LOG = Logger.getLogger(CeciliaFactory.class.getPackage().getName());
    CAppl _application;
    DAOFactory _daoDelegate;
    CLawManager _lawManager;
    OperatorDictionary _dicOperators = null;
    Object _lockDicOperator = new Object();
    static DBWrap WRAP_ERROR = new DBWrap(null){

        @Override
        public Collection<DBRelation> getUseRelations() {
            return null;
        }

        @Override
        public DBFolder.Family getFamily() {
            return null;
        }

        @Override
        public DBWrap getCopy() {
            return null;
        }

        @Override
        protected String getNature() {
            return null;
        }

        @Override
        protected void toXML(Appendable out, String indent) throws IOException {
        }
    };
    Set<DBFolder> _currentStackWrap = new LinkedHashSet<DBFolder>();

    public CeciliaFactory(CAppl application, DAOFactory delegate) {
        this._application = application;
        this._daoDelegate = delegate;
        this._lawManager = new CLawManager(this);
    }

    @Override
    public String getUserLogin() {
        return this._application.getDBUser().getLogin();
    }

    @Override
    public void initConnection() {
    }

    @Override
    public DAOGroup createGroupDAO() {
        return this._daoDelegate.createGroupDAO();
    }

    @Override
    public DAOUser createUserDAO() {
        return this._daoDelegate.createUserDAO();
    }

    @Override
    public DAOSession createSessionDAO() {
        return this._daoDelegate.createSessionDAO();
    }

    @Override
    public DAOPreference createPreferenceDAO() {
        return this._daoDelegate.createPreferenceDAO();
    }

    @Override
    public DAOLicense createLicenseDAO() {
        return this._daoDelegate.createLicenseDAO();
    }

    @Override
    public DAOProperty createPropertyDAO() {
        return this._daoDelegate.createPropertyDAO();
    }

    @Override
    public DAOFolder createFolderDAO() {
        return this._daoDelegate.createFolderDAO();
    }

    @Override
    public DAOObject createObjectDAO() {
        return this._daoDelegate.createObjectDAO();
    }

    @Override
    public DAOObjModel createObjModelDAO() {
        return this._daoDelegate.createObjModelDAO();
    }

    @Override
    public DAORelation createRelationDAO() {
        return this._daoDelegate.createRelationDAO();
    }

    @Override
    public DAOGlobEvent createGlobEventDAO() {
        return this._daoDelegate.createGlobEventDAO();
    }

    @Override
    public DAOUtility createUtilityDAO() {
        return this._daoDelegate.createUtilityDAO();
    }

    @Override
    public DateFormat createDateFormat() {
        return this._daoDelegate.createDateFormat();
    }

    @Override
    public void beginTransaction(boolean cumulatif) throws Exception {
        this._daoDelegate.beginTransaction(cumulatif);
    }

    @Override
    public void endTransaction() throws Exception {
        this._daoDelegate.endTransaction();
    }

    @Override
    public void abortTransaction() throws Exception {
        this._daoDelegate.abortTransaction();
    }

    @Override
    public boolean withExceptionDuringTransaction() {
        return this._daoDelegate.withExceptionDuringTransaction();
    }

    @Override
    public boolean ignoreFreezeState() {
        return this._daoDelegate.ignoreFreezeState();
    }

    @Override
    public void setIgnoreFreezeState(boolean value) {
        this._daoDelegate.setIgnoreFreezeState(value);
    }

    @Override
    public void logStats() {
        this._daoDelegate.logStats();
    }

    @Override
    public CLawManager getLawManager() {
        return this._lawManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperatorDictionary getOperatorDictionary() {
        if (this._dicOperators == null) {
            Object object = this._lockDicOperator;
            synchronized (object) {
                OperatorDictionary localDic = null;
                if (this._dicOperators == null) {
                    localDic = new OperatorDictionary();
                    DAOFolder daoFolder = this.createFolderDAO();
                    DBFolder dbFolder = daoFolder.getRootID("OPERATOR_FAMILIES");
                    localDic.constructFrom(dbFolder, daoFolder);
                    this._application.addFolderUpdateListener(localDic);
                }
                if (this._dicOperators == null) {
                    this._dicOperators = localDic;
                }
            }
        }
        return this._dicOperators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DBWrap findOrCreateWrap(DBFolder dbFolder) {
        if (this._currentStackWrap.contains(dbFolder)) {
            _LOG.severe("DBFolder with loop relation : " + dbFolder.getRefPath());
            for (DBFolder dbTrace : this._currentStackWrap) {
                _LOG.severe("    Trace Loop : " + dbTrace.getRefPath());
            }
            return null;
        }
        this._currentStackWrap.add(dbFolder);
        try {
            DBWrap dBWrap = this.doFindOrCreateWrap(dbFolder);
            return dBWrap;
        }
        finally {
            this._currentStackWrap.remove(dbFolder);
        }
    }

    private DBWrap doFindOrCreateWrap(DBFolder dbFolder) {
        DAOObject daoObject = this.createObjectDAO();
        if (dbFolder.getObject() == null) {
            switch (dbFolder.getFamily()) {
                case BTP_APPLICATION: 
                case BTP_AUTHOR: 
                case BTP_SUBSTANTIATION: {
                    break;
                }
                default: {
                    _LOG.warning("DBFolder without Object (it's a joke): " + dbFolder.getRefPath());
                }
            }
            return null;
        }
        IWrap iwrap = daoObject.getWrap(dbFolder.getObject());
        if (iwrap == WRAP_ERROR) {
            _LOG.warning("DBFolder unconsistency (already previous error during readDAO): " + dbFolder.getRefPath());
            return null;
        }
        if (iwrap != null && iwrap instanceof DBWrap) {
            DBWrap dbWrap = (DBWrap)iwrap;
            if (!dbWrap.changeDependTimeUpdt()) {
                return dbWrap;
            }
            if (_LOG.isLoggable(Level.FINER)) {
                _LOG.finer("Call findOrCreateWrap with changeDependTimeUpdt() : " + dbFolder.getRefPath() + " [timeUpdate = " + dbWrap.getTimeUpdate() + "]");
            }
        }
        DBWrap dbWrap = null;
        switch (dbFolder.getFamily()) {
            case ATTRIBUTE: {
                dbWrap = new DBAttrib(dbFolder);
                break;
            }
            case PARAMETER: {
                dbWrap = new DBParam(dbFolder);
                break;
            }
            case BTP_MODEL: {
                dbWrap = new DBModelLaw(dbFolder);
                break;
            }
            case CCF_MODEL: {
                dbWrap = new CCF(dbFolder);
                break;
            }
            case FMEA_MODEL: {
                dbWrap = new DBModelFMEA(dbFolder);
                break;
            }
            case IMAG: {
                dbWrap = new DBIcon(dbFolder);
                break;
            }
            case TYPE: {
                if (dbFolder.getFamilyFlag() == 1) {
                    dbWrap = new DBEnum(dbFolder);
                    break;
                }
                dbWrap = new DBRecord(dbFolder);
                break;
            }
            case OPERATOR: {
                dbWrap = new AltaOperator(dbFolder);
                break;
            }
            case COMPONENT: {
                dbWrap = new AltaComponent(dbFolder);
                break;
            }
            case EQUIPMENT: {
                dbWrap = new AltaEquipment(dbFolder);
                break;
            }
            case PROJECT: {
                if (dbFolder.isFolder() && dbFolder.getObject() != null) {
                    dbWrap = new DBProject(dbFolder);
                    break;
                }
                switch (dbFolder.getFamilyFlag()) {
                    case 1: {
                        dbWrap = new AltaSystem(dbFolder);
                        break;
                    }
                    case 2: {
                        dbWrap = new FTEquation(dbFolder);
                        break;
                    }
                    case 5: {
                        dbWrap = new BoolEquation(dbFolder);
                        break;
                    }
                    case 3: {
                        dbWrap = new DSFEquation(dbFolder);
                        break;
                    }
                    case 4: {
                        dbWrap = new DBTableFMEA(dbFolder);
                    }
                }
                if (dbWrap != null) break;
            }
            default: {
                _LOG.severe("There are no declared wrap for DBFolder: " + dbFolder.getRefPath());
            }
        }
        if (dbWrap != null) {
            boolean successRead = false;
            try {
                if (_LOG.isLoggable(Level.FINER)) {
                    _LOG.log(Level.FINER, "readFromDAO : " + dbFolder.getRefPath() + " [" + dbFolder.getID() + "," + dbFolder.getObject().getID() + "]");
                }
                successRead = dbWrap.readFromDAO(this);
            }
            catch (DemoLimitedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                _LOG.log(Level.INFO, "Exception non gere lors de la lecture d'un DBFolder", ex);
            }
            if (!successRead) {
                _LOG.severe("Error during read data from DAO for DBFolder: " + dbFolder.getRefPath());
                daoObject.putWrap(dbFolder.getObject(), WRAP_ERROR);
            } else {
                daoObject.putWrap(dbFolder.getObject(), dbWrap);
                return dbWrap;
            }
        }
        return null;
    }
}

