/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.demo;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IWrap;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOObject;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import com.dassault.cecilia.dbobj.demo.DemoLimits;
import com.dassault.cecilia.dbobj.faulttree.ft.BoolEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperator;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class DemoLimitedFactory
extends CeciliaFactory {
    static Logger _LOG = Logger.getLogger(DemoLimitedFactory.class.getPackage().getName());
    DemoLimits _limits = new DemoLimits();
    CAppl _application;
    DAOObject _daoObject;
    DAOObject _daoObjectDelegate;
    DAOFolder _daoFolder = null;
    DAOFolder _daoFolderDelegate;

    public DemoLimitedFactory(CAppl application, DAOFactory delegate) {
        super(application, delegate);
        this._application = application;
    }

    @Override
    public synchronized DBWrap findOrCreateWrap(DBFolder dbFolder) {
        DBWrap result = super.findOrCreateWrap(dbFolder);
        if (result != null) {
            this.verifyModelLimits(result);
        }
        return result;
    }

    @Override
    public synchronized DAOObject createObjectDAO() {
        if (this._daoObject != null) {
            return this._daoObject;
        }
        this._daoObjectDelegate = super.createObjectDAO();
        this._daoObject = new DAOObject(){

            @Override
            public boolean update(DBObject obj) {
                return DemoLimitedFactory.this._daoObjectDelegate.update(obj);
            }

            @Override
            public DBObject find(long id) {
                return (DBObject)DemoLimitedFactory.this._daoObjectDelegate.find(id);
            }

            @Override
            public boolean delete(DBObject obj) {
                return DemoLimitedFactory.this._daoObjectDelegate.delete(obj);
            }

            @Override
            public boolean unlock(DBObject object, DBUser dbUser) {
                return DemoLimitedFactory.this._daoObjectDelegate.unlock(object, dbUser);
            }

            @Override
            public boolean unlock(DBObject obj, DBSession session) {
                return DemoLimitedFactory.this._daoObjectDelegate.unlock(obj, session);
            }

            @Override
            public boolean lock(DBObject obj, DBSession session) {
                return DemoLimitedFactory.this._daoObjectDelegate.lock(obj, session);
            }

            @Override
            public boolean isLockBy(DBObject obj, DBSession session) {
                return DemoLimitedFactory.this._daoObjectDelegate.isLockBy(obj, session);
            }

            @Override
            public boolean setFreeze(DBObject obj, boolean freeze) {
                return DemoLimitedFactory.this._daoObjectDelegate.setFreeze(obj, freeze);
            }

            @Override
            public boolean isFreeze(DBObject obj) {
                return DemoLimitedFactory.this._daoObjectDelegate.isFreeze(obj);
            }

            @Override
            public boolean putWrap(DBObject object, IWrap wrap) {
                return DemoLimitedFactory.this._daoObjectDelegate.putWrap(object, wrap);
            }

            @Override
            public IWrap getWrap(DBObject object) {
                return DemoLimitedFactory.this._daoObjectDelegate.getWrap(object);
            }

            @Override
            public void clearWraps() {
                DemoLimitedFactory.this._daoObjectDelegate.clearWraps();
            }

            @Override
            public DBObject create(DBObject obj) {
                if (!DemoLimitedFactory.this.createNewModel(obj)) {
                    return null;
                }
                return DemoLimitedFactory.this._daoObjectDelegate.create(obj);
            }
        };
        return this._daoObject;
    }

    @Override
    public synchronized DAOFolder createFolderDAO() {
        if (this._daoFolder != null) {
            return this._daoFolder;
        }
        this._daoFolderDelegate = super.createFolderDAO();
        this._daoFolder = new DAOFolder(){

            @Override
            public boolean exist(long id) {
                return DemoLimitedFactory.this._daoFolderDelegate.exist(id);
            }

            @Override
            public DBFolder find(long id) {
                return (DBFolder)DemoLimitedFactory.this._daoFolderDelegate.find(id);
            }

            @Override
            public List<DBFolder> findChildren(DBFolder parent) {
                return DemoLimitedFactory.this._daoFolderDelegate.findChildren(parent);
            }

            @Override
            public List<DBAccess> findAccesses(DBFolder obj) {
                return DemoLimitedFactory.this._daoFolderDelegate.findAccesses(obj);
            }

            @Override
            public boolean refresh(DBFolder dbFodler) {
                return DemoLimitedFactory.this._daoFolderDelegate.refresh(dbFodler);
            }

            @Override
            public void prepareCache() {
                DemoLimitedFactory.this._daoFolderDelegate.prepareCache();
            }

            @Override
            public void updateCache(DAOFolder.UpdateListener listener) {
                DemoLimitedFactory.this._daoFolderDelegate.updateCache(listener);
            }

            @Override
            public void freezeCache(boolean bFreeze) {
                DemoLimitedFactory.this._daoFolderDelegate.freezeCache(bFreeze);
            }

            @Override
            public DBFolder getRootID(String rootKey) {
                return DemoLimitedFactory.this._daoFolderDelegate.getRootID(rootKey);
            }

            private boolean verifyCreateObject(DBFolder dbFolder) {
                if (dbFolder.getObject() != null && dbFolder.getObject().getID() == -1L && !DemoLimitedFactory.this.createNewModel(dbFolder.getObject())) {
                    return false;
                }
                if (dbFolder.getChildren() != null && !dbFolder.getChildren().isEmpty()) {
                    for (DBFolder dbChild : dbFolder.getChildren()) {
                        if (dbChild.getObject() == null || dbChild.getID() != -1L || DemoLimitedFactory.this.createNewModel(dbChild.getObject())) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean update(DBFolder dbFolder) {
                if (!this.verifyCreateObject(dbFolder)) {
                    return false;
                }
                boolean result = DemoLimitedFactory.this._daoFolderDelegate.update(dbFolder);
                DemoLimitedFactory.this.refreshFolderAndVerifyBaseLimits();
                return result;
            }

            @Override
            public DBFolder create(DBFolder dbFolder) {
                if (!this.verifyCreateObject(dbFolder)) {
                    return null;
                }
                DBFolder result = DemoLimitedFactory.this._daoFolderDelegate.create(dbFolder);
                DemoLimitedFactory.this.refreshFolderAndVerifyBaseLimits();
                return result;
            }

            @Override
            public boolean delete(DBFolder obj) {
                boolean result = DemoLimitedFactory.this._daoFolderDelegate.delete(obj);
                DemoLimitedFactory.this.refreshFolderAndVerifyBaseLimits();
                return result;
            }
        };
        return this._daoFolder;
    }

    protected void refreshFolderAndVerifyBaseLimits() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DemoLimitedFactory.this._application.refreshDAOFolder(true);
                DemoLimitedFactory.this.verifyBaseLimitsCounter(true);
            }
        });
    }

    public void verifyModelLimits(DBWrap model) throws DemoLimitedException {
        if (model instanceof DBRecord) {
            DBRecord dbRecord = (DBRecord)model;
            if (dbRecord.getFields().size() > DemoLimits.Limit.LINK_FIELDS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.LINK_FIELDS, model.getDBFolder(), dbRecord.getFields().size());
            }
        } else if (model instanceof AltaSystem) {
            AltaSystem dbSystem = (AltaSystem)model;
            if (dbSystem.getSynchros().size() > DemoLimits.Limit.SYSTEM_SYNCS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.SYSTEM_SYNCS, model.getDBFolder(), dbSystem.getSynchros().size());
            }
            if (dbSystem.getSubs().size() > DemoLimits.Limit.SYSTEM_SUBS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.SYSTEM_SUBS, model.getDBFolder(), dbSystem.getSubs().size());
            }
            if (dbSystem.getConfigs().size() > DemoLimits.Limit.SYSTEM_CONFIGS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.SYSTEM_CONFIGS, model.getDBFolder(), dbSystem.getConfigs().size());
            }
        } else if (model instanceof AltaEquipment) {
            AltaEquipment dbEquipment = (AltaEquipment)model;
            if (dbEquipment.getFlows().size() > DemoLimits.Limit.EQUIPMENT_FLOWS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.EQUIPMENT_FLOWS, model.getDBFolder(), dbEquipment.getFlows().size());
            }
            if (dbEquipment.getSynchros().size() > DemoLimits.Limit.EQUIPMENT_SYNCS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.EQUIPMENT_SYNCS, model.getDBFolder(), dbEquipment.getSynchros().size());
            }
            if (dbEquipment.getSubs().size() > DemoLimits.Limit.EQUIPMENT_SUBS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.EQUIPMENT_SUBS, model.getDBFolder(), dbEquipment.getSubs().size());
            }
        } else if (model instanceof AltaComponent) {
            AltaComponent dbComponent = (AltaComponent)model;
            if (dbComponent.getFlows().size() > DemoLimits.Limit.COMPONENT_FLOWS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.COMPONENT_FLOWS, model.getDBFolder(), dbComponent.getFlows().size());
            }
            if (dbComponent.getStates().size() > DemoLimits.Limit.COMPONENT_STATES.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.COMPONENT_STATES, model.getDBFolder(), dbComponent.getStates().size());
            }
            if (dbComponent.getEvents().size() > DemoLimits.Limit.COMPONENT_EVENTS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.COMPONENT_EVENTS, model.getDBFolder(), dbComponent.getEvents().size());
            }
        } else if (model instanceof AltaOperator) {
            AltaOperator dbOperator = (AltaOperator)model;
            if (dbOperator.getFlows().size() > DemoLimits.Limit.OPERATOR_FLOWS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.OPERATOR_FLOWS, model.getDBFolder(), dbOperator.getFlows().size());
            }
        } else if (model instanceof BoolEquation) {
            BoolEquation boolEq = (BoolEquation)model;
            if (boolEq.getAllVariables().size() > DemoLimits.Limit.PROJECT_BEQ_VARS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.PROJECT_BEQ_VARS, model.getDBFolder(), boolEq.getAllVariables().size());
            }
        } else if (model instanceof FTEquation) {
            FTEquation boolEq = (FTEquation)model;
            if (boolEq.getConfigs().size() > DemoLimits.Limit.PROJECT_TREE_CONFIGS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.PROJECT_TREE_CONFIGS, model.getDBFolder(), boolEq.getConfigs().size());
            }
            int nbrGate = 0;
            int nbrLink = 0;
            int nbrLeaf = 0;
            for (FTVariable ftVar : boolEq.getInternalVariables()) {
                if (ftVar.isRoot()) continue;
                if (ftVar.isLinked()) {
                    ++nbrLink;
                    continue;
                }
                if (ftVar.isEventTerminal()) {
                    ++nbrLeaf;
                    continue;
                }
                ++nbrGate;
            }
            if (nbrLink > DemoLimits.Limit.PROJECT_TREE_LINKS.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.PROJECT_TREE_LINKS, model.getDBFolder(), nbrLink);
            }
            if (nbrLeaf > DemoLimits.Limit.PROJECT_TREE_LEAVES.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.PROJECT_TREE_LEAVES, model.getDBFolder(), nbrLeaf);
            }
            if (nbrGate > DemoLimits.Limit.PROJECT_TREE_GATES.getLimit()) {
                throw new DemoLimitedException(DemoLimits.Limit.PROJECT_TREE_GATES, model.getDBFolder(), nbrGate);
            }
        }
    }

    private void verifyBaseLimitsModel_rec(DBFolder dbFolder, DAOFolder daoFolder) throws DemoLimitedException {
        List<DBFolder> children;
        if (dbFolder.getObject() != null) {
            this.findOrCreateWrap(dbFolder);
        }
        if ((children = dbFolder.getChildren()) == null) {
            children = daoFolder.findChildren(dbFolder);
        }
        if (children == null) {
            return;
        }
        for (DBFolder dbChild : children) {
            this.verifyBaseLimitsModel_rec(dbChild, daoFolder);
        }
    }

    public void verifyBaseLimitsModel() throws DemoLimitedException {
        DAOFolder daoFolder = this.createFolderDAO();
        DBFolder dbRoot = daoFolder.getRootID("ROOT");
        this.verifyBaseLimitsModel_rec(dbRoot, daoFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyBaseLimitsCounter(boolean bReset) throws DemoLimitedException {
        DAOFolder daoFolder = this.createFolderDAO();
        DBFolder dbRoot = daoFolder.getRootID("ROOT");
        if (bReset) {
            this._limits = new DemoLimits();
        }
        try {
            this._limits.countModelFromFolder(dbRoot, daoFolder);
        }
        finally {
            if (bReset && Boolean.getBoolean("cecilia.core.debug")) {
                _LOG.finest(this._limits.toString());
            }
        }
    }

    public boolean createNewModel(DBObject obj) throws DemoLimitedException {
        if (!this.verifyCreateNewModel(obj.getFolder())) {
            return false;
        }
        this._limits.countModelFromFolder(obj.getFolder(), this.createFolderDAO());
        return true;
    }

    public boolean verifyCreateNewModel(DBFolder dbFolder) {
        return this._limits.verifyCreateNewModel(dbFolder);
    }

    public void verifyAppendLimits(DemoLimits appendLimits) throws DemoLimitedException {
        this._limits.verifyAppendLimits(appendLimits);
    }
}

