/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.demo;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.demo.DemoLimitedException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DemoLimits {
    Map<Limit, LimitCount> _counters = new LinkedHashMap<Limit, LimitCount>();

    public DemoLimits() {
    }

    public DemoLimits(Limit limit, int nbr) {
        this._counters.put(limit, new LimitCount(nbr));
    }

    public DemoLimits(Map<Limit, Integer> limits) {
        for (Map.Entry<Limit, Integer> entry : limits.entrySet()) {
            this._counters.put(entry.getKey(), new LimitCount(entry.getValue()));
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        for (Map.Entry<Limit, LimitCount> entry : this._counters.entrySet()) {
            if (buffer.length() > 1) {
                buffer.append(", ");
            }
            buffer.append("[").append(entry.getKey().getKey());
            buffer.append("|").append(entry.getKey().getLimit());
            buffer.append(";").append(entry.getValue()._cpt);
            buffer.append("]");
        }
        buffer.append("}");
        return buffer.toString();
    }

    private void incLimit(Limit limit) throws DemoLimitedException {
        LimitCount count = this._counters.get((Object)limit);
        if (count == null) {
            count = new LimitCount();
            this._counters.put(limit, count);
        }
        if (count._cpt + 1 > limit.getLimit()) {
            throw new DemoLimitedException(limit);
        }
        ++count._cpt;
        count = this._counters.get((Object)Limit.COUNT_ALL);
        if (count == null) {
            count = new LimitCount();
            this._counters.put(Limit.COUNT_ALL, count);
        }
        if (count._cpt + 1 > Limit.COUNT_ALL.getLimit()) {
            throw new DemoLimitedException(Limit.COUNT_ALL);
        }
        ++count._cpt;
    }

    public void incModelCounterFromFolder(DBFolder dbFolder) throws DemoLimitedException {
        if (dbFolder.getObject() == null) {
            return;
        }
        block0 : switch (dbFolder.getFamily()) {
            case ATTRIBUTE: {
                this.incLimit(Limit.COUNT_ATTRIBUT);
                break;
            }
            case OPERATOR: {
                this.incLimit(Limit.COUNT_OPERATOR);
                break;
            }
            case COMPONENT: {
                this.incLimit(Limit.COUNT_COMPONENT);
                break;
            }
            case EQUIPMENT: {
                this.incLimit(Limit.COUNT_EQUIPMENT);
                break;
            }
            case PARAMETER: {
                this.incLimit(Limit.COUNT_PARAMETER);
                break;
            }
            case BTP_MODEL: {
                this.incLimit(Limit.COUNT_BTP_MODEL);
                break;
            }
            case CCF_MODEL: {
                this.incLimit(Limit.COUNT_CCF_MODEL);
                break;
            }
            case FMEA_MODEL: {
                this.incLimit(Limit.COUNT_FMEA_MODEL);
                break;
            }
            case PROJECT: {
                switch (dbFolder.getFamilyFlag()) {
                    case 2: {
                        this.incLimit(Limit.COUNT_PROJECT_TREE);
                        break;
                    }
                    case 5: {
                        this.incLimit(Limit.COUNT_PROJECT_BEQ);
                        break;
                    }
                    case 3: {
                        this.incLimit(Limit.COUNT_PROJECT_DSF);
                        break;
                    }
                    case 4: {
                        this.incLimit(Limit.COUNT_PROJECT_FMEA);
                        break;
                    }
                    case 1: {
                        this.incLimit(Limit.COUNT_PROJECT_MODEL);
                    }
                }
                break;
            }
            case TYPE: {
                switch (dbFolder.getFamilyFlag()) {
                    case 1: {
                        this.incLimit(Limit.COUNT_TYPE_ENUM);
                        break block0;
                    }
                    case 2: {
                        this.incLimit(Limit.COUNT_TYPE_LINK);
                    }
                }
            }
        }
    }

    private void countModelFromFolder_rec(DBFolder dbFolder, DAOFolder daoFolder) throws DemoLimitedException {
        List<DBFolder> children = dbFolder.getChildren();
        if (children == null) {
            children = daoFolder.findChildren(dbFolder);
        }
        if (children == null) {
            return;
        }
        for (DBFolder dbChild : children) {
            this.incModelCounterFromFolder(dbChild);
            this.countModelFromFolder_rec(dbChild, daoFolder);
        }
    }

    public void countModelFromFolder(DBFolder dbRoot, DAOFolder daoFolder) throws DemoLimitedException {
        this.countModelFromFolder_rec(dbRoot, daoFolder);
    }

    private boolean verifyCreateNewModel(Limit limit) {
        return this.verifyCreateNewModel(limit, 1) == 0;
    }

    int verifyCreateNewModel(Limit limit, int nbr) {
        LimitCount count = this._counters.get((Object)Limit.COUNT_ALL);
        if (count == null) {
            count = new LimitCount();
            this._counters.put(Limit.COUNT_ALL, count);
        }
        if (count._cpt + nbr > Limit.COUNT_ALL.getLimit()) {
            return count._cpt + nbr;
        }
        if (limit != Limit.COUNT_ALL) {
            count = this._counters.get((Object)limit);
            if (count == null) {
                count = new LimitCount();
                this._counters.put(limit, count);
            }
            if (count._cpt + nbr > limit.getLimit()) {
                return -(count._cpt + nbr);
            }
        }
        return 0;
    }

    public boolean verifyCreateNewModel(DBFolder dbFolder) {
        switch (dbFolder.getFamily()) {
            case BTP_APPLICATION: 
            case BTP_AUTHOR: 
            case BTP_SUBSTANTIATION: {
                return true;
            }
            case ATTRIBUTE: {
                return this.verifyCreateNewModel(Limit.COUNT_ATTRIBUT);
            }
            case OPERATOR: {
                return this.verifyCreateNewModel(Limit.COUNT_OPERATOR);
            }
            case COMPONENT: {
                return this.verifyCreateNewModel(Limit.COUNT_COMPONENT);
            }
            case EQUIPMENT: {
                return this.verifyCreateNewModel(Limit.COUNT_EQUIPMENT);
            }
            case PARAMETER: {
                return this.verifyCreateNewModel(Limit.COUNT_PARAMETER);
            }
            case BTP_MODEL: {
                return this.verifyCreateNewModel(Limit.COUNT_BTP_MODEL);
            }
            case CCF_MODEL: {
                return this.verifyCreateNewModel(Limit.COUNT_CCF_MODEL);
            }
            case FMEA_MODEL: {
                return this.verifyCreateNewModel(Limit.COUNT_FMEA_MODEL);
            }
            case PROJECT: {
                switch (dbFolder.getFamilyFlag()) {
                    case 2: {
                        return this.verifyCreateNewModel(Limit.COUNT_PROJECT_TREE);
                    }
                    case 5: {
                        return this.verifyCreateNewModel(Limit.COUNT_PROJECT_BEQ);
                    }
                    case 3: {
                        return this.verifyCreateNewModel(Limit.COUNT_PROJECT_DSF);
                    }
                    case 4: {
                        return this.verifyCreateNewModel(Limit.COUNT_PROJECT_FMEA);
                    }
                    case 1: {
                        return this.verifyCreateNewModel(Limit.COUNT_PROJECT_MODEL);
                    }
                }
                break;
            }
            case TYPE: {
                switch (dbFolder.getFamilyFlag()) {
                    case 1: {
                        return this.verifyCreateNewModel(Limit.COUNT_TYPE_ENUM);
                    }
                    case 2: {
                        return this.verifyCreateNewModel(Limit.COUNT_TYPE_LINK);
                    }
                }
            }
        }
        return true;
    }

    void verifyAppendLimits(DemoLimits appendLimits) throws DemoLimitedException {
        int countAll = 0;
        for (Map.Entry<Limit, LimitCount> entry : appendLimits._counters.entrySet()) {
            if (entry.getKey() == Limit.COUNT_ALL) continue;
            int nbr = entry.getValue()._cpt;
            int res = this.verifyCreateNewModel(entry.getKey(), nbr);
            if (res != 0) {
                throw new DemoLimitedException(entry.getKey(), null, res);
            }
            countAll += nbr;
        }
        int res = this.verifyCreateNewModel(Limit.COUNT_ALL, countAll);
        if (res != 0) {
            throw new DemoLimitedException(Limit.COUNT_ALL, null, res);
        }
    }

    static class LimitCount {
        int _cpt = 0;

        LimitCount() {
        }

        LimitCount(int cpt) {
            this._cpt = cpt;
        }
    }

    public static enum Limit {
        LINK_FIELDS(5, "Limit.Link.Fields"),
        OPERATOR_FLOWS(5, "Limit.Operator.Flows"),
        SYSTEM_SYNCS(2, "Limit.Project.Model.Syncs"),
        SYSTEM_CONFIGS(2, "Limit.Project.Model.Configs"),
        SYSTEM_SUBS(20, "Limit.Project.Model.Subs"),
        EQUIPMENT_SYNCS(2, "Limit.Equipment.Syncs"),
        EQUIPMENT_FLOWS(10, "Limit.Equipment.Flows"),
        EQUIPMENT_SUBS(20, "Limit.Equipment.Subs"),
        COMPONENT_FLOWS(10, "Limit.Component.Flows"),
        COMPONENT_STATES(3, "Limit.Component.States"),
        COMPONENT_EVENTS(10, "Limit.Component.Events"),
        PROJECT_BEQ_VARS(50, "Limit.Project.BooleanEq.Vars"),
        PROJECT_TREE_CONFIGS(2, "Limit.Project.Tree.Configs"),
        PROJECT_TREE_LINKS(3, "Limit.Project.Tree.Links"),
        PROJECT_TREE_LEAVES(10, "Limit.Project.Tree.Leaves"),
        PROJECT_TREE_GATES(10, "Limit.Project.Tree.Gates"),
        COUNT_TYPE_ENUM(10, "Count.Type.Enum"),
        COUNT_TYPE_LINK(2, "Count.Type.Link"),
        COUNT_OPERATOR(10, "Count.Operator"),
        COUNT_COMPONENT(20, "Count.Component"),
        COUNT_EQUIPMENT(4, "Count.Equipment"),
        COUNT_PARAMETER(3, "Count.Parameter"),
        COUNT_ATTRIBUT(3, "Count.Attribut"),
        COUNT_BTP_MODEL(5, "Count.BTPModel"),
        COUNT_CCF_MODEL(0, "Count.CCFModel"),
        COUNT_FMEA_MODEL(0, "Count.FMEAModel"),
        COUNT_PROJECT_TREE(5, "Count.Project.Tree"),
        COUNT_PROJECT_BEQ(3, "Count.Project.BooleanEq"),
        COUNT_PROJECT_DSF(2, "Count.Project.DSF"),
        COUNT_PROJECT_MODEL(2, "Count.Project.Model"),
        COUNT_PROJECT_FMEA(0, "Count.Project.FMEA"),
        COUNT_OTHER(3, "Count.Other"),
        COUNT_ALL(50, "Count.All");

        int _nbr;
        String _key;

        private Limit(int nbr, String key) {
            this._nbr = nbr;
            this._key = key;
        }

        public int getLimit() {
            return this._nbr;
        }

        public String getKey() {
            return this._key;
        }
    }
}

