/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ccf;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOObjModel;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ccf.io.CCFHandlerXml;
import com.dassault.cecilia.dbobj.faulttree.ccf.io.CCFReaderRaw;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResult;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultString;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CCF
extends DBWrap {
    public static final int _NBR_ARGS = 4;
    private static Logger _LOG = Logger.getLogger(CCF.class.getPackage().getName());
    CCFType _type;
    double[] _factors;
    Law _law;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public CCF(DBFolder folder) {
        super(folder);
    }

    @Override
    public CCF getCopy() {
        CCF dest = new CCF(this._dbFolder);
        dest.copy(this);
        dest._type = this._type;
        dest._factors = new double[this._factors.length];
        System.arraycopy(this._factors, 0, dest._factors, 0, this._factors.length);
        if (this._law != null) {
            dest._law = this._law.getCopy();
        }
        return dest;
    }

    public CCFType getType() {
        return this._type;
    }

    public CCF setType(CCFType value) {
        this._type = value;
        return this;
    }

    public double[] getFactors() {
        return this._factors;
    }

    public CCF setFactors(double[] value) {
        this._factors = value;
        return this;
    }

    public Law getLaw() {
        return this._law;
    }

    public CCF setLaw(Law value) {
        this._law = value;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CCF)) {
            return false;
        }
        CCF dbCcf = (CCF)obj;
        if (this._type != dbCcf._type) {
            return false;
        }
        if (this._factors.length != dbCcf._factors.length) {
            return false;
        }
        for (int i = 0; i < this._factors.length; ++i) {
            if (!(!Double.isNaN(this._factors[i]) ? this._factors[i] != dbCcf._factors[i] : !Double.isNaN(dbCcf._factors[i]))) continue;
            return false;
        }
        return !(this.getLaw() != null ? !this.getLaw().equals(dbCcf.getLaw()) : dbCcf.getLaw() != null);
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.CCF_MODEL;
    }

    @Override
    protected String getNature() {
        return "ccf.def";
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("RAWTOHEX".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            String istr = DAOObjModel.convertWithFromRAWTOHEX(istream);
            if (istr == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                return false;
            }
            return this.readRaw(istr, cecFactory, logMng);
        }
        if ("RAW".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            byte[] ibyte = DAOObjModel.convertAsByte(istream);
            if (ibyte == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_CONVERT"));
                return false;
            }
            return this.readRaw(new String(ibyte), cecFactory, logMng);
        }
        if ("ZML".equals(format) || "XML".equals(format)) {
            InputStream istream = this.getBinaryStream(model, cecFactory, logMng);
            if (istream == null) {
                return false;
            }
            if ("ZML".equals(format)) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            return this.readXml(istream, cecFactory, logMng);
        }
        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        return false;
    }

    public boolean readRaw(String data, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        CCFReaderRaw reader = new CCFReaderRaw(logMng);
        boolean result = reader.readRaw(data, cecFactory);
        if (result) {
            this._type = reader.getType();
            this._factors = reader.getArgs();
            this._law = reader.getLaw();
        }
        return result;
    }

    public boolean readXml(InputStream input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        boolean result = false;
        CCFHandlerXml saxHanlder = new CCFHandlerXml(logMng, cecFactory, null);
        try {
            this.readXml(input, saxHanlder);
            this._type = saxHanlder.getType();
            this._factors = saxHanlder.getArgs();
            this._law = saxHanlder.getLaw();
            result = true;
        }
        catch (IOException e) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_XML_GENERIC"));
        }
        return result;
    }

    @Override
    public void toXML(Appendable out, String indent) throws IOException {
        out.append(indent).append("<").append("cec.ccf");
        out.append(" ").append("type").append("='").append(this._type.name().toLowerCase()).append("'");
        out.append(">\n");
        for (int i = 0; i < this._factors.length; ++i) {
            out.append(indent).append("  <").append("ccf.factor");
            out.append(" ").append("level").append("='").append(Integer.toString(i)).append("'");
            out.append(" ").append("value").append("='").append(Double.toString(this._factors[i])).append("'");
            out.append("/>\n");
            if (this._type == CCFType.BETA) break;
        }
        this._law.toXML("law", out, indent + "  ", true);
        out.append(indent).append("</").append("cec.ccf").append(">\n");
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        HashSet<DBRelation> relations = new HashSet<DBRelation>();
        this._law.addRelation(this.getDBFolder(), "CCF_MODEL", relations);
        return relations;
    }

    @Override
    public List<Function<DBWrap, CompareResult>> getFieldsToCompare(DAOFactory factoryWrap, boolean forImport) {
        List<Function<DBWrap, CompareResult>> list = super.getFieldsToCompare(factoryWrap, forImport);
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String type1 = CCF.this.getType().getLabel();
                String type2 = ((CCF)wrap).getType().getLabel();
                return new CompareResultString(ResMsgArbor.getString("DBCCF_TYPE"), type1, type2);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String factors1 = Arrays.stream(CCF.this.getFactors()).boxed().collect(Collectors.toList()).toString();
                String factors2 = Arrays.stream(((CCF)wrap).getFactors()).boxed().collect(Collectors.toList()).toString();
                return new CompareResultString(ResMsgArbor.getString("DBCCF_FACTOR"), factors1, factors2);
            }
        });
        list.add(new Function<DBWrap, CompareResult>(){

            @Override
            public CompareResult apply(DBWrap wrap) {
                String law1 = CCF.this.getLaw().toString();
                String law2 = ((CCF)wrap).getLaw().toString();
                return new CompareResultString(ResMsgArbor.getString("DBCCF_LAW"), law1, law2);
            }
        });
        return list;
    }

    public static enum CCFType {
        BETA(ResMsgArbor.getString("DBCCF_TYPE_BETA"), ResMsgArbor.getString("DBCCF_TYPE_BETA_TOOLTIP"), ResMsgArbor.getString("DBCCF_TYPE_BETA_ARG")),
        ALPHA(ResMsgArbor.getString("DBCCF_TYPE_ALPHA"), ResMsgArbor.getString("DBCCF_TYPE_ALPHA_TOOLTIP"), ResMsgArbor.getString("DBCCF_TYPE_ALPHA_ARG")),
        MGL(ResMsgArbor.getString("DBCCF_TYPE_MGL"), ResMsgArbor.getString("DBCCF_TYPE_MGL_TOOLTIP"), ResMsgArbor.getString("DBCCF_TYPE_MGL_ARG"));

        String _label;
        String _tooltip;
        String _arg;

        private CCFType(String label, String tooltip, String arg) {
            this._label = label;
            this._tooltip = tooltip;
            this._arg = arg;
        }

        public String getLabel() {
            return this._label;
        }

        public String getTooltip() {
            return this._tooltip;
        }

        public String getLabelOfArg(int i) {
            if (this == BETA) {
                return this._arg;
            }
            return new StringBuilder(8).append(this._arg).append(i + 1).toString();
        }

        public static ListCellRenderer getListRenderer() {
            return new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof CCFType) {
                        this.setText(((CCFType)((Object)value))._label);
                        this.setToolTipText(((CCFType)((Object)value))._tooltip);
                    }
                    return this;
                }
            };
        }
    }
}

