/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.config.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.table.CeciliaTable;
import com.dassault.cecilia.core.swing.table.JTableTransfertHandler;
import com.dassault.cecilia.core.swing.table.WithErrorTableCellRenderer;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.config.gui.FTConfigDlgEdit;
import com.dassault.cecilia.dbobj.faulttree.config.gui.FTConfigTableCellRenderer;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEditPanel;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class FTConfigPanel
extends FTEditPanel
implements FTEquation.ChangeListener {
    JComboBox _ctrlCriticity;
    JTable _ctrlTable;
    ConfigTableModel _ctrlTableModel;
    JLabel _ctrlNameLabel;
    JTextField _ctrlName;
    protected CeciliaAction _ctrlAdd;
    protected CeciliaAction _ctrlDel;
    protected CeciliaAction _ctrlEdit;
    JPopupMenu _popupMenu = new JPopupMenu();
    FTConfigDlgEdit _dlgEdit;

    public FTConfigPanel(FTEquationFrame frame) {
        super(frame);
        this.createActions();
        this.createTable();
        this.make();
    }

    public FTEquation getEquation() {
        return this._ftEquation;
    }

    private void createTable() {
        this._ctrlTableModel = new ConfigTableModel();
        this._ctrlTable = new FTConfigTable(this._ctrlTableModel);
        this._ctrlTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                FTConfigPanel.this.selectConfig();
            }
        });
    }

    private void createActions() {
        this._ctrlAdd = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FTConfigPanel.this.addConfig();
                FTConfigPanel.this._ctrlName.setText("");
                FTConfigPanel.this._ctrlName.requestFocus();
            }
        }.setDesc(ResMsgArbor.getString("CMD_CONFIG_ADD"));
        this._ctrlDel = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] viewIndices;
                if (FTConfigPanel.this.getAppl().isReader()) {
                    return;
                }
                if (FTConfigPanel.this.getEquation() != null && (viewIndices = FTConfigPanel.this._ctrlTable.getSelectedRows()).length != 0) {
                    int[] modelIndices = new int[viewIndices.length];
                    for (int i = viewIndices.length - 1; i >= 0; --i) {
                        modelIndices[i] = FTConfigPanel.this._ctrlTable.convertRowIndexToModel(viewIndices[i]);
                    }
                    boolean isCritComputeDeleted = false;
                    List<FTConfig> events = FTConfigPanel.this.getEquation().getConfigs();
                    for (int i = modelIndices.length - 1; i >= 0; --i) {
                        FTConfig conf = events.get(modelIndices[i]);
                        if (conf.isCritCompute()) {
                            isCritComputeDeleted = true;
                        }
                        events.remove(conf);
                    }
                    if (isCritComputeDeleted && !events.isEmpty()) {
                        events.get(0).setCritCompute(true);
                    }
                    FTConfigPanel.this._ctrlTableModel.fireTableDataChanged();
                    FTConfigPanel.this._ctrlTable.clearSelection();
                    FTConfigPanel.this.getEquation().setModified(true);
                    FTConfigPanel.this._ctrlName.setText("");
                }
            }
        }.setDesc(ResMsgArbor.getString("CMD_CONFIG_DEL"));
        this._ctrlEdit = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FTConfigPanel.this.getEquation() == null) {
                    return;
                }
                FTConfigPanel.this.doEdit();
            }
        }.setDesc(ResMsgArbor.getString("CMD_CONFIG_EDIT"));
        this._popupMenu.add(this._ctrlEdit.createMenuItem());
        this._popupMenu.add(this._ctrlDel.createMenuItem());
    }

    private void make() {
        this.setLayout(new GridBagLayout());
        JLabel criticityLbl = new JLabel(ResMsgVoc.getString("VOC_CRITICITY"));
        this._ctrlCriticity = new JComboBox();
        this._ctrlCriticity.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!(value instanceof CriticityCriterion)) {
                    return this;
                }
                CriticityCriterion criticity = (CriticityCriterion)value;
                this.setText(criticity.getName());
                return this;
            }
        });
        this.addValuesInCtrlCriticity();
        this._ctrlCriticity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object value = FTConfigPanel.this._ctrlCriticity.getSelectedItem();
                if (!(value instanceof CriticityCriterion)) {
                    FTConfigPanel.this._ftEquation.setCriticityLevel(null);
                } else {
                    FTConfigPanel.this._ftEquation.setCriticityLevel(((CriticityCriterion)value).getName());
                }
                FTConfigPanel.this._ftEquation.updateDependTimeUpdt(FTConfigPanel.this.getAppl().getDAOFactory(), FTConfigPanel.this._ftEquation.getWorkingRelations());
                FTConfigPanel.this._ftEquation.setModified(true);
            }
        });
        this._ctrlCriticity.setEnabled(!this.getAppl().isReader());
        this.add((Component)criticityLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 10, 5), 0, 0));
        this.add((Component)this._ctrlCriticity, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 10, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 10.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this._ftEquation.withMBSAExportFields()) {
            JLabel mbsaListConfLbl = new JLabel(this.getTextMBSA(false));
            mbsaListConfLbl.setToolTipText(this.getTextMBSA(true));
            this.add((Component)mbsaListConfLbl, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        JToolBar panelEventButton = new JToolBar();
        JPanel panelEventValue = new JPanel();
        JPanel ftConfPanel = new JPanel(new GridBagLayout());
        ftConfPanel.setBorder(BorderFactory.createTitledBorder(ResMsgArbor.getString("CFG_DLG_TITLE")));
        JScrollPane scrollTable = new JScrollPane(this._ctrlTable);
        ftConfPanel.add((Component)scrollTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this._frame.isEditable()) {
            scrollTable.setComponentPopupMenu(this._popupMenu);
            ftConfPanel.add((Component)panelEventButton, new GridBagConstraints(0, 1, 5, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            ftConfPanel.add((Component)panelEventValue, new GridBagConstraints(0, 2, 5, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)ftConfPanel, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        panelEventButton.add(Box.createHorizontalGlue());
        panelEventButton.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelEventButton.add(this._ctrlEdit.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        panelEventButton.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        panelEventButton.add(Box.createHorizontalGlue());
        panelEventButton.setFloatable(false);
        this._ctrlNameLabel = new JLabel(ResMsgVoc.getString("VOC_NAME"));
        this._ctrlNameLabel.setForeground(Color.black);
        this._ctrlName = new JTextField("");
        this._ctrlName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FTConfigPanel.this.addConfig();
                    FTConfigPanel.this._ctrlName.setText("");
                    FTConfigPanel.this._ctrlName.requestFocus();
                }
            }
        });
        panelEventValue.setLayout(new GridBagLayout());
        panelEventValue.setBorder(BorderFactory.createEtchedBorder());
        panelEventValue.add((Component)this._ctrlNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panelEventValue.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.selectConfig();
    }

    @Override
    public void doEdit() {
        if (this._ctrlTable.getSelectedRowCount() != 1) {
            return;
        }
        int idx = this._ctrlTable.getSelectedRow();
        if (idx == -1) {
            return;
        }
        if (this._dlgEdit == null) {
            FTConfigDlgEdit dlg = new FTConfigDlgEdit(SwingUtilities.getWindowAncestor(this));
            if (this._dlgEdit == null) {
                this._dlgEdit = dlg;
            }
        }
        this._dlgEdit.setEditable(this._frame.isEditable());
        idx = this._ctrlTable.convertRowIndexToModel(idx);
        List<FTConfig> allConfigs = this.getEquation().getConfigs();
        FTConfig ftCfgOrigin = allConfigs.get(idx);
        FTConfig ftCfgChange = ftCfgOrigin.getCopy();
        ftCfgChange.validateConfig(this._ftEquation.getDBFolder(), this._ftEquation.getWorkingRelations(), this.getAppl().getDAOFactory(), false);
        this._dlgEdit.setConfig(ftCfgChange, allConfigs, this.getEquation());
        this._dlgEdit.setVisible(true);
        if (this._dlgEdit.getResult()) {
            ftCfgOrigin.copy(ftCfgChange);
            ftCfgOrigin.validateConfig(this._ftEquation.getDBFolder(), this._ftEquation.getWorkingRelations(), this.getAppl().getDAOFactory(), false);
            ftCfgOrigin.computeHeight();
            this._ctrlTableModel.fireTableDataChanged();
            idx = this._ctrlTable.convertRowIndexToView(idx);
            this._ctrlTable.setRowSelectionInterval(idx, idx);
            this.getEquation().setModified(true);
        }
    }

    public void addConfig() {
        if (this.getEquation() == null) {
            return;
        }
        String name = this._ctrlName.getText();
        if (name.isEmpty()) {
            return;
        }
        if ((name = FTConfig.verifyName(name, this._ctrlName)) == null || name.isEmpty()) {
            return;
        }
        FTConfig config = this.getEquation().getConfig(name);
        if (config != null) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgArbor.getString("ERR_CONFIG_ALREADY"), ResMsgArbor.getString("CFG_DLG_TITLE"), 0);
            return;
        }
        config = new FTConfig().setName(name);
        this.getEquation().getConfigs().add(config);
        int idx = this.getEquation().getConfigs().size() - 1;
        if (this.getEquation().getConfigs().size() == 1) {
            config.setCritCompute(true);
        }
        this._ctrlTableModel.fireTableDataChanged();
        idx = this._ctrlTable.convertRowIndexToView(idx);
        this._ctrlTable.setRowSelectionInterval(idx, idx);
        this.getEquation().setModified(true);
    }

    public void addValuesInCtrlCriticity() {
        String currentCriticityLevel = null;
        if (this._ctrlCriticity.getSelectedItem() != null && this._ctrlCriticity.getSelectedItem() instanceof CriticityCriterion) {
            currentCriticityLevel = ((CriticityCriterion)this._ctrlCriticity.getSelectedItem()).getName();
        }
        if (currentCriticityLevel == null) {
            currentCriticityLevel = this.getEquation().getCriticityLevel();
        }
        this._ctrlCriticity.removeAllItems();
        this._ctrlCriticity.addItem(" ");
        List<CriticityCriterion> listCriticities = this.getEquation().getProjectCriticities(this.getAppl());
        for (CriticityCriterion criticity : listCriticities) {
            this._ctrlCriticity.addItem(criticity);
        }
        boolean criticityFound = false;
        if (currentCriticityLevel != null) {
            for (CriticityCriterion criticity : listCriticities) {
                if (!criticity.getName().equals(currentCriticityLevel)) continue;
                criticityFound = true;
                this._ctrlCriticity.setSelectedItem(criticity);
                return;
            }
            if (!criticityFound) {
                this.getEquation().setCriticityLevel(null);
            }
        }
    }

    public void selectConfig() {
        int selectCount = this._ctrlTable.getSelectedRowCount();
        if (selectCount != 0) {
            this._ctrlDel.setEnabled(true);
            this._ctrlEdit.setEnabled(selectCount == 1);
            if (this.getEquation() != null && selectCount == 1) {
                int idx = this._ctrlTable.getSelectedRow();
                if (idx != -1) {
                    idx = this._ctrlTable.convertRowIndexToModel(idx);
                    this._ctrlName.setText(this.getEquation().getConfigs().get(idx).getName());
                } else {
                    this._ctrlName.setText("");
                }
            } else {
                this._ctrlName.setText("");
            }
        } else {
            this._ctrlDel.setEnabled(false);
            this._ctrlEdit.setEnabled(false);
        }
    }

    public void updateLangage() {
        this._ctrlNameLabel.setText(ResMsgVoc.getString("VOC_NAME"));
        this._ctrlTableModel.fireTableDataChanged();
        this._ctrlDel.setName(ResMsgVoc.getString("VOC_DELETE"));
        this._ctrlDel.setDesc(ResMsgArbor.getString("CMD_CONFIG_DEL"));
        this._ctrlEdit.setName(ResMsgVoc.getString("VOC_EDIT"));
        this._ctrlEdit.setDesc(ResMsgArbor.getString("CMD_CONFIG_EDIT"));
        this._ctrlAdd.setName(ResMsgVoc.getString("VOC_ADD"));
        this._ctrlAdd.setDesc(ResMsgArbor.getString("CMD_CONFIG_ADD"));
    }

    @Override
    public void changeEvents(Collection<? extends FTVariableAbstract> vars, Component source) {
    }

    @Override
    public void changeDefinitions(Collection<FTVariable> vars, Component source) {
        List<FTConfig> confs = this.getEquation().getConfigs();
        if (confs == null) {
            return;
        }
        for (FTConfig conf : confs) {
            conf.computeHeight();
        }
        this._ctrlTableModel.fireTableDataChanged();
    }

    public void doSave() {
        List<FTConfig> confs = this.getEquation().getConfigs();
        if (confs == null) {
            return;
        }
        for (int i = 0; i < confs.size(); ++i) {
            ArrayList<FTConfig.DSFConfigItem> configToRemove = new ArrayList<FTConfig.DSFConfigItem>();
            FTConfig conf = confs.get(i);
            for (FTConfig.DSFConfigItem item : conf.getDSFItems()) {
                if (item.isEnable()) continue;
                configToRemove.add(item);
            }
            conf.getDSFItems().removeAll(configToRemove);
            conf.computeHeight();
        }
        this._ctrlTableModel.fireTableDataChanged();
    }

    private final String getTextMBSA(boolean forTooltip) {
        String modelPath = this._ftEquation.getModelePathMBSA();
        String initialConf = this._ftEquation.getInitialConfMBSA();
        String target = this._ftEquation.getTargetMBSA();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(ResMsgArbor.getString("MSG_DLG_MBSA_CONF")).append(" : ");
        sb.append("<br/>").append("&nbsp;-&nbsp;").append(ResMsgArbor.getString("MSG_DLG_MBSA_MODEL")).append("&nbsp;:&nbsp;").append(modelPath);
        sb.append("<br/>").append("&nbsp;-&nbsp;").append(ResMsgArbor.getString("MSG_DLG_MBSA_INITIAL_CONF")).append("&nbsp;:&nbsp;").append(initialConf);
        if (forTooltip) {
            sb.append("<br/>").append("&nbsp;-&nbsp;").append(ResMsgArbor.getString("MSG_DLG_MBSA_TARGET")).append("&nbsp;:&nbsp;").append(target);
        }
        sb.append("</html>");
        return sb.toString();
    }

    public class ConfigTableModel
    extends AbstractTableModel {
        public static final int IDX_NAME = 0;
        public static final int IDX_LBL = 1;
        public static final int IDX_CONFIGS = 2;

        ConfigTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (FTConfigPanel.this.getEquation() == null) {
                return 0;
            }
            return FTConfigPanel.this.getEquation().getConfigs().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (FTConfigPanel.this.getEquation() == null) {
                return "null";
            }
            switch (col) {
                case 0: {
                    return FTConfigPanel.this.getEquation().getConfigs().get(row).getName();
                }
                case 1: {
                    return FTConfigPanel.this.getEquation().getConfigs().get(row).getLabel();
                }
                case 2: {
                    return FTConfigPanel.this.getEquation().getConfigs().get(row);
                }
            }
            return " ";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_COMMENT");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_CONFIGURATIONS");
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return FTConfig.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!FTConfigPanel.this._frame.isEditable()) {
                return false;
            }
            return col == 0 && FTConfigPanel.this._ctrlTable.getSelectedRows().length == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            switch (column) {
                case 0: {
                    FTConfig config;
                    String oldName;
                    String name = FTConfig.verifyName((String)aValue, FTConfigPanel.this);
                    if (name == null || name.length() <= 0 || (oldName = (config = FTConfigPanel.this.getEquation().getConfigs().get(row)).getName()).equals(name)) break;
                    if (FTConfigPanel.this.getEquation().getConfig(name) == null) {
                        config.setName(name);
                        this.fireTableDataChanged();
                        row = FTConfigPanel.this._ctrlTable.convertRowIndexToView(row);
                        FTConfigPanel.this._ctrlTable.setRowSelectionInterval(row, row);
                        FTConfigPanel.this.getEquation().setModified(true);
                        break;
                    }
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(FTConfigPanel.this._ctrlTable), ResMsgArbor.getString("ERR_CONFIG_ALREADY"), ResMsgArbor.getString("CFG_DLG_TITLE"), 0);
                    break;
                }
            }
        }
    }

    private class FTConfigTable
    extends CeciliaTable
    implements JTableTransfertHandler.HelperConvert {
        public FTConfigTable(TableModel model) {
            super(model);
            this.setTransferHandler(new JTableTransfertHandler());
            this.setAutoResizeMode(4);
            this.doLayout();
            this.setSelectionMode(2);
            this.setDefaultRenderer(FTConfig.class, new FTConfigTableCellRenderer());
            DefaultTableCellRenderer lblCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    String strValue = value.toString().trim();
                    if (strValue.isEmpty()) {
                        this.setText("");
                        this.setToolTipText(null);
                    } else {
                        Object text = null;
                        StringBuilder sb = new StringBuilder();
                        StringTokenizer st = new StringTokenizer(strValue, "\n");
                        sb.append("<html>");
                        int i = 0;
                        while (st.hasMoreTokens()) {
                            if (i > 0) {
                                sb.append("<br/>");
                            }
                            if (i == 5) {
                                text = sb.toString() + "...</html>";
                            }
                            sb.append(st.nextToken());
                            ++i;
                        }
                        sb.append("</html>");
                        if (text == null) {
                            text = sb.toString();
                        }
                        this.setText((String)text);
                        this.setToolTipText(sb.toString());
                    }
                    return this;
                }
            };
            lblCellRenderer.setOpaque(true);
            this.getColumnModel().getColumn(1).setCellRenderer(lblCellRenderer);
            this.getColumnModel().getColumn(0).setCellRenderer(new WithErrorTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    int rowView = table.convertRowIndexToView(row);
                    FTConfig conf = FTConfigPanel.this.getEquation().getConfigs().get(rowView);
                    if (conf.isCritCompute()) {
                        Font originalFont = label.getFont();
                        label.setFont(new Font(originalFont.getFamily(), 1, originalFont.getSize()));
                    }
                    return label;
                }

                @Override
                public boolean withError(JTable table, Object value, int row, int column) {
                    FTConfig cfg = (FTConfig)FTConfigPanel.this._ctrlTableModel.getValueAt(row, 2);
                    return cfg.withError();
                }
            });
            this.getActionMap().put("DELETE", FTConfigPanel.this._ctrlDel);
            this.getInputMap(0).put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        }

        @Override
        protected boolean withSorter() {
            return true;
        }

        @Override
        protected List<Integer> getUnsortableCols() {
            return Arrays.asList(2);
        }

        @Override
        public void createDefaultColumnsFromModel() {
            super.createDefaultColumnsFromModel();
            TableColumnModel colModel = this.getColumnModel();
            block5: for (int c = 0; c < this.getColumnCount(); ++c) {
                switch (c) {
                    case 0: {
                        colModel.getColumn(c).setPreferredWidth(75);
                        continue block5;
                    }
                    case 1: {
                        colModel.getColumn(c).setPreferredWidth(150);
                        continue block5;
                    }
                    case 2: {
                        colModel.getColumn(c).setPreferredWidth(200);
                    }
                }
            }
        }

        @Override
        protected void doubleClickLeft(MouseEvent e) {
            if (FTConfigPanel.this.getEquation() == null) {
                return;
            }
            int columnView = FTConfigPanel.this._ctrlTable.columnAtPoint(e.getPoint());
            int columnDoc = FTConfigPanel.this._ctrlTable.convertColumnIndexToModel(columnView);
            if (columnDoc == 0) {
                return;
            }
            FTConfigPanel.this.doEdit();
        }

        @Override
        public String convertToString(Object obj, int row, int col) {
            if (obj == null) {
                return "";
            }
            row = this.convertRowIndexToModel(row);
            col = this.convertColumnIndexToModel(col);
            switch (col) {
                case 0: 
                case 1: {
                    return obj.toString();
                }
                case 2: {
                    FTConfig cfg = (FTConfig)obj;
                    StringBuilder sb = new StringBuilder();
                    for (FTConfig.DSFConfigItem dsfCfg : cfg.getDSFItemsView()) {
                        if (!dsfCfg.isEnable() && !dsfCfg.isOnlyFRB()) continue;
                        sb.append(ResMsgArbor.getString("CFG_DLG_DSF")).append("[");
                        sb.append(dsfCfg.getDBFolder().getRefPath()).append("] ");
                        sb.append(ResMsgArbor.getString(dsfCfg.isFRB() ? "CFG_DLG_DSF_FRB" : "CFG_DLG_DSF_SUBTREE"));
                    }
                    int j = 0;
                    for (FTConfig.CCFConfigItem ccfCfg : cfg.getCCFItems()) {
                        if (!ccfCfg.isEnable()) continue;
                        if (j == 0) {
                            sb.append(ResMsgArbor.getString("CFG_DLG_CCF")).append(" : ");
                        } else {
                            sb.append(", ");
                        }
                        sb.append(ccfCfg.getDBFolder().getRefPath());
                        ++j;
                    }
                    return sb.toString();
                }
            }
            assert (false) : "Colonne inconnue : " + col;
            return null;
        }
    }
}

