/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.criticity;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.error.MsgType;
import com.dassault.cecilia.core.cecilia.folder.DBFolderTree;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityListItem;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityInternalFrame;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityParser;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityUtility;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationDatumUtility;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdWithError;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.project.gui.ProjectCriticityTableModel;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.folders.ProjectFolderTree;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ListCriticityGenerateCmd
extends DBFolderCmdWithError {
    private static Logger _LOG = Logger.getLogger(ListCriticityGenerateCmd.class.getPackage().getName());
    private List<CriticityListItem> _listCritId;

    public ListCriticityGenerateCmd(CAppl appl, DBFolderTree owner) {
        super(appl, owner);
    }

    @Override
    protected String getTitle() {
        return ResMsgVoc.getString("VOC_ERROR") + " - " + ResMsgArbor.getString("MSG_LIST_CRITICITY_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean prepareDo() {
        try {
            _LOG.finest("D\u00e9but prepareDo ListCriticity");
            Set<DBFolder> folders = this.recupFolderSelected((ProjectFolderTree)this.getCtrlTree());
            if (this.withWarnning()) {
                this.displayErrors(this.getErrors());
            }
            this._listCritId = new ArrayList<CriticityListItem>();
            if (folders == null || folders.isEmpty()) {
                _LOG.finest("D\u00e9marrage de la liste des criticit\u00e9s sans s\u00e9lection.");
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getAppl().getTopWindow()), ResMsgArbor.getString("MSG_LIST_CRITICITY_DLG_EMPTY_SELECTION"), ResMsgArbor.getString("MSG_LIST_CRITICITY_TITLE"), 0);
            } else {
                for (DBFolder folder : folders) {
                    this._listCritId.add(ListCriticityGenerateCmd.createCriticityIdentifierFromDBFolder(this.getAppl(), this.getSource(), folder));
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            _LOG.finest("Fin prepareDo ListCriticity");
        }
    }

    @Override
    protected void firstDo() {
        _LOG.finest("D\u00e9but G\u00e9n\u00e9ration Criticit\u00e9");
        assert (this._listCritId != null && this._listCritId.isEmpty());
        ListCriticityInternalFrame frame = new ListCriticityInternalFrame(this.getAppl(), this._listCritId);
        frame.showView(((CeciliaAppl)this.getAppl()).getTopWindow().getDesktop());
        _LOG.finest("Fin G\u00e9n\u00e9ration Criticit\u00e9");
    }

    public static final CriticityResult readCriticityResultFromFile(File fileInputStream) {
        try {
            FileInputStream inputStream = new FileInputStream(fileInputStream);
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            ListCriticityParser handler = new ListCriticityParser();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse((InputStream)inputStream, (DefaultHandler)handler);
            return handler.getResult();
        }
        catch (IOException e) {
            _LOG.warning(e.getMessage());
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append("SAX Parser Exception\n");
            sb.append(e.getMessage());
            _LOG.severe(e.getMessage());
        }
        return null;
    }

    private final Set<DBFolder> recupFolderSelected(ProjectFolderTree projectTree) {
        if (projectTree == null) {
            return null;
        }
        TreePath[] selPaths = projectTree.getSelectionPaths();
        if (selPaths == null) {
            return null;
        }
        if (selPaths.length == 0) {
            return null;
        }
        ArrayList<DBFolder> selFolders = projectTree.convertTreePathsToFolders(selPaths);
        LinkedHashSet<DBFolder> recupFolders = new LinkedHashSet<DBFolder>();
        for (DBFolder dbFolder : selFolders) {
            Collection<DBFolder> folders = this.getAllTreeFolder(dbFolder);
            if (folders == null) continue;
            recupFolders.addAll(folders);
        }
        if (recupFolders.size() == 0) {
            return null;
        }
        return recupFolders;
    }

    private final Collection<DBFolder> getAllTreeFolder(DBFolder dbFolder) {
        if (dbFolder.getFamilyFlag() != 2 && dbFolder.getFamilyFlag() != 5 && (dbFolder.isModel() || dbFolder.isVersion())) {
            return null;
        }
        if (dbFolder.isVersion()) {
            if (!dbFolder.isFreeze() && dbFolder.isLocked()) {
                DBSession dbSession = dbFolder.getObject().getLockedSession();
                this.addError(dbFolder, MsgType.WARNING, ResMsgObj.msgFormat("MSG_OBJ_ERR_ISLOCKED", dbFolder.getRefPath(), dbSession.getUser().getLogin(), dbSession.isActive() ? "" : " ~"));
            }
            return Collections.singleton(dbFolder);
        }
        List<DBFolder> children = this.getAppl().getDAOFactory().createFolderDAO().findChildren(dbFolder);
        if (children == null) {
            return null;
        }
        LinkedHashSet<DBFolder> folder = new LinkedHashSet<DBFolder>();
        for (DBFolder child : children) {
            Collection<DBFolder> folders = this.getAllTreeFolder(child);
            if (folders == null) continue;
            folder.addAll(folders);
        }
        return folder;
    }

    private static CriticityListItem doCreateCriticityIdentifierFromDBFolder(CAppl cAppl, Component source, DBFolder folder) {
        String key;
        FTEquationDatumUtility ftEquationDatum;
        TreeInfoCompute infoCompute;
        FTEquation equation = (FTEquation)((CECFactory)cAppl.getDAOFactory()).findOrCreateWrap(folder);
        if (equation == null) {
            CriticityListItem critID = new CriticityListItem(folder, equation, null, null, null);
            critID.setIsALoopTree(true);
            return critID;
        }
        if (!equation.instanciate(true, cAppl.getDBUser()) || equation.getLogs().getMaxLevel() == DBLogs.DBLevel.WARNING) {
            CriticityListItem critID = new CriticityListItem(folder, equation, null, null, null);
            return critID;
        }
        CriticityCriterion criticityCrit = null;
        String criticityLevel = equation.getCriticityLevel();
        DBFolder projectFolder = ListCriticityUtility.getDBProjectFolder(folder);
        DBProject project = (DBProject)((CECFactory)cAppl.getDAOFactory()).findOrCreateWrap(projectFolder);
        List<CriticityCriterion> criterion = project.getCriticityCriterium();
        for (CriticityCriterion criticity : criterion) {
            if (!criticity.getName().equals(criticityLevel)) continue;
            criticityCrit = criticity;
            break;
        }
        if ((infoCompute = (ftEquationDatum = new FTEquationDatumUtility(equation, source, (CeciliaAppl)cAppl){

            @Override
            protected boolean isACritCompute() {
                return true;
            }
        }).getDatum(key = "Tree.Compute." + "MCS" + ".Abstract")) == null) {
            CriticityListItem critID = new CriticityListItem(folder, equation, null, criticityCrit, null);
            return critID;
        }
        String msgError = infoCompute.getParameters().get("tree.error");
        if (msgError != null && !msgError.isEmpty()) {
            CriticityListItem critID = new CriticityListItem(folder, equation, null, criticityCrit, infoCompute);
            return critID;
        }
        equation.readCurrentResults(cAppl.getDBUser(), ((CeciliaAppl)cAppl).getDAOFactory());
        File file = infoCompute.getInputFiles().get("result.abstract");
        CriticityResult result = file != null ? ListCriticityGenerateCmd.readCriticityResultFromFile(file) : null;
        return new CriticityListItem(folder, equation, result, criticityCrit, infoCompute);
    }

    public static final CriticityListItem createCriticityIdentifierFromDBFolder(CAppl cAppl, Component source, DBFolder folder) {
        CriticityListItem item = ListCriticityGenerateCmd.doCreateCriticityIdentifierFromDBFolder(cAppl, source, folder);
        item.setMsgConsistencyTree(ListCriticityUtility.isConsistencyTreeMsg(cAppl, item));
        item.setMsgConsistencyCompute(ListCriticityUtility.isConsistencyComputeMsg(cAppl, item));
        return item;
    }

    public static final String getDBFolderProjectName(DBFolder folder) {
        DBFolder tmp = folder;
        while (!tmp.getParent().isSystem()) {
            tmp = tmp.getParent();
        }
        return tmp.getName();
    }

    public static final String[] getHeaderCritTable() {
        return ProjectCriticityTableModel.__COLUMN_NAMES;
    }
}

