/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.criticity;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsFactory;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityListItem;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityGenerateCmd;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityPreferencies;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityUtility;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractColumnsModel;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;

public class ListCriticityTableModel
extends ItemAbstractTableModel<CriticityListItem> {
    public static final String CRITICITY_FIELD_PROJECT = "projets";
    public static final String CRITICITY_FIELD_SYSTEM = "systemes";
    public static final String CRITICITY_FIELD_TREE = "arbres";
    public static final String CRITICITY_FIELD_CONFIG = "config";
    public static final String CRITICITY_FIELD_FAILURE_COND = "failureCond";
    public static final String CRITICITY_FIELD_COHERENCE_TREE = "coherenceTree";
    public static final String CRITICITY_FIELD_COHERENCE_COMP = "coherenceComp";
    public static final String CRITICITY_FIELD_CRITICITY = "criticity";
    public static final String CRITICITY_FIELD_ATTRIBUT_LSR = "attributLSR";
    public static final String CRITICITY_FIELD_COMPUTED_PROB = "compProb";
    public static final String CRITICITY_FIELD_COMPUTED_ORDER = "compOrder";
    public static final String CRITICITY_FIELD_COMPUTED_LATENT = "compLatent";
    public static final String CRITICITY_FIELD_COMPUTED_EVIDENT = "compEvident";
    public static final int IDX_COL_PROJECT = 0;
    public static final int IDX_COL_SYSTEM = 1;
    public static final int IDX_COL_TREE = 2;
    public static final int IDX_COL_FAILURE_COND = 3;
    public static final int IDX_COL_CONFIG = 4;
    public static final int IDX_COL_COHERENCE_TREE = 5;
    public static final int IDX_COL_COHERENCE_COMP = 6;
    public static final int IDX_COL_CRITICITY = 7;
    public static final int IDX_COL_COMPUTED_PROBA = 8;
    public static final int IDX_COL_COMPUTED_ORDER = 9;
    public static final int IDX_COL_ATTRIBUT_LSR = 10;
    public static final int IDX_COL_LSR_EVIDENT_OK = 11;
    public static final int IDX_COL_LSR_LATENT_OK = 12;
    private final List<CriticityListItem> _listCrits;
    private final CAppl _cAppl;

    public ListCriticityTableModel(CAppl cAppl, List<CriticityListItem> listCrits) {
        super(new ListCriticityColumnModel());
        this._cAppl = cAppl;
        this._listCrits = listCrits;
        PluginWithOptions prefs = this._cAppl.getPreferencies().getOptions(ListCriticityPreferencies.PREF_KEY);
        if (prefs == null || !(prefs instanceof ListCriticityPreferencies)) {
            prefs = new ListCriticityPreferencies();
            this._cAppl.getPreferencies().addOptions(prefs);
            prefs.refreshOptions(((CeciliaAppl)this._cAppl).getPlugable());
        }
        List<PrefFieldBoolean> listPrefs = ((PrefFieldsCategory)prefs).getBooleanFields();
        this.getColumnModel().setOptionnalFields(PrefFieldsFactory.clone(listPrefs));
    }

    public final List<CriticityListItem> getListCrits() {
        return this._listCrits;
    }

    @Override
    public int getRowCount() {
        return this._listCrits.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumnModel().getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 8: {
                return Double.class;
            }
            case 9: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public int getFullRowCount() {
        return this._listCrits.size();
    }

    @Override
    public CriticityListItem getItem(int row) {
        return this._listCrits.get(row);
    }

    private boolean isWithError(CriticityListItem item) {
        if (!item.getConsistencyTree()) {
            return true;
        }
        return !item.getConsistencyCompute();
    }

    @Override
    public Object getValueAt(CriticityListItem item, int column) {
        int col = this.getColumnModel().getColumnField(column).getIdxCode();
        switch (col) {
            case 0: {
                return this.getNameFolder(item.getFolder(), 3);
            }
            case 1: {
                return this.getNameFolder(item.getFolder(), 2);
            }
            case 2: {
                return this.getNameFolder(item.getFolder(), 1) + ";" + item.getFolder().getName();
            }
            case 4: {
                return item.getTreeInfo() != null ? item.getTreeInfo().getParameters().get("Config") : null;
            }
            case 3: {
                return item.getEquation() != null ? item.getEquation().getTopEvent().getName() : null;
            }
            case 5: {
                return CriticityResult.OKKO.getEnumByValue(item.getConsistencyTree());
            }
            case 6: {
                return CriticityResult.OKKO.getEnumByValue(item.getConsistencyCompute());
            }
            case 7: {
                return item.getCriticityCrit() != null ? item.getCriticityCrit().getName() : null;
            }
            case 8: {
                if (item.getResult() != null && !this.isWithError(item)) {
                    return item.getResult().getProbValue();
                }
                return null;
            }
            case 9: {
                return item.getResult() != null && !this.isWithError(item) ? item.getResult().getOrderValue() : null;
            }
            case 10: {
                return item.getResult() != null && !this.isWithError(item) ? item.getResult().getAttributeCriterion() : null;
            }
            case 11: {
                return item.getResult() == null || !item.getResult().isAComputeCriticity() || this.isWithError(item) ? null : (item.getResult().getEvidentLSRCutError() == null ? String.valueOf(Double.NaN) : item.getResult().getEvidentLSRCutError());
            }
            case 12: {
                return item.getResult() == null || !item.getResult().isAComputeCriticity() || this.isWithError(item) ? null : (item.getResult().getLatentLSRCutError() == null ? String.valueOf(Double.NaN) : item.getResult().getLatentLSRCutError());
            }
        }
        assert (false);
        return null;
    }

    @Override
    public void exportToScribeFile(SrbInputStream outScribe, JTable table) throws IOException {
        int col;
        DoubleFormat format = null;
        PluginWithOptions pref = this._cAppl.getPreferencies().getOptions(GeneralTextPreferencies.PREF_KEY);
        if (pref != null && pref instanceof GeneralTextPreferencies) {
            format = ((GeneralTextPreferencies)pref).getDoubleFormat();
        }
        outScribe.concat("<GDOC SEC=''>\n");
        outScribe.concat("<TITLE>" + ResMsgArbor.getString("KEY_1293") + "\n");
        outScribe.concat("<DOCNUM>\n");
        outScribe.concat("<DATE>" + this.getCurrentDateAsDDMMYYYY() + "\n");
        outScribe.concat(".ti @\n");
        outScribe.concat(".tp 5 7 18 20 30 35 40 50 60\n");
        outScribe.concat("<BODY>\n");
        if (this.isAnExportWithCritDef()) {
            this.exportScribeSummary(outScribe);
        }
        outScribe.concat("<H1>" + ResMsgArbor.getString("KEY_1294") + "\n");
        outScribe.concat("<TABLEAU>\n");
        int nbrCols = this.getColumnCount();
        if (this.isAnExportWithCritDef()) {
            --nbrCols;
        }
        String cwidth = new String();
        String align = new String();
        for (col = 0; col < nbrCols; ++col) {
            outScribe.concat("<TABCOL>" + this.getColumnName(col) + "\n");
            cwidth = cwidth.concat("15 ");
            align = align.concat("L ");
        }
        if (cwidth.endsWith(" ")) {
            cwidth = cwidth.substring(0, cwidth.length() - 1);
        }
        if (align.endsWith(" ")) {
            align = align.substring(0, align.length() - 1);
        }
        outScribe.concat("<TABDEF CWIDTH = '" + cwidth + "'   ALIGN = '" + align + "'>\n");
        for (int row = 0; row < this.getRowCount(); ++row) {
            CriticityListItem item = this.getItem(row);
            for (col = 0; col < nbrCols; ++col) {
                int idx = this.getColumnModel().getColumnField(col).getIdxCode();
                Object value = this.getValueAt(item, col);
                String strValue = value == null ? "" : value.toString();
                switch (idx) {
                    case 11: 
                    case 12: {
                        if (strValue.equals(CriticityResult.OKKO.OK.name()) || strValue.isEmpty() || strValue.equals(String.valueOf(Double.NaN))) break;
                        StringBuilder sb = new StringBuilder();
                        sb.append(CriticityResult.OKKO.KO.name()).append(" (");
                        sb.append(strValue).append(')');
                        strValue = sb.toString();
                        break;
                    }
                    case 5: 
                    case 6: {
                        if (strValue.equals(CriticityResult.OKKO.OK.name())) break;
                        StringBuilder sb = new StringBuilder();
                        sb.append(CriticityResult.OKKO.KO.name()).append(" (");
                        sb.append(col == 6 ? ListCriticityUtility.isConsistencyComputeMsg(this._cAppl, this.getItem(row)) : ListCriticityUtility.isConsistencyTreeMsg(this._cAppl, this.getItem(row)));
                        sb.append(')');
                        strValue = sb.toString();
                        break;
                    }
                    case 8: {
                        if (format == null || value == null || !(value instanceof Double)) break;
                        strValue = format.format(((Double)value).doubleValue());
                    }
                }
                outScribe.concat("<C>" + strValue + "\n");
            }
        }
        outScribe.concat("<ETABLEAU>\n");
        outScribe.concat("<EGDOC>0\n");
    }

    private void exportScribeSummary(SrbInputStream outScribe) {
        LinkedHashMap mapProjectNameToCriticity = new LinkedHashMap();
        for (int row = 0; row < this.getRowCount(); ++row) {
            CriticityListItem item = this.getItem(row);
            CriticityCriterion crit = item.getCriticityCrit();
            if (crit == null) continue;
            String projectName = ListCriticityGenerateCmd.getDBFolderProjectName(item.getFolder());
            if (mapProjectNameToCriticity.get(projectName) == null) {
                LinkedHashSet setCrits = new LinkedHashSet();
                mapProjectNameToCriticity.put(projectName, setCrits);
            } else if (((Set)mapProjectNameToCriticity.get(projectName)).contains(crit)) continue;
            ((Set)mapProjectNameToCriticity.get(projectName)).add(crit);
        }
        if (mapProjectNameToCriticity.size() == 1) {
            Map.Entry entry = mapProjectNameToCriticity.entrySet().iterator().next();
            outScribe.concat("<H1>" + ResMsgArbor.msgFormat("MSG_LIST_CRITICITY_DEF_CRIT_FOR_PROJECT", entry.getKey()) + "\n");
            this.exportScribeTableCriticityDef(outScribe, (Set)entry.getValue());
        } else {
            outScribe.concat("<H1>" + ResMsgArbor.getString("MSG_LIST_CRITICITY_DEF_CRIT") + "\n");
            for (Map.Entry entry : mapProjectNameToCriticity.entrySet()) {
                String nameProject = (String)entry.getKey();
                Set crits = (Set)entry.getValue();
                outScribe.concat("<H2>. " + nameProject + "\n");
                this.exportScribeTableCriticityDef(outScribe, crits);
            }
        }
    }

    private final void exportScribeTableCriticityDef(SrbInputStream outScribe, Set<CriticityCriterion> crits) {
        int col;
        String[] headerTabCrit = ListCriticityGenerateCmd.getHeaderCritTable();
        outScribe.concat("<TABLEAU>\n");
        String cwidth = new String();
        String align = new String();
        for (col = 0; col < headerTabCrit.length; ++col) {
            outScribe.concat("<TABCOL>" + headerTabCrit[col] + "\n");
            cwidth = cwidth.concat("15 ");
            align = align.concat("L ");
        }
        if (cwidth.endsWith(" ")) {
            cwidth = cwidth.substring(0, cwidth.length() - 1);
        }
        if (align.endsWith(" ")) {
            align = align.substring(0, align.length() - 1);
        }
        outScribe.concat("<TABDEF CWIDTH = '" + cwidth + "'   ALIGN = '" + align + "'>\n");
        for (CriticityCriterion crit : crits) {
            for (col = 0; col < headerTabCrit.length; ++col) {
                String strValue = null;
                switch (col) {
                    case 0: {
                        strValue = crit.getName();
                        break;
                    }
                    case 1: {
                        strValue = String.valueOf(crit.getProbability());
                        break;
                    }
                    case 2: {
                        strValue = String.valueOf(crit.getOrder());
                        break;
                    }
                    case 4: {
                        if (Double.isNaN(crit.getLSREvident())) {
                            strValue = "-";
                            break;
                        }
                        strValue = String.valueOf(crit.getLSREvident());
                        break;
                    }
                    case 3: {
                        strValue = Double.isNaN(crit.getLSRLatent()) ? "-" : String.valueOf(crit.getLSRLatent());
                    }
                }
                outScribe.concat("<C>" + strValue + "\n");
            }
        }
        outScribe.concat("<ETABLEAU>\n");
    }

    private boolean isAnExportWithCritDef() {
        for (PrefFieldBoolean pref : this.getColumnModel().getOptionnalFields()) {
            if (!pref.getCode().equals("Content.CriticityDef")) continue;
            return pref.isSelected();
        }
        return false;
    }

    @Override
    public void exportToXMLDocBook(DBKOutput xmlWriter) throws IOException {
    }

    public static List<PrefFieldBoolean> createFields() {
        ArrayList<PrefFieldBoolean> fields = new ArrayList<PrefFieldBoolean>();
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_PROJECT"), CRITICITY_FIELD_PROJECT, 0, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_SYSTEM"), CRITICITY_FIELD_SYSTEM, 1, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_TREE"), CRITICITY_FIELD_TREE, 2, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("MSG_LIST_CRITICITY_FAILURE_COND_COL"), CRITICITY_FIELD_FAILURE_COND, 3, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_CONFIGURATIONS"), CRITICITY_FIELD_CONFIG, 4, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("MSG_LIST_CRITICITY_COHERENCE_TREE"), CRITICITY_FIELD_COHERENCE_TREE, 5, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("MSG_LIST_CRITICITY_COHERENCE_COMPUTE"), CRITICITY_FIELD_COHERENCE_COMP, 6, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_CRITICITY"), CRITICITY_FIELD_CRITICITY, 7, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_PROBABILITY"), CRITICITY_FIELD_COMPUTED_PROB, 8, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("MSG_LIST_CRITICITY_COMPUTED_ORDER_COL"), CRITICITY_FIELD_COMPUTED_ORDER, 9, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_ATTRIBUTE"), CRITICITY_FIELD_ATTRIBUT_LSR, 10, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_LSR_EVIDENT"), CRITICITY_FIELD_COMPUTED_EVIDENT, 11, 100, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_LSR_LATENT"), CRITICITY_FIELD_COMPUTED_LATENT, 12, 100, "L"));
        int len = fields.size();
        block8: for (int i = 0; i < len; ++i) {
            PrefFieldBoolean item = fields.get(i);
            item.setOptionnal(true);
            switch (item.getCode()) {
                case "attributLSR": 
                case "compEvident": 
                case "compLatent": {
                    item.setSelected(false);
                    continue block8;
                }
                default: {
                    item.setSelected(true);
                }
            }
        }
        return fields;
    }

    private final String getNameFolder(DBFolder folder, int depth) {
        for (int i = 0; i != depth; ++i) {
            folder = folder.getParent();
            assert (!folder.isSystem());
        }
        return folder.getName();
    }

    public static class ListCriticityColumnModel
    extends ItemAbstractColumnsModel {
        public ListCriticityColumnModel() {
            this.init();
        }

        @Override
        public List<PrefFieldBoolean> createOptionnalFields() {
            return ListCriticityTableModel.createFields();
        }

        @Override
        public void setOptionnalFields(List<PrefFieldBoolean> optionnalFields) {
            this._optionnalFields = optionnalFields;
            this._items.clear();
            for (PrefFieldBoolean field : optionnalFields) {
                this._items.add(field);
            }
            this.resetFilterIndexes();
        }
    }
}

