/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.criticity;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityListItem;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;

public class ListCriticityUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void apercuFileXML(Object input) {
        InputStream istream = null;
        if (input instanceof InputStream) {
            istream = (InputStream)input;
        }
        BufferedReader br = null;
        try {
            if (istream == null) {
                istream = new FileInputStream((File)input);
            }
            br = new BufferedReader(new InputStreamReader(istream));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
            System.out.println(sb.toString());
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (istream != null) {
                    istream.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static final String isConsistencyTreeMsg(CAppl appl, CriticityListItem critId) {
        String msgError;
        if (critId.isALoopTree()) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_LOOPED_EQ");
        }
        List<DBLogs.Log> logs = critId.getEquation().getLogs().getLogs(DBLogs.DBLevel.WARNING);
        Collection relations = critId.getEquation().getUseRelations();
        for (DBRelation relation : relations) {
            DBWrap wrap;
            List<DBLogs.Log> logsRelated;
            DBFolder related = relation.getDestination();
            if (related.getFamilyFlag() != 2 && related.getFamilyFlag() != 3 && related.getFamilyFlag() != 5 || (logsRelated = (wrap = ((CECFactory)appl.getDAOFactory()).findOrCreateWrap(related)).getLogs().getLogs(DBLogs.DBLevel.WARNING)) == null || logsRelated.isEmpty()) continue;
            logs.addAll(logsRelated);
        }
        if (logs != null && !logs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (DBLogs.Log log : logs) {
                sb.append(log.getMessage()).append("<br>");
            }
            sb.append("</html>");
            return sb.toString();
        }
        if (critId.getTreeInfo() != null && (msgError = critId.getTreeInfo().getParameters().get("tree.error")) != null && !msgError.isEmpty()) {
            return msgError;
        }
        return null;
    }

    public static final String isConsistencyComputeMsg(CAppl appl, CriticityListItem critID) {
        String isConsistencyTreeMsg = ListCriticityUtility.isConsistencyTreeMsg(appl, critID);
        if (isConsistencyTreeMsg != null && !isConsistencyTreeMsg.isEmpty()) {
            return isConsistencyTreeMsg;
        }
        DBFolder projectFolder = ListCriticityUtility.getDBProjectFolder(critID.getFolder());
        DBProject project = (DBProject)((CECFactory)appl.getDAOFactory()).findOrCreateWrap(projectFolder);
        if (project == null || project.getCriticityCriterium() == null || project.getCriticityCriterium().isEmpty()) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_NO_CRIT_PROJ");
        }
        if (critID.getCriticityCrit() == null) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_NO_CRIT_TREE");
        }
        if (critID.getResult() == null) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_COMPUTE_NO_RESULT_FROM_XML");
        }
        if (!critID.getResult().getCriticity().equals(critID.getCriticityCrit().getName())) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_DIFF_CRIT");
        }
        String xmlCRCOK = critID.getTreeInfo().getParameters().get("CRC.Xml.equals");
        if (xmlCRCOK == null || xmlCRCOK.equals("false")) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_COMPUTE_OUT_OF_DATE");
        }
        if (!critID.getResult().isAComputeCriticity()) {
            return ResMsgArbor.getString("MSG_LIST_CRITICITY_ERR_COMPUTE_NO_VALID_RESULT");
        }
        return null;
    }

    public static final DBFolder getDBProjectFolder(DBFolder folder) {
        assert (folder.getFamily() == DBFolder.Family.PROJECT);
        assert (folder.getFamilyFlag() == 2 || folder.getFamilyFlag() == 5);
        while (!folder.getParent().isSystem()) {
            folder = folder.getParent();
        }
        return folder;
    }
}

