/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.egli.gui;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.folder.JPanelTableFolder;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResIcoArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTPanelTableFolder;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class EventGlobalListSelectionPanel
extends FTPanelTableFolder {
    private List<DBFolder> _listDBFolder;
    private JCheckBox _ctrlIgnoreReference;
    private static final String TAG_CECILIA_EGL = "cecilia.EGL";

    public EventGlobalListSelectionPanel(CAppl cAppl, JDialog dlg, List<DBFolder> folders) {
        super(cAppl, dlg);
        this._listDBFolder = folders;
        this.initialise();
        this.getModel().setFolders(folders);
        this.getModel().fireTableDataChanged();
    }

    private JPanelTableFolder.DBFolderModel getModel() {
        return (JPanelTableFolder.DBFolderModel)this._model;
    }

    @Override
    public void deleteRows() {
        int[] selectedRows = this._table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        ArrayList<DBFolder> foldersToRemove = new ArrayList<DBFolder>();
        for (int i = 0; i < selectedRows.length; ++i) {
            foldersToRemove.add(this.getModel().getItem(this._table.convertRowIndexToModel(selectedRows[i])));
        }
        this.getModel().getFolders().removeAll(foldersToRemove);
        this._listDBFolder.removeAll(foldersToRemove);
        this.getModel().fireTableDataChanged();
    }

    public List<DBFolder> getSelectedFolders() {
        return this.getModel().getFolders();
    }

    @Override
    protected JPanel createBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this._ctrlIgnoreReference = new JCheckBox(ResMsgObj.getString("EGL_MSG_IGNORE_OLD"));
        this._ctrlIgnoreReference.addActionListener(e -> this.updateTableModel());
        panel.add((Component)this._ctrlIgnoreReference, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(1, 0, 1, 1, 100.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        return panel;
    }

    protected void updateTableModel() {
        if (this._ctrlIgnoreReference.isSelected()) {
            List<DBFolder> folders = this.getLastUpdatedFolders(this._listDBFolder);
            this.getModel().setFolders(folders);
        } else {
            this.getModel().setFolders(this._listDBFolder);
        }
        this.getModel().fireTableDataChanged();
    }

    private List<DBFolder> getLastUpdatedFolders(List<DBFolder> folders) {
        ArrayList<DBFolder> filteredFolders = new ArrayList<DBFolder>();
        LinkedHashSet<DBFolder> parents = new LinkedHashSet<DBFolder>();
        for (DBFolder folder : folders) {
            DBFolder parent = folder.getParent();
            if (parent == null) continue;
            parents.add(parent);
        }
        block1: for (DBFolder parent : parents) {
            ArrayList<DBFolder> children = new ArrayList<DBFolder>(parent.getChildren());
            Collections.sort(children, (dbf1, dbf2) -> {
                String nameDBF1 = dbf1.getName();
                String nameDBF2 = dbf2.getName();
                int versionDBF1 = Integer.parseInt(nameDBF1.substring(0, nameDBF1.indexOf(46)));
                int releaseDBF1 = Integer.parseInt(nameDBF1.substring(nameDBF1.indexOf(46) + 1, nameDBF1.length()));
                int versionDBF2 = Integer.parseInt(nameDBF2.substring(0, nameDBF2.indexOf(46)));
                int releaseDBF2 = Integer.parseInt(nameDBF2.substring(nameDBF2.indexOf(46) + 1, nameDBF2.length()));
                if (versionDBF1 == versionDBF2) {
                    return releaseDBF1 > releaseDBF2 ? -1 : 1;
                }
                return versionDBF1 > versionDBF2 ? -1 : 1;
            });
            for (int i = 0; i < children.size(); ++i) {
                if (!folders.contains(children.get(i))) continue;
                filteredFolders.add((DBFolder)children.get(i));
                continue block1;
            }
        }
        return filteredFolders;
    }

    @Override
    protected void addToBatch(DBFolder node) {
        if (!this._listDBFolder.contains(node)) {
            this._listDBFolder.add(node);
        }
        if (!this.getModel().getFolders().contains(node)) {
            this.getModel().getFolders().add(node);
        }
    }

    @Override
    protected void updateModel() {
        this.updateTableModel();
    }

    @Override
    public void save(File output) {
        this.doSave(output, TAG_CECILIA_EGL, this._listDBFolder);
    }

    @Override
    protected void doSaveOther(Writer writer, String increment) throws IOException {
        writer.append(increment).append("<ignorePastResults value=\"");
        writer.append(String.valueOf(this._ctrlIgnoreReference.isSelected()));
        writer.append("\"/>\n");
    }

    @Override
    public void load(File input) {
        this._listDBFolder.clear();
        this.getModel().getFolders().clear();
        this.doLoad(input, TAG_CECILIA_EGL);
        this.updateTableModel();
    }

    @Override
    protected void doLoadFolder(DBFolder dbFolder, Element elem) {
        this._listDBFolder.add(dbFolder);
    }

    @Override
    protected void doLoadOther(Element elem) {
        if (elem.getTagName().equals("ignorePastResults")) {
            String ignorePastResults = elem.getAttribute("value");
            this._ctrlIgnoreReference.setSelected(Boolean.parseBoolean(ignorePastResults));
        }
    }

    public static class EventGlobalListSelectionDlg
    extends JDialogCecilia {
        private EventGlobalListSelectionPanel _panel;

        public EventGlobalListSelectionDlg(Window owner, CAppl appl, List<DBFolder> selFolders) {
            super(owner, ResMsgObj.getString("EGL_TITLE"), false);
            this.setIconImage(ResIcoArbor.getImageIcon("EVENT_GLOBAL_LIST").getImage());
            this.getContentPane().setLayout(new BorderLayout());
            this._panel = new EventGlobalListSelectionPanel(appl, this, selFolders);
            this.getContentPane().add((Component)this._panel, "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.setLocation(((CeciliaGUI)appl.getTopWindow()).getDesktop().getDesktop().getDesktopManager().initLocation(this));
            this.pack();
        }

        public List<DBFolder> getSelectedFolders() {
            return this._panel.getSelectedFolders();
        }

        @Override
        protected boolean verifyParameters() {
            return true;
        }
    }
}

