/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.lib.util.CopyUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class FTVariable
extends FTVariableAbstract {
    private static Logger _LOG = Logger.getLogger(FTVariable.class.getPackage().getName());
    long _idInternal = -1L;
    String _strName = null;
    String _strLabel = "";
    boolean _bGeneric = false;
    String _strExportName = null;
    FTDefinition _ftDefinition = null;
    FTEvent _ftEvent = null;
    boolean _bIsLinked = false;
    FTLink _ftLink = null;
    boolean _bIsLocked = false;

    @Override
    public boolean isIntern() {
        return true;
    }

    public FTVariable setLocked(boolean value) {
        this._bIsLocked = value;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this._bIsLocked;
    }

    @Override
    public long getInternalID() {
        return this._idInternal;
    }

    FTVariable setInternalID(long value) {
        this._idInternal = value;
        return this;
    }

    @Override
    public String getName() {
        return this._strName;
    }

    public FTVariable setName(String value) {
        this._strName = value;
        return this;
    }

    @Override
    public String getExportName() {
        if (this._strExportName != null) {
            return this._strExportName;
        }
        return super.getExportName();
    }

    public FTVariable setExportName(String value) {
        this._strExportName = value;
        return this;
    }

    @Override
    public String getLabel() {
        return this._strLabel;
    }

    public FTVariable setLabel(String value) {
        this._strLabel = value;
        return this;
    }

    @Override
    public boolean isGeneric() {
        return this._bGeneric;
    }

    public FTVariable setGeneric(boolean value) {
        this._bGeneric = value;
        return this;
    }

    @Override
    public FTDefinition getDefinition() {
        return this._ftDefinition;
    }

    @Override
    public FTVariable setDefinition(FTDefinition value) {
        this._ftDefinition = value;
        this._bLeaf = this._ftDefinition == null;
        return this;
    }

    @Override
    public FTEvent getEvent() {
        return this._ftEvent;
    }

    public FTVariable setEvent(FTEvent value) {
        this._bLeaf = true;
        this._ftEvent = value;
        if (this._ftEvent != null) {
            this._ftEvent.setVariable(this);
        }
        this._bIsLinked = false;
        return this;
    }

    @Override
    public FTLink getLink() {
        return this._ftLink;
    }

    public FTVariable setLink(FTLink value) {
        this._ftLink = value;
        this._bIsLinked = this._ftLink != null;
        return this;
    }

    public boolean isLinked() {
        return this._bIsLinked && this._ftLink != null;
    }

    @Override
    public FTDefinition.Type getType() {
        if (this._ftDefinition != null) {
            return this._ftDefinition.getType();
        }
        return FTDefinition.Type.VAR;
    }

    @Override
    public FTVariable getCopy(CopyUtility util) {
        Object ref = util.getRef((Object)this);
        if (ref == null) {
            FTVariable ftVar = new FTVariable();
            ftVar.copy(this, util);
            util.setRef((Object)this, (Object)ftVar);
            return ftVar;
        }
        return (FTVariable)ref;
    }

    @Override
    public void copy(FTVariableAbstract src, CopyUtility util) {
        super.copy(src, util);
        this._bGeneric = src.isGeneric();
        this._strName = src.getName();
        this._strLabel = src.getLabel();
        this._bIsLocked = src.isLocked();
        if (src.getEvent() == null) {
            this._ftEvent = null;
        } else {
            this._ftEvent = src.getEvent().getCopy();
            this._ftEvent.setVariable(this);
        }
        FTLink fTLink = this._ftLink = src.getLink() == null ? null : src.getLink().getCopy();
        if (this.isIntern() && this._ftLink == null) {
            FTDefinition fTDefinition = this._ftDefinition = src.getDefinition() == null ? null : src.getDefinition().getCopy(util);
        }
        if (!(src instanceof FTVariable)) {
            return;
        }
        FTVariable ftVarSrc = (FTVariable)src;
        this._idInternal = util.copyInternalID((Object)ftVarSrc) ? ftVarSrc._idInternal : -1L;
        this._bIsLinked = ftVarSrc._bIsLinked;
        this._strExportName = ftVarSrc._strExportName;
    }

    public void toXMLDictionary(Appendable out, String indent) throws IOException {
        if (this.getInternalID() == -1L) {
            throw new IOException("Variable avec un ID n\u00e9gatif : " + this._strName);
        }
        out.append(indent).append("<").append("ft.var");
        out.append(" ").append("id").append("='").append(Long.toString(this.getInternalID())).append("'");
        DBObjectXmlUtility.appendXML(out.append(" ").append("name").append("='"), this._strName).append("'");
        if (this._strExportName != null) {
            DBObjectXmlUtility.appendXML(out.append(" ").append("export").append("='"), this._strExportName).append("'");
        }
        if (this.isRoot()) {
            out.append(" ").append("isRoot").append("='true'");
        }
        if (this.isLinked()) {
            out.append(" ").append("isLink").append("='true'");
        } else if (this.isLeaf()) {
            out.append(" ").append("isLeaf").append("='true'");
        }
        if (this.isGeneric()) {
            out.append(" ").append("isGeneric").append("='true'");
        }
        if (!Double.isNaN(this._probability)) {
            out.append(" ").append("pr").append("='").append(Double.toString(this._probability)).append("'");
        }
        if (this._strLabel.length() > 0 || this.isLinked() || this.isLeaf()) {
            out.append(">\n");
            if (this._strLabel.length() > 0) {
                out.append(indent).append("  <").append("label").append(">");
                DBObjectXmlUtility.appendXML(out, this._strLabel);
                out.append("</").append("label").append(">\n");
            }
            if (this.isLinked()) {
                this._ftLink.toXML(out, indent);
            } else if (this.isLeaf()) {
                this._ftEvent.toXML(out, indent);
            }
            out.append(indent).append("</").append("ft.var").append(">\n");
        } else {
            out.append("/>\n");
        }
    }

    public void toXMLEquation(Appendable out, String indent) throws IOException {
        if (this.isLinked()) {
            return;
        }
        if (this.isLeaf()) {
            return;
        }
        if (this._ftDefinition != null) {
            this._ftDefinition.toXML(out, indent, this.getInternalID());
        }
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        if (this.getEvent() != null) {
            this.getEvent().addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
        if (this.getLink() != null) {
            this.getLink().addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
    }

    public List<FTVariable> extractVariables() {
        class ExtractUtility
        extends LinkedHashMap<Object, Object>
        implements CopyUtility {
            ArrayList<FTVariable> _vars = new ArrayList();

            ExtractUtility() {
            }

            public Object getRef(Object src) {
                return this.get(src);
            }

            public void setRef(Object src, Object ref) {
                this.put(src, ref);
                if (ref instanceof FTVariable) {
                    this._vars.add((FTVariable)ref);
                }
            }

            public boolean selectForCopy(Object src) {
                return true;
            }

            public boolean copyInternalID(Object src) {
                return true;
            }
        }
        ExtractUtility utility = new ExtractUtility();
        FTVariable ftCopy = this.getCopy(utility);
        ftCopy.setRoot(false);
        Collections.reverse(utility._vars);
        if (utility._vars.isEmpty()) {
            _LOG.fine("Extraction par defaut renvoie une liste vide : " + this.getName());
            utility._vars.add(ftCopy);
        } else if (utility._vars.get(0) != ftCopy) {
            _LOG.fine("Extraction par defaut ne commence pas par ce qui \u00e9tait attendu : " + this.getName());
            utility._vars.remove(ftCopy);
            utility._vars.add(0, ftCopy);
        }
        return utility._vars;
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        if (this.getEvent() != null) {
            sb.append(this.getEvent().getAbstract());
        } else if (this.getDefinition() != null) {
            sb.append(this.getDefinition().toString());
        }
        return sb.toString();
    }
}

