/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CApplInit;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.AbstractInfoDatum;
import com.dassault.cecilia.dbobj.faulttree.TreeInfoCompute;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResult;
import com.dassault.cecilia.dbobj.faulttree.criticity.CriticityResultTableModel;
import com.dassault.cecilia.dbobj.faulttree.criticity.ListCriticityGenerateCmd;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class ExpFTCriticityResult
extends ExpTable {
    private CriticityResultTableModel _tableModel;
    private boolean _canBeExported = false;

    public ExpFTCriticityResult(CriticityResultTableModel tableModel) {
        this._tableModel = tableModel;
        this._canBeExported = true;
    }

    public ExpFTCriticityResult(FTEquation ftEqu, DoubleFormat formatter) {
        Map<String, TreeInfoCompute> treeComputes = ftEqu.getInfoComputes();
        if (treeComputes == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MCS");
        sb.append(".Abstract");
        sb.append('.');
        AbstractInfoDatum infoCmpt = null;
        for (Map.Entry<String, TreeInfoCompute> entry : treeComputes.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(sb.toString())) continue;
            infoCmpt = entry.getValue();
        }
        if (infoCmpt == null) {
            return;
        }
        File file = infoCmpt.getInputFiles().get("result.abstract");
        if (file == null && Boolean.valueOf(infoCmpt.getParameters().get("CRC.Xml.equals")).booleanValue()) {
            return;
        }
        CriticityResult result = ListCriticityGenerateCmd.readCriticityResultFromFile(file);
        if (!result.isAComputeCriticity()) {
            return;
        }
        CeciliaAppl appl = (CeciliaAppl)CApplInit.getInstance();
        final CriticityCriterion crit = ftEqu.getCurrentCriterion(appl);
        this._tableModel = new CriticityResultTableModel(result, formatter){

            @Override
            protected Number getValueCriticity(int row) {
                switch (row) {
                    case 0: {
                        return crit.getProbability();
                    }
                    case 1: {
                        return crit.getOrder();
                    }
                    case 3: {
                        return crit.getLSREvident();
                    }
                    case 2: {
                        return crit.getLSRLatent();
                    }
                }
                return null;
            }
        };
        this._canBeExported = true;
    }

    public final boolean canBeExported() {
        return this._canBeExported;
    }

    @Override
    protected int getColumnCount() {
        return this._tableModel == null ? 0 : this._tableModel.getColumnCount();
    }

    @Override
    protected String getColumnName(int col) {
        return this._tableModel == null ? null : this._tableModel.getColumnName(col);
    }

    @Override
    protected int getRowCount() {
        return this._tableModel == null ? 0 : this._tableModel.getRowCount();
    }

    private String getValueAt(int col, int row) {
        Object valueAt = this._tableModel.getValueAt(row, col);
        switch (col) {
            case 0: 
            case 3: {
                return String.valueOf(valueAt);
            }
            case 1: {
                if (valueAt instanceof Double) {
                    return this._tableModel.getRenderer().format(((Double)valueAt).doubleValue());
                }
                return String.valueOf(valueAt);
            }
            case 2: {
                String valueStr = String.valueOf(valueAt);
                if (!valueStr.contains(".")) {
                    return valueStr;
                }
                if (!valueStr.contains("(")) {
                    return this._tableModel.getRenderer().formatProbability(((Double)valueAt).doubleValue());
                }
                return CriticityResultTableModel.convertLatentInformations(valueStr, this._tableModel.getRenderer());
            }
        }
        return String.valueOf(valueAt);
    }

    @Override
    protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
        output.write(this.getValueAt(col, row), true);
    }

    @Override
    protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
        buffer.append(this.getValueAt(col, row));
    }

    @Override
    protected int getColumnWidth(int col) {
        switch (col) {
            case 0: {
                return 10;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 10;
            }
            case 3: {
                return 5;
            }
        }
        return super.getColumnWidth(col);
    }

    public static class ExpFTCriticityResultSection
    extends ExpSection {
        private final FTEquation _ftEquation;

        public ExpFTCriticityResultSection(FTEquation ftEqu, DoubleFormat formatter) {
            this._ftEquation = ftEqu;
            ExpFTCriticityResult expCrits = new ExpFTCriticityResult(this._ftEquation, formatter);
            if (expCrits.canBeExported()) {
                this.add(expCrits);
            }
        }

        @Override
        public String getTitle() {
            return ResMsgVoc.getString("VOC_CRITICITY");
        }

        @Override
        public void writeContentScribe(SrbInputStream scribe) throws IOException {
            this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_CRITICITY"), this._ftEquation.getCriticityLevel());
            super.writeContentScribe(scribe);
        }

        @Override
        protected void writeContentDocbook(DBKOutput output) throws IOException {
            this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_CRITICITY"), this._ftEquation.getCriticityLevel());
            super.writeContentDocbook(output);
        }
    }
}

