/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.export.ExpTableEvents;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ExpFTListVarTable
extends ExpTableEvents<FTVariableAbstract> {
    private static Logger _LOG = Logger.getLogger(ExpFTListVarTable.class.getPackage().getName());
    private final FTEquation _ftEqu;
    private final PrefFieldBoolean _prefField;
    List<FTVariableAbstract> _vars;
    List<PrefFieldBoolean> _cols;
    private final boolean _isOnlyIntern;

    public ExpFTListVarTable(FTEquation ftEqu, PrefFieldBoolean prefField, List<PrefFieldBoolean> colFilters, boolean isOnlyIntern) {
        this._ftEqu = ftEqu;
        this._prefField = prefField;
        this._cols = colFilters;
        this._isOnlyIntern = isOnlyIntern;
    }

    @Override
    protected int getColumnCount() {
        return this._cols.size();
    }

    @Override
    protected String getColumnName(int col) {
        return this._cols.get(col).getLabel();
    }

    @Override
    protected ExpTable.ExpAlign getColumnAlign(int col) {
        Object info = this._cols.get(col).getInfo("Align");
        if (info == null) {
            return ExpTable.ExpAlign.LEFT;
        }
        switch (info.toString()) {
            case "R": {
                return ExpTable.ExpAlign.RIGHT;
            }
            case "C": {
                return ExpTable.ExpAlign.CENTER;
            }
        }
        return ExpTable.ExpAlign.LEFT;
    }

    @Override
    protected int getColumnWidth(int col) {
        Object info = this._cols.get(col).getInfo("Width");
        if (info == null || !(info instanceof Number)) {
            return 5;
        }
        return ((Number)info).intValue();
    }

    @Override
    protected int getRowCount() {
        return this._vars.size();
    }

    @Override
    protected FTVariableAbstract getObject(int row) {
        return this._vars.get(row);
    }

    @Override
    protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
        this.writeDocbookCellAt(output, col, row);
    }

    private boolean prepareWrite() {
        ExpBook book = this.getBook();
        if (book == null) {
            _LOG.severe("Don't find root book for exportation");
            return false;
        }
        this._vars = this.filterVariables();
        return true;
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        if (!this.prepareWrite()) {
            return;
        }
        if (this._vars.isEmpty()) {
            output.write("<simpara>", false);
            output.write(this.getMsgEmpty(), true);
            output.write("</simpara>", false);
        } else {
            super.writeDocbook(output);
        }
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        if (!this.prepareWrite()) {
            return;
        }
        if (this._vars.isEmpty()) {
            scribe.concat("@@");
            scribe.concat(this.getMsgEmpty());
            scribe.concat("\n");
            scribe.concat(".br \n");
        } else {
            super.writeScribe(scribe);
        }
    }

    private List<FTVariableAbstract> filterVariables() {
        ArrayList<FTVariableAbstract> select = new ArrayList<FTVariableAbstract>();
        for (FTVariableAbstract var : this._ftEqu.getAllVariables()) {
            if (this._isOnlyIntern && !var.isIntern() || !this.respectCriterion(var)) continue;
            select.add(var);
        }
        return select;
    }

    protected void writeDocbookCellAt(DBKOutput output, int col, int row) throws IOException {
        String value;
        FTVariableAbstract var = this._vars.get(row);
        int codCol = this._cols.get(col).getIdxCode();
        String string = value = codCol == 0 ? String.valueOf(row + 1) : this.getEntryAt(codCol, var);
        if (!value.isEmpty()) {
            output.write(value, true);
        }
    }

    @Override
    protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
        String value;
        FTVariableAbstract var = this._vars.get(row);
        int codCol = this._cols.get(col).getIdxCode();
        String string = value = codCol == 0 ? String.valueOf(row + 1) : this.getEntryAt(codCol, var);
        if (!value.isEmpty()) {
            buffer.append(value);
        }
    }

    @Override
    protected String getEntryAt(int codCol, FTVariableAbstract item) {
        switch (codCol) {
            case 1: {
                return item.getName();
            }
            case 2: {
                return item.getLabel();
            }
            case 30: {
                FTDefinition ftDef = item.getDefinition();
                if (ftDef != null) {
                    return ftDef.toString();
                }
                return "";
            }
            case 3: {
                FTEvent ftEvt = item.getEvent();
                if (ftEvt != null && ftEvt.getLaw() != null) {
                    return this.ltos(ftEvt.getLaw());
                }
                return "";
            }
            case 4: {
                double probability = item.getProbability();
                if (probability < 0.0 || probability > 1.0) {
                    return "-";
                }
                return this.dtos(probability);
            }
            case 5: {
                FTEvent ftEvt = item.getEvent();
                if (ftEvt != null) {
                    return ftEvt.getState().getLabel();
                }
                return "";
            }
            case 6: {
                FTEvent ftEvt = item.getEvent();
                if (ftEvt != null) {
                    return ftEvt.getStyle().getLabel();
                }
                return "";
            }
            case 7: {
                return item.isGeneric() ? ResMsgVoc.getString("VOC_YES") : "";
            }
            case 8: {
                if (item.getLink() != null) {
                    return item.getLink().getGeneric();
                }
                return "";
            }
            case 9: {
                return item.getLink() != null && !item.getLink().isDSF() ? ResMsgVoc.getString("VOC_YES") : "";
            }
            case 10: {
                return item.getLink() != null && item.getLink().isDSF() ? ResMsgVoc.getString("VOC_YES") : "";
            }
            case 11: {
                if (item.getLink() != null) {
                    return item.getLink().getSubTree().getRefPath();
                }
                return "";
            }
            case 12: {
                FTEvent ftEvt = item.getEvent();
                if (ftEvt != null && ftEvt.getModelLaw() != null) {
                    return ftEvt.getModelLaw().getRefPath();
                }
                return "";
            }
            case 13: {
                if (item.getEvent() != null) {
                    Set<Param> params = item.getEvent().recupParams(new LinkedHashSet<Param>(), new FctParamSelect.FctParamFMEA());
                    return ParamFMEA.transcodeCollections(params);
                }
                return "";
            }
            case 15: {
                if (item.getDefinition() != null) {
                    return item.getDefinition().isGSR() ? ResMsgVoc.getString("VOC_YES") : "";
                }
                return "";
            }
            case 16: {
                FTEvent ftEvt = item.getEvent();
                if (ftEvt != null && ftEvt.getInspected() != null) {
                    return this.ptos(ftEvt.getInspected());
                }
                return "";
            }
            case 17: {
                FTEvent ftEvt = item.getEvent();
                if (ftEvt != null && ftEvt.getInflightTested() != null) {
                    return this.ptos(ftEvt.getInflightTested());
                }
                return "";
            }
            case 18: {
                FTEvent ftEvt = item.getEvent();
                if (ftEvt != null) {
                    return ftEvt.getAttributesAsDisplayedString();
                }
                return "";
            }
            case 19: {
                FTEvent ftEvt = item.getEvent();
                if (ftEvt != null && ftEvt.getCCF() != null) {
                    return ftEvt.getCCF().getRefPath();
                }
                return "";
            }
            case 20: {
                return this.dtos(item.getEvent() == null ? Double.NaN : item.getEvent().getIF(FTEvent.IF.CPr));
            }
            case 21: {
                return this.dtos(item.getEvent() == null ? Double.NaN : item.getEvent().getIF(FTEvent.IF.MIF));
            }
            case 23: {
                return this.dtos(item.getEvent() == null ? Double.NaN : item.getEvent().getIF(FTEvent.IF.DIF));
            }
            case 22: {
                return this.dtos(item.getEvent() == null ? Double.NaN : item.getEvent().getIF(FTEvent.IF.CIF));
            }
            case 24: {
                return this.dtos(item.getEvent() == null ? Double.NaN : item.getEvent().getIF(FTEvent.IF.RAW));
            }
            case 25: {
                return this.dtos(item.getEvent() == null ? Double.NaN : item.getEvent().getIF(FTEvent.IF.RRW));
            }
        }
        return "";
    }

    private final boolean respectCriterion(FTVariableAbstract var) {
        switch (this._prefField.getCode()) {
            case "Events.Undeveloped": {
                return var.isEventTerminal();
            }
            case "Events.Intermediate": {
                return var.isEventIntermediate();
            }
            case "Events.InFlightTested": {
                return var.isEventInflightTested();
            }
            case "Events.Inspected": {
                return var.isEventInspected();
            }
            case "Events.SubTree": {
                return var.isEventSubTree();
            }
            case "Events.GraphicSubRoot": {
                return var.isEventGSR();
            }
        }
        return false;
    }

    private final String getMsgEmpty() {
        switch (this._prefField.getCode()) {
            case "Events.Undeveloped": {
                return ResMsgArbor.getString("MSG_EXPORT_NO_TERMINALS_EVENTS");
            }
            case "Events.Intermediate": {
                return ResMsgArbor.getString("MSG_EXPORT_NO_INTERMEDIATE_EVENTS");
            }
            case "Events.InFlightTested": {
                return ResMsgArbor.getString("MSG_EXPORT_NO_INFLIGHT_EVENTS");
            }
            case "Events.Inspected": {
                return ResMsgArbor.getString("MSG_EXPORT_NO_INSPECTED_EVENTS");
            }
            case "Events.SubTree": {
                return ResMsgArbor.getString("MSG_EXPORT_NO_SUBTREE_EVENTS");
            }
            case "Events.GraphicSubRoot": {
                return ResMsgArbor.getString("MSG_EXPORT_NO_GRAPHICAL_INTER_EVENTS");
            }
        }
        _LOG.severe("Grave erreur, aucun Subtitle r\u00e9cup\u00e9r\u00e9.");
        return "";
    }
}

