/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTListVarTable;
import com.dassault.cecilia.dbobj.faulttree.pref.FTVariableListPrintPreferencies;
import java.util.ArrayList;
import java.util.List;

public class ExpFTListVariables
extends ExpSection {
    FTEquation _ftEqu;

    @Override
    public String getTitle() {
        return ResMsgArbor.getString("KEY_0152").toUpperCase();
    }

    public ExpFTListVariables(ExpBook book, FTEquation ftEqu) {
        this(book, ftEqu, true);
    }

    public ExpFTListVariables(ExpBook book, FTEquation ftEqu, boolean addSections) {
        this._ftEqu = ftEqu;
        if (addSections) {
            this.addFieldSections(book, ftEqu);
        }
    }

    protected void addFieldSections(ExpBook book, FTEquation ftEqu) {
        PrefFieldsCategory prefFields = this.readPreferencies(book);
        List<PrefFieldBoolean> filterFields = this.filterFields(prefFields);
        boolean onlyInter = prefFields.getPref("Events.OnlyIntern").isSelected();
        for (PrefFieldBoolean prefField : prefFields.getBooleanFields()) {
            if (!prefField.isSelected() || !this.isAEventFilter(prefField)) continue;
            this.add(new ExpSectionTable(prefField.getCode(), new ExpFTListVarTable(ftEqu, prefField, filterFields, onlyInter)));
        }
    }

    protected PrefFieldsCategory readPreferencies(ExpBook book) {
        PluginWithOptions prefs = book.getPreferencies().getOptions(FTVariableListPrintPreferencies.PREF_KEY);
        if (prefs == null || !(prefs instanceof FTVariableListPrintPreferencies)) {
            prefs = new FTVariableListPrintPreferencies();
            book.getPreferencies().addOptions(prefs);
        }
        return (PrefFieldsCategory)prefs;
    }

    private List<PrefFieldBoolean> filterFields(PrefFieldsCategory prefFields) {
        List<PrefFieldBoolean> listPrefs = prefFields.getBooleanFields();
        ArrayList<PrefFieldBoolean> fields = new ArrayList<PrefFieldBoolean>(listPrefs.size() + 2);
        PrefFieldBoolean field = prefFields.getPref("Events.NumberColumnsDisplayed");
        if (field != null && field.isSelected()) {
            fields.add(field.getCopy());
        }
        if ((field = prefFields.getPref("proba")) != null && field.isSelected()) {
            fields.add(field.getCopy());
        }
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_NAME"), "name", 1, 15, "L"));
        for (PrefFieldBoolean prefField : listPrefs) {
            if (prefField.getCode().startsWith("Events.") || prefField.getCode().equals("proba") || !prefField.isSelected()) continue;
            fields.add(prefField.getCopy());
        }
        return fields;
    }

    private final boolean isAEventFilter(PrefFieldBoolean field) {
        switch (field.getCode()) {
            case "Events.Undeveloped": 
            case "Events.Intermediate": 
            case "Events.InFlightTested": 
            case "Events.Inspected": 
            case "Events.SubTree": 
            case "Events.GraphicSubRoot": {
                return true;
            }
        }
        return false;
    }

    public static class ExpSectionTable
    extends ExpSection {
        private final String _title;

        public ExpSectionTable(String title, ExpTable table) {
            this._title = title;
            this.add(table);
        }

        @Override
        public String getTitle() {
            switch (this._title) {
                case "Events.Undeveloped": {
                    return ResMsgArbor.getString("TITLE_EXPORT_UNDEVELOPED_EVENTS");
                }
                case "Events.Intermediate": {
                    return ResMsgArbor.getString("TITLE_EXPORT_DEVELOPED_EVENTS");
                }
                case "Events.InFlightTested": {
                    return ResMsgArbor.getString("TITLE_EXPORT_INFLIGHT_EVENTS");
                }
                case "Events.Inspected": {
                    return ResMsgArbor.getString("TITLE_EXPORT_INSPECTED_EVENTS");
                }
                case "Events.SubTree": {
                    return ResMsgArbor.getString("TITLE_EXPORT_SUBTREE_EVENTS");
                }
                case "Events.GraphicSubRoot": {
                    return ResMsgArbor.getString("TITLE_EXPORT_GRAPHICS_EVENTS");
                }
            }
            return "";
        }
    }
}

