/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTAnalysis;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTConfigs;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTListVariables;
import com.dassault.cecilia.dbobj.faulttree.ft.export.ExpFTListVariablesRecap;
import com.dassault.cecilia.dbobj.faulttree.pref.FTVariableListPrintPreferencies;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatPerHour;
import java.io.IOException;
import java.util.logging.Logger;

public class ExpFTListVariables51
extends ExpFTListVariables {
    private static Logger _LOG = Logger.getLogger(ExpFTListVariables51.class.getPackage().getName());

    public ExpFTListVariables51(ExpBook book, FTEquation ftEqu) {
        super(book, ftEqu, false);
        this.prepare(book);
    }

    private void prepare(ExpBook book) {
        PrefFieldsCategory prefs = this.readPreferencies(book);
        PrefFieldBoolean pref = prefs.getPref("Content.QAnalysis");
        GeneralTextPreferencies textPref = (GeneralTextPreferencies)book.getPreferencies().getOptions(GeneralTextPreferencies.PREF_KEY);
        FTVariableListPrintPreferencies printPref = (FTVariableListPrintPreferencies)book.getPreferencies().getOptions(FTVariableListPrintPreferencies.PREF_KEY);
        boolean onlyInternal = printPref.getPref("Events.OnlyIntern").isSelected();
        if (pref == null || pref.isSelected()) {
            DoubleFormat renderer = textPref.getDoubleFormat();
            if (this._ftEqu.getComputeParameters().isOneHourOption()) {
                double time = this._ftEqu.getComputeParameters().getFlightDuration();
                if (Double.isNaN(time)) {
                    time = this._ftEqu.getComputeParameters().getTime();
                }
                if (!Double.isNaN(time)) {
                    renderer = new DoubleFormatPerHour(renderer, time / 3600.0);
                }
            }
            this.add(new ExpFTAnalysis(this._ftEqu, renderer));
        }
        this.add(new ExpFTConfigs(this._ftEqu.getConfigs()));
        this.add(new ExpFTListVariablesRecap(this._ftEqu, onlyInternal));
        this.addFieldSections(book, this._ftEqu);
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        ExpBook book = this.getBook();
        if (book == null) {
            _LOG.severe("Don't find root book for exportation");
            return;
        }
        super.writeDocbook(output);
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        ExpBook book = this.getBook();
        if (book == null) {
            _LOG.severe("Don't find root book for exportation");
            return;
        }
        super.writeScribe(scribe);
    }
}

