/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class ExpFTListVariablesRecap
extends ExpSection {
    private final FTEquation _ftEquation;
    private final boolean _onlyInternal;

    public ExpFTListVariablesRecap(FTEquation ftEquation, boolean onlyInternal) {
        this._ftEquation = ftEquation;
        this._onlyInternal = onlyInternal;
        this.add(new ExpFTListVariablesRecapTable());
    }

    @Override
    public String getTitle() {
        return ResMsgArbor.getString("MSG_EXPORT_EVENTS_SUMMARY");
    }

    private List<? extends FTVariableAbstract> getVariables() {
        return this._onlyInternal ? this._ftEquation.getInternalVariables() : this._ftEquation.getAllVariables();
    }

    private class ExpFTListVariablesRecapTable
    extends ExpTable {
        private ExpFTListVariablesRecapTable() {
        }

        @Override
        protected int getColumnCount() {
            return 2;
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            if (col == 0) {
                return ExpTable.ExpAlign.LEFT;
            }
            return ExpTable.ExpAlign.RIGHT;
        }

        @Override
        protected int getColumnWidth(int col) {
            if (col == 0) {
                return 25;
            }
            return 5;
        }

        @Override
        protected String getColumnName(int col) {
            if (col == 0) {
                return ResMsgVoc.getString("VOC_TYPE");
            }
            return ResMsgVoc.getString("VOC_NUMBER");
        }

        @Override
        protected int getRowCount() {
            return 7;
        }

        private String getValueOfEntry(int col, int row) {
            switch (row) {
                case 0: {
                    if (col == 0) {
                        return ResMsgArbor.getString("MSG_EXPORT_EVENTS_TOTAL");
                    }
                    return String.valueOf(ExpFTListVariablesRecap.this.getVariables().size());
                }
                case 1: {
                    if (col == 0) {
                        return ResMsgArbor.getString("MSG_EXPORT_EVENTS_TERMINAL");
                    }
                    return String.valueOf(ExpFTListVariablesRecap.this.getVariables().stream().filter(x -> x.isEventTerminal()).collect(Collectors.toList()).size());
                }
                case 2: {
                    if (col == 0) {
                        return ResMsgArbor.getString("MSG_EXPORT_EVENTS_INTERMEDIATE");
                    }
                    return String.valueOf(ExpFTListVariablesRecap.this.getVariables().stream().filter(x -> x.isEventIntermediate()).collect(Collectors.toList()).size());
                }
                case 3: {
                    if (col == 0) {
                        return ResMsgArbor.getString("MSG_EXPORT_EVENTS_SUBTREE");
                    }
                    return String.valueOf(ExpFTListVariablesRecap.this.getVariables().stream().filter(x -> x.isEventSubTree()).collect(Collectors.toList()).size());
                }
                case 4: {
                    if (col == 0) {
                        return ResMsgArbor.getString("MSG_EXPORT_EVENTS_GSR");
                    }
                    return String.valueOf(ExpFTListVariablesRecap.this.getVariables().stream().filter(x -> x.isEventGSR()).collect(Collectors.toList()).size());
                }
                case 5: {
                    if (col == 0) {
                        return ResMsgArbor.getString("MSG_EXPORT_EVENTS_INSPECTED");
                    }
                    return String.valueOf(ExpFTListVariablesRecap.this.getVariables().stream().filter(x -> x.isEventInspected()).collect(Collectors.toList()).size());
                }
                case 6: {
                    if (col == 0) {
                        return ResMsgArbor.getString("MSG_EXPORT_EVENTS_INFLIGHT_TESTED");
                    }
                    return String.valueOf(ExpFTListVariablesRecap.this.getVariables().stream().filter(x -> x.isEventInflightTested()).collect(Collectors.toList()).size());
                }
            }
            return "";
        }

        @Override
        protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
            output.write(this.getValueOfEntry(col, row), true);
        }

        @Override
        protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
            buffer.append(this.getValueOfEntry(col, row));
        }
    }
}

