/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf;

import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContent;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGScissor;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.pref.FTEquationViewPrintPreferencies;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class FGBook {
    private static Logger _LOG = Logger.getLogger(FGBook.class.getPackage().getName());
    FTEquation _ftEqu;
    FTVariable _ftTop;
    boolean _bWithGSR;
    boolean _bWithParent;
    boolean _bWithLimit;
    int _limitDepth;
    boolean _bWithSubTree;
    ArrayList<FGPage> _pages;
    Map<FTVariableAbstract, FGPage> _mapVars;
    FGContext _fgContext;

    public FGBook(FTEquation ftEqu, FTVariable ftVar) {
        this._ftEqu = ftEqu;
        this._ftTop = ftVar;
        this._bWithLimit = true;
        this._bWithParent = true;
        this._bWithGSR = true;
        this._bWithParent = false;
        this._limitDepth = 6;
        this._bWithSubTree = true;
        this._fgContext = new FGContext(this._ftEqu);
        this._fgContext.setPrinting(true);
    }

    public FGBook(FTEquation ftEqu) {
        this(ftEqu, ftEqu.getTopEvent());
    }

    public boolean withGSR() {
        return this._bWithGSR;
    }

    public boolean withParent() {
        return this._bWithParent;
    }

    public boolean withLimit() {
        return this._bWithLimit;
    }

    public FGBook setWithGSR(boolean value) {
        this._bWithGSR = value;
        return this;
    }

    public FGBook setWithParent(boolean value) {
        this._bWithParent = value;
        return this;
    }

    public FGBook setWithLimit(boolean value) {
        this._bWithLimit = value;
        return this;
    }

    public int getLimitDepth() {
        return this.withLimit() ? this._limitDepth : -1;
    }

    public FGBook setLimitDepth(int value) {
        this._limitDepth = value;
        return this;
    }

    public boolean withSubTree() {
        return this._bWithSubTree;
    }

    public FGBook setWithSubTree(boolean value) {
        this._bWithSubTree = value;
        return this;
    }

    public FGContext getContext() {
        return this._fgContext;
    }

    public void updateFromPreferencies(Preferencies prefs) {
        PluginWithOptions opts = prefs.getOptions(FTEquationViewPrintPreferencies.PREF_KEY);
        if (opts != null && opts instanceof FTEquationViewPrintPreferencies) {
            FTEquationViewPrintPreferencies options = (FTEquationViewPrintPreferencies)opts;
            this.setWithGSR(options.getPref("Cut.GSR").isSelected());
            this.setWithParent(options.getPref("Cut.Parent").isSelected());
            this.setWithLimit(options.getPref("Cut.Level").isSelected());
            if (this.withLimit()) {
                this.setLimitDepth(options.getPrefLevel());
            }
            this.setWithSubTree(options.getPref("SubTrees").isSelected());
        }
        this._fgContext.updateFromPreferencies(prefs);
    }

    public void prepare() {
        LinkedHashSet<FTVariableAbstract> topVars = new LinkedHashSet<FTVariableAbstract>();
        topVars.add(this._ftTop);
        this._ftEqu.setFlags(0);
        this.prepareLink_rec(this._ftTop, topVars);
        _LOG.finest("FGBook: nbr root after link: " + topVars.size());
        if (this._bWithParent) {
            this._ftEqu.setFlags(0);
            this.prepareParent_rec(this._ftTop, topVars);
            _LOG.finest("FGBook: nbr root after parents: " + topVars.size());
        }
        if (this._bWithGSR) {
            this._ftEqu.setFlags(0);
            this.prepareGSR_rec(this._ftTop, topVars);
            _LOG.finest("FGBook: nbr root after GSR: " + topVars.size());
        }
        if (this._bWithLimit) {
            LinkedHashSet<FTVariableAbstract> LimitTopVars = new LinkedHashSet<FTVariableAbstract>();
            this._ftEqu.setFlags(0);
            for (FTVariableAbstract fTVariableAbstract : topVars) {
                fTVariableAbstract.setFlags(2);
            }
            for (FTVariableAbstract fTVariableAbstract : topVars) {
                this.prepareLimit_rec(fTVariableAbstract, 0, LimitTopVars);
            }
            topVars.addAll(LimitTopVars);
            _LOG.finest("FGBook: nbr root after Limit: " + topVars.size());
        }
        if (topVars.size() > 0) {
            LinkedHashSet<FTVariableAbstract> sortTopVars = new LinkedHashSet<FTVariableAbstract>();
            this._ftEqu.setFlags(0);
            this.prepareSort_rec(this._ftTop, topVars, sortTopVars);
            if (topVars.size() != sortTopVars.size()) {
                _LOG.severe("Erreur interne lors du tri des variables sommets a 'imprimer' : {" + ((Object)sortTopVars).toString() + "} != {" + ((Object)topVars).toString() + "}");
            }
            topVars = sortTopVars;
            _LOG.finest("FGBook:Roots: {" + ((Object)topVars).toString() + "}");
        }
        this._pages = new ArrayList(topVars.size() + 1);
        this._mapVars = new LinkedHashMap<FTVariableAbstract, FGPage>();
        int pge = 0;
        InternalScissor fgScissor = new InternalScissor(topVars, this.withSubTree());
        for (FTVariableAbstract ftVar : topVars) {
            FGContent fgContent = new FGContent(this._ftEqu, fgScissor);
            fgScissor.setCurrent(ftVar);
            fgContent.browse(ftVar);
            FGPage fgPage = new FGPage(ftVar, fgContent, pge++);
            this._pages.add(fgPage);
            this._mapVars.put(ftVar, fgPage);
            fgContent.getTop().clearSummary();
        }
        for (int i = 0; i < this._pages.size(); ++i) {
            FGContent fgContent = this.getContentAt(i);
            HashMap<FTVariableAbstract, Object> hashMap = new HashMap<FTVariableAbstract, Object>();
            int idxLink = 1;
            Iterator<FGVariable> iVars = fgContent.iterator();
            if (iVars.hasNext()) {
                iVars.next();
            }
            while (iVars.hasNext()) {
                FGPage fgPage;
                FGVariable fgVar = iVars.next();
                if (fgVar.getChildren() != null && fgVar.getChildren().size() != 0) continue;
                FTVariableAbstract ftVar = fgVar.getVar();
                if (ftVar.getLink() != null) {
                    Object mark2 = (String)hashMap.get(ftVar);
                    if (mark2 == null) {
                        mark2 = ftVar.getLink().isDSF() ? "DSF" + idxLink++ : "ST" + idxLink++;
                        hashMap.put(ftVar, mark2);
                    }
                    fgVar.setMark((String)mark2);
                }
                if ((fgPage = this._mapVars.get(ftVar)) == null) continue;
                fgVar.setLinkPageIdx(fgPage.getPage());
                fgPage.getContent().getTop().addSummary(fgContent.getTop().getVar(), i);
            }
        }
        this._fgContext.setNbrPages(this._pages.size());
    }

    private void prepareLink_rec(FTVariableAbstract ftVar, Set<FTVariableAbstract> topVars) {
        if (ftVar.getFlags() > 0) {
            return;
        }
        ftVar.setFlags(1);
        if (!this._bWithSubTree && !ftVar.isIntern()) {
            return;
        }
        if (ftVar.getLink() != null) {
            if (this._bWithSubTree) {
                topVars.add(ftVar);
            } else {
                return;
            }
        }
        if (ftVar.getDefinition() != null) {
            for (FTVariableAbstract ftChild : ftVar.getDefinition().getArgs()) {
                this.prepareLink_rec(ftChild, topVars);
            }
        }
    }

    private void prepareParent_rec(FTVariableAbstract ftVar, Set<FTVariableAbstract> topVars) {
        if (ftVar.getFlags() == 1) {
            ftVar.setFlags(2);
            if (!ftVar.isLeaf()) {
                topVars.add(ftVar);
            }
            return;
        }
        if (ftVar.getFlags() > 0) {
            return;
        }
        ftVar.setFlags(1);
        if (!this._bWithSubTree && !ftVar.isIntern()) {
            return;
        }
        if (ftVar.getDefinition() != null) {
            for (FTVariableAbstract ftChild : ftVar.getDefinition().getArgs()) {
                this.prepareParent_rec(ftChild, topVars);
            }
        }
    }

    private void prepareGSR_rec(FTVariableAbstract ftVar, Set<FTVariableAbstract> topVars) {
        if (ftVar.getFlags() > 0) {
            return;
        }
        ftVar.setFlags(1);
        if (!this._bWithSubTree && !ftVar.isIntern()) {
            return;
        }
        if (ftVar.getDefinition() != null) {
            if (ftVar.getDefinition().isGSR()) {
                topVars.add(ftVar);
            }
            for (FTVariableAbstract ftChild : ftVar.getDefinition().getArgs()) {
                this.prepareGSR_rec(ftChild, topVars);
            }
        }
    }

    private void prepareLimit_rec(FTVariableAbstract ftVar, int depth, Set<FTVariableAbstract> topVars) {
        if (!this._bWithSubTree && !ftVar.isIntern()) {
            return;
        }
        if (ftVar.getFlags() > 1 && depth != 0) {
            return;
        }
        if (depth == this._limitDepth - 1) {
            if (!ftVar.isLeaf() && (this._bWithSubTree || ftVar.getLink() == null)) {
                topVars.add(ftVar);
            }
            depth = 0;
        }
        if (ftVar.getDefinition() != null) {
            for (FTVariableAbstract ftChild : ftVar.getDefinition().getArgs()) {
                this.prepareLimit_rec(ftChild, depth + 1, topVars);
            }
        }
    }

    private void prepareSort_rec(FTVariableAbstract ftVar, Set<FTVariableAbstract> topVars, Set<FTVariableAbstract> sortTopVars) {
        if (!this._bWithSubTree && !ftVar.isIntern()) {
            ftVar.setFlags(3);
            return;
        }
        if (ftVar.getFlags() > 0) {
            return;
        }
        ftVar.setFlags(1);
        if (topVars.contains(ftVar)) {
            sortTopVars.add(ftVar);
            ftVar.setFlags(2);
        }
        if (ftVar.getDefinition() != null) {
            for (FTVariableAbstract ftChild : ftVar.getDefinition().getArgs()) {
                this.prepareSort_rec(ftChild, topVars, sortTopVars);
            }
        }
    }

    public int getNumberOfPages() {
        return this._pages.size();
    }

    private FGContent getContentAt(int idx) {
        return this._pages.get(idx).getContent();
    }

    public void preparePaint(Graphics2D g) {
        for (int i = this._pages.size() - 1; i >= 0; --i) {
            this.getContentAt(i).computeSize(g, this._fgContext);
        }
    }

    public Dimension getSizeAt(int idx) {
        FGContent fgContent = this.getContentAt(idx);
        return new Dimension(fgContent.getWidth(), fgContent.getHeight());
    }

    public void paintAt(int idx, Graphics2D g) {
        FGContent fgContent = this.getContentAt(idx);
        fgContent.paint(g, this._fgContext);
    }

    public FTEquation getEquation() {
        return this._ftEqu;
    }

    public FGPage getPageAt(int idx) {
        return this._pages.get(idx);
    }

    private static class InternalScissor
    implements FGScissor {
        boolean _bWithSubTree;
        Set<FTVariableAbstract> _topVars;
        FTVariableAbstract _ftVar;

        InternalScissor(Set<FTVariableAbstract> topVars, boolean withSubTree) {
            this._topVars = topVars;
            this._bWithSubTree = withSubTree;
        }

        public void setCurrent(FTVariableAbstract ftVar) {
            this._ftVar = ftVar;
        }

        @Override
        public void incDepth() {
        }

        @Override
        public void decDepth() {
        }

        @Override
        public void begin() {
        }

        @Override
        public boolean cut(FTVariableAbstract ftVar) {
            if (this._ftVar == ftVar) {
                return false;
            }
            if (!this._bWithSubTree && !ftVar.isIntern()) {
                return true;
            }
            return this._topVars.contains(ftVar);
        }
    }

    public static class FGPage {
        int _idx;
        FTVariableAbstract _ftVar;
        FGContent _fgContent;

        FGPage(FTVariableAbstract ftVar, FGContent fgContent, int idx) {
            this._ftVar = ftVar;
            this._fgContent = fgContent;
            this._idx = idx;
        }

        public int getPage() {
            return this._idx;
        }

        public FTVariableAbstract getTopVar() {
            return this._ftVar;
        }

        public FGContent getContent() {
            return this._fgContent;
        }
    }
}

