/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.IUser;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTComputeParameters;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGBook;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContent;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.faulttree.pref.FTEquationViewPrintPreferencies;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class FGBookPageRenderer {
    private static Logger _LOG = Logger.getLogger(FGBookPageRenderer.class.getPackage().getName());
    protected FGBook _fgBook;
    boolean _bPrepareBook = false;
    BufferedImage _logo = null;
    boolean _bWithOwner;
    boolean _bWithCompute;
    boolean _bWithLinks;
    boolean _bWithLogo;
    boolean _bWithCopyright;
    DateFormat _dateFormat = DateFormat.getDateTimeInstance();

    public FGBookPageRenderer(FGBook fgBook) {
        this._fgBook = fgBook;
        String pathLogo = System.getProperty("cecilia.export.print.logo");
        if (pathLogo != null && pathLogo.length() > 0) {
            try {
                this._logo = ImageIO.read(new File(pathLogo));
            }
            catch (IOException e) {
                _LOG.info("Impossible de charger le logo d'impression : " + pathLogo);
                _LOG.log(Level.FINEST, "Exception lors de la lecture du logo d'impression", e);
            }
        }
        this._bWithCopyright = true;
        this._bWithLogo = true;
        this._bWithLinks = true;
        this._bWithCompute = true;
        this._bWithOwner = true;
    }

    public FGBookPageRenderer setWithOwner(boolean value) {
        this._bWithOwner = value;
        return this;
    }

    public FGBookPageRenderer setWithCompute(boolean value) {
        this._bWithCompute = value;
        return this;
    }

    public FGBookPageRenderer setWithLinks(boolean value) {
        this._bWithLinks = value;
        return this;
    }

    public FGBookPageRenderer setWithLogo(boolean value) {
        this._bWithLogo = value;
        return this;
    }

    public FGBookPageRenderer setWithCopyright(boolean value) {
        this._bWithCopyright = value;
        return this;
    }

    public FGBook getBook() {
        return this._fgBook;
    }

    public void updateFromPreferencies(Preferencies prefs) {
        PluginWithOptions opts = prefs.getOptions(FTEquationViewPrintPreferencies.PREF_KEY);
        if (opts != null && opts instanceof FTEquationViewPrintPreferencies) {
            FTEquationViewPrintPreferencies options = (FTEquationViewPrintPreferencies)opts;
            this._bWithOwner = options.getPref("Content.Owner").isSelected();
            this._bWithCompute = options.getPref("Content.Analysis").isSelected();
        }
        if ((opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY)) != null && opts instanceof GeneralTextPreferencies) {
            GeneralTextPreferencies gpref = (GeneralTextPreferencies)opts;
            this._dateFormat = gpref.getDateFormat();
        }
    }

    private void printBuffer(Graphics2D g, String[] lines, Position pos, double width, double height) {
        int i;
        FontMetrics fm = g.getFontMetrics();
        int hTxt = fm.getHeight();
        int maxWidth = 0;
        for (i = 0; i < lines.length; ++i) {
            int curWidth = fm.stringWidth(lines[i]);
            if (curWidth <= maxWidth) continue;
            maxWidth = curWidth;
        }
        block7: for (i = 0; i < lines.length; ++i) {
            switch (pos) {
                case TopLeft: {
                    g.drawString(lines[i], hTxt / 2, hTxt * (i + 1));
                    continue block7;
                }
                case TopRight: {
                    g.drawString(lines[i], (int)(width - (double)maxWidth - (double)(hTxt / 2)), hTxt * (i + 1));
                    continue block7;
                }
                case BottomLeft: {
                    g.drawString(lines[i], hTxt / 2, (int)(height - (double)(hTxt * (lines.length - i)) + (double)(hTxt / 2)));
                    continue block7;
                }
                case BottomRight: {
                    g.drawString(lines[i], (int)(width - (double)maxWidth - (double)(hTxt / 2)), (int)(height - (double)(hTxt * (lines.length - i)) + (double)(hTxt / 2)));
                }
            }
        }
    }

    private String getUserName(IUser iUser) {
        if (iUser == null) {
            return "???";
        }
        if (iUser instanceof DBUser) {
            return ((DBUser)iUser).getName();
        }
        return iUser.getLogin();
    }

    private String getAbstractOwner() {
        DBFolder dbFolder = this._fgBook.getEquation().getDBFolder();
        StringBuilder sb = new StringBuilder(512);
        DBObjProperty dbObjProp = null;
        if (dbFolder.isVersion() && dbFolder.getObject() != null) {
            dbObjProp = dbFolder.getObject().getProperty("object.creator");
        }
        if (dbObjProp != null) {
            sb.append(ResMsgCore.msgFormat("MSG_DATE_CREATE_WITH_USER", this._dateFormat.format(dbFolder.getDateCreate()), dbObjProp.getValue()));
        } else {
            sb.append(ResMsgCore.msgFormat("MSG_DATE_CREATE", this._dateFormat.format(dbFolder.getDateCreate())));
        }
        if (dbFolder.getDateModify() != null && dbFolder.getUserModify() != null) {
            sb.append("\n");
            sb.append(ResMsgCore.msgFormat("MSG_DATE_MODIFY", this._dateFormat.format(dbFolder.getDateModify()), this.getUserName(dbFolder.getUserModify())));
        }
        return sb.toString();
    }

    private String getAbstractCompute() {
        FTComputeParameters ftCompute = this._fgBook.getEquation().getComputeParameters();
        StringBuilder sb = new StringBuilder(512);
        sb.append(ResMsgVoc.getString("VOC_FLIGHT_PHASE")).append(" :                   \n");
        sb.append("  ").append(ResMsgArbor.getString("KEY_0413")).append(" : \n");
        sb.append("  ").append(ResMsgVoc.getString("VOC_DURATION")).append(" : ").append(ResMsgArbor.formatHMS(ftCompute.getTime()));
        if (ftCompute.isOneHourOption()) {
            sb.append(" ").append(ResMsgArbor.getString("KEY_0837"));
        }
        sb.append("\n");
        sb.append(ftCompute.getType().getLabel());
        if (ftCompute.getAverageAttribute() != null) {
            sb.append(" (").append(ftCompute.getAverageAttribute()).append(")");
        }
        sb.append("\n");
        double averageDuration = ftCompute.getFlightDuration();
        if (!Double.isNaN(averageDuration)) {
            sb.append(ResMsgObj.getString("DLG_AVERAGEFLIGHT_LABEL")).append(" :                   \n");
            sb.append("  ").append(ResMsgVoc.getString("VOC_DURATION")).append(" : ").append(ResMsgArbor.formatHMS(averageDuration)).append("\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String getAbstractLinks(int pageIndex) {
        FGContent fgContent = this._fgBook.getPageAt(pageIndex).getContent();
        HashSet<String> markSet = new HashSet<String>();
        StringBuilder sb = new StringBuilder(512);
        Iterator<FGVariable> iVars = fgContent.iterator();
        if (iVars.hasNext()) {
            iVars.next();
        }
        while (iVars.hasNext()) {
            FGVariable fgVar = iVars.next();
            FTVariableAbstract ftVar = fgVar.getVar();
            if (ftVar.getLink() == null) continue;
            String mark2 = fgVar.getMark();
            if (mark2 == null) {
                mark2 = ftVar.getName();
            }
            if (markSet.contains(mark2)) continue;
            markSet.add(mark2);
            sb.append(mark2).append(" : ");
            sb.append(ftVar.getLink().getSubTree().getDBFolder().getRefPath());
            String generic = ftVar.getLink().getGeneric();
            if (generic != null && generic.length() > 0) {
                sb.append("   [").append(generic).append("]");
            }
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension preparePrint(Graphics2D g, double wpf, double hpf, double zoomInfo, int pageIndex) {
        int hTxt;
        double wImg = wpf * zoomInfo;
        double hImg = hpf * zoomInfo;
        g.scale(1.0 / zoomInfo, 1.0 / zoomInfo);
        if (this._bWithLogo && this._logo != null) {
            double scaleLogo = 0.3333333333333333;
            double wLogo = (double)this._logo.getWidth() * scaleLogo;
            double hLogo = (double)this._logo.getHeight() * scaleLogo;
            if (wLogo > wImg) {
                hLogo *= (scaleLogo *= wImg / wLogo);
            }
            if (hLogo > hImg / 3.0) {
                scaleLogo *= hImg / 3.0 / hLogo;
            }
            wLogo = (double)this._logo.getWidth() * scaleLogo;
            hLogo = (double)this._logo.getHeight() * scaleLogo;
            g.drawImage(this._logo, 0, 0, (int)wLogo, (int)hLogo, null);
            g.translate(0.0, hLogo);
            hImg -= hLogo;
        }
        if (this._bWithCopyright) {
            String txt = Locale.getDefault().getLanguage().equals(Locale.FRENCH.getLanguage()) ? System.getProperty("cecilia.export.print.propriete", "") : System.getProperty("cecilia.export.print.property", "");
            Font oldFont = g.getFont();
            AffineTransform saveAT = g.getTransform();
            hTxt = 0;
            try {
                g.setFont(this._fgBook.getContext().getFont(null, -1, 8));
                hTxt = g.getFontMetrics().getHeight();
                g.translate(0.0, hImg);
                g.rotate(-1.5707963267948966);
                g.drawString(txt, 0, hTxt);
                hTxt = 2 * hTxt;
                g.drawString(ResMsgArbor.msgFormat("IO_PRINT_PRODUCTOR", "Cecilia WorkShop", "6.3.1"), 0, hTxt);
            }
            finally {
                g.setFont(oldFont);
                g.setTransform(saveAT);
            }
            g.translate(hTxt += 6, 0);
            wImg -= (double)hTxt;
        }
        Font oldFont = g.getFont();
        Stroke oldStroke = g.getStroke();
        g.setFont(this._fgBook.getContext().getFont(null, -1, -1));
        FontMetrics fm = g.getFontMetrics();
        hTxt = fm.getHeight();
        g.setStroke(this._fgBook.getContext().getStroke(2, -1, -1, false));
        try {
            String append;
            String append2;
            String append3;
            String txt = ResMsgArbor.msgFormat("IO_PRINT_PAGE_HEADER", pageIndex + 1, this._fgBook.getNumberOfPages());
            g.drawString(txt, (int)(wImg - (double)fm.stringWidth(txt)), hTxt / 2);
            g.translate(0, hTxt);
            g.drawRect(0, 0, (int)wImg, (int)(hImg -= (double)hTxt));
            int marge = hTxt / 2;
            g.drawString(ResMsgArbor.msgFormat("IO_PRINT_TREE_PATH", this._fgBook.getEquation().getDBFolder().getRefPath()), marge, hTxt);
            String initialConf = this._fgBook.getEquation().getInitialConfMBSA();
            String modelRef = this._fgBook.getEquation().getModelePathMBSA();
            String target = this._fgBook.getEquation().getTargetMBSA();
            if (initialConf != null || modelRef != null || target != null) {
                double xTxt;
                double minXTxt = Double.MAX_VALUE;
                if (initialConf != null) {
                    initialConf = ResMsgArbor.msgFormat("IO_PRINT_TREE_MBSA_CONF", initialConf);
                    xTxt = wImg - (double)marge - (double)g.getFontMetrics().stringWidth(initialConf);
                    minXTxt = Math.min(minXTxt, xTxt);
                }
                if (modelRef != null) {
                    modelRef = ResMsgArbor.msgFormat("IO_PRINT_TREE_MBSA_MODEL", modelRef);
                    xTxt = wImg - (double)marge - (double)g.getFontMetrics().stringWidth(modelRef);
                    minXTxt = Math.min(minXTxt, xTxt);
                }
                if (target != null) {
                    target = ResMsgArbor.msgFormat("IO_PRINT_TREE_MBSA_TARGET", target);
                    xTxt = wImg - (double)marge - (double)g.getFontMetrics().stringWidth(target);
                    minXTxt = Math.min(minXTxt, xTxt);
                }
                String mbsaSettings = ResMsgArbor.getString("IO_PRINT_TREE_MBSA");
                double xTxt2 = wImg - (double)marge - (double)g.getFontMetrics().stringWidth(mbsaSettings);
                minXTxt = Math.min(minXTxt, xTxt2);
                g.drawString(mbsaSettings, (int)minXTxt, hTxt);
                hTxt += g.getFontMetrics().getHeight() + 5;
                if (initialConf != null) {
                    g.drawString(modelRef, (int)minXTxt, hTxt);
                    hTxt += g.getFontMetrics().getHeight();
                }
                if (modelRef != null) {
                    g.drawString(initialConf, (int)minXTxt, hTxt);
                    hTxt += g.getFontMetrics().getHeight();
                }
                if (target != null) {
                    g.drawString(target, (int)minXTxt, hTxt);
                    hTxt += g.getFontMetrics().getHeight();
                }
            } else {
                hTxt += hTxt;
            }
            g.drawString(ResMsgArbor.msgFormat("IO_PRINT_TREE_TOP", this._fgBook.getPageAt(pageIndex).getTopVar().getName()), marge, hTxt);
            g.translate(0, marge += hTxt);
            hImg -= (double)marge;
            g.drawLine(0, 0, (int)wImg, 0);
            if (this._bWithOwner && (append3 = this.getAbstractOwner()) != null) {
                this.printBuffer(g, append3.split("\n"), Position.TopLeft, wImg, hImg);
            }
            if (this._bWithCompute && (append2 = this.getAbstractCompute()) != null) {
                this.printBuffer(g, append2.split("\n"), Position.TopRight, wImg, hImg);
            }
            if (this._bWithLinks && (append = this.getAbstractLinks(pageIndex)) != null) {
                this.printBuffer(g, append.split("\n"), Position.BottomLeft, wImg, hImg);
            }
        }
        finally {
            g.setFont(oldFont);
            g.setStroke(oldStroke);
        }
        return new Dimension((int)Math.ceil(wImg), (int)Math.ceil(hImg));
    }

    public void display(Graphics2D g2, double wpf, double hpf, double zoomInfo, int pageIndex) {
        if (!this._bPrepareBook) {
            this._bPrepareBook = true;
            this._fgBook.preparePaint(g2);
        }
        g2.setColor(Color.BLACK);
        Dimension sPF = this.preparePrint(g2, wpf, hpf, zoomInfo, pageIndex);
        double marge = 10.0;
        double wPF = sPF.getWidth() - 2.0 * marge;
        double hPF = sPF.getHeight() - 2.0 * marge;
        double dPF = wPF / hPF;
        Dimension sBo = this._fgBook.getSizeAt(pageIndex);
        double wBo = sBo.getWidth();
        double hBo = sBo.getHeight();
        double dBo = wBo / hBo;
        double coef = dBo >= dPF ? wPF / wBo : hPF / hBo;
        if (coef > 1.0) {
            coef = 1.0;
        }
        double dx = (wPF - coef * wBo) / 2.0;
        double dy = (hPF - coef * hBo) / 2.0;
        g2.translate(dx + marge, dy + marge);
        g2.scale(coef, coef);
        this._fgBook.paintAt(pageIndex, g2);
    }

    private static enum Position {
        TopLeft,
        TopRight,
        BottomLeft,
        BottomRight;

    }
}

