/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.grf.arranger;

import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGArranger;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGContext;
import com.dassault.cecilia.dbobj.faulttree.ft.grf.FGVariable;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.List;

public class FGArrangerShape
extends FGArranger {
    protected static final int _wpadDefault = 30;
    protected static final int _hpadDefault = 30;
    private static boolean _TRACE = false;

    protected void trace(String msg) {
        System.out.println(msg);
    }

    @Override
    public void arrange(FGVariable fgTop, Graphics2D g, FGContext context) {
        this.arrange_rec(fgTop, g, context);
    }

    private Area arrange_rec(FGVariable fgVar, Graphics2D g, FGContext context) {
        Dimension size = context.getFormatter(fgVar).computeSizeDisplay(fgVar, g, context);
        fgVar.setW(size.width).setH(size.height);
        List<FGVariable> children = fgVar.getChildren();
        if (children == null || children.isEmpty()) {
            fgVar.setDX(0).setDY(0).setXPad(0);
            fgVar.setWAll(size.width).setHAll(size.height);
            return new Area(new Rectangle(0, 0, size.width, size.height));
        }
        Area currentArea = null;
        int currentDX = 0;
        for (int i = 0; i < children.size(); ++i) {
            FGVariable child = children.get(i);
            Area childArea = this.arrange_rec(child, g, context);
            if (currentArea == null) {
                currentArea = childArea;
                child.setXPad(0);
            } else {
                if (currentDX - child.getDX() > 0) {
                    childArea.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, currentDX - child.getDX(), 0.0f));
                }
                int dxmax = currentArea.getBounds().width + 1;
                if (_TRACE) {
                    this.trace("translateChildArea(" + child.getVar().getName() + "::" + childArea.getBounds() + ", " + currentArea.getBounds() + ", " + dxmax / 2 + ") - ");
                }
                this.translateChildArea(childArea, currentArea, dxmax / 2);
                childArea.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 30.0f, 0.0f));
                Rectangle childBound = childArea.getBounds();
                if (_TRACE) {
                    this.trace("    => " + childBound);
                }
                child.setXPad(childBound.x);
                currentArea.add(childArea);
            }
            currentDX += child.getDX() + child.getW();
        }
        Rectangle rect = currentArea.getBounds();
        fgVar.setHAll(rect.height + size.height + 30);
        fgVar.setDY(size.height + 30);
        if (rect.width > size.width) {
            fgVar.setDX((rect.width - size.width) / 2);
            currentArea.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, size.height + 30));
            currentArea.add(new Area(new Rectangle(fgVar.getDX(), 0, size.width, size.height)));
            fgVar.setWAll(rect.width);
        } else {
            fgVar.setDX(0);
            int dxpad = (size.width - rect.width) / 2;
            currentArea.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, dxpad, size.height + 30));
            for (int i = 0; i < children.size(); ++i) {
                FGVariable child = children.get(i);
                child.setXPad(child.getXPad() + dxpad);
            }
            currentArea.add(new Area(new Rectangle(0, 0, size.width, size.height)));
            fgVar.setWAll(size.width);
        }
        if (_TRACE) {
            this.trace("arrange_rec(" + fgVar + ")=>" + currentArea.getBounds());
            for (int i = 0; i < children.size(); ++i) {
                FGVariable child = children.get(i);
                this.trace("    " + child);
            }
        }
        return currentArea;
    }

    private void translateChildArea(Area childArea, Area currentArea, int dxpivot) {
        if (dxpivot == 0) {
            return;
        }
        childArea.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, dxpivot, 0.0f));
        Area tmpArea = (Area)currentArea.clone();
        tmpArea.intersect(childArea);
        if (_TRACE) {
            this.trace("    " + dxpivot + ": [" + childArea.getBounds() + "] / [" + tmpArea.getBounds() + "]");
        }
        if (dxpivot < 0) {
            dxpivot *= -1;
        }
        if (tmpArea.isEmpty()) {
            this.translateChildArea(childArea, currentArea, -dxpivot / 2);
        } else {
            this.translateChildArea(childArea, currentArea, dxpivot / 2);
        }
    }
}

