/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.folder.JPanelTableFolder;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationDlgChooser;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class FTPanelTableFolder
extends JPanelTableFolder {
    private FTEquationDlgChooser _dbFTChooser = null;
    private Object _LockerDlgChooser = new Object();
    private static DocumentBuilderFactory _dbf = null;

    public FTPanelTableFolder(CAppl cAppl, JDialog dlg) {
        super(cAppl, dlg);
    }

    @Override
    protected void addRows() {
        FTEquationDlgChooser dlg = this.getDlgChooser(SwingUtilities.getWindowAncestor(this), (CeciliaAppl)this._cAppl);
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        this.addFolders(dlg.getSelectFolders());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FTEquationDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (this._dbFTChooser == null) {
            FTEquationDlgChooser dlg = null;
            Object object = this._LockerDlgChooser;
            synchronized (object) {
                if (this._dbFTChooser == null) {
                    dlg = new FTEquationDlgChooser(win, appl);
                    dlg.setFilterDSF(false);
                    dlg.setFilterTree(true);
                    dlg.setFilterBooleanEquation(true);
                    dlg.defineExcludeFolders(new HashSet<DBFolder>());
                    dlg.setMultiSelectionTree(true);
                    dlg.getCtrlSelect().resetCache();
                }
                if (this._dbFTChooser == null) {
                    this._dbFTChooser = dlg;
                }
            }
        }
        return this._dbFTChooser;
    }

    @Override
    public String getPathSave() {
        return PlugableUtility.getStrOpt(((CeciliaAppl)this._cAppl).getPlugable(), "plugable.option.path", ".");
    }

    @Override
    protected File displayDlgFile(boolean save, String path) {
        File file = super.displayDlgFile(save, path);
        if (file != null) {
            ((CeciliaAppl)this._cAppl).getPlugable().setOption("plugable.option.path", file.getParent());
        }
        return file;
    }

    protected void doSaveOther(Writer writer, String increment) throws IOException {
    }

    protected void doSave(File output, String topEntityName, List<DBFolder> dbFolders) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(output));){
            writer.write("<?xml version=\"1.0\" encoding=\"iso-8859-15\"?>\n");
            writer.write("<!-- Pas de DTD par defaut -->\n");
            writer.append('<').append(topEntityName).append(">\n");
            Iterator<DBFolder> i = dbFolders.iterator();
            String increment = "  ";
            while (i.hasNext()) {
                DBFolder folder = i.next();
                writer.append(increment).append("<folder refPath=\"");
                writer.append(folder.getRefPath());
                writer.append("\"/>\n");
            }
            this.doSaveOther(writer, increment);
            writer.append("</").append(topEntityName).append(">\n");
        }
        catch (IOException err) {
            Logger.getLogger(FTPanelTableFolder.class.getName()).log(Level.WARNING, "Exception during save file '" + output + "'", err);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.getString("FILE_ERROR_SAVE") + err.getMessage());
        }
    }

    protected abstract void doLoadFolder(DBFolder var1, Element var2);

    protected void doLoadOther(Element elem) {
    }

    public void doLoad(File input, String topEntityName) {
        if (_dbf == null) {
            _dbf = DocumentBuilderFactory.newInstance();
            _dbf.setValidating(false);
            _dbf.setIgnoringComments(true);
            _dbf.setIgnoringElementContentWhitespace(true);
            _dbf.setCoalescing(false);
            _dbf.setExpandEntityReferences(true);
        }
        try {
            DocumentBuilder db = _dbf.newDocumentBuilder();
            Document doc = db.parse(new File(input.getPath()));
            Element root = doc.getDocumentElement();
            if (topEntityName != null && !root.getNodeName().equals(topEntityName)) {
                throw new IOException(ResMsgCore.msgFormat("FILE_ERROR_OPEN_XML_ROOT", topEntityName));
            }
            NodeList childs = root.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node xmlTgt = childs.item(i);
                if (!(xmlTgt instanceof Element)) continue;
                Element elem = (Element)xmlTgt;
                if (elem.getTagName().equals("folder")) {
                    String refPath = elem.getAttribute("refPath");
                    DBFolder folder = this._cAppl.getDAOFactory().createFolderDAO().findFolder("PROJECTS", refPath);
                    this.doLoadFolder(folder, elem);
                    continue;
                }
                this.doLoadOther(elem);
            }
        }
        catch (Exception err) {
            Logger.getLogger(FTPanelTableFolder.class.getName()).log(Level.WARNING, "Exception during load file '" + input + "'", err);
            StringBuilder sb = new StringBuilder(32);
            sb.append(err.getClass().getName());
            sb.append(" : ");
            String mess = err.getMessage();
            if (mess == null) {
                sb.append("<null>");
            } else {
                sb.append(mess);
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgCore.getString("FILE_ERROR_OPEN") + err.getMessage());
        }
    }
}

