/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTVariableListTable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarRename;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.Filter;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterAbstract;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterAttribute;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterDlgExtended;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterLaw;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterLawAralia;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.FilterString;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.filter.TypeFilter;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractColumnsModel;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractTableModel;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawFormat;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class FTVariableListModel
extends ItemAbstractTableModel<FTVariableAbstract> {
    static Logger _LOG = Logger.getLogger(FTVariableListModel.class.getPackage().getName());
    public static final String EL_FIELD_NAME = "name";
    public static final String EL_FIELD_COMMENT = "label";
    public static final String EL_FIELD_LAW = "law";
    public static final String EL_FIELD_PROBA = "proba";
    public static final String EL_FIELD_STATE = "state";
    public static final String EL_FIELD_STYLE = "style";
    public static final String EL_FIELD_GENERIC = "generic";
    public static final String EL_FIELD_EXTENTION = "extension";
    public static final String EL_FIELD_SUBTREE = "subtree";
    public static final String EL_FIELD_DSF = "dsf";
    public static final String EL_FIELD_TREENAME = "treename";
    public static final String EL_FIELD_BTP = "frb";
    public static final String EL_FIELD_FMEA = "fmea";
    public static final String EL_FIELD_GSR = "GSR";
    public static final String EL_FIELD_INSPECTED = "inspected";
    public static final String EL_FIELD_TESTED = "infligh";
    public static final String EL_FIELD_ATTRIBS = "attributes";
    public static final String EL_FIELD_CCF = "ccf";
    public static final String EL_FIELD_DEFINITION = "definition";
    public static final int EL_IDX_NAME = 1;
    public static final int EL_IDX_COMMENT = 2;
    public static final int EL_IDX_LAW = 3;
    public static final int EL_IDX_PROBA = 4;
    public static final int EL_IDX_STATE = 5;
    public static final int EL_IDX_STYLE = 6;
    public static final int EL_IDX_GENERIC = 7;
    public static final int EL_IDX_EXTENTION = 8;
    public static final int EL_IDX_SUBTREE = 9;
    public static final int EL_IDX_DSF = 10;
    public static final int EL_IDX_TREENAME = 11;
    public static final int EL_IDX_BTP = 12;
    public static final int EL_IDX_FMEA = 13;
    public static final int EL_IDX_EQUIV = 14;
    public static final int EL_IDX_GSR = 15;
    public static final int EL_IDX_INSPECTED = 16;
    public static final int EL_IDX_TESTED = 17;
    public static final int EL_IDX_ATTRIBS = 18;
    public static final int EL_IDX_CCF = 19;
    public static final int EL_IDX_IP_CP = 20;
    public static final int EL_IDX_IP_MIF = 21;
    public static final int EL_IDX_IP_CIF = 22;
    public static final int EL_IDX_IP_DIF = 23;
    public static final int EL_IDX_IP_RAW = 24;
    public static final int EL_IDX_IP_RRW = 25;
    public static final int EL_IDX_IP_CC = 26;
    public static final int EL_IDX_IP_PC = 27;
    public static final int EL_IDX_DEFINITION = 30;
    private FTEquationFrame _frame;
    private int[] _visibleIndexes = new int[0];
    private Filter<FTVariableAbstract> _filter;

    public static List<PrefFieldBoolean> createFields() {
        ArrayList<PrefFieldBoolean> fields = new ArrayList<PrefFieldBoolean>();
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("VOC_DEFINITION"), EL_FIELD_DEFINITION, 30, 15, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_COMMENTS"), EL_FIELD_COMMENT, 2, 15, "L"));
        fields.add(new PrefFieldBoolean(ResMsgObj.getString("LAW_FIELD"), EL_FIELD_LAW, 3, 15, "L"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("EVENT_FIELD_PROBABILITY"), EL_FIELD_PROBA, 4, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_STATE"), EL_FIELD_STATE, 5, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_STYLE"), EL_FIELD_STYLE, 6, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_GENERIC"), EL_FIELD_GENERIC, 7, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("EVENT_FIELD_GENERIC_EXTENTION"), EL_FIELD_EXTENTION, 8, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_SUBTREE"), EL_FIELD_SUBTREE, 9, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_DSF"), EL_FIELD_DSF, 10, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("EVENT_FIELD_LINK"), EL_FIELD_TREENAME, 11, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_FRB"), EL_FIELD_BTP, 12, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_FMEA"), EL_FIELD_FMEA, 13, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_GSR"), EL_FIELD_GSR, 15, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_INSPECTED"), EL_FIELD_INSPECTED, 16, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_INFLIGHT_TESTED"), EL_FIELD_TESTED, 17, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString("VOC_ATTRIBUTES"), EL_FIELD_ATTRIBS, 18, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgArbor.getString("VOC_CCF"), EL_FIELD_CCF, 19, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgObj.getString("COMPUTE_IP_CP"), "cpr", 20, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgObj.getString("COMPUTE_IP_MIF"), "mif", 21, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgObj.getString("COMPUTE_IP_CIF"), "cif", 22, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgObj.getString("COMPUTE_IP_DIF"), "dif", 23, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgObj.getString("COMPUTE_IP_RAW"), "raw", 24, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgObj.getString("COMPUTE_IP_RRW"), "rrw", 25, 6, "R"));
        int len = fields.size();
        block3: for (int i = 0; i < len; ++i) {
            PrefFieldBoolean item = fields.get(i);
            item.setOptionnal(true);
            switch (item.getIdxCode()) {
                case 2: 
                case 3: 
                case 5: 
                case 11: 
                case 12: 
                case 16: 
                case 18: 
                case 30: {
                    item.setSelected(true);
                    continue block3;
                }
                default: {
                    item.setSelected(false);
                }
            }
        }
        return fields;
    }

    FTEquation getEquation() {
        return this._frame.getDBWrap();
    }

    FTVariableListModel(FTEquationFrame frame) {
        super(new ELColumnsModel());
        this._frame = frame;
        this._filter = FilterELFactory.createItem(TypeFilter.ALL, null);
        this.computeVisibleRows();
    }

    @Override
    public void refresh(boolean rowsChanged, boolean columnsChanged) {
        if (rowsChanged) {
            this.computeVisibleRows();
        }
        super.refresh(rowsChanged, columnsChanged);
    }

    public void computeVisibleRows() {
        int i;
        ArrayList<Integer> lst = new ArrayList<Integer>();
        List<FTVariableAbstract> allVars = this.getEquation().getAllVariables();
        for (i = 0; i < allVars.size(); ++i) {
            FTVariableAbstract itemArbre = allVars.get(i);
            if (itemArbre != null) {
                if (!this._filter.filter(itemArbre)) continue;
                lst.add(i);
                continue;
            }
            _LOG.severe("Don't find leaves for ID : " + allVars.get(i));
        }
        this._visibleIndexes = new int[lst.size()];
        for (i = 0; i < lst.size(); ++i) {
            this._visibleIndexes[i] = (Integer)lst.get(i);
        }
    }

    public void setFilter(Filter filter) {
        if (this._filter == filter) {
            return;
        }
        this._filter = filter;
        this.refresh(true, false);
    }

    @Override
    public int getFullRowCount() {
        return this.getEquation().getAllVariables().size();
    }

    @Override
    public int getRowCount() {
        return this._visibleIndexes.length;
    }

    @Override
    public FTVariableAbstract getItem(int row) {
        int idx = this._visibleIndexes[row];
        if (idx >= this.getEquation().getAllVariables().size()) {
            _LOG.severe("FTVariableListModel::getItem(...) : java.lang.IndexOutOfBoundsException: Index: " + idx + ", Size: " + this.getEquation().getAllVariables().size());
            idx = 0;
        }
        return this.getEquation().getAllVariables().get(idx);
    }

    @Override
    public Object getValueAt(FTVariableAbstract item, int column) {
        int idxCol = this.getColumnModel().getColumnField(column).getIdxCode();
        switch (idxCol) {
            case 1: {
                return item.getName();
            }
            case 2: {
                return item.getLabel();
            }
            case 30: {
                return item.getDefinition();
            }
            case 3: {
                if (item.getEvent() != null) {
                    return item.getEvent().getLaw();
                }
                return null;
            }
            case 4: {
                double probability = item.getProbability();
                if (probability == -1.0) {
                    return Double.NaN;
                }
                return probability;
            }
            case 5: {
                if (item.getEvent() != null) {
                    return item.getEvent().getState();
                }
                return null;
            }
            case 6: {
                if (item.getEvent() != null) {
                    return item.getEvent().getStyle();
                }
                return null;
            }
            case 7: {
                return item.isGeneric();
            }
            case 8: {
                if (item.getLink() != null) {
                    return item.getLink().getGeneric();
                }
                return null;
            }
            case 9: {
                return item.getLink() != null && !item.getLink().isDSF();
            }
            case 10: {
                return item.getLink() != null && item.getLink().isDSF();
            }
            case 11: {
                if (item.getLink() != null) {
                    return item.getLink().getSubTree().getDBFolder();
                }
                return null;
            }
            case 12: {
                if (item.getEvent() != null) {
                    return item.getEvent().getModelLaw();
                }
                return null;
            }
            case 13: {
                if (item.getEvent() != null) {
                    Set<Param> params = item.getEvent().recupParams(new LinkedHashSet<Param>(), new FctParamSelect.FctParamFMEA());
                    return ParamFMEA.transcodeCollections(params);
                }
                return "";
            }
            case 15: {
                if (item.getDefinition() != null) {
                    return item.getDefinition().isGSR();
                }
                return false;
            }
            case 16: {
                if (item.getEvent() != null) {
                    return item.getEvent().getInspected();
                }
                return null;
            }
            case 17: {
                if (item.getEvent() != null) {
                    return item.getEvent().getInflightTested();
                }
                return null;
            }
            case 18: {
                if (item.getEvent() != null) {
                    return item.getEvent().getAttributes();
                }
                return null;
            }
            case 19: {
                if (item.getEvent() != null) {
                    return item.getEvent().getCCF();
                }
                return null;
            }
            case 20: {
                return item.getEvent() == null ? null : Double.valueOf(item.getEvent().getIF(FTEvent.IF.CPr));
            }
            case 21: {
                return item.getEvent() == null ? null : Double.valueOf(item.getEvent().getIF(FTEvent.IF.MIF));
            }
            case 23: {
                return item.getEvent() == null ? null : Double.valueOf(item.getEvent().getIF(FTEvent.IF.DIF));
            }
            case 22: {
                return item.getEvent() == null ? null : Double.valueOf(item.getEvent().getIF(FTEvent.IF.CIF));
            }
            case 24: {
                return item.getEvent() == null ? null : Double.valueOf(item.getEvent().getIF(FTEvent.IF.RAW));
            }
            case 25: {
                return item.getEvent() == null ? null : Double.valueOf(item.getEvent().getIF(FTEvent.IF.RRW));
            }
        }
        return "";
    }

    @Override
    public Class getColumnClass(int column) {
        int idxCol = this.getColumnModel().getColumnField(column).getIdxCode();
        switch (idxCol) {
            case 1: 
            case 2: 
            case 8: 
            case 13: 
            case 14: {
                return String.class;
            }
            case 11: {
                return DBFolder.class;
            }
            case 18: {
                return Collection.class;
            }
            case 30: {
                return FTDefinition.class;
            }
            case 5: {
                return FTEvent.State.class;
            }
            case 6: {
                return FTEvent.Style.class;
            }
            case 3: {
                return Law.class;
            }
            case 12: 
            case 19: {
                return DBWrap.class;
            }
            case 16: 
            case 17: {
                return Param.class;
            }
            case 4: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return Double.class;
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this._frame.getApplication().isReader()) {
            return false;
        }
        if (this.getEquation().isBigTree()) {
            return false;
        }
        FTVariableAbstract item = this.getItem(row);
        if (!item.isIntern()) {
            return false;
        }
        if (item.isLocked()) {
            return false;
        }
        int idxCol = this.getColumnModel().getColumnField(col).getIdxCode();
        switch (idxCol) {
            case 1: {
                return true;
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        FTVariableAbstract item = this.getItem(row);
        if (!item.isIntern()) {
            return;
        }
        if (!(item instanceof FTVariable)) {
            return;
        }
        int idxCol = this.getColumnModel().getColumnField(column).getIdxCode();
        switch (idxCol) {
            case 1: {
                String newName = aValue.toString();
                if (item.getName().equals(newName)) break;
                FTCmdVarRename cmd = new FTCmdVarRename(this._frame.getApplication(), this._frame, (FTVariable)item, newName, this._frame);
                cmd.realiseDo();
                break;
            }
            case 2: {
                ((FTVariable)item).setLabel(aValue.toString());
                break;
            }
        }
    }

    @Override
    public void exportToScribeFile(SrbInputStream outScribe, JTable table) throws IOException {
        outScribe.concat("<GDOC SEC=''>\n");
        outScribe.concat("<TITLE>" + ResMsgArbor.getString("KEY_1293") + "\n");
        outScribe.concat("<DOCNUM>\n");
        outScribe.concat("<DATE>" + this.getCurrentDateAsDDMMYYYY() + "\n");
        outScribe.concat(".ti @\n");
        outScribe.concat(".tp 5 7 18 20 30 35 40 50 60\n");
        outScribe.concat("<BODY>\n");
        outScribe.concat("<H1>" + ResMsgArbor.getString("KEY_1294") + "\n");
        StringBuffer b = new StringBuffer();
        b.append("<TABLEAU>\n");
        b.append("<TABTIT>" + ResMsgArbor.getString("KEY_1293") + "\n");
        this.exportTableToScribeFile(b, table);
        b.append("<ETABLEAU>\n");
        outScribe.concat(b.toString());
        outScribe.concat("<EGDOC>0\n");
    }

    @Override
    protected int getExportNbrSubCell(int row, int col, JTable table) {
        int colDoc = this.getColumnModel().getColumnField(col).getIdxCode();
        switch (colDoc) {
            case 18: {
                Collection attributes = (Collection)this.getValueAt(this.getItem(row), col);
                if (attributes == null || attributes.isEmpty()) break;
                return attributes.size();
            }
            case 2: {
                String comment = (String)this.getValueAt(this.getItem(row), col);
                if (comment == null || comment.isEmpty()) break;
                return comment.split("\n").length;
            }
        }
        return 1;
    }

    @Override
    protected String getExportValueAt(int row, int col, int idx, JTable table) {
        if (idx > 0 && this.getExportNbrSubCell(row, col, table) == 1) {
            return "";
        }
        Object value = this.getValueAt(this.getItem(row), col);
        if (value == null) {
            return "";
        }
        switch (this.getColumnModel().getColumnField(col).getIdxCode()) {
            case 18: {
                Collection attributes = (Collection)value;
                if (!attributes.isEmpty()) {
                    if (idx >= 0) {
                        int nbr = 0;
                        Iterator iterator = attributes.iterator();
                        while (iterator.hasNext()) {
                            if (nbr == idx) {
                                return ((DBAttrib.Value)iterator.next()).toDisplay();
                            }
                            ++nbr;
                            iterator.next();
                        }
                        return "";
                    }
                    StringBuilder buffer = new StringBuilder();
                    Iterator iterator = attributes.iterator();
                    while (iterator.hasNext()) {
                        buffer.append(((DBAttrib.Value)iterator.next()).toDisplay());
                        if (!iterator.hasNext()) continue;
                        buffer.append(" ; ");
                    }
                    return buffer.toString();
                }
                return "-";
            }
            case 2: {
                if (idx < 0) {
                    return value.toString().replaceAll("\n", " ");
                }
                String[] lines = value.toString().split("\n");
                if (lines.length > 0 && idx < lines.length) {
                    return lines[idx];
                }
                return "";
            }
            case 16: 
            case 17: {
                if (value instanceof Param) {
                    FTVariableListTable theTable = (FTVariableListTable)table;
                    return LawFormat.DEFAULT.format((Param)value, theTable._format);
                }
                return "-";
            }
            case 3: {
                if (value instanceof Law) {
                    FTVariableListTable theTable = (FTVariableListTable)table;
                    return LawFormat.DEFAULT.format((Law)value, theTable._format);
                }
                return "-";
            }
            case 11: {
                if (value instanceof DBFolder) {
                    return ((DBFolder)value).getRefPath();
                }
                return "-";
            }
            case 12: 
            case 19: {
                if (value instanceof DBWrap) {
                    return ((DBWrap)value).getRefPath();
                }
                return "-";
            }
            case 30: {
                if (value instanceof FTDefinition) {
                    return value.toString();
                }
                return "-";
            }
            case 5: {
                if (value instanceof FTEvent.State) {
                    return ((FTEvent.State)((Object)value)).getLabel();
                }
                return "-";
            }
            case 6: {
                if (value instanceof FTEvent.Style) {
                    return ((FTEvent.Style)((Object)value)).getLabel();
                }
                return "-";
            }
            case 7: 
            case 9: 
            case 10: 
            case 15: {
                if (value instanceof Boolean) {
                    return ResMsgVoc.getString((Boolean)value != false ? "VOC_TRUE" : "VOC_FALSE");
                }
                return "-";
            }
            case 4: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (value instanceof Double) {
                    FTVariableListTable theTable = (FTVariableListTable)table;
                    return theTable._format.format(((Double)value).doubleValue());
                }
                return "-";
            }
            case 1: 
            case 8: 
            case 13: 
            case 14: {
                return value.toString();
            }
        }
        return value.toString();
    }

    @Override
    public void exportToXMLDocBook(DBKOutput xmlWriter) throws IOException {
    }

    protected static class ELColumnsModel
    extends ItemAbstractColumnsModel {
        PrefFieldBoolean _nameItem = new PrefFieldBoolean(ResMsgVoc.getString("VOC_EVENTS"), "name", 1, 10, "L");

        public ELColumnsModel() {
            this.init();
        }

        @Override
        public List<PrefFieldBoolean> createOptionnalFields() {
            return FTVariableListModel.createFields();
        }

        @Override
        public void setOptionnalFields(List<PrefFieldBoolean> optionnalFields) {
            this._optionnalFields = optionnalFields;
            this._items.clear();
            this._items.add(this._nameItem);
            for (PrefFieldBoolean item : this._optionnalFields) {
                this._items.add(item);
            }
            this.resetFilterIndexes();
        }
    }

    protected static class FilterELFactory {
        protected FilterELFactory() {
        }

        static Filter<FTVariableAbstract> createItem(TypeFilter type, FTEquation ftEqu) {
            switch (type) {
                case ALL: {
                    return new FilterAbstract<FTVariableAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTVariableAbstract row) {
                            return true;
                        }
                    };
                }
                case ROOTS: {
                    return new FilterAbstract<FTVariableAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTVariableAbstract row) {
                            return row.isRoot();
                        }
                    };
                }
                case GATES: {
                    return new FilterAbstract<FTVariableAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTVariableAbstract row) {
                            return row.isEventIntermediate();
                        }
                    };
                }
                case LEAVES: {
                    return new FilterAbstract<FTVariableAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTVariableAbstract row) {
                            return row.isEventTerminal();
                        }
                    };
                }
                case SUBTREE: {
                    return new FilterAbstract<FTVariableAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTVariableAbstract row) {
                            return row.isEventSubTreeTree();
                        }
                    };
                }
                case DSF: {
                    return new FilterAbstract<FTVariableAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTVariableAbstract row) {
                            return row.isEventSubTreeDSF();
                        }
                    };
                }
                case INSPECTED: {
                    return new FilterAbstract<FTVariableAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTVariableAbstract row) {
                            return row.isEventInspected();
                        }
                    };
                }
                case INFLYTESTED: {
                    return new FilterAbstract<FTVariableAbstract>(type.getLabel()){

                        @Override
                        public boolean filter(FTVariableAbstract row) {
                            return row.isEventInflightTested();
                        }
                    };
                }
                case FILTERED: {
                    return new FilterELExtended(ftEqu);
                }
            }
            return null;
        }
    }

    protected static class FilterELExtended
    extends FilterAbstract<FTVariableAbstract> {
        boolean _evtTypeGate;
        boolean _evtTypeLeaf;
        boolean _evtTypeSubTree;
        boolean _evtTypeRoot;
        boolean _evtTypeDSF;
        boolean _evtTypeInspected;
        boolean _evtTypeTested;
        FilterString<FTVariableAbstract> _evtName;
        FilterString<FTVariableAbstract> _evtRemark;
        FilterLaw<FTVariableAbstract> _evtLaw;
        FilterAttribute<FTVariableAbstract> _evtAttr;
        FTEquation _ftEqu;

        public FilterELExtended(FTEquation ftEqu) {
            super(ResMsgVoc.getString("VOC_FILTER"));
            this._ftEqu = ftEqu;
            this._evtName = new FilterString<FTVariableAbstract>(ResMsgVoc.getString("VOC_NAME")){

                @Override
                public String getString(FTVariableAbstract row) {
                    return row.getName();
                }
            };
            this._evtRemark = new FilterString<FTVariableAbstract>(ResMsgVoc.getString("VOC_COMMENT")){

                @Override
                public String getString(FTVariableAbstract row) {
                    return row.getLabel();
                }
            };
            this._evtLaw = new FilterLawAralia<FTVariableAbstract>(){

                @Override
                public Law getLaw(FTVariableAbstract row) {
                    if (row.getEvent() == null) {
                        return null;
                    }
                    return row.getEvent().getLaw();
                }
            };
            this._evtAttr = new FilterAttribute<FTVariableAbstract>(){

                @Override
                public Collection<? extends Attr> getAttributes(FTVariableAbstract row) {
                    if (row.getEvent() == null) {
                        return null;
                    }
                    return row.getEvent().getAttributes();
                }
            };
        }

        @Override
        public boolean filter(FTVariableAbstract row) {
            boolean isTerminal = false;
            if (this._evtTypeLeaf && row.isEventTerminal()) {
                isTerminal = true;
            } else if (this._evtTypeInspected && row.isEventInspected()) {
                isTerminal = true;
            } else if (this._evtTypeTested && row.isEventInflightTested()) {
                isTerminal = true;
            } else if (this._evtTypeDSF && row.isEventSubTreeDSF()) {
                isTerminal = true;
            } else if (!(this._evtTypeRoot && row.isRoot() || this._evtTypeGate && row.isEventIntermediate() || this._evtTypeSubTree && row.isEventSubTreeTree())) {
                return false;
            }
            if (!this._evtName.filter(row)) {
                return false;
            }
            if (!this._evtRemark.filter(row)) {
                return false;
            }
            if (isTerminal) {
                if (!this._evtLaw.filter(row)) {
                    return false;
                }
                if (!this._evtAttr.filter(row)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean withDialog() {
            return true;
        }

        @Override
        public boolean selectFilter(JComponent owner) {
            if (!(this._evtTypeGate || this._evtTypeLeaf || this._evtTypeSubTree || this._evtTypeRoot || this._evtTypeDSF || this._evtTypeInspected || this._evtTypeTested || this._evtName.isSelected() || this._evtRemark.isSelected() || this._evtLaw.isSelected() || this._evtAttr.isSelected())) {
                return this.displayDialog(owner);
            }
            return true;
        }

        @Override
        public boolean displayDialog(JComponent owner) {
            Window win = SwingUtilities.getWindowAncestor(owner);
            FilterDlgExtended dlg = new FilterDlgExtended(win){

                @Override
                protected Map<DBAttrib, Set<String>> createAttributes() {
                    return _ftEqu.getAttributesOfVariables();
                }
            };
            dlg.setOnlyEventFilter(true);
            dlg.create();
            if (this._ftEqu.isBigTree()) {
                this._evtTypeGate = false;
                this._evtTypeRoot = false;
                this._evtTypeSubTree = false;
                this._evtTypeDSF = false;
                dlg.getEvtTypeGateCheck().setEnabled(false);
                dlg.getEvtTypeSubTreeCheck().setEnabled(false);
                dlg.getEvtTypeDSFCheck().setEnabled(false);
            }
            dlg.getEventSelectCheck().setSelected(true);
            dlg.getEvtTypeGateCheck().setSelected(this._evtTypeGate);
            dlg.getEvtTypeRootCheck().setSelected(this._evtTypeRoot);
            dlg.getEvtTypeLeafCheck().setSelected(this._evtTypeLeaf);
            dlg.getEvtTypeSubTreeCheck().setSelected(this._evtTypeSubTree);
            dlg.getEvtTypeDSFCheck().setSelected(this._evtTypeDSF);
            dlg.getEvtTypeInspectedCheck().setSelected(this._evtTypeInspected);
            dlg.getEvtTypeTestedCheck().setSelected(this._evtTypeTested);
            dlg.copyToCtrl(this._evtName, dlg.getEvtNameCheck(), dlg.getEvtNameText());
            dlg.copyToCtrl(this._evtRemark, dlg.getEvtRemarkCheck(), dlg.getEvtRemarkText());
            dlg.getEvtLawCheck().setSelected(this._evtLaw.isSelected());
            dlg.setEvtLawType(this._evtLaw.getType());
            dlg.setEvtLawOp(this._evtLaw.getOp());
            dlg.setEvtLawValue(this._evtLaw.getLimit());
            dlg.getEvtAttrCheck().setSelected(this._evtAttr.isSelected());
            if (this._evtAttr.isSelected()) {
                dlg.setEvtAttrSelect(this._evtAttr.getAttribute());
            }
            dlg.updateCtrls();
            dlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
            dlg.setVisible(true);
            if (!dlg.getResult()) {
                return false;
            }
            this._evtTypeGate = dlg.getEvtTypeGateCheck().isSelected();
            this._evtTypeRoot = dlg.getEvtTypeRootCheck().isSelected();
            this._evtTypeLeaf = dlg.getEvtTypeLeafCheck().isSelected();
            this._evtTypeSubTree = dlg.getEvtTypeSubTreeCheck().isSelected();
            this._evtTypeDSF = dlg.getEvtTypeDSFCheck().isSelected();
            this._evtTypeInspected = dlg.getEvtTypeInspectedCheck().isSelected();
            this._evtTypeTested = dlg.getEvtTypeTestedCheck().isSelected();
            dlg.copyFromCtrl(this._evtName, dlg.getEvtNameCheck(), dlg.getEvtNameText());
            dlg.copyFromCtrl(this._evtRemark, dlg.getEvtRemarkCheck(), dlg.getEvtRemarkText());
            this._evtLaw.setSelected(dlg.getEvtLawCheck().isSelected());
            if (this._evtLaw.isSelected()) {
                this._evtLaw.setType(dlg.getEvtLawType());
                this._evtLaw.setOp(dlg.getEvtLawOp());
                this._evtLaw.setLimit(dlg.getEvtLawValue());
            }
            this._evtAttr.setSelected(dlg.getEvtAttrCheck().isSelected());
            if (this._evtAttr.isSelected()) {
                this._evtAttr.configure(dlg.getEvtAttrSelect());
            }
            return true;
        }
    }
}

