/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmdVarRename;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTVariableAbstract;
import com.dassault.cecilia.lib.util.CopyUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;

public class FTCmdVarDuplicate
extends FTCmdVarRename {
    private final FTVariable _parent;
    private FTVariable _newVar;
    private int _idxVar;

    public FTCmdVarDuplicate(CeciliaAppl appl, FTEquationFrame frame, FTVariable ftVar, FTVariable parent, String newName, Component source) {
        super(appl, frame, ftVar, newName, source);
        this._parent = parent;
    }

    @Override
    protected boolean prepareDo() {
        if (!super.prepareDo()) {
            return false;
        }
        this._newVar = this._ftVariable.getCopy((CopyUtility)new CopyUtility.Default(){

            public boolean copyInternalID(Object src) {
                return false;
            }
        });
        this._newVar.setName(this._newName);
        if (this._ftVariable.getDefinition() != null && this._ftVariable instanceof FTVariable) {
            FTDefinition def = this._ftVariable.getDefinition().getCopy((CopyUtility)new CopyUtility.Default());
            def.setArgs(new ArrayList<FTVariableAbstract>(this._ftVariable.getDefinition().getArgs()));
            this._newVar.setDefinition(def);
        }
        this._idxVar = new ArrayList<FTVariableAbstract>(this._parent.getDefinition().getArgs()).indexOf(this._ftVariable);
        return true;
    }

    @Override
    protected void firstDo() {
        this.redo();
        this.getSource().addHisto(this);
    }

    @Override
    public void undo() {
        this._parent.getDefinition().getArgs().remove(this._newVar);
        ((ArrayList)this._parent.getDefinition().getArgs()).add(this._idxVar, this._ftVariable);
        this.updateSelection(true);
    }

    @Override
    public void redo() {
        this._parent.getDefinition().getArgs().remove(this._ftVariable);
        ((ArrayList)this._parent.getDefinition().getArgs()).add(this._idxVar, this._newVar);
        this.updateSelection(false);
    }

    @Override
    public void debugTrace(StringBuilder out) {
        out.append(this.getClass().getSimpleName()).append(" : ").append(this._ftVariable.getName()).append(" => ").append(this._newName);
    }

    @Override
    protected String getTitleAction() {
        return ResMsgVoc.getString("VOC_DUPLICATE");
    }

    private final void updateSelection(boolean isUndo) {
        this._ftEquation.changeDefinitionOf(this._parent, this._parent.getDefinition());
        this._ftEquation.instanciateAfterChangeDefinition(this.getAppl().getDBUser());
        this._ftEquation.fireChangeDefinitions(Collections.singleton(this._parent), this._source);
        for (FTVariableAbstract ftVar : this._ftEquation.getAllVariables()) {
            ftVar.setSelected(false);
        }
        if (isUndo) {
            this._ftVariable.setSelected(true);
        } else {
            this._newVar.setSelected(true);
        }
    }
}

