/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.gui.actions;

import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTEquationFrame;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.actions.FTCmd;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.util.Collections;

public abstract class FTCmdVarEdit
extends FTCmd {
    FTVariable _ftVariable;
    FTDefinition _oldDefine;
    FTLink _oldLink;
    FTEvent _oldEvent;
    Component _source;

    protected boolean withClearResults() {
        return true;
    }

    public FTCmdVarEdit(CeciliaAppl appl, FTEquationFrame frame, FTVariable ftVar, Component source) {
        super(appl, frame);
        this._ftVariable = ftVar;
        this._source = source;
        this._oldLink = this._ftVariable.getLink();
        if (this._oldLink == null) {
            this._oldEvent = this._ftVariable.getEvent();
            if (this._oldEvent == null) {
                this._oldDefine = this._ftVariable.getDefinition();
            }
        }
    }

    @Override
    protected boolean prepareChangeDSFConfig(boolean force) {
        return super.prepareChangeDSFConfig(this._oldLink != null || force);
    }

    @Override
    public void undo() {
        if (this._oldEvent != null) {
            this._ftVariable.setEvent(this._oldEvent);
            this._ftVariable.setLink(null);
        } else if (this._oldLink != null) {
            this._ftVariable.setEvent(null);
            this._ftVariable.setLink(this._oldLink);
        } else {
            this._ftVariable.setEvent(null);
            this._ftVariable.setLink(null);
        }
        this.changeDefinitionOf(this._ftVariable, this._oldDefine);
        if (this.withClearResults()) {
            this._ftEquation.clearResults();
        }
        this.undoChangeDSFConfig();
        this.refreshEvents();
        this._ftEquation.updateDependTimeUpdt(this.getAppl().getDAOFactory(), this._ftEquation.getWorkingRelations());
        this.getSource().refreshCtrlInstanciate();
        this.getSource().refreshCtrlLogs();
    }

    protected boolean changeDefinitionOf(FTVariable ftVar, FTDefinition ftDefine) {
        boolean result = true;
        this._ftEquation.changeDefinitionOf(ftVar, ftDefine);
        result = this.verifyInstanciate(true);
        this._ftEquation.defineLockedVariables();
        this._ftEquation.setModified(true);
        return result;
    }

    protected void refreshEvents() {
        this._ftEquation.fireChangeDefinitions(Collections.singleton(this._ftVariable), this._source);
        this._ftEquation.setModified(true);
    }
}

