/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.config.io.FTConfigReaderRaw;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class RAWConfigReader {
    String _name = null;

    protected boolean verify(DBObjModel model, DAOFactory cecFactory, FTEquation ftEquation, DBLogs.DBLogsManager logMng) {
        this._name = model.getNature().substring("dsf.config".length());
        if (this._name.startsWith(".") && this._name.length() > 1) {
            this._name = this._name.substring(1);
        }
        if (ftEquation.getConfig(this._name) != null) {
            logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("ERR_RAW_CONFIG_ALREADY", this._name));
            return false;
        }
        return true;
    }

    public boolean read(DBObjModel model, CECFactory cecFactory, FTEquation ftEquation, DBLogs.DBLogsManager logMng) {
        if (!this.verify(model, cecFactory, ftEquation, logMng)) {
            return false;
        }
        if (model.getSize() == 0L) {
            FTConfig config = new FTConfig();
            config.setName(this._name);
            ftEquation.addConfig(config);
            return true;
        }
        InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
        if (istream == null) {
            logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
            return false;
        }
        FTConfigReaderRaw reader = new FTConfigReaderRaw(cecFactory, logMng, ftEquation);
        InflaterInputStream inflaterStream = new InflaterInputStream(istream, new Inflater());
        if (!reader.read(inflaterStream)) {
            return false;
        }
        FTConfig config = new FTConfig();
        config.setName(this._name);
        config.configLightest(reader.getDSFs(), reader.getCCFs());
        ftEquation.addConfig(config);
        return true;
    }
}

