/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ResMsgArbor;
import com.dassault.cecilia.dbobj.faulttree.ccf.CCF;
import com.dassault.cecilia.dbobj.faulttree.ft.FTVariable;
import com.dassault.cecilia.dbobj.faulttree.obj.FTDefinition;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEquationAbstract;
import com.dassault.cecilia.dbobj.faulttree.obj.FTEvent;
import com.dassault.cecilia.dbobj.faulttree.obj.FTLink;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.dbobj.general.law.io.LawParserRaw;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.io.BasicLexer;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefReader {
    private static Logger _LOG = Logger.getLogger(DefReader.class.getPackage().getName());
    CECFactory _cecFactory;
    DBLogs.DBLogsManager _logMng;
    Map<String, FTVariable> _mapDictionary;
    protected static final String PREFIXE = "Event_";
    LawParser _lawParser = null;
    static Object _lockLawParser = new Object();
    LawParser _lawParserRaw = null;
    static Object _lockLawParserRaw = new Object();
    private static final Integer KOD_NAME = 0;
    private static final Integer KOD_COMMENT = 1;
    private static final Integer KOD_STATE = 2;
    private static final Integer KOD_UNLINK = 3;
    private static final Integer KOD_SUBTREE = 4;
    private static final Integer KOD_TREENAME1 = 5;
    private static final Integer KOD_TREENAME2 = 6;
    private static final Integer KOD_SUBTREEID = 7;
    private static final Integer KOD_GENERICADD = 12;
    private static final Integer KOD_EQU = 8;
    private static final Integer KOD_EQUSYSTEM = 9;
    private static final Integer KOD_EQULOCAL = 10;
    private static final Integer KOD_GENERIC = 11;
    private static final Integer KOD_GSR = 13;
    private static final Integer KOD_FRB1 = 14;
    private static final Integer KOD_FRB2 = 15;
    private static final Integer KOD_LAW1 = 16;
    private static final Integer KOD_LAW2 = 17;
    private static final Integer KOD_INSPECTED = 18;
    private static final Integer KOD_INFLIGHT = 19;
    private static final Integer KOD_ATTRIBUTE1 = 20;
    private static final Integer KOD_ATTRIBUTE2 = 21;
    private static final Integer KOD_CCF1 = 22;
    private static final Integer KOD_CCF2 = 23;
    private static final Integer KOD_DSF = 24;
    static Map<String, Integer> _DEF_ELTCODE = new HashMap<String, Integer>();

    public DefReader(CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        this._cecFactory = cecFactory;
        this._logMng = logMng;
        this._mapDictionary = new LinkedHashMap<String, FTVariable>();
    }

    protected boolean treatBigTree() {
        return false;
    }

    protected boolean isLeaf(FTVariable var) {
        return true;
    }

    protected FTVariable findVariable(String originName) {
        if (this._mapDictionary.isEmpty()) {
            FTVariable ftVar = new FTVariable().setName(originName);
            ftVar.setEvent(new FTEvent());
            this._mapDictionary.put(originName, ftVar);
            return ftVar;
        }
        if (originName.startsWith(PREFIXE)) {
            return this._mapDictionary.get(originName.substring(PREFIXE.length()));
        }
        return this._mapDictionary.get(originName);
    }

    public Collection<FTVariable> getVariables() {
        return this._mapDictionary.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LawParser createLawParser() {
        if (this._lawParser == null) {
            Object object = _lockLawParser;
            synchronized (object) {
                FTRawLawParser lawParser = null;
                if (this._lawParser == null) {
                    lawParser = new FTRawLawParser(this._cecFactory.getLawManager(), this._cecFactory);
                }
                if (this._lawParser == null) {
                    this._lawParser = lawParser;
                }
            }
        }
        this._lawParser.clearErrors();
        return this._lawParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LawParser createLawParserRaw() {
        if (this._lawParserRaw == null) {
            Object object = _lockLawParserRaw;
            synchronized (object) {
                LawParserRaw lawParser = null;
                if (this._lawParserRaw == null) {
                    this._lawParserRaw = null;
                    lawParser = new LawParserRaw(this._cecFactory.getLawManager(), this._cecFactory);
                }
                if (this._lawParserRaw == null) {
                    this._lawParserRaw = lawParser;
                }
            }
        }
        this._lawParserRaw.clearErrors();
        return this._lawParserRaw;
    }

    public boolean readDef(Reader inputReader) {
        try {
            LineNumberReader reader = new LineNumberReader(inputReader);
            String line = reader.readLine();
            if (line == null) {
                this._logMng.addLog(DBLogs.DBLevel.INFO, "Le fichier de description est vide...");
                return true;
            }
            int p = line.indexOf("<ARBORJAVA>");
            if (p == -1) {
                this._logMng.addLog(DBLogs.DBLevel.ERROR, "Le fichier de description n'est pas valide (Format Cedre ?)...");
                return false;
            }
            LinkedHashMap<Integer, Object> defElements = null;
            while ((line = reader.readLine()) != null) {
                Integer flagDef;
                int position = line.indexOf("<NAME>");
                if (position != -1) {
                    position += 5;
                    flagDef = KOD_NAME;
                } else {
                    position = line.indexOf(">");
                    if (position == -1) {
                        _LOG.finest("Flux DEF - ligne sans balise : " + line);
                        continue;
                    }
                    flagDef = _DEF_ELTCODE.get(line.substring(0, position + 1));
                    if (flagDef == null) {
                        _LOG.finest("Flux DEF - ligne sans balise connue : " + line);
                        continue;
                    }
                }
                if (flagDef == KOD_NAME) {
                    this.treatDefinition(defElements, reader.getLineNumber());
                    defElements = new LinkedHashMap<Integer, Object>();
                }
                if (defElements == null) continue;
                if (flagDef == KOD_COMMENT || flagDef == KOD_ATTRIBUTE1 || flagDef == KOD_ATTRIBUTE2) {
                    Object current = (String)defElements.get(flagDef);
                    current = current == null ? line.substring(position + 1).trim() : (String)current + "\n" + line.substring(position + 1);
                    defElements.put(flagDef, current);
                    continue;
                }
                defElements.put(flagDef, line.substring(position + 1));
            }
            this.treatDefinition(defElements, reader.getLineNumber());
            return true;
        }
        catch (IOException ioe) {
            this._logMng.addLog(DBLogs.DBLevel.ERROR, "Erreur lors de la lecture du flux de definition...");
            _LOG.log(Level.INFO, "Erreur lors de la lecture du flux de definition...", ioe);
            return false;
        }
    }

    private void treatDefinition(Map<Integer, String> defElements, int lineNumber) {
        FTDefinition ftDefinition;
        if (defElements == null) {
            return;
        }
        FTVariable var = null;
        String name = null;
        StringBuilder fineMsg = new StringBuilder(512);
        name = defElements.get(KOD_NAME);
        if (name == null) {
            _LOG.info("no name for 'definition' in line: " + lineNumber);
            return;
        }
        var = this.findVariable(name);
        if (var == null) {
            if (!this.treatBigTree()) {
                this._logMng.addLog(DBLogs.DBLevel.ERROR, "Unknown variable for current tree : " + name);
            }
            return;
        }
        String value = null;
        value = defElements.get(KOD_COMMENT);
        if (value != null) {
            var.setLabel(value.trim());
        }
        if ((value = defElements.get(KOD_GENERIC)) != null && !var.isRoot()) {
            var.setGeneric(value.indexOf("true") != -1);
        }
        if ((value = defElements.get(KOD_SUBTREE)) != null) {
            boolean subtree;
            boolean bl = subtree = value.indexOf("true") != -1;
            if (subtree) {
                long id = -1L;
                String path = null;
                String generic = null;
                if (var.isGeneric() && (value = defElements.get(KOD_GENERICADD)) != null) {
                    generic = value.trim();
                }
                if ((value = defElements.get(KOD_SUBTREEID)) != null) {
                    try {
                        int idOldObjBTP = Integer.parseInt(value.trim());
                        id = this._cecFactory.createUtilityDAO().convertMigrationOldIDObjectToIDFolder(idOldObjBTP);
                        if (id == -1L) {
                            this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", idOldObjBTP));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        _LOG.warning("<SUBTREEID> element with value (" + value + ") is not integer for event: " + name);
                    }
                }
                if ((value = defElements.get(KOD_TREENAME2)) != null) {
                    path = this.constructSubTreePath(name, value.trim(), ';');
                } else {
                    value = defElements.get(KOD_TREENAME1);
                    if (value != null) {
                        path = this.constructSubTreePath(name, value.trim(), '/');
                    }
                }
                if (path != null || id != -1L) {
                    DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder(id, path, "PROJECTS");
                    if (dbFolder == null) {
                        this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_RAW_TREE_UNKNOWN", path, name));
                    } else if (dbFolder.getFamilyFlag() != 2 && dbFolder.getFamilyFlag() != 3) {
                        this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_RAW_TREE_UNKNOWN", path, name));
                    } else {
                        DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                        if (dbWrap == null) {
                            this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_RAW_TREE_READ", path, name));
                        } else {
                            FTLink ftLink = new FTLink().setSubTree(((FTEquationAbstract)dbWrap).getCopy());
                            if (generic != null) {
                                ftLink.setGeneric(generic);
                            }
                            var.setLink(ftLink);
                        }
                    }
                }
            }
        }
        if ((value = defElements.get(KOD_STATE)) != null) {
            int istate = -1;
            try {
                istate = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException nfe) {
                this._logMng.addLog(DBLogs.DBLevel.INFO, "<STATE> element with value is not integer: " + var.getName());
            }
            if (istate != -1) {
                FTEvent ftEvent = var.getEvent();
                if (ftEvent == null) {
                    if (istate != 0) {
                        this._logMng.addLog(DBLogs.DBLevel.INFO, "<STATE> element only to leaf variable: " + var.getName());
                    }
                } else {
                    switch (istate) {
                        case 1: {
                            ftEvent.setState(FTEvent.State.TRUE);
                            break;
                        }
                        case 2: {
                            ftEvent.setState(FTEvent.State.FALSE);
                            break;
                        }
                        default: {
                            this._logMng.addLog(DBLogs.DBLevel.INFO, "<STATE> element with value not included in [0,2]: " + var.getName());
                        }
                        case 0: {
                            ftEvent.setState(FTEvent.State.DEFAULT);
                        }
                    }
                }
            }
        }
        if ((value = defElements.get(KOD_UNLINK)) != null) {
            FTEvent ftEvent = var.getEvent();
            if (ftEvent == null) {
                this._logMng.addLog(DBLogs.DBLevel.INFO, "<UNLINKSUBTREE> element only to leaf variable");
            } else {
                ftEvent.setStyle(FTEvent.Style.UNLINK);
            }
        }
        if ((value = defElements.get(KOD_EQU)) != null && !value.trim().isEmpty()) {
            fineMsg.append("  <EQUIVALENCE value='").append(value.trim()).append("'/>\n");
        }
        if ((value = defElements.get(KOD_EQUSYSTEM)) != null && !(value = value.trim()).equals("I")) {
            fineMsg.append("  <SYSTEMTYPE value='").append(value).append("'/>\n");
        }
        if ((value = defElements.get(KOD_EQULOCAL)) != null && !(value = value.trim()).equals("I")) {
            fineMsg.append("  <LOCALTYPE value='").append(value).append("'/>\n");
        }
        if ((value = defElements.get(KOD_GSR)) != null && (ftDefinition = var.getDefinition()) != null) {
            ftDefinition.setGSR(value.indexOf("true") != -1);
        }
        if (this.isLeaf(var)) {
            Law law;
            LawParser lawParser;
            boolean bTreatLaw = false;
            FTEvent ftEvent = var.getEvent();
            if (!bTreatLaw && (value = defElements.get(KOD_FRB2)) != null) {
                bTreatLaw = this.treatFRB2(ftEvent, value, name);
            }
            if (!bTreatLaw && (value = defElements.get(KOD_FRB1)) != null) {
                bTreatLaw = this.treatFRB1(ftEvent, value, name);
            }
            if (!bTreatLaw && (value = defElements.get(KOD_LAW2)) != null && value.trim().length() > 0) {
                lawParser = this.createLawParserRaw();
                law = lawParser.parseLaw(value);
                if (law != null) {
                    ftEvent.setOccurrence(law);
                    bTreatLaw = true;
                } else {
                    lawParser.traceError(this._logMng, name, value, _LOG, true);
                }
            }
            if (!bTreatLaw && (value = defElements.get(KOD_LAW1)) != null && value.trim().length() > 0) {
                lawParser = this.createLawParser();
                law = lawParser.parseLaw(value);
                if (law != null) {
                    ftEvent.setOccurrence(law);
                    bTreatLaw = true;
                } else {
                    lawParser.traceError(this._logMng, name, value, _LOG, true);
                }
            }
            if (this._cecFactory.getLawManager().isInspectedCompatible(ftEvent.getLaw())) {
                value = defElements.get(KOD_INSPECTED);
                if (value != null) {
                    lawParser = this.createLawParser();
                    param = lawParser.parseParam(value);
                    if (param != null) {
                        ftEvent.setInspected(param);
                    } else {
                        lawParser.traceError(this._logMng, name, value, _LOG, false);
                    }
                } else {
                    value = defElements.get(KOD_INFLIGHT);
                    if (value != null) {
                        lawParser = this.createLawParser();
                        param = lawParser.parseParam(value);
                        if (param != null) {
                            ftEvent.setInflightTested(param);
                        } else {
                            lawParser.traceError(this._logMng, name, value, _LOG, false);
                        }
                    }
                }
            }
            if ((value = defElements.get(KOD_ATTRIBUTE1)) != null) {
                this.treatAttributes1(ftEvent, value, name);
            }
            if ((value = defElements.get(KOD_ATTRIBUTE2)) != null) {
                this.treatAttributes2(ftEvent, value, name);
            }
            if ((value = defElements.get(KOD_CCF1)) != null) {
                this.treatCCF1(ftEvent, value, name);
            }
            if ((value = defElements.get(KOD_CCF2)) != null) {
                this.treatCCF2(ftEvent, value, name);
            }
        }
        if ((value = defElements.get(KOD_DSF)) == null || !value.equalsIgnoreCase("false")) {
            // empty if block
        }
        if (fineMsg.length() > 0) {
            StringBuilder msg = new StringBuilder(fineMsg.length() + 256);
            msg.append("<INFO name='").append(name).append("'>\n");
            msg.append(fineMsg.toString());
            msg.append("</INFO>");
            this._logMng.addLog(DBLogs.DBLevel.FINE, msg.toString());
        }
    }

    private String constructSubTreePath(String name, String treePath, char sep) {
        try {
            int pos = treePath.indexOf(sep);
            String projectName = treePath.substring(0, pos);
            int pos2 = treePath.indexOf(sep, pos + 1);
            String systemName = treePath.substring(pos + 1, pos2);
            String treeName = treePath.substring(pos2 + 1);
            if (projectName.endsWith(" (1.0)")) {
                projectName = projectName.substring(0, projectName.length() - 6);
            }
            if (systemName.endsWith(" (1.0)")) {
                systemName = systemName.substring(0, systemName.length() - 6);
            }
            String treeVersion = "";
            pos = treeName.lastIndexOf(41);
            if (pos != -1 && (pos2 = treeName.lastIndexOf(40, pos)) != -1) {
                treeVersion = treeName.substring(pos2 + 1, pos);
                treeName = treeName.substring(0, pos2).trim();
            }
            StringBuilder sb = new StringBuilder(treePath.length());
            sb.append(projectName).append("/").append(systemName).append("/").append(treeName);
            if (!treeVersion.isEmpty()) {
                sb.append(";").append(treeVersion);
            }
            return sb.toString();
        }
        catch (Throwable th) {
            this._logMng.addLog(DBLogs.DBLevel.WARNING, "<TREENAME[2]?> syntax error for event '" + name + "': " + treePath);
            return null;
        }
    }

    private boolean treatFRB1(FTEvent ftEvent, String value, String name) {
        DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder("LAW_MODELS", value);
        if (dbFolder == null) {
            this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_UNKNOWN", value, name));
        } else {
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null || !(dbWrap instanceof DBModelLaw)) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_READ", dbFolder.getRefPath(), name));
            } else {
                ftEvent.setModelLaw((DBModelLaw)dbWrap);
                return true;
            }
        }
        return false;
    }

    private boolean treatFRB2(FTEvent ftEvent, String value, String name) {
        long idBTP = -1L;
        try {
            int idOldObjBTP = Integer.parseInt(value.trim());
            idBTP = this._cecFactory.createUtilityDAO().convertMigrationOldIDObjectToIDFolder(idOldObjBTP);
            if (idBTP == -1L) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", idOldObjBTP));
            }
        }
        catch (NumberFormatException ex) {
            _LOG.log(Level.WARNING, "L'attribut 'eventModelId' n'est pas un entier", ex);
        }
        if (idBTP != -1L) {
            DBFolder dbFolder = (DBFolder)this._cecFactory.createFolderDAO().find(idBTP);
            if (dbFolder == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_UNKNOWN", value, name));
            } else {
                DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                if (dbWrap == null || !(dbWrap instanceof DBModelLaw)) {
                    this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_EVENT_READ", dbFolder.getRefPath(), name));
                } else {
                    ftEvent.setModelLaw((DBModelLaw)dbWrap);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean treatCCF1(FTEvent ftEvent, String value, String name) {
        DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder("CCF_MODELS", value);
        if (dbFolder == null) {
            this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_RAW_CCF_UNKNOWN", value, name));
        } else {
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null || !(dbWrap instanceof CCF)) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_RAW_CCF_READ", dbFolder.getRefPath(), name));
            } else {
                ftEvent.setCCF((CCF)dbWrap);
                return true;
            }
        }
        return false;
    }

    private boolean treatCCF2(FTEvent ftEvent, String value, String name) {
        long idCCF = -1L;
        try {
            int idOldObjBTP = Integer.parseInt(value.trim());
            idCCF = this._cecFactory.createUtilityDAO().convertMigrationIDCCFToIDFolder(idOldObjBTP);
            if (idCCF == -1L) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", idOldObjBTP));
            }
        }
        catch (NumberFormatException ex) {
            _LOG.log(Level.WARNING, "L'attribut 'CCF2' n'est pas un entier", ex);
        }
        if (idCCF != -1L) {
            DBFolder dbFolder = (DBFolder)this._cecFactory.createFolderDAO().find(idCCF);
            if (dbFolder == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_RAW_CCF_UNKNOWN", value, name));
            } else {
                DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                if (dbWrap == null || !(dbWrap instanceof CCF)) {
                    this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgArbor.msgFormat("MSG_ERR_RAW_CCF_READ", dbFolder.getRefPath(), name));
                } else {
                    ftEvent.setCCF((CCF)dbWrap);
                    return true;
                }
            }
        }
        return false;
    }

    private void treatAttributes1(FTEvent ftEvent, String value, String name) {
        StringTokenizer st = new StringTokenizer(value, "\n");
        while (st.hasMoreTokens()) {
            int posLeft;
            String path;
            value = st.nextToken().trim();
            if (value.charAt(0) != '\'' || value.indexOf(39, 1) == -1 || value.length() < 2) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Syntax of attribute not valid: " + value);
            }
            if ((path = value.substring(1, value.indexOf(39, 1))).endsWith("]") && (posLeft = path.indexOf(91)) != -1) {
                StringBuilder sb = new StringBuilder(path.length());
                sb.append(path.substring(0, posLeft)).append(";");
                path = sb.append(path.substring(posLeft + 1, path.length() - 1)).toString();
            }
            String attrValue = value.substring(value.indexOf(39, 1) + 1).trim();
            DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder("ATTRIBUTES", path);
            if (dbFolder == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNKNOWN_WITH_EVT", path, name));
                continue;
            }
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null || !(dbWrap instanceof DBAttrib)) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_READ_WITH_EVT", path, name));
                continue;
            }
            DBAttrib dbAttrib = (DBAttrib)dbWrap;
            DBAttrib.Value dbValue = dbAttrib.createInstance(dbAttrib.correctRAWValue(attrValue));
            if (dbValue == null) {
                String definition = new StringBuilder(128).append("'").append(dbFolder.getRefPath()).append("' = ").append(attrValue).toString();
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNCOMPATIBLE_WITH_EVT", definition, name));
                continue;
            }
            ftEvent.addAttribute(dbValue);
        }
    }

    private void treatAttributes2(FTEvent ftEvent, String value, String name) {
        StringTokenizer st = new StringTokenizer(value, "\n");
        while (st.hasMoreTokens()) {
            value = st.nextToken().trim();
            if ((value = value.trim()).charAt(0) != '\'' || value.indexOf(39, 1) == -1) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Syntax of attribute not valid: " + value);
            }
            String path = value.substring(1, value.indexOf(39, 1));
            long id = -1L;
            try {
                int idOldObj = Integer.parseInt(path);
                id = this._cecFactory.createUtilityDAO().convertMigrationIDAttributeToIDFolder(idOldObj);
                if (id == -1L) {
                    this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", idOldObj));
                }
            }
            catch (NumberFormatException ex) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, "Syntax of attribute not valid: " + value);
            }
            if (id == -1L) continue;
            String attrValue = value.substring(value.indexOf(39, 1) + 1).trim();
            DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder(id, "", "ATTRIBUTES");
            if (dbFolder == null) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNKNOWN_WITH_EVT", path, name));
                continue;
            }
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null || !(dbWrap instanceof DBAttrib)) {
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_READ_WITH_EVT", path, name));
                continue;
            }
            DBAttrib dbAttrib = (DBAttrib)dbWrap;
            DBAttrib.Value dbValue = dbAttrib.createInstance(dbAttrib.correctRAWValue(attrValue));
            if (dbValue == null) {
                String definition = new StringBuilder(128).append("'").append(dbFolder.getRefPath()).append("' = ").append(attrValue).toString();
                this._logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNCOMPATIBLE_WITH_EVT", definition, name));
                continue;
            }
            ftEvent.addAttribute(dbValue);
        }
    }

    static {
        _DEF_ELTCODE.put("<NAME>", KOD_NAME);
        _DEF_ELTCODE.put("<COMMENT>", KOD_COMMENT);
        _DEF_ELTCODE.put("<STATE>", KOD_STATE);
        _DEF_ELTCODE.put("<UNLINKSUBTREE>", KOD_UNLINK);
        _DEF_ELTCODE.put("<SUBTREE>", KOD_SUBTREE);
        _DEF_ELTCODE.put("<TREENAME>", KOD_TREENAME1);
        _DEF_ELTCODE.put("<TREENAME2>", KOD_TREENAME2);
        _DEF_ELTCODE.put("<SUBTREEID>", KOD_SUBTREEID);
        _DEF_ELTCODE.put("<EQUIVALENCE>", KOD_EQU);
        _DEF_ELTCODE.put("<SYSTEMTYPE>", KOD_EQUSYSTEM);
        _DEF_ELTCODE.put("<LOCALTYPE>", KOD_EQULOCAL);
        _DEF_ELTCODE.put("<GENERIC>", KOD_GENERIC);
        _DEF_ELTCODE.put("<GENERICSTRING>", KOD_GENERICADD);
        _DEF_ELTCODE.put("<GSR>", KOD_GSR);
        _DEF_ELTCODE.put("<EVENTMODELID>", KOD_FRB1);
        _DEF_ELTCODE.put("<EVENTMODELID2>", KOD_FRB2);
        _DEF_ELTCODE.put("<LAW>", KOD_LAW1);
        _DEF_ELTCODE.put("<LAW2>", KOD_LAW2);
        _DEF_ELTCODE.put("<INSPECTED>", KOD_INSPECTED);
        _DEF_ELTCODE.put("<INFLIGHTTESTED>", KOD_INFLIGHT);
        _DEF_ELTCODE.put("<ATTRIBUTE>", KOD_ATTRIBUTE1);
        _DEF_ELTCODE.put("<ATTRIBUTE2>", KOD_ATTRIBUTE2);
        _DEF_ELTCODE.put("<CCF>", KOD_CCF1);
        _DEF_ELTCODE.put("<CCF2>", KOD_CCF2);
        _DEF_ELTCODE.put("<DSF>", KOD_DSF);
    }

    static class FTRawLawParser
    extends LawParser {
        public FTRawLawParser(LawManager lawManager, CECFactory cecFactory) {
            super(lawManager, cecFactory);
        }

        @Override
        protected String readNextIdentify(BasicLexer lex) {
            boolean slash;
            String result = lex.readNextIdentify(false);
            if (result.isEmpty()) {
                return result;
            }
            if (result.endsWith("'")) {
                int posLeft;
                if (result.endsWith("]'") && (posLeft = result.lastIndexOf(91)) != -1) {
                    StringBuilder sb = new StringBuilder(result.length());
                    sb.append(result.substring(0, posLeft)).append(";");
                    sb.append(result.substring(posLeft + 1, result.length() - 2));
                    return sb.append("'").toString();
                }
                return result;
            }
            char car = lex.readChar();
            boolean bl = slash = car == '/';
            if (slash || car == '[') {
                StringBuilder buffer = new StringBuilder(result.length() + 16);
                buffer.append(result);
                buffer.append(";");
                while ((car = lex.readChar()) >= '0' && car <= '9') {
                    buffer.append(car);
                }
                if (!slash && car != ']') {
                    lex.ungetChar();
                }
                return buffer.toString();
            }
            lex.ungetChar();
            return result;
        }
    }
}

