/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef;

import com.dassault.cecilia.dbobj.faulttree.ft.io.dagdef.EquBoolNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EquBoolStdNode
implements EquBoolNode {
    public static EquBoolStdNode __TRUE = new EquBoolStdNode(EquBoolNode.Type.TRUE, "true");
    public static EquBoolStdNode __FALSE = new EquBoolStdNode(EquBoolNode.Type.FALSE, "false");
    private String _name;
    private EquBoolNode.Type _type;
    int _flag;
    short _mark;
    private static final short MASK_BIG = 128;
    private static final short MASK_USE = 1;
    private static final short MASK_LEFT = 2;
    private static final short MASK_RIGHT = 4;
    private static final short MASK_ROOT = 8;
    private static final short MASK_LEAF = 16;
    private static final short MASK_GATE = 32;
    private Map<String, String> _attributes;
    private List<EquBoolStdNode> _parents;
    private List<EquBoolStdNode> _children;

    public EquBoolStdNode() {
    }

    public EquBoolStdNode(EquBoolNode.Type t, String a) {
        this._type = t;
        this._name = a;
        this._attributes = null;
        this._parents = null;
        this._children = null;
        this._flag = 0;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public EquBoolNode.Type getType() {
        return this._type;
    }

    @Override
    public int getFlag() {
        return this._flag;
    }

    @Override
    public void setFlag(int v) {
        this._flag = v;
    }

    void setBig() {
        this._mark = (short)(this._mark | 0x80);
    }

    boolean isUsed() {
        if ((this._mark & 0x80) > 0) {
            return (this._mark & 1) > 0;
        }
        return !this.isRoot();
    }

    void setUsed() {
        if ((this._mark & 0x80) > 0) {
            this._mark = (short)(this._mark | 1);
        }
    }

    boolean isLeft() {
        if ((this._mark & 0x80) > 0) {
            return (this._mark & 2) > 0;
        }
        return this.getChildrenNumber() > 0;
    }

    void setLeft() {
        if ((this._mark & 0x80) > 0) {
            this._mark = (short)(this._mark | 2);
        }
    }

    boolean isRight() {
        if ((this._mark & 0x80) > 0) {
            return (this._mark & 4) > 0;
        }
        return this.getParentsNumber() > 0;
    }

    void setRight() {
        if ((this._mark & 0x80) > 0) {
            this._mark = (short)(this._mark | 4);
        }
    }

    @Override
    public boolean isRoot() {
        if ((this._mark & 0x80) > 0) {
            return (this._mark & 8) > 0;
        }
        if (this._parents == null) {
            return true;
        }
        return this._parents.isEmpty();
    }

    void setRoot() {
        if ((this._mark & 0x80) > 0) {
            this._mark = (short)(this._mark | 8);
        }
    }

    @Override
    public boolean isLeaf() {
        if ((this._mark & 0x80) > 0) {
            return (this._mark & 0x10) > 0;
        }
        if (this._children == null) {
            return true;
        }
        return this._children.isEmpty();
    }

    void setLeaf() {
        if ((this._mark & 0x80) > 0) {
            this._mark = (short)(this._mark | 0x10);
        }
    }

    boolean isGate() {
        if ((this._mark & 0x80) > 0) {
            return (this._mark & 0x20) > 0;
        }
        return !this.isRoot() && !this.isLeaf();
    }

    void setGate() {
        if ((this._mark & 0x80) > 0) {
            this._mark = (short)(this._mark | 0x20);
        }
    }

    @Override
    public Map<String, String> getAttributes() {
        return this._attributes;
    }

    void addAttribute(String attr, String val) {
        if (this._attributes == null) {
            this._attributes = new TreeMap<String, String>();
        }
        this._attributes.put(attr, val);
    }

    @Override
    public String getAttribute(String nameAttr) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(nameAttr);
    }

    public void addParent(EquBoolStdNode an) {
        if (this._parents == null) {
            this._parents = new ArrayList<EquBoolStdNode>();
        }
        this._parents.add(an);
    }

    public List<EquBoolStdNode> getParents() {
        if (this._parents == null) {
            this._parents = new ArrayList<EquBoolStdNode>();
        }
        return this._parents;
    }

    public List<String> getParentsNames() {
        if (this._parents == null) {
            this._parents = new ArrayList<EquBoolStdNode>();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (EquBoolStdNode parent : this._parents) {
            names.add(parent.getName());
        }
        return names;
    }

    public int getParentsNumber() {
        if (this._parents == null) {
            return 0;
        }
        return this._parents.size();
    }

    public void addChild(EquBoolStdNode an) {
        if (this._children == null) {
            this._children = new ArrayList<EquBoolStdNode>();
        }
        this._children.add(an);
    }

    public List<EquBoolStdNode> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<EquBoolStdNode>();
        }
        return this._children;
    }

    public List<String> getChildrenNames() {
        if (this._children == null) {
            this._children = new ArrayList<EquBoolStdNode>();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (EquBoolStdNode child : this._children) {
            names.add(child.getName());
        }
        return names;
    }

    public int getChildrenNumber() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public void printLeaf(Appendable out, boolean bigtree) throws IOException {
        boolean write = false;
        if (this._attributes != null) {
            for (Map.Entry<String, String> attr : this._attributes.entrySet()) {
                String key = attr.getKey();
                if (key.startsWith("#")) {
                    if (!key.equals("#Law")) continue;
                    out.append("law ");
                    out.append(this.getName());
                    out.append(" ");
                    out.append(attr.getValue());
                    out.append(";\n");
                    write = true;
                    continue;
                }
                out.append("attribute set ");
                out.append(key);
                out.append(" ");
                out.append(this.getName());
                out.append(" \"");
                out.append(attr.getValue());
                out.append("\" ;\n");
                write = true;
            }
        }
        if (!write && bigtree) {
            out.append("/* leaf : ");
            out.append(this.getName());
            out.append(" */\n");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.printNode(sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public void printNode(Appendable out) throws IOException {
        switch (this._type) {
            case VAR: {
                out.append(this._name);
                break;
            }
            case TRUE: {
                out.append("1");
                break;
            }
            case FALSE: {
                out.append("0");
                break;
            }
            case AND: 
            case OR: 
            case XOR: 
            case IFF: 
            case IMPLY: 
            case IMPLIED: {
                out.append("( ");
                Iterator<EquBoolStdNode> i = this._children.iterator();
                while (i.hasNext()) {
                    EquBoolStdNode node = i.next();
                    node.printNode(out);
                    if (!i.hasNext()) continue;
                    out.append(" " + this._name + " ");
                }
                out.append(" )");
                break;
            }
            case ITE: {
                Iterator<EquBoolStdNode> i = this._children.iterator();
                out.append("( ");
                i.next().printNode(out);
                out.append(" ? ");
                i.next().printNode(out);
                out.append(" : ");
                i.next().printNode(out);
                out.append(" )");
                break;
            }
            case KOfN: {
                out.append("@(");
                String atLeast = this.getAttribute("#AtLeast");
                if (atLeast == null) {
                    out.append("0");
                } else {
                    out.append(atLeast);
                }
                out.append(", [");
                Iterator<EquBoolStdNode> i = this._children.iterator();
                while (i.hasNext()) {
                    EquBoolStdNode node = i.next();
                    node.printNode(out);
                    if (!i.hasNext()) continue;
                    out.append(", ");
                }
                out.append("] )");
                break;
            }
            case CARD: {
                out.append("#(");
                String atLeast = this.getAttribute("#AtLeast");
                if (atLeast == null) {
                    out.append("0");
                } else {
                    out.append(atLeast);
                }
                out.append(", ");
                String atMost = this.getAttribute("#AtMost");
                if (atLeast == null) {
                    out.append("0");
                } else {
                    out.append(atMost);
                }
                out.append(", [");
                Iterator<EquBoolStdNode> i = this._children.iterator();
                while (i.hasNext()) {
                    EquBoolStdNode node = i.next();
                    node.printNode(out);
                    if (!i.hasNext()) continue;
                    out.append(", ");
                }
                out.append("] )");
                break;
            }
            case EXISTS: 
            case FORALL: 
            case COF: {
                out.append(this._name);
                out.append(" ");
                int cpt = 1;
                int nbr = this._children.size();
                Iterator<EquBoolStdNode> i = this._children.iterator();
                while (i.hasNext()) {
                    i.next().printNode(out);
                    out.append(cpt++ < nbr - 1 ? ", " : " ");
                }
                break;
            }
            case NOT: {
                Iterator<EquBoolStdNode> i = this._children.iterator();
                out.append("-");
                i.next().printNode(out);
            }
        }
    }

    public boolean applyActionR(Function f, Object userData) {
        if (!f.onGo(this, userData)) {
            return false;
        }
        if (f.stopRecurse) {
            f.stopRecurse = false;
            return true;
        }
        if (this.isLeaf()) {
            return true;
        }
        for (EquBoolStdNode child : this._children) {
            child.applyActionR(f, userData);
        }
        return f.onReturn(this, userData);
    }

    public abstract class Function {
        public boolean stopRecurse = false;

        public boolean onGo(EquBoolStdNode node, Object userData) {
            return true;
        }

        public boolean onReturn(EquBoolStdNode node, Object userData) {
            return true;
        }
    }
}

