/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.fmea.io.FmeaXMLReader;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.xml.sax.InputSource;

public abstract class DBAbstractFMEA
extends DBWrap {
    private static final Logger _LOG = Logger.getLogger(DBAbstractFMEA.class.getPackage().getName());
    Fmea _fmea;
    public static final String PROP_XMLFMEA_COMPRESS = "cecilia.migration.db51to60.FMEAXmlIsCompressed";

    public DBAbstractFMEA(DBFolder folder) {
        super(folder);
    }

    protected void copy(DBWrap src, CECFactory cecFactory) {
        super.copy(src);
        if (src instanceof DBAbstractFMEA) {
            DBAbstractFMEA srcFMEA = (DBAbstractFMEA)src;
            try {
                StringWriter iwriter = new StringWriter();
                DBObjectXmlUtility.appendXMLHeader(iwriter);
                srcFMEA.toXML(iwriter);
                this.readXml(cecFactory, new ByteArrayInputStream(iwriter.toString().getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                _LOG.log(Level.SEVERE, "Probl\u00e8me lors de la copie de la partie FMEA ...", e);
            }
        }
    }

    protected abstract void toXML(Appendable var1) throws IOException;

    public Fmea getFMEA() {
        return this._fmea;
    }

    @Override
    public boolean isModified() {
        if (this._fmea != null && this._fmea.getChangeNotifier().isOwnerChanged()) {
            return true;
        }
        return super.isModified();
    }

    @Override
    public void setModified(boolean value) {
        super.setModified(value);
        if (this._fmea != null) {
            this._fmea.getChangeNotifier().setChanged(value);
        }
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        return null;
    }

    @Override
    protected boolean readFromDBObjModel(DBObjModel model, CECFactory cecFactory, DBLogs.DBLogsManager logMng) {
        String format = model.getFormat();
        if ("XML".equals(format) || "ZML".equals(format)) {
            InputStream istream = cecFactory.createObjModelDAO().getBinaryStream(model);
            if (istream == null) {
                logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.getString("MSG_ERR_DBMOD_READ"));
                return false;
            }
            if ("ZML".equals(format) || Boolean.getBoolean(PROP_XMLFMEA_COMPRESS)) {
                istream = new InflaterInputStream(istream, new Inflater());
            }
            return this.readXml(cecFactory, istream);
        }
        logMng.addLog(DBLogs.DBLevel.ERROR, ResMsgCore.msgFormat("MSG_ERR_DBMOD_FORMAT", this.getNature(), format));
        return false;
    }

    protected void appendXmlHeadFile(Appendable buf) throws IOException {
        String line;
        buf.append("<?xml version=\"1.0\"?>\n");
        buf.append("<!DOCTYPE FMEA \n");
        buf.append("[\n");
        URL propertiesURL = ClassLoader.getSystemClassLoader().getResource("com/dassault/cecilia/dbobj/fmea/resources/fmea.dtd");
        BufferedReader dtd = new BufferedReader(new InputStreamReader(propertiesURL.openStream(), StandardCharsets.UTF_8));
        while ((line = dtd.readLine()) != null) {
            buf.append(line + "\n");
        }
        dtd.close();
        buf.append("]\n");
        buf.append(">\n");
    }

    boolean readXml(CECFactory cecFactory, InputStream ... streams) {
        this._fmea = null;
        try {
            StringBuilder buffer = new StringBuilder();
            this.appendXmlHeadFile(buffer);
            buffer.append("<FMEA>\n");
            for (int i = 0; i < streams.length; ++i) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(streams[i], StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("<?xml") || line.endsWith("FMEA_TABLE>")) continue;
                    buffer.append(line).append("\n");
                }
                reader.close();
            }
            buffer.append("</FMEA>\n");
            InputSource source = new InputSource(new ByteArrayInputStream(buffer.toString().getBytes(StandardCharsets.UTF_8)));
            this._fmea = new FmeaXMLReader(cecFactory).read(source);
        }
        catch (Exception e) {
            _LOG.log(Level.SEVERE, "Exception lors de la lecture du flux XML d'une FMEA", e);
        }
        return this._fmea != null;
    }
}

