/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.fmea.DBAbstractFMEA;
import com.dassault.cecilia.dbobj.fmea.model.DBIdentifier;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaModelDescriptor;
import java.io.IOException;
import java.util.logging.Logger;

public class DBModelFMEA
extends DBAbstractFMEA {
    private static final Logger _LOG = Logger.getLogger(DBModelFMEA.class.getPackage().getName());
    FmeaModelDescriptor _desc;

    @Override
    protected Logger getJavaLog() {
        return _LOG;
    }

    public DBModelFMEA(DBFolder folder) {
        super(folder);
        this._desc = new FmeaModelDescriptor(new DBIdentifier(folder.getID(), folder.getParent().getName()));
        this._desc.setDescription(folder.getDescription());
        this._fmea = new Fmea();
    }

    @Override
    public DBFolder.Family getFamily() {
        return DBFolder.Family.FMEA_MODEL;
    }

    @Override
    protected String getNature() {
        return "fmea.model";
    }

    @Override
    public DBModelFMEA getCopy() {
        throw new RuntimeException();
    }

    public DBModelFMEA getCopy(CECFactory cecFactory) {
        DBModelFMEA dest = new DBModelFMEA(this.getDBFolder());
        dest.copy(this, cecFactory);
        return dest;
    }

    public FmeaModelDescriptor getModelFMEADescription() {
        return this._desc;
    }

    @Override
    protected void toXML(Appendable out, String indent) throws IOException {
        this._fmea.getModel().addInternalAttribute("ID", this._desc.getIdent().getName());
        this._fmea.getModel().addInternalAttribute("COMMENT", this._desc.getDescription());
        this._fmea.getModel().toXML(out, indent);
    }

    @Override
    protected void toXML(Appendable out) throws IOException {
        this.toXML(out, "");
    }
}

