/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Messages {
    public static final String RESOURCES = Messages.class.getPackage().getName() + ".messages";
    private static Logger _LOG = Logger.getLogger(Messages.class.getPackage().getName());
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(RESOURCES);

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String msgFormat(String idPattern, Object ... arguments) {
        String msgPattern = Messages.getString(idPattern);
        try {
            return MessageFormat.format(msgPattern, arguments);
        }
        catch (Throwable thrown) {
            StringBuffer sb = new StringBuffer(256);
            sb.append("Error during MessageFormat.format(");
            sb.append("\"").append(msgPattern).append("\"");
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(", ").append(arguments[i]);
            }
            sb.append(") <= ").append(idPattern);
            _LOG.log(Level.WARNING, sb.toString(), thrown);
            return msgPattern;
        }
    }
}

