/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJava;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugModel;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.fmea.DBTableFMEA;
import com.dassault.cecilia.dbobj.fmea.gui.DBTableFMEAOutputOptions;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaDBTable;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTablePanel;
import com.dassault.cecilia.dbobj.fmea.io.FmeaOutput;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapFrameEdit;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlg;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlgWithVirtual;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.folders.ProjectFolderCreateTreeVersionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class DBTableFMEAFrameEdit
extends DBWrapFrameEdit
implements PlugModel {
    private static final Logger _LOG = Logger.getLogger(DBTableFMEAFrameEdit.class.getPackage().getName());
    FmeaTablePanel _ctrlFMEA;

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_FMEA_MODELS");
    }

    @Override
    public DBTableFMEA getDBWrap() {
        return (DBTableFMEA)super.getDBWrap();
    }

    public DBTableFMEAFrameEdit(DBTableFMEA dbFMEA, CeciliaAppl appl) {
        super(dbFMEA.getCopy(appl.getDAOFactory()), appl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createCenterPanel(), "Center");
        this.getContentPane().add(this.createAndPlugLogsButtonAt(this.createSaveAndClosePanel()), "South");
        this.setJMenuBar(this._ctrlFMEA.createMenubar());
        this.pack();
        this.setSize(800, 500);
        this.refreshControl();
        this.setModified(false);
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this.getDBWrap().isModified();
    }

    @Override
    public void setModified(boolean value) {
        this.getDBWrap().setModified(value);
        super.setModified(value);
    }

    @Override
    protected void refreshControl() {
        this._ctrlFMEA.open(this.getDBWrap());
        this._ctrlFMEA.updateUI();
    }

    private Component createCenterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add(this.createFMEACtrl(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        return result;
    }

    protected Component createFMEACtrl() {
        this._ctrlFMEA = new FmeaTablePanel(this.getApplication());
        return this._ctrlFMEA;
    }

    @Override
    protected void toDoWhenActivated() {
        this.getApplication().getTopWindow().setEnabledAction("PRINT", true);
        super.toDoWhenActivated();
    }

    @Override
    protected void toDoWhenDeActivated() {
        this.getApplication().getTopWindow().setEnabledAction("PRINT", false);
        super.toDoWhenDeActivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean print() {
        PageFormat format = this.getApplication().getPageFormat();
        PrinterJob job = PrinterJob.getPrinterJob();
        FmeaOutput output = new FmeaOutput(this.getDBFolder(), (FmeaDBTable)this._ctrlFMEA.getFmeaTable(), new DBTableFMEAOutputOptions(this.getApplication().getPreferencies()));
        try (SrbInputStream scribe = new SrbInputStream("");){
            output.exportFormatScribe(scribe);
        }
        ListProcessorJava pageable = new ListProcessorJava(scribe);
        pageable.processScribeFile();
        pageable.computePageCount(format);
        job.setPageable(pageable);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                _LOG.log(Level.FINE, "Probleme d'impression de la table d'AMDEC : " + this.getDBFolder(), e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModel getModel(String key) {
        JChooserFileUtility.Type type = ExpBookUtility.convertModelKey(key);
        if (type != null) {
            StringBuilder defaultName = new StringBuilder();
            defaultName.append("FMEA_").append(this.getDBFolder().getParent().getName()).append("_").append(this.getDBFolder().getName());
            File file = ExpBookUtility.selectFile(type, this.getApplication().getPlugable(), this, this.getDBFolder(), defaultName.toString());
            if (file != null) {
                FmeaOutput output = new FmeaOutput(this.getDBFolder(), (FmeaDBTable)this._ctrlFMEA.getFmeaTable(), new DBTableFMEAOutputOptions(this.getApplication().getPreferencies()));
                try {
                    output.exportXMLDocBook(file);
                    IModel.DefaultModel defaultModel = new IModel.DefaultModel(key, file);
                    return defaultModel;
                }
                catch (Exception e) {
                    _LOG.log(Level.FINE, "Probleme lors de l'export de la table d'AMDEC : " + this.getDBFolder(), e);
                }
            }
        }
        return null;
    }

    @Override
    public String getInfo(String key) {
        return null;
    }

    @Override
    protected DBWrapSaveAsDlg saveAsPrepareDialog() {
        return new DBWrapSaveAsDlgWithVirtual(JOptionCecilia.getWindowOf(this), this.getApplication(), this.getDBFolder().getFamily()){

            @Override
            protected DBFolderPropertiesPanel createVersionPanel() {
                return new ProjectFolderCreateTreeVersionPanel();
            }
        };
    }

    @Override
    protected DBFolder[] saveAsPrepareFolders(DBWrapSaveAsDlg dlg) {
        if (!dlg.isVersionCreation()) {
            return DBFactory.createModel(dlg.getSelectFolder(), this.getApplication().getDBUser(), dlg.getNewName(), "1.0", this.getDBFolder().getFamily(), this.getDBFolder().getFamilyFlag(), (short)0);
        }
        return super.saveAsPrepareFolders(dlg);
    }

    @Override
    protected boolean withUpdateEdit() {
        return true;
    }

    @Override
    protected void updateEdit() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this.getDBWrap().getLogs());
        if (this.getDBWrap().update(this.getApplication().getDAOFactory(), logMng)) {
            this.refreshControl();
            this.setModified(true);
        }
        this.getDBWrap().prepareDependTimeUpdt(this.getApplication().getDAOFactory(), this.getDBWrap().getUseRelations());
        this.updateLogs(this.getDBWrap().getUseRelations(), oldLevel, oldNbr);
    }
}

