/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTableRenderer;
import com.dassault.cecilia.dbobj.fmea.ihm.Head;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReferenceTableModel;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaExternalRefAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FmeaPrintablePage
implements Printable,
Pageable {
    private Head _head;
    private FmeaTable _table;
    private PageFormat _pf;
    private Integer _pageCount;
    private Integer _tablePageCount;
    private Integer _externRefPageCount;
    List<Point> _externRefAttr = new ArrayList<Point>();
    Map<Integer, Integer> _externRefAttrIndexes = new HashMap<Integer, Integer>();
    private Font f1 = new Font("Helvetica", 1, 16);
    private Font f2 = new Font("Helvetica", 0, 14);
    private int h1 = 10;
    protected CellRendererPane _rendererPaneHeader;
    protected FmeaTableRenderer _tableRenderer;

    FmeaPrintablePage(FmeaTable table, Head head, PageFormat pf) {
        this._head = head;
        this._table = table;
        this._pf = pf;
        this._rendererPaneHeader = new CellRendererPane();
        table.getTableHeader().add(this._rendererPaneHeader);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g = (Graphics2D)graphics;
        float w = 0.5f;
        BasicStroke stroke = new BasicStroke(w);
        g.setStroke(stroke);
        if (pageIndex < this._tablePageCount) {
            return this.printFmeaTable(graphics, pageFormat, pageIndex);
        }
        if (pageIndex < this._pageCount) {
            return this.printExternalAttributeRef(graphics, pageIndex);
        }
        return 1;
    }

    private int printFmeaTable(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g = (Graphics2D)graphics;
        int firstRow = this.computeFirstRow(pageIndex);
        if (firstRow == -1) {
            return 1;
        }
        int lastRow = this.computeLastRow(pageIndex, firstRow);
        this._tableRenderer = new FmeaTableRenderer(this._table, firstRow, lastRow);
        this.paint(g);
        return 0;
    }

    private void printHead(Graphics g) {
        TableColumnModel cModel;
        int h;
        Head.MyTableHeader header;
        int i;
        this._head.setPrinting(true);
        int y = 0;
        for (i = 0; i < this._head.getRowCount(); ++i) {
            header = (Head.MyTableHeader)this._head.getRow(i).getColumnHeader().getView();
            g.drawLine(0, y, header.getWidth() - 2, y);
            h = header.getPreferredSize().height;
            cModel = header.getColumnModel();
            int x = 0;
            for (int c = 0; c < cModel.getColumnCount(); ++c) {
                g.drawLine(x, y, x, y + h);
                x += cModel.getColumn(c).getWidth();
            }
            g.drawLine(x - 2, y, x - 2, y + h);
            y += h;
        }
        y = 0;
        for (i = 0; i < this._head.getRowCount(); ++i) {
            header = (Head.MyTableHeader)this._head.getRow(i).getColumnHeader().getView();
            h = header.getPreferredSize().height;
            cModel = header.getColumnModel();
            for (int c = 0; c < cModel.getColumnCount(); ++c) {
                Component component = this.getHeaderRenderer(header, c);
                Rectangle r = header.getHeaderRect(c);
                r.translate(0, y);
                int m = 3;
                this._rendererPaneHeader.paintComponent(g, component, header, r.x + m, r.y + m, r.width - m * 2, r.height - m * 2, true);
            }
            y += h;
        }
        this._rendererPaneHeader.removeAll();
        this._head.setPrinting(false);
    }

    private Component getHeaderRenderer(JTableHeader header, int columnIndex) {
        TableColumn aColumn = header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private void paint(Graphics2D g) {
        g.translate(this._pf.getImageableX() + 1.0, this._pf.getImageableY());
        this.printHead(g);
        g.translate(0, this._head.getHeight());
        this._tableRenderer.paint(g);
    }

    private int printExternalAttributeRef(Graphics graphics, int pageIndex) throws PrinterException {
        Graphics2D g = (Graphics2D)graphics;
        g.translate(this._pf.getImageableX() + 1.0, this._pf.getImageableY());
        int h = this._table.getFontMetrics(this.f1).getHeight();
        g.translate(0, h);
        String title = Messages.getString("FmeaPrintablePage.4") + "(" + (pageIndex + 1 - this._tablePageCount) + "/" + this._externRefPageCount + ")";
        int w = this._table.getFontMetrics(this.f1).stringWidth(title);
        int x = (int)this._pf.getImageableWidth() / 2 - w / 2;
        g.setFont(this.f1);
        g.drawString(title, x, 0);
        h = this._table.getFontMetrics(this.f2).getHeight();
        int firstIdx = this._externRefAttrIndexes.get(pageIndex - this._tablePageCount);
        int lastIdx = pageIndex == this._pageCount - 1 ? this._externRefAttr.size() : this._externRefAttrIndexes.get(pageIndex + 1 - this._tablePageCount).intValue();
        for (int i = firstIdx; i < lastIdx; ++i) {
            Point p = this._externRefAttr.get(i);
            int row = p.x;
            int col = p.y;
            this.printExternalAttributeRef(g, row, col);
        }
        return 0;
    }

    private void printExternalAttributeRef(Graphics graphics, int row, int col) {
        FmeaTableModel model = this._table.getFmeaTableModel();
        FmeaColumnDefinition colDef = model.getColumnDefinition(col);
        FmeaExternalRefAttribute attribute = (FmeaExternalRefAttribute)model.getAttributeAt(row, col);
        FmeaEntity entity = model.getEntityAt(row, col);
        Graphics2D g = (Graphics2D)graphics;
        g.setFont(this.f2);
        int h = this._table.getFontMetrics(this.f2).getHeight();
        int x = 0;
        g.translate(x, h);
        g.translate(x, h);
        Object line = Messages.getString("FmeaPrintablePage.5") + colDef.getName();
        g.drawString((String)line, x, 0);
        g.translate(x, h);
        line = Messages.getString("FmeaPrintablePage.6") + attribute.getValue().toString();
        g.drawString((String)line, x, 0);
        g.translate(x, h);
        line = Messages.getString("FmeaPrintablePage.7") + colDef.getEntityDefinition().getName() + "." + entity.getName();
        g.drawString((String)line, x, 0);
        g.translate(x, h);
        line = Messages.getString("FmeaPrintablePage.9") + colDef.getAttributeDefinition().getName();
        g.drawString((String)line, x, 0);
        g.translate(x, h);
        line = Messages.getString("FmeaPrintablePage.10");
        g.drawString((String)line, x, 0);
        Collection<ExternalFmeaReference> refs = attribute.getExternalReferences();
        JFrame frame = new JFrame();
        JTable tbl = this.getExternalReferenceTable(frame, refs);
        FmeaTableRenderer renderer = new FmeaTableRenderer(tbl, 0, tbl.getRowCount() - 1);
        g.translate(x, this.h1);
        renderer.paint(g);
        h = tbl.getTableHeader().getPreferredSize().height;
        g.translate(x, h += tbl.getPreferredScrollableViewportSize().height);
        frame.getContentPane().removeAll();
        frame.dispose();
    }

    private JTable getExternalReferenceTable(JFrame frame, Collection<ExternalFmeaReference> refs) {
        JTable tbl = new JTable();
        tbl.setModel(new ExternalFmeaReferenceTableModel());
        tbl.setAutoResizeMode(0);
        tbl.getTableHeader().setBackground(Color.WHITE);
        tbl.setGridColor(Color.BLACK);
        MyTableHeaderRenderer r = new MyTableHeaderRenderer();
        JTableHeader tableHeader = tbl.getTableHeader();
        TableColumnModel cm = tableHeader.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            cm.getColumn(column).setHeaderRenderer(r);
        }
        JScrollPane scpane = new JScrollPane(tbl);
        scpane.setHorizontalScrollBarPolicy(31);
        scpane.setVerticalScrollBarPolicy(21);
        scpane.setBorder(new EmptyBorder(0, 0, 0, 0));
        scpane.getViewport().setBackground(Color.WHITE);
        ExternalFmeaReferenceTableModel mdl = (ExternalFmeaReferenceTableModel)tbl.getModel();
        mdl.setReferences(new ArrayList<ExternalFmeaReference>(refs));
        this.resizeTableToContent(tbl);
        frame.getContentPane().add(scpane);
        frame.pack();
        return tbl;
    }

    private void resizeTableToContent(JTable table) {
        FontMetrics fm = table.getFontMetrics(table.getFont());
        int totalW = 0;
        for (int col = 0; col < table.getColumnCount(); ++col) {
            TableColumn tableCol = table.getColumnModel().getColumn(col);
            int w = fm.stringWidth(tableCol.getHeaderValue().toString()) + 10;
            for (int row = 0; row < table.getRowCount(); ++row) {
                w = Math.max(w, fm.stringWidth(table.getValueAt(row, col).toString()) + 10);
            }
            tableCol.setPreferredWidth(w);
            totalW += w;
        }
        if (totalW != 0) {
            int h = 0;
            int row = 0;
            while (row < table.getRowCount()) {
                ++row;
                h += table.getRowHeight();
            }
            Dimension dim = new Dimension(totalW, h);
            table.setPreferredScrollableViewportSize(dim);
        }
    }

    private int getExternalReferencePageCount() {
        if (this._externRefPageCount != null) {
            return this._externRefPageCount;
        }
        FmeaTableModel model = this._table.getFmeaTableModel();
        for (int row = 0; row < this._table.getRowCount(); ++row) {
            for (int col = 0; col < this._table.getColumnCount(); ++col) {
                int mdlCol = this._table.convertColumnIndexToModel(col);
                int mdlRow = this._table.convertRowIndexToFmeaModel(row);
                FmeaAttribute attribute = model.getAttributeAt(mdlRow, mdlCol);
                if (!(attribute instanceof FmeaExternalRefAttribute)) continue;
                this._externRefAttr.add(new Point(mdlRow, mdlCol));
            }
        }
        int offset = this._head.getHeight() + this._table.getTableHeader().getHeight();
        int availableHeight = (int)this._pf.getImageableHeight() - offset;
        int h0 = this._table.getFontMetrics(this.f1).getHeight();
        availableHeight -= h0;
        JFrame frame = new JFrame();
        int pageNo = 0;
        int i = 0;
        while (i < this._externRefAttr.size()) {
            this._externRefAttrIndexes.put(pageNo, i);
            int H = h0;
            while (i < this._externRefAttr.size()) {
                Point p = this._externRefAttr.get(i);
                int row = p.x;
                int col = p.y;
                FmeaExternalRefAttribute attribute = (FmeaExternalRefAttribute)model.getAttributeAt(row, col);
                if ((H += this.getExternalReferenceHeight(attribute, frame)) > availableHeight) break;
                ++i;
            }
            ++pageNo;
        }
        frame.dispose();
        this._externRefPageCount = this._externRefAttr.size() == 0 ? 0 : pageNo;
        return this._externRefPageCount;
    }

    private int getExternalReferenceHeight(FmeaExternalRefAttribute attribute, JFrame frame) {
        int h = this._table.getFontMetrics(this.f2).getHeight();
        h *= 6;
        h += this.h1;
        Collection<ExternalFmeaReference> refs = attribute.getExternalReferences();
        JTable tbl = this.getExternalReferenceTable(frame, refs);
        h += tbl.getTableHeader().getPreferredSize().height;
        frame.getContentPane().removeAll();
        return h += tbl.getPreferredScrollableViewportSize().height;
    }

    private int computeFirstRow(int pg) {
        int offset = this._head.getHeight() + this._table.getTableHeader().getHeight();
        int availableHeight = (int)this._pf.getImageableHeight() - offset;
        int row = 0;
        for (int no = 0; no < pg; ++no) {
            int height = this._table.getRowHeight(row);
            while (height < availableHeight) {
                if (row >= this._table.getRowCount()) {
                    return -1;
                }
                height += this._table.getRowHeight(row);
                ++row;
            }
        }
        return row;
    }

    private int computeLastRow(int pg, int firstRow) {
        if (firstRow == -1) {
            return -1;
        }
        if (this._table.getRowCount() == 1) {
            return 0;
        }
        int offset = this._head.getHeight() + this._table.getTableHeader().getHeight();
        int availableHeight = (int)this._pf.getImageableHeight() - offset;
        int row = firstRow;
        for (int height = this._table.getRowHeight(row); row < this._table.getRowCount() && height < availableHeight; height += this._table.getRowHeight(row), ++row) {
        }
        return row - 1;
    }

    @Override
    public int getNumberOfPages() {
        if (this._pageCount != null) {
            return this._pageCount;
        }
        int offset = this._head.getHeight() + this._table.getTableHeader().getHeight();
        int availableHeight = (int)this._pf.getImageableHeight() - offset;
        int pgCount = 0;
        int row = 0;
        while (row < this._table.getRowCount()) {
            ++pgCount;
            for (int height = this._table.getRowHeight(row); row < this._table.getRowCount() && height < availableHeight; height += this._table.getRowHeight(row), ++row) {
            }
        }
        this._tablePageCount = pgCount;
        this._pageCount = pgCount += this.getExternalReferencePageCount();
        return this._pageCount;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this._pf;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent component = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setBorder(new LineBorder(Color.black){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Color oldColor = g.getColor();
                    g.setColor(this.lineColor);
                    for (int i = 0; i < this.thickness; ++i) {
                        g.drawLine(x + i, y + i, x + width - i - 1, y + i);
                        g.drawLine(x + i, y + height - i - 1, x + width - i - 1, y + height - i - 1);
                        g.drawLine(x + width - i - 1, y + i, x + width - i - 1, y + height - i - 1);
                    }
                    g.setColor(oldColor);
                }
            });
            return component;
        }
    }
}

