/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm;

import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.ihm.FmeaTable;
import com.dassault.cecilia.dbobj.fmea.ihm.Head;
import com.dassault.cecilia.dbobj.fmea.ihm.PrintPreviewPage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class FmeaTableView
extends JPanel {
    private FmeaTable _table;
    private Head _head;
    private JScrollPane _viewScPane = new JScrollPane();
    private JPanel _view = new JPanel(new GridBagLayout());
    private PageFormat _pageFormat = PrinterJob.getPrinterJob().defaultPage();
    private PrintPreviewPage _previewPage;
    private JPanel _scrolledView = new JPanel(new GridBagLayout());
    private JScrollPane _printPreviewScPane = new JScrollPane(this._scrolledView);
    private JPanel _printPreview = new JPanel(new GridBagLayout());
    private JScrollBar _scrollbar = new JScrollBar();
    private JPopupMenu _popup = new JPopupMenu();
    private JMenuItem _item = new JMenuItem();
    boolean _printing = false;

    public FmeaTableView() {
        this.init();
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
    }

    public void setData(FmeaTable table, Head head) {
        this.clear();
        this._table = table;
        this._head = head;
        this._pageFormat = this._pageFormat == null ? PrinterJob.getPrinterJob().defaultPage() : this._pageFormat;
        this.buildView();
        this.buildPrintPreview();
        this.add((Component)this._view, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._printPreview, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setPrintPreviewActive(false);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void setHead(Head editedHead, boolean initDone) {
        this.inactivePrintPreview();
        this._head = editedHead;
        this._previewPage = new PrintPreviewPage(this._head, this._table, this._pageFormat, true);
        this._scrolledView.removeAll();
        this._scrolledView.add((Component)this._previewPage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(50, 50, 50, 50), 0, 0));
        this.setPrintPreviewActive(true);
        this.setPrintPreviewActive(false);
    }

    public void setViewVisible(boolean visible) {
        this._view.setVisible(visible);
    }

    public void setPrintPreviewVisible(boolean visible) {
        this._printPreviewScPane.setVisible(visible);
        this._previewPage.setVisible(visible);
        this._scrollbar.setVisible(visible);
    }

    private void buildView() {
        this._view.removeAll();
        this._view.add((Component)this._viewScPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void buildPrintPreview() {
        this._previewPage = new PrintPreviewPage(this._head, this._table, this._pageFormat, false);
        this._scrolledView.removeAll();
        this._scrolledView.add((Component)this._previewPage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(50, 50, 50, 50), 0, 0));
        this._printPreviewScPane.setVerticalScrollBarPolicy(21);
        this._printPreview.removeAll();
        this._printPreview.add((Component)this._printPreviewScPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._printPreview.add((Component)this._scrollbar, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this._popup.add(this._item);
        this._scrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                int h2 = FmeaTableView.this._scrolledView.getPreferredSize().height;
                int h1 = FmeaTableView.this._printPreviewScPane.getViewport().getBounds().height;
                int diff = h2 - h1;
                int page = diff >= 0 ? e.getValue() / diff + 1 : e.getValue();
                if (diff >= 0) {
                    int y = e.getValue() - diff * (page - 1);
                    JViewport viewport = FmeaTableView.this._printPreviewScPane.getViewport();
                    viewport.setViewPosition(new Point(viewport.getViewPosition().x, y));
                }
                FmeaTableView.this._item.setText(Messages.getString("FmeaTableView.0") + " " + page);
                FmeaTableView.this._previewPage.setPage(page);
                FmeaTableView.this.repaint();
            }
        });
        this._scrollbar.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                FmeaTableView.this._popup.show(FmeaTableView.this, FmeaTableView.this._scrollbar.getLocation().x - FmeaTableView.this._popup.getPreferredSize().width, FmeaTableView.this._scrollbar.getLocation().y);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FmeaTableView.this._popup.setVisible(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this._scrollbar.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                FmeaTableView.this.setScrollbarValues(FmeaTableView.this._scrolledView.getPreferredSize().height, FmeaTableView.this._printPreviewScPane.getViewport().getBounds().height, FmeaTableView.this._previewPage.getPageCount());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public void clear() {
        this._scrolledView.removeAll();
        this.removeAll();
        this._pageFormat = PrinterJob.getPrinterJob().defaultPage();
        this._head = null;
        this._table = null;
    }

    public boolean isPreviewPageActive() {
        return this._previewPage != null ? this._previewPage.isVisible() : false;
    }

    public void setPrintPreviewActive(boolean active) {
        if (!active) {
            this.inactivePrintPreview();
        } else {
            this.activePrintPreview();
        }
    }

    private void activePrintPreview() {
        this._table.setPrinting(true);
        this.setViewVisible(false);
        this.setPrintPreviewVisible(true);
        this.revalidate();
        this._printPreviewScPane.revalidate();
        this._scrolledView.revalidate();
        this.setScrollbarValues(this._scrolledView.getPreferredSize().height, this._printPreviewScPane.getViewport().getBounds().height, this._previewPage.getPageCount());
        this._printPreviewScPane.revalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    private void inactivePrintPreview() {
        this._table.setPrinting(false);
        this._viewScPane.setViewportView(this._table);
        this.setViewVisible(true);
        this.setPrintPreviewVisible(false);
        this.revalidate();
        this.repaint();
    }

    public PageFormat getPageFormat() {
        return this._pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this._pageFormat = pageFormat;
        if (!this.isPreviewPageActive()) {
            return;
        }
        this._previewPage.setFormat(pageFormat);
        this._printPreviewScPane.revalidate();
        this._scrolledView.revalidate();
        this.setScrollbarValues(this._scrolledView.getPreferredSize().height, this._printPreviewScPane.getViewport().getBounds().height, this._previewPage.getPageCount());
    }

    public void setScrollbarValues(int scrolledViewHeight, int scrollViewHeight, int pageCount) {
        int h2 = scrolledViewHeight;
        int h1 = scrollViewHeight;
        int diff = h2 - h1;
        if (diff >= 0) {
            int extents = h1;
            int max = h1 + diff * pageCount - 1;
            this._scrollbar.setValues(0, extents, 0, max);
        } else {
            this._scrollbar.setValues(1, 1, 1, pageCount + 1);
        }
    }

    public static void main(String[] args) {
    }
}

