/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.dialog;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DictionnaryDlg
extends JDialog {
    private boolean _create = false;
    private boolean _canceled = true;
    private boolean _writeAccess = true;
    private Collection _names = new HashSet();
    Comparator _comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Map.Entry)o1).getKey().toString().compareToIgnoreCase(((Map.Entry)o2).getKey().toString());
        }
    };
    private EntryTableModel _dataModel = new EntryTableModel();
    JLabel _lname = new JLabel(Messages.getString("DictionnaryDlg.3") + ":");
    JLabel _ldesc = new JLabel(Messages.getString("DictionnaryDlg.5") + ":");
    JTextField _tfName = new JTextField();
    JTextArea _taDesc = new JTextArea(3, 10);
    JTable _tbl = new JTable(this._dataModel);
    JButton _bAdd = new JButton(Messages.getString("DictionnaryDlg.7"));
    JButton _bEdit = new JButton(Messages.getString("DictionnaryDlg.8"));
    JButton _bRemove = new JButton(Messages.getString("DictionnaryDlg.9"));
    JButton _bOk = new JButton(Messages.getString("DictionnaryDlg.10"));
    JButton _bCancel = new JButton(Messages.getString("DictionnaryDlg.11"));

    public DictionnaryDlg(String title, boolean create) throws HeadlessException {
        this._create = create;
        this.setTitle(title);
        this.init();
    }

    public DictionnaryDlg(Dialog owner, String title, boolean create) throws HeadlessException {
        super(owner, title);
        this._create = create;
        this.init();
    }

    @Override
    public void setName(String name) {
        this._tfName.setText(name);
    }

    public void setNames(Collection names) {
        this._names = names;
    }

    public void setDescription(String description) {
        this._taDesc.setText(description);
    }

    public void setEntries(Collection entries) {
        ArrayList lst = new ArrayList(entries);
        Collections.sort(lst, this._comparator);
        this._dataModel.setEntries(lst);
    }

    @Override
    public String getName() {
        return this._tfName.getText();
    }

    public String getDescription() {
        return this._taDesc.getText();
    }

    public Collection getEntries() {
        return new ArrayList(this._dataModel.getEntries());
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setWriteAccess(boolean b) {
        this._writeAccess = b;
        this.updateComponentStates();
    }

    public void updateComponentStates() {
        int count = this._tbl.getSelectedRowCount();
        this._tfName.setEnabled(this._writeAccess);
        this._taDesc.setEnabled(this._writeAccess);
        this._bAdd.setEnabled(this._writeAccess);
        this._bEdit.setEnabled(this._writeAccess && count != 0);
        this._bRemove.setEnabled(this._writeAccess && count != 0);
    }

    protected void init() {
        JScrollPane spTa = new JScrollPane(this._taDesc);
        Dimension d = new Dimension(0, this._taDesc.getPreferredSize().height + 4);
        spTa.setMaximumSize(d);
        spTa.setMinimumSize(d);
        spTa.setPreferredSize(d);
        JScrollPane spTbl = new JScrollPane(this._tbl);
        spTbl.setPreferredSize(new Dimension(300, 200));
        d = this._bCancel.getPreferredSize();
        this._bOk.setPreferredSize(d);
        this._bCancel.setPreferredSize(d);
        this.updateComponentStates();
        JPanel pnl = new JPanel(new GridBagLayout());
        JPanel bPnl = new JPanel(new GridBagLayout());
        bPnl.add((Component)this._bAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        bPnl.add((Component)this._bEdit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        bPnl.add((Component)this._bRemove, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel bottomPnl = new JPanel(new GridBagLayout());
        bottomPnl.add((Component)this._bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        bottomPnl.add((Component)this._bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel entries = new JPanel(new GridBagLayout());
        entries.setBorder(new TitledBorder(Messages.getString("DictionnaryDlg.12")));
        entries.add((Component)spTbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        entries.add((Component)bPnl, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        pnl.add((Component)this._lname, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        pnl.add((Component)this._tfName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        pnl.add((Component)this._ldesc, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        pnl.add((Component)spTa, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        pnl.add((Component)entries, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        pnl.add((Component)bottomPnl, new GridBagConstraints(0, 4, 4, 3, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(pnl);
        this.pack();
        this.setModal(true);
        this.validate();
        this.defineListeners();
        this.setLocationRelativeTo(null);
    }

    protected void defineListeners() {
        this._bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryDlg.this.doAddEntry();
            }
        });
        this._bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryDlg.this.doEditEntry();
            }
        });
        this._bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryDlg.this.doRemoveEntries();
            }
        });
        this._bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DictionnaryDlg.this.checkFields()) {
                    DictionnaryDlg.this._canceled = false;
                    DictionnaryDlg.this.setVisible(false);
                }
            }
        });
        this._bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DictionnaryDlg.this._canceled = true;
                DictionnaryDlg.this.setVisible(false);
            }
        });
        this._tbl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DictionnaryDlg.this.updateComponentStates();
            }
        });
        this._tbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DictionnaryDlg.this._writeAccess && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    DictionnaryDlg.this.doEditEntry();
                }
            }
        });
    }

    protected boolean checkFields() {
        String name = this._tfName.getText();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("DictionnaryDlg.13"), Messages.getString("ErrorManager.2"), 0);
            return false;
        }
        if (this._create && this._names.contains(name)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("DictionnaryDlg.14"), Messages.getString("ErrorManager.2"), 0);
            return false;
        }
        return true;
    }

    protected boolean isValidName(String name) {
        return true;
    }

    private void doAddEntry() {
        final EditEntryDlg dlg = new EditEntryDlg(this, Messages.getString("DictionnaryDlg.15"), true);
        try {
            dlg.setDefaultCloseOperation(2);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return;
            }
            if (dlg.getName() == null || dlg.getName().length() == 0) {
                return;
            }
            Map.Entry entry = new Map.Entry(){

                public Object getKey() {
                    return dlg.getName();
                }

                public Object getValue() {
                    return dlg.getValue();
                }

                public Object setValue(Object value) {
                    return null;
                }
            };
            this._dataModel.addEntry(entry);
        }
        finally {
            dlg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEditEntry() {
        int row = this._tbl.getSelectedRow();
        if (row == -1) {
            return;
        }
        String name = this._dataModel.getValueAt(row, 0).toString();
        Double value = (Double)this._dataModel.getValueAt(row, 1);
        final EditEntryDlg dlg = new EditEntryDlg(this, Messages.getString("DictionnaryDlg.16"), false);
        try {
            dlg.setName(name);
            dlg.setValue(value);
            dlg.setDefaultCloseOperation(2);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return;
            }
            if (dlg.getName() == null || dlg.getName().length() == 0) {
                return;
            }
            Map.Entry entry = new Map.Entry(){

                public Object getKey() {
                    return dlg.getName();
                }

                public Object getValue() {
                    return dlg.getValue();
                }

                public Object setValue(Object val) {
                    return null;
                }
            };
            this._dataModel.modifyEntry(row, entry);
        }
        finally {
            dlg.dispose();
        }
    }

    private void doRemoveEntries() {
        this._dataModel.removeEntries(this._tbl.getSelectedRows());
    }

    private class EntryTableModel
    extends AbstractTableModel {
        List<Map.Entry> _data = new ArrayList<Map.Entry>();

        private EntryTableModel() {
        }

        public void setEntries(List data) {
            this._data = data;
            this.fireTableDataChanged();
        }

        public List getEntries() {
            return this._data;
        }

        public void addEntry(Map.Entry entry) {
            this._data.add(entry);
            Collections.sort(this._data, DictionnaryDlg.this._comparator);
            this.fireTableDataChanged();
        }

        public void removeEntries(int[] rows) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this._data.remove(rows[i]);
            }
            this.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        }

        public void modifyEntry(int row, Map.Entry entry) {
            this._data.remove(row);
            this._data.add(entry);
            Collections.sort(this._data, DictionnaryDlg.this._comparator);
            this.fireTableDataChanged();
        }

        public Object getEntryValue(String key) {
            for (Map.Entry entry : this._data) {
                if (!entry.getKey().equals(key)) continue;
                return entry.getValue();
            }
            return null;
        }

        public boolean containsKey(String key) {
            return this.getEntryValue(key) != null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Double.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Messages.getString("DictionnaryDlg.0");
                }
                case 1: {
                    return Messages.getString("DictionnaryDlg.1");
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map.Entry entry = this._data.get(row);
            switch (col) {
                case 0: {
                    return entry.getKey();
                }
                case 1: {
                    return entry.getValue();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }
    }

    private class EditEntryDlg
    extends JDialog {
        private boolean create;
        private boolean canceled;
        private JLabel lName;
        private JTextField tfName;
        private JLabel lValue;
        private JTextField tfValue;
        private JButton bOk;
        private JButton bCancel;

        EditEntryDlg(Dialog owner, String title, boolean bCreate) throws HeadlessException {
            super(owner, title);
            this.create = false;
            this.canceled = true;
            this.lName = new JLabel(Messages.getString("DictionnaryDlg.3") + ":");
            this.tfName = new JTextField();
            this.lValue = new JLabel(Messages.getString("DictionnaryDlg.1"));
            this.tfValue = new JTextField();
            this.bOk = new JButton(Messages.getString("DictionnaryDlg.10"));
            this.bCancel = new JButton(Messages.getString("DictionnaryDlg.11"));
            this.create = bCreate;
            this.setModal(true);
            Dimension d = this.bCancel.getPreferredSize();
            this.bOk.setPreferredSize(d);
            this.bCancel.setPreferredSize(d);
            JPanel bottomPnl = new JPanel(new GridBagLayout());
            bottomPnl.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            bottomPnl.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)this.lName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pnl.add((Component)this.tfName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pnl.add((Component)this.lValue, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pnl.add((Component)this.tfValue, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pnl.add((Component)bottomPnl, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add(pnl);
            this.pack();
            this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
            this.bOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditEntryDlg.this.checkFields()) {
                        EditEntryDlg.this.canceled = false;
                        EditEntryDlg.this.setVisible(false);
                    }
                }
            });
            this.bCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditEntryDlg.this.canceled = true;
                    EditEntryDlg.this.setVisible(false);
                }
            });
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        @Override
        public void setName(String name) {
            this.tfName.setText(name);
        }

        public void setValue(Double value) {
            this.tfValue.setText(String.valueOf(value));
        }

        @Override
        public String getName() {
            return this.tfName.getText();
        }

        public Object getValue() {
            return Double.valueOf(this.tfValue.getText());
        }

        protected boolean checkFields() {
            String name = this.tfName.getText();
            if (name.length() == 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("DictionnaryDlg.13"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            if (this.create && DictionnaryDlg.this._dataModel.containsKey(name)) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("DictionnaryDlg.14"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            if (this.tfValue.getText().length() == 0) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("DictionnaryDlg.24"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            try {
                Double.valueOf(this.tfValue.getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), Messages.getString("DictionnaryDlg.25"), Messages.getString("ErrorManager.2"), 0);
                return false;
            }
            return true;
        }
    }
}

