/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.dialog;

import com.dassault.cecilia.core.Util;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.fmea.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TabbedTextFileImportDlg
extends JDialog {
    private static final int COL_WIDTH = 150;
    Plugable _plugable;
    private char[] _streamData = null;
    private List _data = new ArrayList();
    private List _usedData = new ArrayList();
    private int _columnCount = 0;
    private Vector _columns = new Vector();
    private Vector _originalColumns = new Vector();
    private Vector _referenceColumns = new Vector();
    private Vector _columnRelations = new Vector();
    private boolean _canceled = true;
    private int _stepCount = 2;
    private int _step = 0;
    private JPanel _panel = new JPanel(new GridBagLayout());
    private JPanel _bPanel = new JPanel(new GridBagLayout());
    private JButton _bNext;
    private JButton _bPrevious;
    private JButton _bCancel;
    private JButton _bFinish;
    private JPanel[] _stepPanel = new JPanel[this._stepCount];
    private JPanel _currentStepPanel = null;
    private static DocumentBuilderFactory __dbf = null;

    public TabbedTextFileImportDlg(Frame owner, Plugable plugable, boolean modal) throws HeadlessException {
        super(owner, "", modal);
        this._plugable = plugable;
        this.setDefaultCloseOperation(2);
        this.updateTitle();
        this._bNext = new JButton(Messages.getString("TabbedTextFileImportDlg.1"));
        this._bPrevious = new JButton(Messages.getString("TabbedTextFileImportDlg.2"));
        this._bCancel = new JButton(Messages.getString("TabbedTextFileImportDlg.3"));
        this._bFinish = new JButton(Messages.getString("TabbedTextFileImportDlg.4"));
        this._bPanel.add((Component)this._bCancel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._bPanel.add((Component)this._bPrevious, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._bPanel.add((Component)this._bNext, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._bPanel.add((Component)this._bFinish, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._panel.add((Component)this._bPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add(this._panel);
        this.buildStepPanels();
        this.goToStep(this._step);
        this.setSize(700, 500);
        this.setResizable(true);
        this.defineListeners();
        this.updateButtonStates();
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(owner));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(File file, Vector cols, Vector referenceColumns, boolean singleEntity) {
        InputStream in = null;
        try {
            this._referenceColumns = referenceColumns;
            this._originalColumns = new Vector(cols);
            this._columns = new Vector(cols);
            in = new BufferedInputStream(new FileInputStream(file));
            CharArrayWriter w = new CharArrayWriter(0x100000);
            int c = -1;
            while ((c = in.read()) != -1) {
                w.append((char)c);
            }
            this._streamData = w.toCharArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String fileName = file.getName();
        int beginIndex = fileName.lastIndexOf(46) + 1;
        String extention = "";
        if (beginIndex != -1) {
            extention = fileName.substring(beginIndex, fileName.length());
        }
        if (extention.equalsIgnoreCase("csv")) {
            this.getStepPanel1().checkBox3.setSelected(true);
        } else {
            this.getStepPanel1().checkBox1.setSelected(true);
        }
        this.getStepPanel1().checkBox7.setEnabled(singleEntity);
        this.getStepPanel1().checkBox7.setSelected(singleEntity);
        if (singleEntity) {
            Iterator i = this._referenceColumns.iterator();
            while (i.hasNext()) {
                this._columns.remove(i.next());
            }
        }
        this._originalColumns.add(0, " ");
        this._columns.add(0, " ");
        TableColumn tableColumn = this.getStepPanel2().columnMatchTable.getColumn(this.getStepPanel2().columnMatchTable.getColumnName(1));
        JComboBox combo = (JComboBox)((DefaultCellEditor)tableColumn.getCellEditor()).getComponent();
        combo.setModel(new DefaultComboBoxModel(this._columns));
    }

    public boolean canceled() {
        return this._canceled;
    }

    public List getLines() {
        return this._usedData;
    }

    public boolean getImportEachLineAsSingleEntity() {
        return this.getStepPanel1().checkBox7.isSelected();
    }

    public Vector getColumnRelations() {
        Vector data = new Vector();
        for (Vector v : this._columnRelations) {
            Vector<Integer> v2 = new Vector<Integer>();
            String s = (String)v.get(0);
            v2.add(Integer.valueOf(s.substring(s.indexOf(32) + 1)));
            s = (String)v.get(1);
            v2.add(Integer.valueOf(s.substring(s.indexOf(32) + 1)));
            data.add(v2);
        }
        return data;
    }

    public Map<String, Integer> getColumnMatch() {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        for (Vector v : this.getStepPanel2().columnMatchData) {
            String c;
            if (v.get(1) == null || (c = (String)v.get(1)).length() == 0) continue;
            String s = (String)v.get(0);
            data.put((String)v.get(1), Integer.valueOf(s.substring(s.indexOf(32) + 1)));
        }
        return data;
    }

    protected void goToStep(int step) {
        this.updateTitle();
        if (this._currentStepPanel != null) {
            this._panel.remove(this._currentStepPanel);
        }
        this._panel.add((Component)this._stepPanel[step], new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._currentStepPanel = this._stepPanel[step];
        this.updateButtonStates();
        this._panel.revalidate();
        this._panel.repaint();
    }

    protected void buildStepPanels() {
        this._stepPanel[0] = this.buildStepPanel1();
        this._stepPanel[1] = this.buildStepPanel2();
    }

    protected JPanel buildStepPanel1() {
        return new StepPanel1();
    }

    protected JPanel buildStepPanel2() {
        return new StepPanel2();
    }

    protected StepPanel1 getStepPanel1() {
        return (StepPanel1)this._stepPanel[0];
    }

    protected StepPanel2 getStepPanel2() {
        return (StepPanel2)this._stepPanel[1];
    }

    protected void updateButtonStates() {
        this._bCancel.setEnabled(true);
        this._bPrevious.setEnabled(this._step != 0);
        this._bNext.setEnabled(this._step != 1);
        this._bFinish.setEnabled(this._step == 1);
    }

    protected void updateTitle() {
        this.setTitle(Messages.getString("TabbedTextFileImportDlg.6") + " " + this.getStepTitle());
    }

    protected String getStepTitle() {
        return Messages.getString("TabbedTextFileImportDlg.7") + " " + (this._step + 1) + " " + Messages.getString("TabbedTextFileImportDlg.8") + " " + this._stepCount;
    }

    protected void defineListeners() {
        this._bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedTextFileImportDlg.this._canceled = true;
                TabbedTextFileImportDlg.this.setVisible(false);
                TabbedTextFileImportDlg.this.dispose();
            }
        });
        this._bPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedTextFileImportDlg.this.goToStep(--TabbedTextFileImportDlg.this._step);
            }
        });
        this._bNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedTextFileImportDlg.this.goToStep(++TabbedTextFileImportDlg.this._step);
            }
        });
        this._bFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabbedTextFileImportDlg.this._canceled = false;
                TabbedTextFileImportDlg.this.setVisible(false);
                TabbedTextFileImportDlg.this.dispose();
            }
        });
    }

    protected void updatePreview(char[] fieldSeparators, boolean noTextIdentifier, char textIdentifier) {
        TabbedTextReader reader = new TabbedTextReader(new CharArrayReader(this._streamData), fieldSeparators, noTextIdentifier, textIdentifier);
        this._data = reader.read();
        this.getStepPanel1().previewTableDataModel1.fireTableStructureChanged();
    }

    class StepPanel1
    extends JPanel {
        JPanel optionPanel = new JPanel(new GridBagLayout());
        JPanel previewPanel = new JPanel(new GridBagLayout());
        private AbstractTableModel previewTableDataModel1 = new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                return Messages.getString("TabbedTextFileImportDlg.0") + col;
            }

            @Override
            public int getColumnCount() {
                return TabbedTextFileImportDlg.this._columnCount + 1;
            }

            @Override
            public int getRowCount() {
                return TabbedTextFileImportDlg.this._data.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return row + 1;
                }
                List dataCols = (List)TabbedTextFileImportDlg.this._data.get(row);
                return dataCols == null || dataCols.size() < col ? null : dataCols.get(col - 1);
            }
        };
        JTable previewTable = new JTable(this.previewTableDataModel1){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                int n = 1;
                int size = TabbedTextFileImportDlg.this._data.size();
                while ((size /= 10) > 0) {
                    ++n;
                }
                int width = e.getToIndex() == 0 ? 10 * n : 150;
                this.getColumnModel().getColumn(e.getToIndex()).setPreferredWidth(width);
                ButtonCellRenderer cellRenderer = new ButtonCellRenderer();
                cellRenderer.setMargin(new Insets(1, 0, 0, 0));
                this.getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
            }
        };
        JScrollPane scPane = new JScrollPane(this.previewTable);
        JLabel label1 = new JLabel(Messages.getString("TabbedTextFileImportDlg.9"));
        JLabel label2 = new JLabel(Messages.getString("TabbedTextFileImportDlg.10"));
        TitledBorder separatorBorder = new TitledBorder(Messages.getString("TabbedTextFileImportDlg.11"));
        TitledBorder previewBorder = new TitledBorder(Messages.getString("TabbedTextFileImportDlg.12"));
        JCheckBox checkBox1 = new JCheckBox(Messages.getString("TabbedTextFileImportDlg.13"));
        JCheckBox checkBox2 = new JCheckBox(Messages.getString("TabbedTextFileImportDlg.14"));
        JCheckBox checkBox3 = new JCheckBox(Messages.getString("TabbedTextFileImportDlg.15"));
        JCheckBox checkBox4 = new JCheckBox(Messages.getString("TabbedTextFileImportDlg.16"));
        JCheckBox checkBox5 = new JCheckBox(Messages.getString("TabbedTextFileImportDlg.17") + " : ");
        JTextField separatorField = new JTextField(2);
        JCheckBox checkBox6 = new JCheckBox();
        JLabel label3 = new JLabel(Messages.getString("TabbedTextFileImportDlg.19") + " : ");
        Object[] items = new Object[]{"\"", "'", Messages.getString("TabbedTextFileImportDlg.18")};
        JComboBox comboBox = new JComboBox<Object>(this.items);
        JTextArea textArea = new JTextArea(Messages.getString("TabbedTextFileImportDlg.24"), 2, 65);
        TitledBorder limitBorder = new TitledBorder(Messages.getString("TabbedTextFileImportDlg.64"));
        JLabel limitLabel1 = new JLabel(Messages.getString("TabbedTextFileImportDlg.66") + Messages.getString("TabbedTextFileImportDlg.67"));
        JLabel limitLabel2 = new JLabel(Messages.getString("TabbedTextFileImportDlg.68") + Messages.getString("TabbedTextFileImportDlg.67"));
        JCheckBox checkBox7 = new JCheckBox(Messages.getString("TabbedTextFileImportDlg.69"));
        JTextField textField1 = new NumberField(5);
        JTextField textField2 = new NumberField(5);

        StepPanel1() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.optionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.previewPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            JPanel checkBoxPanel = new JPanel(new GridBagLayout());
            checkBoxPanel.setBorder(this.separatorBorder);
            this.checkBox1.setMnemonic(66);
            checkBoxPanel.add((Component)this.checkBox1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            checkBoxPanel.add((Component)this.checkBox2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            checkBoxPanel.add((Component)this.checkBox3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            checkBoxPanel.add((Component)this.checkBox4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            checkBoxPanel.add((Component)this.checkBox5, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 22), 0, 0));
            checkBoxPanel.add((Component)this.separatorField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel limitPanel = new JPanel(new GridBagLayout());
            limitPanel.setBorder(this.limitBorder);
            limitPanel.add((Component)this.limitLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            limitPanel.add((Component)this.textField1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            limitPanel.add((Component)this.limitLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            limitPanel.add((Component)this.textField2, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.optionPanel.add((Component)this.label1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.optionPanel.add((Component)this.label2, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.optionPanel.add((Component)checkBoxPanel, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 17, 0, new Insets(20, 5, 5, 5), 0, 0));
            this.optionPanel.add((Component)this.checkBox6, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 5, 5), 0, 0));
            this.optionPanel.add((Component)this.textArea, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 45, 5, 5), 0, 0));
            this.optionPanel.add((Component)this.label3, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 5), 0, 0));
            this.optionPanel.add((Component)this.comboBox, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 120), 0, 0));
            this.optionPanel.add((Component)limitPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 90), 0, 0));
            this.optionPanel.add((Component)this.checkBox7, new GridBagConstraints(1, 4, 2, 1, 0.0, 1.0, 18, 0, new Insets(0, 20, 5, 5), 0, 0));
            this.textArea.setFont(this.label1.getFont());
            this.textArea.setBackground(this.optionPanel.getBackground());
            this.textArea.setEditable(false);
            this.textArea.setHighlighter(null);
            this.textArea.setFocusable(true);
            this.textArea.setRequestFocusEnabled(true);
            this.textArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    StepPanel1.this.checkBox6.setSelected(!StepPanel1.this.checkBox6.isSelected());
                }
            });
            KeyAdapter keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    StepPanel1.this.previewTable.repaint();
                }
            };
            this.textField1.addKeyListener(keyListener);
            this.textField2.addKeyListener(keyListener);
            this.previewTable.setEnabled(false);
            this.previewTable.setBackground(this.getBackground());
            this.previewTable.setRowSelectionAllowed(false);
            this.previewTable.setColumnSelectionAllowed(false);
            this.previewTable.setShowHorizontalLines(false);
            this.previewTable.setGridColor(Color.black);
            this.previewTable.setFont(new Font("Courier New", 0, 10));
            this.previewTable.setRowHeight(12);
            this.previewTable.getTableHeader().setPreferredSize(new Dimension(0, 0));
            this.previewTable.setAutoResizeMode(0);
            this.previewTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (column != 0) {
                        int limitSup;
                        int limitInf = StepPanel1.this.textField1.getText().length() == 0 ? 0 : Math.max(0, Integer.parseInt(StepPanel1.this.textField1.getText()) - 1);
                        int n = limitSup = StepPanel1.this.textField2.getText().length() == 0 ? table.getRowCount() - 1 : Math.min(table.getRowCount(), Integer.parseInt(StepPanel1.this.textField2.getText()) - 1);
                        if (row < limitInf || limitSup < row) {
                            ((JLabel)component).setBackground(new Color(200, 200, 200));
                        } else {
                            ((JLabel)component).setBackground(table.getBackground());
                        }
                    }
                    return component;
                }
            });
            this.scPane.setBorder(this.previewBorder);
            this.previewPanel.setPreferredSize(new Dimension(200, 100));
            this.previewPanel.add((Component)this.scPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.defineListeners();
        }

        protected void defineListeners() {
            ItemListener checkBoxListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean noTextIdentifier = StepPanel1.this.comboBox.getSelectedItem().toString().equals(Messages.getString("TabbedTextFileImportDlg.18"));
                    char textIdentifier = StepPanel1.this.comboBox.getSelectedItem().toString().charAt(0);
                    int count = 0;
                    char[] tmp = new char[5];
                    if (StepPanel1.this.checkBox1.isSelected()) {
                        tmp[count++] = 9;
                    }
                    if (StepPanel1.this.checkBox2.isSelected()) {
                        tmp[count++] = 59;
                    }
                    if (StepPanel1.this.checkBox3.isSelected()) {
                        tmp[count++] = 44;
                    }
                    if (StepPanel1.this.checkBox4.isSelected()) {
                        tmp[count++] = 32;
                    }
                    if (StepPanel1.this.checkBox5.isSelected() && StepPanel1.this.separatorField.getText().length() != 0) {
                        tmp[count++] = StepPanel1.this.separatorField.getText().charAt(0);
                    }
                    char[] fieldSeparator = new char[count];
                    for (int i = 0; i < count; ++i) {
                        fieldSeparator[i] = tmp[i];
                    }
                    TabbedTextFileImportDlg.this.updatePreview(fieldSeparator, noTextIdentifier, textIdentifier);
                }
            };
            this.checkBox1.addItemListener(checkBoxListener);
            this.checkBox2.addItemListener(checkBoxListener);
            this.checkBox3.addItemListener(checkBoxListener);
            this.checkBox4.addItemListener(checkBoxListener);
            this.checkBox5.addItemListener(checkBoxListener);
            this.checkBox7.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StepPanel1.this.checkBox7.isSelected()) {
                        Iterator i = TabbedTextFileImportDlg.this._referenceColumns.iterator();
                        while (i.hasNext()) {
                            TabbedTextFileImportDlg.this._columns.remove(i.next());
                        }
                    } else {
                        TabbedTextFileImportDlg.this._columns.clear();
                        TabbedTextFileImportDlg.this._columns.addAll(TabbedTextFileImportDlg.this._originalColumns);
                    }
                    TableColumn tableColumn = TabbedTextFileImportDlg.this.getStepPanel2().columnMatchTable.getColumn(TabbedTextFileImportDlg.this.getStepPanel2().columnMatchTable.getColumnName(1));
                    JComboBox combo = (JComboBox)((DefaultCellEditor)tableColumn.getCellEditor()).getComponent();
                    combo.setModel(new DefaultComboBoxModel(TabbedTextFileImportDlg.this._columns));
                }
            });
            this.comboBox.addItemListener(checkBoxListener);
            this.separatorField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    StepPanel1.this.checkBox5.setSelected(StepPanel1.this.separatorField.getText().length() != 0);
                }
            });
            this.separatorField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        return;
                    }
                    if (StepPanel1.this.separatorField.getText().length() >= 1) {
                        StepPanel1.this.separatorField.setText("");
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
        }

        public class NumberField
        extends JTextField {
            NumberField(int col) {
                super(col);
            }

            @Override
            protected Document createDefaultModel() {
                return new NumberDocument();
            }

            class NumberDocument
            extends PlainDocument {
                NumberDocument() {
                }

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    if (str == null) {
                        return;
                    }
                    char[] charArray = str.toCharArray();
                    Object result = new String();
                    for (int i = 0; i < charArray.length; ++i) {
                        if (!Character.isDigit(charArray[i])) continue;
                        result = (String)result + charArray[i];
                    }
                    super.insertString(offs, (String)result, a);
                }
            }
        }

        class ButtonCellRenderer
        extends JButton
        implements TableCellRenderer {
            ButtonCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setText(value == null ? "" : value.toString());
                this.setFont(table.getFont());
                return this;
            }
        }
    }

    class StepPanel2
    extends JPanel {
        private static final String EMPTY_VALUE = " ";
        JPanel optionPanel;
        JPanel previewPanel;
        Vector columnMatchData;
        AbstractTableModel columnMatchDataModel;
        JTable columnMatchTable;
        private AbstractTableModel previewTableDataModel2;
        JTable previewTable;
        ColumnRelationPanel columnRelationPnl;
        TitledBorder correspondenceBorder;
        TitledBorder relationBorder;
        JScrollPane scPaneColumnMatch;
        JScrollPane scPanePrev;
        TitledBorder previewBorder;
        JTextArea textArea;
        JButton bSavePreferences;

        StepPanel2() {
            super(new GridBagLayout());
            this.optionPanel = new JPanel(new GridBagLayout());
            this.previewPanel = new JPanel(new GridBagLayout());
            this.columnMatchData = new Vector();
            this.columnMatchDataModel = new AbstractTableModel(){

                @Override
                public String getColumnName(int col) {
                    return col == 0 ? Messages.getString("TabbedTextFileImportDlg.29") : Messages.getString("TabbedTextFileImportDlg.30");
                }

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public int getRowCount() {
                    return TabbedTextFileImportDlg.this._columnCount;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    Vector columns = StepPanel2.this.columnMatchData == null ? null : (row < StepPanel2.this.columnMatchData.size() ? (Vector)StepPanel2.this.columnMatchData.get(row) : null);
                    return columns == null ? null : columns.get(col);
                }

                @Override
                public void setValueAt(Object value, int row, int col) {
                    Vector columns = (Vector)StepPanel2.this.columnMatchData.get(row);
                    columns.set(col, value == StepPanel2.EMPTY_VALUE ? null : value);
                    super.setValueAt(value, row, col);
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == 1;
                }
            };
            this.columnMatchTable = new JTable(this.columnMatchDataModel);
            this.previewTableDataModel2 = new AbstractTableModel(){

                @Override
                public String getColumnName(int col) {
                    return Messages.getString("TabbedTextFileImportDlg.0") + col;
                }

                @Override
                public int getColumnCount() {
                    return TabbedTextFileImportDlg.this._columnCount;
                }

                @Override
                public int getRowCount() {
                    return TabbedTextFileImportDlg.this._usedData.size();
                }

                @Override
                public Object getValueAt(int row, int col) {
                    List columns = (List)TabbedTextFileImportDlg.this._usedData.get(row);
                    return columns == null || columns.size() - 1 < col ? null : columns.get(col);
                }
            };
            this.previewTable = new JTable(this.previewTableDataModel2){

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                    StepPanel2.this.previewTable.getColumnModel().getColumn(e.getToIndex()).setPreferredWidth(150);
                }
            };
            this.columnRelationPnl = new ColumnRelationPanel();
            this.correspondenceBorder = new TitledBorder(Messages.getString("TabbedTextFileImportDlg.31"));
            this.relationBorder = new TitledBorder(Messages.getString("TabbedTextFileImportDlg.32"));
            this.scPaneColumnMatch = new JScrollPane(this.columnMatchTable);
            this.scPanePrev = new JScrollPane(this.previewTable);
            this.previewBorder = new TitledBorder(Messages.getString("TabbedTextFileImportDlg.33"));
            this.textArea = new JTextArea(Messages.getString("TabbedTextFileImportDlg.34") + Messages.getString("TabbedTextFileImportDlg.35"), 2, 65);
            this.bSavePreferences = new JButton(Messages.getString("TabbedTextFileImportDlg.70"));
            this.add((Component)this.optionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.previewPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)this.scPaneColumnMatch, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            pnl.add((Component)this.bSavePreferences, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.optionPanel.add((Component)this.textArea, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.optionPanel.add((Component)pnl, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.columnMatchTable.setPreferredScrollableViewportSize(new Dimension(200, 80));
            this.columnMatchTable.setRowSelectionAllowed(false);
            this.columnMatchTable.getTableHeader().setReorderingAllowed(false);
            pnl.setBorder(this.correspondenceBorder);
            this.columnRelationPnl.setBorder(this.relationBorder);
            this.textArea.setFont(new JLabel().getFont());
            this.textArea.setBackground(this.optionPanel.getBackground());
            this.textArea.setEditable(false);
            this.textArea.setHighlighter(null);
            this.previewTable.setEnabled(false);
            this.previewTable.setBackground(this.getBackground());
            this.previewTable.getTableHeader().setReorderingAllowed(false);
            this.previewTable.setAutoResizeMode(0);
            this.previewTable.setRowSelectionAllowed(false);
            this.previewTable.setColumnSelectionAllowed(false);
            this.previewTable.setShowHorizontalLines(false);
            this.previewTable.setGridColor(Color.black);
            this.previewTable.setFont(new Font(Messages.getString("TabbedTextFileImportDlg.36"), 0, 10));
            this.previewTable.setRowHeight(10);
            this.scPanePrev.setBorder(this.previewBorder);
            this.previewPanel.setPreferredSize(new Dimension(200, 80));
            this.previewPanel.add((Component)this.scPanePrev, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.defineListeners();
            JComboBox<Object> comboBox = new JComboBox<Object>();
            DefaultListCellRenderer comboRenderer = new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value != null && TabbedTextFileImportDlg.this._referenceColumns.contains(value.toString())) {
                        comp.setFont(new Font(comp.getFont().getFamily(), 1, comp.getFont().getSize()));
                    }
                    return comp;
                }
            };
            comboBox.setRenderer(comboRenderer);
            TableColumn tableColumn = this.columnMatchTable.getColumn(this.columnMatchTable.getColumnName(1));
            DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value != null && TabbedTextFileImportDlg.this._referenceColumns.contains(value.toString())) {
                        comp.setFont(new Font(comp.getFont().getFamily(), 1, comp.getFont().getSize()));
                    }
                    return comp;
                }
            };
            tableColumn.setCellRenderer(cellRenderer);
            DefaultCellEditor cellEditor = new DefaultCellEditor(comboBox);
            cellEditor.setClickCountToStart(2);
            tableColumn.setCellEditor(cellEditor);
            this.columnRelationPnl.setWriteAccess(false);
        }

        protected void defineListeners() {
            TabbedTextFileImportDlg.this._bNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StepPanel2.this.updateData();
                }
            });
            this.bSavePreferences.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        StepPanel2.this.savePreferences();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }

        protected void updateData() {
            int i;
            int limitInf = TabbedTextFileImportDlg.this.getStepPanel1().textField1.getText().length() == 0 ? 0 : Math.max(0, Integer.parseInt(TabbedTextFileImportDlg.this.getStepPanel1().textField1.getText()) - 1);
            int limitSup = TabbedTextFileImportDlg.this.getStepPanel1().textField2.getText().length() == 0 ? TabbedTextFileImportDlg.this._data.size() : Math.min(TabbedTextFileImportDlg.this._data.size(), Integer.parseInt(TabbedTextFileImportDlg.this.getStepPanel1().textField2.getText()));
            TabbedTextFileImportDlg.this._usedData.clear();
            for (i = limitInf; i < limitSup; ++i) {
                TabbedTextFileImportDlg.this._usedData.add(TabbedTextFileImportDlg.this._data.get(i));
            }
            this.previewTableDataModel2.fireTableStructureChanged();
            this.columnMatchData.clear();
            for (i = 0; i < TabbedTextFileImportDlg.this._columnCount; ++i) {
                Vector<CallSite> columns = new Vector<CallSite>();
                columns.add((CallSite)((Object)(Messages.getString("TabbedTextFileImportDlg.5") + i)));
                columns.add(null);
                this.columnMatchData.add(columns);
            }
            if (TabbedTextFileImportDlg.this._plugable != null) {
                String pref = TabbedTextFileImportDlg.this._plugable.getOption("fmea.import.text.columnMatch");
                if (pref == null) {
                    pref = "";
                }
                try {
                    this.openPreferences(pref);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.columnMatchDataModel.fireTableDataChanged();
        }

        public void savePreferences() throws IOException {
            if (TabbedTextFileImportDlg.this._plugable == null) {
                return;
            }
            StringWriter sw = new StringWriter();
            BufferedWriter writer = new BufferedWriter(sw);
            writer.write("<?xml version=\"1.0\" encoding=\"iso-8859-15\"?>\n");
            writer.write("<!-- Pas de DTD par defaut -->\n");
            writer.write("<fmea.import.text.columnMatch>\n");
            for (int i = 0; i < this.columnMatchTable.getRowCount(); ++i) {
                String val1 = (String)this.columnMatchTable.getValueAt(i, 0);
                String val2 = (String)this.columnMatchTable.getValueAt(i, 1);
                val2 = val2 == null ? "" : val2;
                val1 = Util.formatStringForXml(val1);
                val2 = Util.formatStringForXml(val2);
                writer.write("<match inFile=\"" + val1 + "\" inFmea=\"" + val2 + "\">\n");
                writer.write("</match>\n");
            }
            writer.write("</fmea.import.text.columnMatch>\n");
            ((Writer)writer).close();
            TabbedTextFileImportDlg.this._plugable.setOption("fmea.import.text.columnMatch", sw.toString());
        }

        public void openPreferences(String preferences) throws IOException {
            if (preferences == null || preferences.length() == 0) {
                return;
            }
            if (__dbf == null) {
                __dbf = DocumentBuilderFactory.newInstance();
                __dbf.setValidating(false);
                __dbf.setIgnoringComments(true);
                __dbf.setIgnoringElementContentWhitespace(true);
                __dbf.setCoalescing(false);
                __dbf.setExpandEntityReferences(true);
            }
            try {
                DocumentBuilder db = __dbf.newDocumentBuilder();
                org.w3c.dom.Document doc = db.parse(new InputSource(new StringReader(preferences)));
                Element root = doc.getDocumentElement();
                if (!root.getNodeName().equals("fmea.import.text.columnMatch")) {
                    throw new IOException("Erreur de syntaxe : racine != \"<fmea.import.text.columnMatch>\"");
                }
                NodeList childs = root.getElementsByTagName("match");
                for (int i = 0; i < childs.getLength() && i < this.columnMatchTable.getRowCount(); ++i) {
                    Element xmlMatch = (Element)childs.item(i);
                    String inFmea = xmlMatch.getAttribute("inFmea");
                    if (!TabbedTextFileImportDlg.this._columns.contains(inFmea)) continue;
                    String inFile = xmlMatch.getAttribute("inFile");
                    this.columnMatchTable.setValueAt(inFile, i, 0);
                    this.columnMatchTable.setValueAt(inFmea, i, 1);
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                System.err.println(e);
                StringBuffer sb = new StringBuffer(32);
                sb.append(e.getClass().getName());
                sb.append(" : ");
                String mess = e.getMessage();
                if (mess == null) {
                    sb.append("<null>");
                } else {
                    sb.append(mess);
                }
                throw new IOException(sb.toString());
            }
        }
    }

    class TabbedTextReader {
        Reader _reader = null;
        boolean _noTextIdentifier = false;
        char _textIdentifier = (char)34;
        char[] _fieldSeparators = new char[]{'\t'};

        TabbedTextReader(Reader reader, char[] fieldSeparators, boolean noTextIdentifier, char textIdentifier) {
            this._reader = reader;
            this._noTextIdentifier = noTextIdentifier;
            this._textIdentifier = textIdentifier;
            this._fieldSeparators = fieldSeparators;
        }

        public List read() {
            try {
                return this.parseStream();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (InvalidLineException e) {
                e.printStackTrace();
                return null;
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                TabbedTextFileImportDlg.this._columnCount = 0;
                return new ArrayList();
            }
        }

        List parseStream() throws IOException, InvalidLineException {
            int n;
            TabbedTextFileImportDlg.this._columnCount = 0;
            int n2 = -1;
            ArrayList<List> lines = new ArrayList<List>();
            StringBuffer line = new StringBuffer();
            boolean parseString = false;
            boolean stop = false;
            while ((n = this._reader.read()) != -1) {
                if (n == this._textIdentifier) {
                    if (!this._noTextIdentifier) {
                        parseString = !parseString;
                    }
                    line.append((char)n);
                } else if (n == 10) {
                    if (parseString) {
                        line.append((char)n);
                    } else {
                        stop = true;
                    }
                } else {
                    line.append((char)n);
                }
                if (!stop) continue;
                stop = false;
                lines.add(this.parseLine(line.toString()));
                line = new StringBuffer();
            }
            if (line.length() > 0) {
                lines.add(this.parseLine(line.toString()));
            }
            return lines;
        }

        List parseLine(String line) throws IOException {
            int n;
            ArrayList<String> columns = new ArrayList<String>();
            StringReader r = new StringReader(line);
            StringBuffer field = new StringBuffer();
            boolean parseString = false;
            boolean doublequote = false;
            int n2 = -1;
            while ((n = r.read()) != -1) {
                if (n == this._textIdentifier) {
                    if (doublequote) {
                        field.append((char)n);
                    }
                    if (!this._noTextIdentifier) {
                        parseString = !parseString;
                    }
                    doublequote = !doublequote;
                    continue;
                }
                if (this.isFieldSeparator((char)n)) {
                    doublequote = false;
                    if (parseString) {
                        field.append((char)n);
                        continue;
                    }
                    columns.add(field.toString());
                    field = new StringBuffer();
                    continue;
                }
                doublequote = false;
                field.append((char)n);
            }
            String s = field.toString().trim();
            if (s.length() != 0) {
                columns.add(s);
            }
            TabbedTextFileImportDlg.this._columnCount = Math.max(TabbedTextFileImportDlg.this._columnCount, columns.size());
            return columns;
        }

        void setTextIdentifier(char textIdentifier) {
            this._textIdentifier = textIdentifier;
        }

        void setFieldSeparators(char[] fieldSeparators) {
            this._fieldSeparators = fieldSeparators;
        }

        boolean isFieldSeparator(char c) {
            for (int i = 0; i < this._fieldSeparators.length; ++i) {
                if (c != this._fieldSeparators[i]) continue;
                return true;
            }
            return false;
        }

        class InvalidLineException
        extends Exception {
            String _line;
            int _lineno = 0;

            public InvalidLineException(String line, int lineno) {
                this._line = line;
                this._lineno = lineno;
            }

            String getLine() {
                return this._line;
            }

            int getLineNo() {
                return this._lineno;
            }

            @Override
            public String getMessage() {
                StringBuffer b = new StringBuffer();
                b.append("Invalid line (lineno=");
                b.append(this._lineno);
                b.append(")");
                if (this._line != null) {
                    b.append(": [");
                    b.append(this._line);
                    b.append("]");
                }
                return b.toString();
            }
        }
    }

    class ColumnRelationPanel
    extends JPanel {
        private JButton add;
        private JButton remove;
        private ColumnRelationTableModel columnRelationDataModel;
        private JTable columnRelationTable;
        private Vector cellEditorItems;

        private ColumnRelationPanel() {
            super(new GridBagLayout());
            this.add = new JButton(Messages.getString("TabbedTextFileImportDlg.39"));
            this.remove = new JButton(Messages.getString("TabbedTextFileImportDlg.40"));
            this.columnRelationDataModel = new ColumnRelationTableModel();
            this.columnRelationTable = new JTable(this.columnRelationDataModel);
            this.cellEditorItems = new Vector();
            this.add((Component)new JScrollPane(this.columnRelationTable), new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.add, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.remove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.columnRelationTable.setPreferredScrollableViewportSize(new Dimension(150, 100));
            this.columnRelationTable.getTableHeader().setReorderingAllowed(false);
            JComboBox comboBox = new JComboBox(this.cellEditorItems);
            DefaultCellEditor cellEditor = new DefaultCellEditor(comboBox);
            cellEditor.setClickCountToStart(2);
            this.columnRelationTable.getColumn(this.columnRelationTable.getColumnName(0)).setCellEditor(cellEditor);
            this.columnRelationTable.getColumn(this.columnRelationTable.getColumnName(1)).setCellEditor(cellEditor);
            this.add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnRelationPanel.this.columnRelationDataModel.addRow();
                }
            });
            this.remove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnRelationPanel.this.columnRelationDataModel.removeRows(ColumnRelationPanel.this.columnRelationTable.getSelectedRows());
                }
            });
            TabbedTextFileImportDlg.this._bNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedTextFileImportDlg.this._columnRelations.clear();
                    ColumnRelationPanel.this.columnRelationDataModel.addRow();
                    ColumnRelationPanel.this.cellEditorItems.clear();
                    for (int i = 0; i < TabbedTextFileImportDlg.this._columnCount; ++i) {
                        ColumnRelationPanel.this.cellEditorItems.add(Messages.getString("TabbedTextFileImportDlg.43") + i);
                    }
                }
            });
            TabbedTextFileImportDlg.this._bFinish.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnRelationPanel.this.columnRelationDataModel.removeInvalidRows();
                }
            });
        }

        public void setWriteAccess(boolean access) {
            this.setEnabled(access);
            TitledBorder b = (TitledBorder)this.getBorder();
            if (!access) {
                b.setTitleColor(Color.gray);
            }
            this.add.setEnabled(access);
            this.remove.setEnabled(access);
            this.columnRelationTable.setEnabled(access);
            this.columnRelationTable.getTableHeader().setEnabled(access);
            this.columnRelationTable.getTableHeader().setResizingAllowed(access);
            if (!access) {
                this.columnRelationTable.setBackground(this.getBackground());
            }
        }

        private class ColumnRelationTableModel
        extends AbstractTableModel {
            @Override
            public String getColumnName(int col) {
                return col == 0 ? Messages.getString("TabbedTextFileImportDlg.41") : Messages.getString("TabbedTextFileImportDlg.42");
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return TabbedTextFileImportDlg.this._columnRelations.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                return ((Vector)TabbedTextFileImportDlg.this._columnRelations.get(row)).get(col);
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                int r;
                if (value == null) {
                    super.setValueAt(value, row, col);
                    return;
                }
                Object relatedValue = this.getValueAt(row, 1 - col);
                if (relatedValue != null && relatedValue.equals(value)) {
                    String msg = Messages.getString("TabbedTextFileImportDlg.55");
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(ColumnRelationPanel.this), msg, Messages.getString("ErrorManager.2"), 0);
                    return;
                }
                JTable matchTable = ((StepPanel2)TabbedTextFileImportDlg.this._stepPanel[1]).columnMatchTable;
                for (r = 0; r < matchTable.getRowCount() && !matchTable.getValueAt(r, 0).equals(value); ++r) {
                }
                assert (r < matchTable.getRowCount());
                Object matchValue = matchTable.getValueAt(r, 1);
                if (matchValue == null) {
                    String msg = com.dassault.cecilia.dbobj.fmea.util.Util.FormatString(Messages.getString("TabbedTextFileImportDlg.56"), value.toString());
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(ColumnRelationPanel.this), msg, Messages.getString("ErrorManager.2"), 0);
                    return;
                }
                if (!TabbedTextFileImportDlg.this._referenceColumns.contains(matchValue)) {
                    String msg = com.dassault.cecilia.dbobj.fmea.util.Util.FormatString(Messages.getString("TabbedTextFileImportDlg.57"), matchValue.toString(), value.toString());
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(ColumnRelationPanel.this), msg, Messages.getString("ErrorManager.2"), 0);
                    return;
                }
                Vector columns = (Vector)TabbedTextFileImportDlg.this._columnRelations.get(row);
                columns.set(col, value);
                super.setValueAt(value, row, col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            public void addRow() {
                Vector<Object> v = new Vector<Object>();
                v.add(null);
                v.add(null);
                TabbedTextFileImportDlg.this._columnRelations.add(v);
                this.fireTableDataChanged();
            }

            public void removeRows(int[] rows) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    TabbedTextFileImportDlg.this._columnRelations.remove(rows[i]);
                }
                this.fireTableDataChanged();
            }

            public void removeInvalidRows() {
                Iterator data = TabbedTextFileImportDlg.this._columnRelations.iterator();
                while (data.hasNext()) {
                    Vector v = (Vector)data.next();
                    if (v.get(0) != null && v.get(1) != null) continue;
                    data.remove();
                }
                this.fireTableDataChanged();
            }
        }
    }
}

