/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.ihm.modeldefinition;

import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeList {
    Map<FmeaEntityDefinition, DefaultMutableTreeNode> roots = new TreeMap<FmeaEntityDefinition, DefaultMutableTreeNode>(new Comparator<FmeaEntityDefinition>(){

        @Override
        public int compare(FmeaEntityDefinition o1, FmeaEntityDefinition o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });

    public void addEntity(FmeaEntityDefinition entity) {
        DefaultMutableTreeNode entityNode = new DefaultMutableTreeNode(entity);
        this.roots.put(entity, entityNode);
    }

    public void removeEntity(FmeaEntityDefinition entity) {
        this.roots.remove(entity);
    }

    public void addRelation(FmeaEntityDefinition entity, FmeaEntityDefinition relatedEntity) {
        Vector entityNodes = this.getNodes(entity);
        Vector relatedEntityNodes = this.getNodes(relatedEntity);
        if (this.roots.isEmpty()) {
            this.addFreeRelation(entity, relatedEntity);
            return;
        }
        if (entityNodes.isEmpty() && relatedEntityNodes.isEmpty()) {
            this.addFreeRelation(entity, relatedEntity);
            return;
        }
        if (!entityNodes.isEmpty() && relatedEntityNodes.isEmpty()) {
            DefaultMutableTreeNode relatedEntityNode = new DefaultMutableTreeNode(relatedEntity);
            this.addRelation(entityNodes, relatedEntityNode);
            return;
        }
        if (entityNodes.isEmpty() && !relatedEntityNodes.isEmpty()) {
            this.addFreeRelation(entity, (DefaultMutableTreeNode)relatedEntityNodes.get(0));
            this.roots.remove(relatedEntity);
            return;
        }
        if (!entityNodes.isEmpty() && !relatedEntityNodes.isEmpty()) {
            this.addRelation(entityNodes, relatedEntityNodes);
            this.roots.remove(relatedEntity);
            return;
        }
    }

    public void removeRelation(FmeaEntityDefinition entity, FmeaEntityDefinition relatedEntity) {
        DefaultMutableTreeNode firstNode = this.getFirstNode(relatedEntity);
        if (firstNode == null) {
            return;
        }
        DefaultMutableTreeNode relatedEntityNodeCopy = this.getCopy(firstNode);
        Vector entityNodes = this.getNodes(entity);
        for (DefaultMutableTreeNode parent : entityNodes) {
            DefaultMutableTreeNode child = null;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (node.getUserObject() != relatedEntity) continue;
                child = node;
                break;
            }
            if (child == null) continue;
            parent.remove(child);
        }
        this.roots.put(relatedEntity, relatedEntityNodeCopy);
    }

    private DefaultMutableTreeNode getFirstNode(FmeaEntityDefinition entity) {
        for (DefaultMutableTreeNode node : this.roots.values()) {
            DefaultMutableTreeNode relatedEntityNode = this.getFirstNode(entity, node);
            if (relatedEntityNode == null) continue;
            return relatedEntityNode;
        }
        return null;
    }

    private DefaultMutableTreeNode getFirstNode(FmeaEntityDefinition entity, DefaultMutableTreeNode node) {
        if (node.getUserObject() == entity) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode entityNode = this.getFirstNode(entity, child);
            if (entityNode == null) continue;
            return entityNode;
        }
        return null;
    }

    private void addRelation(Vector entityNodes, Vector relatedEntityNodes) {
        DefaultMutableTreeNode relatedEntityNode = (DefaultMutableTreeNode)relatedEntityNodes.get(0);
        this.addRelation(entityNodes, relatedEntityNode);
    }

    private void addRelation(Vector entityNodes, DefaultMutableTreeNode relatedEntityNode) {
        for (DefaultMutableTreeNode node : entityNodes) {
            node.add(this.getCopy(relatedEntityNode));
        }
    }

    private void addFreeRelation(FmeaEntityDefinition entity, FmeaEntityDefinition relatedEntity) {
        DefaultMutableTreeNode entityNode = new DefaultMutableTreeNode(entity);
        DefaultMutableTreeNode relatedEntityNode = new DefaultMutableTreeNode(relatedEntity);
        entityNode.add(relatedEntityNode);
        this.roots.put(entity, entityNode);
    }

    private void addFreeRelation(FmeaEntityDefinition entity, DefaultMutableTreeNode relatedEntityNode) {
        DefaultMutableTreeNode entityNode = new DefaultMutableTreeNode(entity);
        entityNode.add(this.getCopy(relatedEntityNode));
        this.roots.put(entity, entityNode);
    }

    private DefaultMutableTreeNode getCopy(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode copy = (DefaultMutableTreeNode)node.clone();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childCopy = this.getCopy((DefaultMutableTreeNode)node.getChildAt(i));
            copy.add(childCopy);
        }
        return copy;
    }

    private Vector getNodes(FmeaEntityDefinition entity) {
        Vector v = new Vector();
        Iterator<DefaultMutableTreeNode> itrRoots = this.roots.values().iterator();
        while (itrRoots.hasNext()) {
            Vector nodes = this.getNodes(entity, itrRoots.next());
            v.addAll(nodes);
        }
        return v;
    }

    private Vector getNodes(FmeaEntityDefinition entity, DefaultMutableTreeNode node) {
        Vector<DefaultMutableTreeNode> v = new Vector<DefaultMutableTreeNode>();
        if (node.getUserObject() == entity) {
            v.add(node);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                Vector nodes = this.getNodes(entity, child);
                v.addAll(nodes);
            }
        }
        return v;
    }

    public Iterator getRoots() {
        return this.roots.values().iterator();
    }

    public void expandAllNodes(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAllNodes(tree, root);
    }

    private void expandAllNodes(JTree tree, TreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            tree.expandPath(new TreePath(model.getPathToRoot(child)));
            this.expandAllNodes(tree, child);
        }
    }

    public static void main(String[] args) {
        JFrame frame;
        JTree tree;
        DefaultMutableTreeNode root;
        Vector v;
        TreeList lst;
        int i;
        Vector table = new Vector();
        FmeaEntityDefinition e1 = new FmeaEntityDefinition("e1");
        e1.setName("z_name_" + e1.getKey());
        FmeaEntityDefinition e2 = new FmeaEntityDefinition("e2");
        e2.setName("d_name_" + e2.getKey());
        FmeaEntityDefinition e3 = new FmeaEntityDefinition("e3");
        e3.setName("a_name_" + e3.getKey());
        FmeaEntityDefinition e4 = new FmeaEntityDefinition("e4");
        e4.setName("c_name_" + e4.getKey());
        FmeaEntityDefinition e5 = new FmeaEntityDefinition("e5");
        e5.setName("b_name_" + e5.getKey());
        FmeaEntityDefinition[][] tbl = new FmeaEntityDefinition[][]{{e1, e2}, {e3, e4}, {e5, e4}, {e2, e3}};
        for (i = 0; i < tbl.length; ++i) {
            Vector<FmeaEntityDefinition> v2 = new Vector<FmeaEntityDefinition>();
            v2.add(tbl[i][0]);
            v2.add(tbl[i][1]);
            table.add(v2);
        }
        for (i = 0; i < table.size(); ++i) {
            lst = new TreeList();
            for (int j = 0; j <= i; ++j) {
                v = (Vector)table.get(j);
                lst.addRelation((FmeaEntityDefinition)v.get(0), (FmeaEntityDefinition)v.get(1));
            }
            Iterator itr = lst.getRoots();
            root = new DefaultMutableTreeNode("ROOT");
            while (itr.hasNext()) {
                root.add((DefaultMutableTreeNode)itr.next());
            }
            tree = new JTree(root);
            lst.expandAllNodes(tree);
            frame = new JFrame("Tree");
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().add(new JScrollPane(tree));
            frame.setSize(200, 500);
            frame.setLocation(200 * (i % 7), 500 * (i / 7));
            frame.setVisible(true);
        }
        lst = new TreeList();
        for (int j = 0; j < i; ++j) {
            v = (Vector)table.get(j);
            lst.addRelation((FmeaEntityDefinition)v.get(0), (FmeaEntityDefinition)v.get(1));
        }
        lst.removeRelation(e2, e3);
        Iterator itr = lst.getRoots();
        root = new DefaultMutableTreeNode("ROOT");
        while (itr.hasNext()) {
            root.add((DefaultMutableTreeNode)itr.next());
        }
        tree = new JTree(root);
        lst.expandAllNodes(tree);
        frame = new JFrame("Tree");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new JScrollPane(tree));
        frame.setSize(200, 500);
        frame.setLocation(200 * (i % 7), 500 * (i / 7));
        frame.setVisible(true);
    }
}

