/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class FmeaBufferedWriter
extends BufferedWriter {
    private int tabCount = 0;
    private boolean tabWritten = false;

    public FmeaBufferedWriter(Writer out) {
        super(out);
    }

    public FmeaBufferedWriter(Writer out, int sz) {
        super(out, sz);
    }

    public void writeln() throws IOException {
        this.newLine();
    }

    public void writeln(String str) throws IOException {
        this.write(str);
        this.newLine();
    }

    @Override
    public void newLine() throws IOException {
        super.newLine();
        this.tabWritten = false;
    }

    @Override
    public void write(String str) throws IOException {
        if (!this.tabWritten) {
            this.writeStartTabs();
        }
        super.write(str);
        if (str.endsWith("\n")) {
            this.tabWritten = false;
        }
    }

    private void writeStartTabs() throws IOException {
        for (int i = 0; i < this.tabCount; ++i) {
            super.write("\t");
        }
        this.tabWritten = true;
    }

    public void setTabCount(int count) {
        this.tabCount = count;
    }

    public void incTabCount() {
        ++this.tabCount;
    }

    public void decTabCount() {
        --this.tabCount;
    }
}

