/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.io;

import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.fmea.model.DefaultDictionnary;
import com.dassault.cecilia.dbobj.fmea.model.Dictionnary;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import com.dassault.cecilia.dbobj.fmea.model.Fmea;
import com.dassault.cecilia.dbobj.fmea.model.FmeaAttributeDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaColumnDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntity;
import com.dassault.cecilia.dbobj.fmea.model.FmeaEntityDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaExternalRefAttribute;
import com.dassault.cecilia.dbobj.fmea.model.FmeaGraphicPropertyCollection;
import com.dassault.cecilia.dbobj.fmea.model.FmeaHead;
import com.dassault.cecilia.dbobj.fmea.model.FmeaModel;
import com.dassault.cecilia.dbobj.fmea.model.FmeaObject;
import com.dassault.cecilia.dbobj.fmea.model.FmeaRelation;
import com.dassault.cecilia.dbobj.fmea.model.FmeaRelationDefinition;
import com.dassault.cecilia.dbobj.fmea.model.FmeaTableDefinition;
import com.dassault.cecilia.dbobj.fmea.model.Formula;
import com.dassault.cecilia.dbobj.fmea.model.SortData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FmeaXMLReader {
    private boolean _isImport = false;
    private InputSource _source = null;
    private Fmea _fmea = null;
    DAOFactory _daoFactory;

    public FmeaXMLReader(DAOFactory daoFactory) {
        this._daoFactory = daoFactory;
    }

    public void setImport(boolean isImport) {
        this._isImport = isImport;
    }

    public void setFmea(Fmea fmea) {
        this._fmea = fmea;
    }

    public Fmea read(InputSource source) throws SAXException, IOException, ParserConfigurationException {
        this._source = source;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        FmeaHandler fmeaHandler = new FmeaHandler();
        parser.parse(this._source, (DefaultHandler)fmeaHandler);
        return this._fmea;
    }

    public static String getXmlHeadFile() {
        try {
            String line;
            URL propertiesURL = ClassLoader.getSystemClassLoader().getResource("dassault/fmea/resources/fmea.dtd");
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            buf.append("<!DOCTYPE FMEA \n");
            buf.append("[\n");
            BufferedReader dtd = new BufferedReader(new InputStreamReader(propertiesURL.openStream()));
            while ((line = dtd.readLine()) != null) {
                buf.append(line + "\n");
            }
            dtd.close();
            buf.append("]\n");
            buf.append(">\n");
            return buf.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getInternalDocTypeLine(String root) {
        return "<!DOCTYPE " + root + " SYSTEM \"jar:file:fmea/fmea.jar!/dassault/fmea/resources/fmea.dtd\">\n";
    }

    class FmeaHandler
    extends DefaultHandler {
        private FmeaModel cur_fmeaModel = null;
        private FmeaEntityDefinition cur_entityDef = null;
        private FmeaAttributeDefinition cur_attributeDef = null;
        private FmeaEntity cur_entity = null;
        private String cur_attributeKey = null;
        private FmeaExternalRefAttribute cur_extRefAttribute = null;
        private ExternalFmeaReference cur_extFmeaRef = null;
        private FmeaTableDefinition cur_tableDef = null;
        private FmeaColumnDefinition cur_columnDef = null;
        private FmeaColumnDefinition cur_sortingColumn = null;
        private Dictionnary cur_dico = null;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("FMEA")) {
                if (FmeaXMLReader.this._fmea == null) {
                    FmeaXMLReader.this._fmea = new Fmea();
                }
                this.addInternalAttributes(FmeaXMLReader.this._fmea, attributes);
            } else if (qName.equals("FMEA_MODEL")) {
                this.cur_fmeaModel = new FmeaModel();
                if (FmeaXMLReader.this._fmea == null) {
                    FmeaXMLReader.this._fmea = new Fmea();
                }
                FmeaXMLReader.this._fmea.setModel(this.cur_fmeaModel);
                this.addInternalAttributes(this.cur_fmeaModel, attributes);
            } else if (qName.equals("ENTITY_PATH")) {
                FmeaXMLReader.this._fmea.getModel().setEntityPath(null);
            } else if (qName.equals("ENTITY_DEF_NAME")) {
                FmeaEntityDefinition entityDef = FmeaXMLReader.this._fmea.getModel().getEntityDefinition(attributes.getValue("NAME"));
                if (entityDef == null) {
                    entityDef = FmeaXMLReader.this._fmea.getModel().getEntityDefinitionWithName(attributes.getValue("NAME"));
                }
                FmeaXMLReader.this._fmea.getModel().addToEntityPath(entityDef);
            } else if (qName.equals("ENTITY_DEFINITION")) {
                String key = attributes.getValue("KEY");
                if (key == null) {
                    key = attributes.getValue("NAME");
                }
                this.cur_entityDef = new FmeaEntityDefinition(key);
                this.addInternalAttributes(this.cur_entityDef, attributes);
                FmeaXMLReader.this._fmea.addEntityDefinition(this.cur_entityDef);
            } else if (qName.equals("ATTRIBUTE_DEFINITION")) {
                String key = attributes.getValue("KEY");
                if (key == null) {
                    key = attributes.getValue("NAME");
                }
                this.cur_attributeDef = new FmeaAttributeDefinition(key);
                this.addInternalAttributes(this.cur_attributeDef, attributes);
                this.cur_entityDef.addAttributeDefinition(this.cur_attributeDef);
            } else if (qName.equals("ENTITY")) {
                String definition = attributes.getValue("DEFINITION");
                if (definition == null) {
                    definition = attributes.getValue("DEFINITION_NAME");
                }
                FmeaEntityDefinition entityDef = FmeaXMLReader.this._fmea.getModel().getEntityDefinition(definition);
                String name = attributes.getValue("NAME");
                this.cur_entity = FmeaXMLReader.this._fmea.createEntity(entityDef, name);
            } else if (qName.equals("ATTRIBUTE_VALUE")) {
                String key = attributes.getValue("NAME");
                String value = attributes.getValue("VALUE");
                this.cur_attributeKey = key;
                this.cur_entity.setAttributeValue(key, value, Locale.US);
                this.cur_extRefAttribute = new FmeaExternalRefAttribute();
            } else if (qName.equals("EXTERNAL_REF")) {
                FmeaAttributeDefinition attDef = this.cur_entity.getDefinition().getAttributeDefinition(this.cur_attributeKey);
                String value = attributes.getValue("FMEA_ATTRIBUTE_VALUE");
                Object object = FmeaAttributeDefinition.convertObjectToType(value, attDef.getType());
                DBFolder dbFolder = null;
                long id = FmeaXMLReader.this._isImport ? -1L : DBFactory.parseID(attributes.getValue("FMEA_ID"));
                String path = attributes.getValue("FMEA_PATH");
                dbFolder = FmeaXMLReader.this._daoFactory.createFolderDAO().findFolder(id, path, DBFolder.Family.PROJECT.getRootName());
                if (dbFolder != null) {
                    if (!dbFolder.isVersion()) {
                        dbFolder = null;
                    } else if (dbFolder.getFamilyFlag() != 4) {
                        dbFolder = null;
                    }
                }
                if (dbFolder == null) {
                    String path2 = attributes.getValue("FMEA_PATH");
                    dbFolder = new DBFolder(-1L).setName(path2);
                }
                this.cur_extFmeaRef = new ExternalFmeaReference(dbFolder, attributes.getValue("FMEA_ENTITY_ID"), attributes.getValue("FMEA_ENTITY_NAME"), attributes.getValue("FMEA_ENTITY_VALUE"), attributes.getValue("FMEA_ATTRIBUTE_ID"), attributes.getValue("FMEA_ATTRIBUTE_NAME"), object);
                FmeaXMLReader.this._fmea.getExternalLinks().add(this.cur_extFmeaRef);
                this.cur_extRefAttribute.getExternalReferences().add(this.cur_extFmeaRef);
                this.cur_entity.setAttribute(attDef.getKey(), this.cur_extRefAttribute);
            } else if (qName.equals("EXT_REF_COLUMN")) {
                String key = attributes.getValue("ID");
                String name = attributes.getValue("NAME");
                String value = attributes.getValue("VALUE");
                this.cur_extFmeaRef.addColumn(key, name, value);
            } else if (qName.equals("RELATION_DEFINITION")) {
                String key = attributes.getValue("KEY");
                if (key == null) {
                    key = attributes.getValue("NAME");
                }
                String entityDefRef1 = attributes.getValue("ENTITY1");
                FmeaEntityDefinition entityDef1 = FmeaXMLReader.this._fmea.getModel().getEntityDefinition(entityDefRef1);
                if (entityDef1 == null) {
                    entityDef1 = FmeaXMLReader.this._fmea.getModel().getEntityDefinitionWithName(entityDefRef1);
                }
                String entityDefRef2 = attributes.getValue("ENTITY2");
                FmeaEntityDefinition entityDef2 = FmeaXMLReader.this._fmea.getModel().getEntityDefinition(entityDefRef2);
                if (entityDef2 == null) {
                    entityDef2 = FmeaXMLReader.this._fmea.getModel().getEntityDefinitionWithName(entityDefRef2);
                }
                FmeaRelationDefinition.Type type = attributes.getValue("TYPE").equals("one_to_one") ? FmeaRelationDefinition.One_to_One : FmeaRelationDefinition.One_to_Many;
                FmeaRelationDefinition relationDef = new FmeaRelationDefinition(key, entityDef1.getKey(), entityDef2.getKey(), type);
                FmeaXMLReader.this._fmea.addRelationDefinition(relationDef);
            } else if (qName.equals("RELATION")) {
                FmeaRelationDefinition relationDef;
                String definition = attributes.getValue("DEFINITION");
                if (definition == null) {
                    definition = attributes.getValue("DEFINITION_NAME");
                }
                if ((relationDef = FmeaXMLReader.this._fmea.getModel().getRelationDefinition(definition)) == null) {
                    return;
                }
                FmeaEntity entity1 = FmeaXMLReader.this._fmea.getEntity(relationDef.getEntityDef1(), attributes.getValue("ENTITY_REF1"));
                FmeaEntity entity2 = FmeaXMLReader.this._fmea.getEntity(relationDef.getEntityDef2(), attributes.getValue("ENTITY_REF2"));
                FmeaRelation relation = new FmeaRelation(relationDef, entity1, entity2);
                FmeaXMLReader.this._fmea.addRelation(relation);
            } else if (qName.equals("TABLE_DEFINITION")) {
                this.cur_tableDef = new FmeaTableDefinition();
                this.addInternalAttributes(this.cur_tableDef, attributes);
                FmeaXMLReader.this._fmea.getModel().setTableDefinition(this.cur_tableDef);
            } else if (qName.equals("HEAD")) {
                FmeaHead head = new FmeaHead();
                this.addInternalAttributes(head, attributes);
                this.cur_tableDef.setHead(head);
            } else if (qName.equals("COLUMN_DEFINITION")) {
                String attributeDefKey;
                FmeaAttributeDefinition attributeDef;
                FmeaEntityDefinition entityDef;
                String entityDefKey = attributes.getValue("ENTITY");
                FmeaEntityDefinition fmeaEntityDefinition = entityDef = entityDefKey == null ? null : FmeaXMLReader.this._fmea.getModel().getEntityDefinition(entityDefKey);
                if (entityDef == null) {
                    entityDef = entityDefKey == null ? null : FmeaXMLReader.this._fmea.getModel().getEntityDefinitionWithName(entityDefKey);
                }
                FmeaAttributeDefinition fmeaAttributeDefinition = attributeDef = (attributeDefKey = attributes.getValue("ATTRIBUTE")) == null ? null : entityDef.getAttributeDefinition(attributeDefKey);
                if (attributeDef == null) {
                    attributeDef = attributeDefKey == null ? null : entityDef.getAttributeDefinitionWithName(attributeDefKey);
                }
                this.cur_columnDef = new FmeaColumnDefinition(attributes.getValue("KEY"), attributes.getValue("NAME"), entityDef, attributeDef);
                FmeaXMLReader.this._fmea.getModel().getTableDefinition().addColumnDefinition(this.cur_columnDef);
            } else if (qName.equals("TYPE_PROPERTY")) {
                this.cur_attributeDef.addTypeProperty(attributes.getValue("NAME"), attributes.getValue("VALUE"));
            } else if (qName.equals("GRAPHIC_PROPERTY")) {
                FmeaGraphicPropertyCollection properties = this.cur_columnDef.getGraphicProperties();
                properties.putProperty(attributes.getValue("NAME"), attributes.getValue("VALUE"));
                String formulaText = properties.getString(FmeaGraphicPropertyCollection.formula);
                if (formulaText != null) {
                    try {
                        Formula formula = new Formula(formulaText);
                        this.cur_columnDef.setFormula(formula);
                    }
                    catch (Formula.InvalidExpressionException e) {
                        e.printStackTrace();
                    }
                }
            } else if (qName.equals("SORT")) {
                boolean groupCells = attributes.getValue("GROUP_CELLS") == null ? false : Boolean.valueOf(attributes.getValue("GROUP_CELLS"));
                SortData sortData = new SortData(groupCells);
                FmeaXMLReader.this._fmea.getModel().setSortData(sortData);
            } else if (qName.equals("SORT_COLUMN")) {
                String key = attributes.getValue("COLUMN");
                if (key == null || key.length() == 0) {
                    key = attributes.getValue("NAME");
                    this.cur_sortingColumn = FmeaXMLReader.this._fmea.getModel().getTableDefinition().getColumnDefinitionWithName(key);
                } else {
                    this.cur_sortingColumn = FmeaXMLReader.this._fmea.getModel().getTableDefinition().getColumnDefinition(key);
                }
                if (this.cur_sortingColumn != null) {
                    FmeaXMLReader.this._fmea.getModel().getSortData().addColumn(this.cur_sortingColumn, attributes.getValue("SORT_ORDER"));
                }
            } else if (qName.equals("GROUPBY_FORMULA")) {
                FmeaXMLReader.this._fmea.getModel().getSortData().setColumnFormula(this.cur_sortingColumn, true);
                String sourceColKey = attributes.getValue("SOURCE_COLUMN");
                FmeaColumnDefinition srcColDef = FmeaXMLReader.this._fmea.getModel().getTableDefinition().getColumnDefinition(sourceColKey);
                if (srcColDef == null) {
                    srcColDef = FmeaXMLReader.this._fmea.getModel().getTableDefinition().getColumnDefinitionWithName(sourceColKey);
                }
                int operation = attributes.getValue("OPERATION").equals("sum") ? 0 : 1;
                FmeaXMLReader.this._fmea.getModel().getSortData().setColumnFormula(this.cur_sortingColumn, srcColDef, operation);
            } else if (qName.equals("DICTIONNARY")) {
                String name = attributes.getValue("NAME");
                String description = attributes.getValue("DESCRIPTION");
                this.cur_dico = new DefaultDictionnary(name, description);
                this.cur_fmeaModel.getDicoMgr().addDictionnary(this.cur_dico);
            } else if (qName.equals("ENTRY")) {
                String key = attributes.getValue("KEY");
                Double value = Double.valueOf(attributes.getValue("VALUE"));
                this.cur_dico.put(key, value);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("FMEA_MODEL")) {
                this.cur_fmeaModel = null;
            }
            if (qName.equals("DICTIONNARY")) {
                this.cur_dico = null;
            }
        }

        public void addInternalAttributes(FmeaObject fmeaObject, Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                fmeaObject.addInternalAttribute(attributes.getQName(i), attributes.getValue(i));
            }
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            System.out.println("\n** Parsing warning, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.out.println("   " + spe.getMessage());
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            System.out.println("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.out.println("   " + spe.getMessage());
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            System.out.println("\n** Parsing fatal error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.out.println("   " + spe.getMessage());
        }
    }
}

