/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.fmea.model;

import com.dassault.cecilia.dbobj.fmea.Messages;
import com.dassault.cecilia.dbobj.fmea.model.ExternalFmeaReference;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;

public class ExternalFmeaReferenceTableModel
extends AbstractTableModel {
    static final DecimalFormat _FORMATER = new DecimalFormat("0.000E00", new DecimalFormatSymbols(Locale.ENGLISH));
    static Comparator _COMPARATOR = new Comparator(){

        public synchronized int compare(Object o1, Object o2) {
            ExternalFmeaReference ref1 = (ExternalFmeaReference)o1;
            ExternalFmeaReference ref2 = (ExternalFmeaReference)o2;
            int r = 0;
            r = ref1.getDBFolder().getRefPath().compareTo(ref2.getDBFolder().getRefPath());
            if (r != 0) {
                return r;
            }
            r = ref1.getFmeaEntName().compareTo(ref2.getFmeaEntName());
            if (r != 0) {
                return r;
            }
            r = ref1.getFmeaEntValue().compareTo(ref2.getFmeaEntValue());
            if (r != 0) {
                return r;
            }
            r = ref1.getFmeaAttName().compareTo(ref2.getFmeaAttName());
            if (r != 0) {
                return r;
            }
            return 0;
        }
    };
    List<ExternalFmeaReference> _data = new ArrayList<ExternalFmeaReference>();

    public void setReferences(List list) {
        this._data = list;
        Collections.sort(this._data, _COMPARATOR);
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public List getReferences() {
        return this._data;
    }

    public ExternalFmeaReference getReference(int row) {
        return this._data.get(row);
    }

    public void addReferences(List<ExternalFmeaReference> refs) {
        int size = this._data.size();
        this._data.addAll(refs);
        Collections.sort(this._data, _COMPARATOR);
        if (size == 0) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
    }

    public void removeReferences(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            this._data.remove(rows[i]);
        }
        this.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        if (this._data.size() == 0) {
            this.fireTableStructureChanged();
        }
    }

    public void modifyExternalFmeaReference(int row, ExternalFmeaReference ref) {
        this._data.remove(row);
        this._data.add(ref);
        Collections.sort(this._data, _COMPARATOR);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        return 4 + this._data.get(0).getcolumnCount();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: 
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        int count = this._data.get(0).getcolumnCount();
        if (col == 0) {
            return Messages.getString("ExternalFmeaReferencePanel.0");
        }
        if (col > 0 && col <= count) {
            return this._data.get(0).getColumnName(col - 1);
        }
        if (col == count + 1) {
            return Messages.getString("ExternalFmeaReferencePanel.1");
        }
        if (col == count + 2) {
            return Messages.getString("ExternalFmeaReferencePanel.2");
        }
        if (col == count + 3) {
            return Messages.getString("ExternalFmeaReferencePanel.9");
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        ExternalFmeaReference ref = this._data.get(row);
        int count = ref.getcolumnCount();
        if (col == 0) {
            return ref.getDBFolder().getRefPath();
        }
        if (col > 0 && col <= count) {
            return ref.getColumnValue(col - 1);
        }
        if (col == count + 1) {
            return ref.getFmeaEntName() + "." + ref.getFmeaEntValue();
        }
        if (col == count + 2) {
            return ref.getFmeaAttName();
        }
        if (col == count + 3) {
            return ref.getFmeaAttValue() == null ? "" : _FORMATER.format(ref.getFmeaAttValue());
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

